<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;

use Helper;
use App\Helpers\ReportHelper;

class AssignWHController extends Controller
{
    public function assign_wh_qty($store){
        $po_serial=Helper::get_sup_po_no(1);
        
        $urban_store='11,13';
        
        if($store=='decrum'){
            $store_id=1;
            $column='Quantity';
            // $whereSingleRaw='store_id != 11';
            // $whereBundleRaw='bundle_list_pr_wise.store_id !=11';
            
            $whereSingleRaw='store_id NOT IN ('.$urban_store.')';
            $whereBundleRaw='bundle_list_pr_wise.store_id NOT IN ('.$urban_store.')';
            $whName='DEWHAUTO';
            
        }else{
            $store_id=11;
            $column='uc_quantity';
            
            // $whereSingleRaw='store_id =11';
            // $whereBundleRaw='bundle_list_pr_wise.store_id =11';
            
            $whereSingleRaw='store_id IN ('.$urban_store.')';
            $whereBundleRaw='bundle_list_pr_wise.store_id IN ('.$urban_store.')';
            $whName='UCWHAUTO';
        }
        
        $pr_id_other=date('dmy').$whName;
        $po_id=$pr_id_other.'-'.$po_serial;
        
        $where=[
            'prod_status' => 1,
            'is_deleted' => 0,
        ];
        
        
        $arr=Helper::get_quantity($store_id);
        
        $product_info=DB::table('product_info')
                        ->where($where)
                        ->where($column,'!=',0)
                        ->select('variation_id')
                        ->get()
                        ->pluck('variation_id')->toArray();
        
        
        $check=DB::table('process_order_quantity')
                ->whereIn('variation_id',$product_info)
                ->where('status',0)
                ->whereRaw($whereSingleRaw)
                ->selectRaw('variation_id, sum(receiving_qty) as approve_qty')
                ->groupBy('variation_id')
                ->get();
        
        $insert_assign=[];
        $insert_log=[];
        if($check->count()>0){
            foreach ($check as $c){
                $variation_id=$c->variation_id;
                $approve_qty=$c->approve_qty;
                
                $group_id=substr($variation_id, 0, -1);
                $size=substr($variation_id, -1);
                
                if(isset($arr[$variation_id])){
                    if($arr[$variation_id]<=$approve_qty){
                        $qty=$arr[$variation_id];
                        $arr[$variation_id]=0;
                    }elseif($arr[$variation_id]>$approve_qty){
                        $qty=$approve_qty;
                        $arr[$variation_id]=$arr[$variation_id] - $approve_qty;
                    }
                    
                    if($qty>0){
                        $insert22=[
                            'variation_id' => $variation_id,
                            'variation_design' => $variation_id,
                            'main_type' => $group_id,
                            'prod_size' => $size,
                            'in_stock' =>  $qty,
                            'supplier_id' => 1,
                            'assign_date' => date('Y-m-d'),
                            'order_qty_given' => $qty,
                            'receive_qty' => $qty,
                            'pr_id' => $pr_id_other,
                            'po_id' => $po_id,
                        ];
                    
                        $insert_assign[]=$insert22;
                    
                        $insertl=[
                            'variation_id' => $variation_id,
                            'pr_id' => $pr_id_other,
                            'given_qty' => $qty,
                            'supplier_id' => 1,
                            'user_id' => isset(auth()->user()->id)?auth()->user()->id:28,
                            'type_name' => 'Assign Warehouse',
                            'created_date' => date('Y-m-d H:i:s')
                        ];
                    
                        $insert_log[]=$insertl; 
                    }
                    
                    
                }
            }
        }
        
        
        
        $check=\DB::table('bundle_sets')
            ->leftjoin('bundle_list_pr_wise','bundle_list_pr_wise.bundle_set_variation','=','bundle_sets.bundle_set_variation')
            ->whereIn('bundle_sets.variation_id',$product_info)
            ->where('bundle_list_pr_wise.status',0)
            ->whereRaw($whereBundleRaw)
            ->selectRaw('bundle_sets.variation_id, sum(given_qty) as approve_qty')
            ->groupBy('bundle_sets.variation_id')
            ->get();
            
        if($check->count()>0){
            foreach ($check as $c){
                $variation_id=$c->variation_id;
                $approve_qty=$c->approve_qty;
                
                $group_id=substr($variation_id, 0, -1);
                $size=substr($variation_id, -1);
                
                if(isset($arr[$variation_id])){
                    if($arr[$variation_id]<=$approve_qty){
                        $qty=$arr[$variation_id];
                        $arr[$variation_id]=0;
                    }elseif($arr[$variation_id]>$approve_qty){
                        $qty=$approve_qty;
                        $arr[$variation_id]=$arr[$variation_id] - $approve_qty;
                    }
                    
                    if($qty>0){
                        $insert22=[
                            'variation_id' => $variation_id,
                            'variation_design' => $variation_id,
                            'main_type' => $group_id,
                            'prod_size' => $size,
                            'in_stock' =>  $qty,
                            'supplier_id' => 1,
                            'assign_date' => date('Y-m-d'),
                            'order_qty_given' => $qty,
                            'receive_qty' => $qty,
                            'pr_id' => $pr_id_other,
                            'po_id' => $po_id,
                        ];
                    
                        $insert_assign[]=$insert22;
                    
                        $insertl=[
                            'variation_id' => $variation_id,
                            'pr_id' => $pr_id_other,
                            'given_qty' => $qty,
                            'supplier_id' => 1,
                            'user_id' => isset(auth()->user()->id)?auth()->user()->id:28,
                            'type_name' => 'Assign Warehouse',
                            'created_date' => date('Y-m-d H:i:s')
                        ];
                    
                        $insert_log[]=$insertl; 
                    }
                    
                    
                }
            }
        }
        
        // dd($insert_assign,$insert_log);
        
        
        if(count($insert_assign)>0){
            $comments='Auto Old WH Assign Quantity Cancelled by system date ('.date('d-m-Y').')';
            $update_arr=[
                'status' => 1,
                'comments' => $comments,
                'is_cancelled' => 1,
                'is_cancelled_by' => isset(auth()->user()->id)?auth()->user()->id:28,
                'is_cancelled_date' => date('Y-m-d')
            ];
            
            $short_name = 'UC';
            $likeCondition = $store_id == 11 ? 'LIKE' : 'NOT LIKE';
            
            $list = DB::table('assign_quantity')
                ->where('status',0)
                ->where('supplier_id',1)
                ->where('pr_id', $likeCondition, '%' . $short_name . '%')
                ->update($update_arr);
                
            DB::table('assign_quantity')->insert($insert_assign);
            DB::table('item_log')->insert($insert_log);
        }        
        
        return response()->json([
            'code' => '200',
            'message' => 'Assign WH Inventory Successfully'
        ]);
        
        
    }
    
    public function addingGrade(){
        $endDate = date('Y-m-d'); // Today
        $startDate = date('Y-m-d', strtotime('-365 days')); // 365 days ago
        
        $country_list = ['US'];
        $child=0;
        $decrum_sale = ReportHelper::AmazonOrders("amazon_order_report_decrum",$startDate,$endDate,$country_list,$child,4);
        
        // dd($decrum_sale);
        
       
         
        $where_single = ['is_deleted = 0','prod_status = 1'];
        $where_bundle = ['is_deleted = 0','status = 1'];
        
        $fields_single='prod_status,
                        group_id,
                        variation_design,
                        prod_design,
                        product_name,
                        grade';
        
        $fields_bundle='status as prod_status,
                        bundle_group as group_id,
                        bundle_set_variation as variation_design,
                        decrum_instock as prod_design,
                        bundle_name as product_name,
                        grade';
        
        
        
        $results_bundle = DB::table('bundle')
                            ->selectRaw($fields_bundle)
                            ->whereRaw(implode(' AND ',$where_bundle))
                            ->groupBy('group_id');
                            
        $results = DB::table('product_info_design')
                        ->selectRaw($fields_single)
                        ->whereRaw(implode(' AND ',$where_single))
                        ->groupBy(['group_id','prod_design'])
                        ->union($results_bundle)->get();
        // dd($results);
        
        if($results){
            $log=[];
            foreach($results as $sku){
                $variation_design=$sku->variation_design;
                
                $bundle_check=preg_match( '/^4BUN/im',$variation_design);
                
                $group_id=$sku->group_id;
                
                $design1=explode('-',$sku->variation_design);
                $design1=isset($design1[1])?'-'.$design1[1]:'';
                
                if($design1){
                    $group_design=$sku->group_id.$design1;
                }else{
                    $group_design=$group_id;
                }
                
                if($bundle_check){
                    $table= 'bundle';
                   
                    $where=[
                        'bundle_group = "'.$group_id.'"'
                    ];
                }else{
                    $table= 'product_info_design';
                    
                    if($design1){
                        $where=[
                            'group_id = "'.$group_id.'"',
                            'prod_design = "'.$sku->prod_design.'"'
                        ];
                        
                        
                    }else{
                        $where=[
                            'group_id = "'.$group_id.'"',
                            'prod_design = "0"'
                        ];
                    }
                    
                }
                
                $total_sale=0;
                        
                if(isset($decrum_sale[$group_design])){
                    $decrum=$decrum_sale[$group_design];
                    $total_sale=$decrum['total_sale'];
                }
                
                // if($group_design =='4002201-AE'){
                //     dd($total_sale);
                // }
                
                $grade = 'D'; // Default grade
                if ($total_sale >= 500) {
                    $grade = 'A';
                } elseif ($total_sale >= 201) {
                    $grade = 'B';
                } elseif ($total_sale >= 100) {
                    $grade = 'C';
                }
                
                if($sku->grade != $grade){
                    // dd($grade,$where);
                    DB::table($table)->whereRaw(implode(' AND ',$where))->update(['grade' => $grade]);
                    
                    if($sku->grade !=''){
                        $comments ='Grade change from '.$sku->grade.' to '.$grade.' date '.now();
                    }else{
                        $comments ='Grade change from Empty to '.$grade.' date '.now();
                    }
                    
                    
                    $log[]=[
                        'group_id' => $sku->group_id,
                        'group_design' => $group_design,
                        'comments' => $comments,
                        'created_date' => now(),
                        'user_id' => 74,
                    ];
                }
                
            }
            
            if(count($log)>0){
                DB::table('sku_grade_log')->insert($log);
            }
        }
        
        return response()->json([
            'code' => 200,
            'message' => 'Grade Updated Successfully'
        ]);
    }
    
    
    
}
