<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdminShippmentController extends Controller
{
    protected $to=['smsufian.esire@gmail.com','esire.zohaib@gmail.com'];
    protected $store_id=[1,6,11];
    
    public function today_drop_in(){
        $now=Date('Y-m-d');
        $records=DB::table('product_receiving')
            ->where(DB::raw('DATE(product_receiving.created_date)'),'=',$now)
            ->join('product_info','product_info.variation_id','=','product_receiving.variation_id')
            ->join('suppliers','suppliers.id','=','product_receiving.supplier_id')
            ->join('users','users.id','=','product_receiving.user_id')
            ->select([
                'product_receiving.last_receiving as receive_qtn',
                'product_receiving.*',
                'product_info.product_name',
                'suppliers.supplier_name',
                'users.name'
            ])->get();
            
        $html='<html><head><style>table, tr,td, th {border: 1px solid black;}table {width: 100%;border-collapse: collapse;word-break:word-break: break-all;}</style></head><body>';
        
        $html.='<h3>Total Drop In Date: '.date('d-m-Y',strtotime($now)).'</h3>';
        $html.='<table>
                <thead>
                    <tr style="font-weight:bold;background-color:#d3d3d3">
                        <td>S#</td>
                        <td>SKU</td>
                        <td>REC ID</td>
                        <td>Product Name</td>
                        <td>Color</td>
                        <td>Size</td>
                        <td>Received QTY</td>
                        <td>Supplier Name</td>
                        <td>Drop In by</td>
                    </tr>
                </thead><tbody>';
                
        if($records->count()>0){
            $total=0;
            $sno=1;
            foreach($records as $row){
                $exp=explode(',',$row->product_name);
                $name=$exp[0];
                $size=$exp[1];
                
                $exp=explode('|',$name);
                $name=$exp[0];
                $color=$exp[1];
                
                
                
                $html.='<tr >
                            <td>'.$sno.'</td>
                            <td>'.$row->variation_id.'</td>
                            <td>'.$row->rec_id.'</td>
                            <td>'.$name.'</td>
                            <td>'.$color.'</td>
                            <td>'.$size.'</td>
                            <td>'.$row->receive_qtn.'</td>
                            <td>'.$row->supplier_name.'</td>
                            <td>'.$row->name.'</td>
                        </tr>';
                $sno++;
                $total+=$row->receive_qtn;
            }
            
            $html.='<tr style="font-weight:bold;background-color:#d3d3d3">
                        <td colspan="6" style="text-align:right">Total</td>
                        <td colspan="3">'.$total.'</td>
                    </tr>';
            $html.='</tbody></table>';        
            
            
        }else{
            $html.='<tr >
                    <td colspan="6"> NO Drop IN Today</td>
                </tr>';
            $html.='</tbody></table>';
        }
        
        $records=DB::table('gatepass_reverse_history')
            ->where(DB::raw('DATE(gatepass_reverse_history.created_date)'),'=',$now)
            ->join('product_info','product_info.variation_id','=','gatepass_reverse_history.variation_id')
            ->join('suppliers','suppliers.id','=','gatepass_reverse_history.supplier_id')
            ->join('users','users.id','=','gatepass_reverse_history.user_id')
            ->select([
                'gatepass_reverse_history.*',
                'product_info.product_name',
                'suppliers.supplier_name',
                'users.name'
            ])->get();
        
        $html.='<h3>Drop In Reverse Date: '.date('d-m-Y',strtotime($now)).'</h3>';
        $html.='<table>
                <thead>
                    <tr style="font-weight:bold;background-color:#d3d3d3">
                        <td>S#</td>
                        <td>SKU</td>
                        <td>REC ID</td>
                        <td>Product Name</td>
                        <td>Color</td>
                        <td>Size</td>
                        <td>Reverse QTY</td>
                        <td>Supplier Name</td>
                        <td>Reverse by</td>
                        <td>Reverse Reason</td>
                    </tr>
                </thead><tbody>';
                
        if($records->count()>0){
            $total=0;
            $sno=1;
            
            
            foreach($records as $row){
                $exp=explode(',',$row->product_name);
                $name=$exp[0];
                $size=$exp[1];
                
                $exp=explode('|',$name);
                $name=$exp[0];
                $color=$exp[1];
                
                
                
                $html.='<tr >
                            <td>'.$sno.'</td>
                            <td>'.$row->variation_id.'</td>
                            <td>'.$row->rec_id.'</td>
                            <td>'.$name.'</td>
                            <td>'.$color.'</td>
                            <td>'.$size.'</td>
                            <td>'.$row->quantity.'</td>
                            <td>'.$row->supplier_name.'</td>
                            <td>'.$row->name.'</td>
                            <td>'.$row->reason.'</td>
                        </tr>';
                $sno++;
                $total+=$row->quantity;
            }
            
            $html.='<tr style="font-weight:bold;background-color:#d3d3d3">
                        <td colspan="6" style="text-align:right">Total</td>
                        <td colspan="4">'.$total.'</td>
                    </tr>';
            $html.='</tbody></table>'; 
            
            
        }else{
            $html.='<tr >
                    <td colspan="10"> NO Reverse Drop IN Today</td>
                </tr>';
            $html.='</tbody></table>';
        }
        
        $html.='</body></html>';
        
        \Mail::html($html, function ($message) use(&$now){
            $to=$this->to;
            $message->to($to)->subject("Total Drop In Date: (".date('d-m-Y',strtotime($now)).")");
        });
        
        
        return response()->json(['code' => 200]);
            
        
    }
    
    public function today_ready_shipment(){
        $now=Date('Y-m-d');
        
        $stores=DB::table('store')->whereIn('id',$this->store_id)->get();
        
        $html='<html><head><style>table, tr,td, th {border: 1px solid black;}table {width: 100%;border-collapse: collapse;word-break:word-break: break-all;}</style></head><body>';
        
        foreach ($stores as $st){
            $records=DB::table('processed_orders')
                        ->groupBy('processed_orders.variation_design','processed_orders.store_id','processed_orders.shipment_type')
                        ->join('product_info_design','product_info_design.variation_design','=','processed_orders.variation_design')
                        ->join('users','users.id','=','processed_orders.user_id')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.prod_size','ASC')
                        ->orderBy('product_info_design.prod_design','ASC')
                        ->where('processed_orders.shipment_ready_status','0')
                        ->where('processed_orders.store_id',$st->id)
                        ->where(DB::raw('Date(processed_orders.created_date)'),$now)
                        ->where('processed_orders.shipment_type',1)
                        ->select([
                            'processed_orders.variation_id',
                            'processed_orders.id',
                            'processed_orders.variation_design',
                            DB::raw('sum(processed_orders.filled_qty) as filled_qty'),
                            DB::raw('sum(processed_orders.approve_qty) as approve_qty'),
                            'processed_orders.created_date',
                            'product_info_design.product_name',
                            'users.name'
                        ])->get();
            $html.='<h3>Store Name : <span style="color:#D35400">'.$st->strong_name.'</span> Shipment Type : <span style="color:#D35400">Air Cargo</span></h3>';
            
            $html.='<table>
                <thead>
                    <tr style="font-weight:bold;background-color:#d3d3d3">
                        <td>S#</td>
                        <td>SKU</td>
                        <td>SKU Design</td>
                        <td>Product Name</td>
                        <td>Color</td>
                        <td>Size</td>
                        <td>Given QTY</td>
                        <td>Created By</td>
                    </tr>
                </thead><tbody>';
                
            if($records->count()>0){
                $total=0;
                $sno=1;
                foreach($records as $row){
                    $exp=explode(',',$row->product_name);
                    $name=$exp[0];
                    $size=$exp[1];
                
                    $exp=explode('|',$name);
                    $name=$exp[0];
                    $color=$exp[1];
                    
                    $html.='<tr >
                            <td>'.$sno.'</td>
                            <td>'.$row->variation_id.'</td>
                            <td>'.$row->variation_design.'</td>
                            <td>'.$name.'</td>
                            <td>'.$color.'</td>
                            <td>'.$size.'</td>
                            <td>'.$row->filled_qty.'</td>
                            <td>'.$row->name.'</td>
                        </tr>';
                        
                    $sno++;
                    $total+=$row->filled_qty;
                }
                
                $html.='<tr style="font-weight:bold;background-color:#d3d3d3">
                    
                    <td colspan="6" style="text-align:right">Total</td>
                    <td colspan="2">'.$total.'</td>
                    
                </tr>';
                $html.='</tbody></table>';
            }else{
                $html.='<tr>
                            <td colspan="8">No Record Found</td>
                        </tr>';
                $html.='</tbody></table>';
            }
            
            $records=DB::table('processed_orders')
                        ->groupBy('processed_orders.variation_design','processed_orders.store_id','processed_orders.shipment_type')
                        ->join('product_info_design','product_info_design.variation_design','=','processed_orders.variation_design')
                        ->join('users','users.id','=','processed_orders.user_id')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.prod_size','ASC')
                        ->orderBy('product_info_design.prod_design','ASC')
                        ->where('processed_orders.shipment_ready_status','0')
                        ->where('processed_orders.store_id',$st->id)
                        ->where(DB::raw('Date(processed_orders.created_date)'),$now)
                        ->where('processed_orders.shipment_type',2)
                        ->select([
                            'processed_orders.variation_id',
                            'processed_orders.id',
                            'processed_orders.variation_design',
                            DB::raw('sum(processed_orders.filled_qty) as filled_qty'),
                            DB::raw('sum(processed_orders.approve_qty) as approve_qty'),
                            'processed_orders.created_date',
                            'product_info_design.product_name',
                            'users.name'
                        ])->get();
            $html.='<h3>Store Name : <span style="color:#D35400">'.$st->strong_name.'</span> Shipment Type : <span style="color:#D35400">Sea Cargo</span></h3>';
            
            $html.='<table>
                <thead>
                    <tr style="font-weight:bold;background-color:#d3d3d3">
                        <td>S#</td>
                        <td>SKU</td>
                        <td>SKU Design</td>
                        <td>Product Name</td>
                        <td>Color</td>
                        <td>Size</td>
                        <td>Given QTY</td>
                        <td>Created By</td>
                    </tr>
                </thead><tbody>';
                
            if($records->count()>0){
                $total=0;
                $sno=1;
                foreach($records as $row){
                    $exp=explode(',',$row->product_name);
                    $name=$exp[0];
                    $size=$exp[1];
                
                    $exp=explode('|',$name);
                    $name=$exp[0];
                    $color=$exp[1];
                    
                    $html.='<tr >
                            <td>'.$sno.'</td>
                            <td>'.$row->variation_id.'</td>
                            <td>'.$row->variation_design.'</td>
                            <td>'.$name.'</td>
                            <td>'.$color.'</td>
                            <td>'.$size.'</td>
                            <td>'.$row->filled_qty.'</td>
                            <td>'.$row->name.'</td>
                        </tr>';
                        
                    $sno++;
                    $total+=$row->filled_qty;
                }
                
                $html.='<tr style="font-weight:bold;background-color:#d3d3d3">
                    
                    <td colspan="6" style="text-align:right">Total</td>
                    <td colspan="2">'.$total.'</td>
                    
                </tr>';
                $html.='</tbody></table>';
            }else{
                $html.='<tr>
                            <td colspan="8">No Record Found</td>
                        </tr>';
                $html.='</tbody></table>';
            }
        }
        
        $html.='</body></html>';
        // echo $html;exit;
        
        \Mail::html($html, function ($message) use(&$now){
            $to=$this->to;
            $message->to($to)->subject("Total Ready To Shipment Date: (".date('d-m-Y',strtotime($now)).")");
        });
        
        
        return response()->json(['code' => 200]);
    }
    
    public function pr_data(){
        $pr_data=\DB::table('pr_data')->get();
        
        foreach($pr_data as $pr){
            $total_qty=\DB::table('process_orders')->where('pr_id',$pr->pr_name)->select([DB::raw('sum(approve_qty) as approve_qty'),DB::raw('sum(given_qty) as given_qty')])->first();
            
            $approve_qty=$total_qty->approve_qty;
            $remaining_qty=$total_qty->given_qty;
            
            $ready_to_ship=(int)$approve_qty - (int)$remaining_qty;
            
            echo $pr->pr_name.'===='.$approve_qty.'===='.$remaining_qty.'===='.$ready_to_ship.'<br>';
            
        }
    }
}
