<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Helper;

class UploadController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:upload-reports');
    }
    
    public function index(Request $request){
        if($request->isMethod('post')){
            if($request->hasFile('file_upload')){
                $input = $request->all();
                
                // dd($input);
                $check=Helper::findPendingOrder($input['store_selection'],$input['shipment_type']);
                // dd($check);
                
                if($check>0){
                    $image = $request->file('file_upload');
                    $name = time().'.'.$image->getClientOriginalExtension();
                    $destinationPath = public_path('/uploads/txt_upload');
                    $image->move($destinationPath, $name);
                    
                    $insert_excel=[
                        'file_name' => $name,
                        'original_name' => $image->getClientOriginalName(),
                        'type' => '5',
                        'type_name' => 'Urgent Mark Excel',
                        'status' => '1',
                        'uploaded_by' => auth()->user()->id,
                        'upload_date' => date('Y-m-d'),
                        'store_id' => $input['store_selection'],
                        'shipment_type' => $input['shipment_type']
                    ];
                    $insert_data=DB::table('upload_excel')->insert($insert_excel);
                    
                    $extension=$image->getClientOriginalExtension();
                    $res=$this->upload_urgent_mark($name,$extension,$input['store_selection'],$input['shipment_type'],$input['marking_type']);
                    
                    if($res){
                        $code ='200';
                        $message = 'Record Updated Successfully';
                    }else{
                        $code ='400';
                        $message = 'Error in Updating';
                    }  
                }else{
                    $code ='400';
                    $message = 'No Pending Order Found';
                }
                
                return response()->json([
                    'code' => $code,
                    'message' => $message
                ]);
                
                
                
            }
        }else{
            $stores=DB::table('store')->whereIn('id',[1,6])->orderBy('id','ASC')->get();
            return view('upload.urgent',['stores'=> $stores]);
        }
    }
    
    public function upload_urgent_mark($file_name,$extension,$store_id,$shipment_type,$urgent_tag){
        if($extension == 'csv'){
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
            $reader->setDelimiter(','); // Set the delimiter explicitly
            $spreadsheet = $reader->load(public_path('/uploads/txt_upload/'.$file_name));
        } elseif($extension == 'xlsx') {
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
            $spreadsheet = $reader->load(public_path('/uploads/txt_upload/'.$file_name));
        } else {
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
            $spreadsheet = $reader->load(public_path('/uploads/txt_upload/'.$file_name));
        }

        // $spreadsheet = $reader->load(public_path('/uploads/upload_excel/'.$file_name));
        $allDataInSheet = $spreadsheet->getActiveSheet();
        $lastRow = $allDataInSheet->getHighestRow();
        
        $single_arr=[];
        $bundle_arr=[];
        for ($row = 2; $row <= $lastRow; $row++) {
            $variation_design= trim($allDataInSheet->getCell('A'.$row)->getValue());
            
            
            $start_number=isset($variation_design[0])?$variation_design[0]:'0';
            
            if($start_number =='4'){
                $bundle_check=preg_match( '/^4BUN/im',$variation_design);
                
                if($bundle_check==true){
                    $bundle_arr[]=$variation_design;
                }else{
                    $single_arr[]=$variation_design;
                }
                
                // dd($variation_design);
            }
        }
        
        $urgent=0;
        if($urgent_tag ==1){
            $urgent=1;
        }else{
            $urgent=0;
        }
        
        // dd($bundle_arr,$single_arr,$store_id,$shipment_type,$urgent);
            
        if(count($bundle_arr)>0){
            DB::table('bundle_list_pr_wise')
                ->whereIn('bundle_set_variation',$bundle_arr)
                ->where('store_id','=',$store_id)
                ->where('shipment_type','=',$shipment_type)
                ->where('status','=',0)
                ->update([
                    'urgent_status' => $urgent,
                    'urgent_date' => now(),
                    'urgent_by' => auth()->user()->id
                ]);
        }
        
        if(count($single_arr)>0){
            DB::table('process_order_quantity')
                ->whereIn('variation_design',$single_arr)
                ->where('store_id','=',$store_id)
                ->where('shipment_type','=',$shipment_type)
                ->where('status','=',0)
                ->update([
                    'urgent_status' => $urgent,
                    'urgent_date' => now(),
                    'urgent_by' => auth()->user()->id
                ]);
        }
        
        return true;
    }
}

