<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use App\Models\Sku;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

use App\Helpers\ReportHelper;


class TrendController extends Controller
{
    protected $keyArr=[1,2,3,4,5];
    
    public function __construct(){
        $this->middleware(['auth']);
    }
    
    public function index(Request $request){
        $login_user=auth()->user();
        $path_new = storage_path() . "/data_reports/trendsSalesnew_".$login_user->id.".json";
        $dataArrayStock=[];
        $today_date=date('d-m-Y');
        
        
        
        if($request->ajax()){
            $country_list=$request->countrySelector;
            
            $title=$request->title;
            $withOutSpaceTitle=trim(str_replace('<br>','_',$title));
            $track_id=$request->track_id;
            
            
            
            if (file_exists($path_new)) {
                $jsonData = file_get_contents($path_new);
                $dataArrayStock = json_decode($jsonData, true);
                
                $lastUpdateDate=isset($dataArrayStock['lastUpdateDate'])?$dataArrayStock['lastUpdateDate']:'';
                // dd($dataArrayStock['compare_filter']);
                
                if($today_date==$lastUpdateDate){
                    $dataArrayStock=$dataArrayStock;
                }else{
                    $dataArrayStock=[];
                }
                
                
            }
            
            
            
            $dataArrayStock['lastUpdateDate']=$today_date;
            
            
            
            if($request->start_date !=''){
                $start_date = date('Y-m-d',strtotime($request->start_date));
            }else{
                $start_date = date('Y-m-d');
            }
    	        
            if($request->end_date !=''){
                $end_date = date('Y-m-d',strtotime($request->end_date));
            }else{
                $end_date = date('Y-m-d');
            }
        
            if($request->child_sku !=''){
               $child=1;
            }else{
               $child=0;
            }
            
            
            
            
            
	        $sale = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,$country_list,$child,4);
                 
            $dataArrayStock['compare_filter'][$track_id]=[
                'title' => $withOutSpaceTitle,
                'sale'=> $sale,
            ];
            
            
            
            
                
            $json_encode = json_encode($dataArrayStock);
            file_put_contents($path_new,$json_encode);
            
            $html='';
        
            return response()->json([
                'code' => 200,
                'html' => $html
            ]);
            
            
        }else{
            $json_encode = json_encode($dataArrayStock);
            file_put_contents($path_new,$json_encode);
            return view('datareports.trend');
        }
        
    }
    
    public function clearFilter(Request $request){
        if($request->ajax()){
            $login_id=auth()->user();
            $path_new = storage_path() . "/data_reports/trendsSalesnew_".$login_id->id.".json";
            $dataArrayStock=[];
            
            $json_encode = json_encode($dataArrayStock);
            file_put_contents($path_new,$json_encode);
            
            return response()->json([
                'code' => 200,
                'message' => 'Clear Filter'
            ]);
        }
    }
    
    public function ajax_datatable(Request $request){
        $login_id=auth()->user();
        $path_new = storage_path() . "/data_reports/trendsSalesnew_".$login_id->id.".json";
            
        $jsonData =file_get_contents($path_new);
        $dataArrayStock = json_decode($jsonData, true);
        
        // dd($dataArrayStock);
            
        
        
        $data_show=$request->data_show;
            
        if($data_show ==0){
            return DataTables::of([])->make(true);
        }
        
        $columns = [
            0 =>'id' 
        ];
            
            
        $limit = $request->input('length');
        $start = $request->input('start');
        // $order = $columns[$request->input('order.0.column')];
        // $dir = $request->input('order.0.dir');
        $order = $columns[0];
        $dir = 'ASC';
        
        $url=asset('uploads/sku_images/').'/';
        
        $fields_single='prod_status,
                        group_id,
                        variation_design,
                        prod_design,
                        product_name,
                        CASE 
                            WHEN product_url != "" THEN product_url
                            ELSE CONCAT("'.$url.'", prod_img)
                        END as image';
        
        $fields_bundle='status as prod_status,
                        bundle_group as group_id,
                        bundle_set_variation as variation_design,
                        decrum_instock as prod_design,
                        bundle_name as product_name,
                        image_url as image';
            
        $is_discarded=$request->is_discarded;
        $child_sku=$request->child_sku;
            
        $status='';
        
        $where_single=$where_bundle=' is_deleted = 0';
        
        if($is_discarded ==''){
            $where_single .=' AND prod_status = 1';
            $where_bundle .=' AND status = 1';
        }
            
            
        if(!empty($request->input('search.value'))){
            $search = trim($request->input('search.value'));
            
            $search_minus_e='-';
            
            if(preg_match("/{$search_minus_e}/i", strtolower($search))){
                $exp=explode('-',$search);
                $group_id=$exp[0];
                $dalpha=$exp[1];
                
                $where_single.=' AND ( group_id = "'.$group_id.'" AND variation_design LIKE "%'.$dalpha.'%" )';
            }else{
                $where_single.=' AND ( variation_design LIKE "%'.$search.'%" OR product_name LIKE "%'.$search.'%" )';
                
            }
            
            $where_bundle.=' AND ( bundle_set_variation LIKE "%'.$search.'%" OR bundle_set_name LIKE "%'.$search.'%" )';
        }
        
        $results_bundle = DB::table('bundle')
                            ->selectRaw($fields_bundle)
                            ->whereRaw($where_bundle);
                            
        $results = DB::table('product_info_design')
                        ->selectRaw($fields_single)
                        ->whereRaw($where_single);
        
        $gsingle=$gbundle='';
        if($child_sku ==''){
            $results_bundle->groupBy('group_id');
            $results->groupBy(['group_id','prod_design']);
            
            $gsingle=' GROUP BY group_id,prod_design';
            $gbundle=' GROUP BY bundle_group';
        }
        
    $c='SELECT COUNT(*) AS allcount FROM (
                        SELECT group_id
                        FROM product_info_design
                        WHERE '.$where_single.$gsingle.'
                                            
                        UNION ALL
                    
                        SELECT bundle_group AS group_id
                        FROM bundle
                        WHERE '.$where_bundle.$gbundle.'
                        
                    ) t';
                    
                    // dd($c);
            
        $totalData = DB::select($c)[0]->allcount;
        
        $totalFiltered = $totalData;
            
        
        $results=$results->union($results_bundle);
            
        if($limit !='-1'){
            $skus=$results->offset($start)->limit($limit)->get();
        }else{
            $skus=$results->get();
        }
        
        $data = [];
            
        if($skus->count()>0){
            foreach($skus as $sku){
                
                $url=$sku->image;
                
                $image='<a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image" id="product_img_'.$sku->group_id.'">
                        <img src="'.$url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">
                    </a>';
                
                
                
                
                            
                $astatus='<span class="badge badge-success">Active</span>';
                if(in_array($sku->prod_status,[0,2])){
                    $astatus='<span class="badge badge-danger">Discard</span>';
                }
                
                $group_id=$sku->group_id;
                
                $design1=explode('-',$sku->variation_design);
                $design1=isset($design1[1])?'-'.$design1[1]:'';
                if($child_sku ==''){
                    if($design1){
                        $group_design=$sku->group_id.$design1;
                    }else{
                        $group_design=$group_id;
                    }
                    
                    $product_name=explode(",",$sku->product_name);
                    $product_name=$product_name[0];
                }else{
                    $group_design=$sku->variation_design;
                    $product_name=$sku->product_name;
                }
                
                
                $n=$this->compare_total($group_design,$dataArrayStock);
                $new=[];
                $new['ProductImg'] = $image;
                $new['variation']= $group_design;
                $new['ProductDetail']='<span class="text-wrap" style="width: 1rem;">'.$product_name.'</span><br>'.$astatus;
                $data[] = array_merge($new,$n);
            }
        }
        
        $json_data = [
            "draw"            => intval($request->input('draw')),  
            "recordsTotal"    => intval($totalData),  
            "recordsFiltered" => intval($totalFiltered), 
            "data"            => $data
        ];
        
        return response()->json($json_data);
    }
    
    
    
    public function compare_total($sku,$dataArrayStock){
        $compareFilter=$dataArrayStock['compare_filter'];
        
        $keyArr=$this->keyArr;
        
        $count=0;
        $returnKey=[];
        $upcoming1=$upcoming2=0;
        $upcoming1Arr=[];
        $upcoming2Arr=[];
        foreach($keyArr as $k){
            if(isset($compareFilter[$k])){
                $dStock=$compareFilter[$k];
                $total=0;
                
                        
                if(isset($dStock['sale'][$sku])){
                    $total+=$dStock['sale'][$sku]['total_sale'];
                }
                
                $returnKey['th_'.$k]=$total;
                $upcoming1Arr[]=$total;
                $upcoming2Arr[]=$total;
                $count++;
            }else{
                $returnKey['th_'.$k]=0;
            }
        }
        
        
        $up_coming_1 = round((array_sum($upcoming1Arr) / count($upcoming1Arr)));
        
        
        array_shift($upcoming2Arr);
        $upcoming2Arr[]=$up_coming_1;
        $up_coming_2 = round((array_sum($upcoming2Arr) / count($upcoming2Arr)));
        
        $returnKey['up_comming_1']=$up_coming_1;
        $returnKey['up_comming_2']=$up_coming_2;
        
        return $returnKey;
    }


    
}
