<?php
namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use \DB;

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

use DataTables;

use App\Helpers\ReportHelper;

// ini_set('memory_limit', '128M');

class StockDashboardController extends Controller
{

    public function __construct(){
        $this->middleware('auth');
    }
    
    
    public function stockDashboard(Request $request){
        $login_id=auth()->user();
        $path_new = storage_path() . "/data_reports/stockDashboard_".$login_id->id.".json";
        
        $data=[];
        
        if($request->ajax()){
            
            $store=$request->store;
            $teamId=4;
            
            if($request->child_sku !=''){
               $child=1;
            }else{
               $child=0;
            }
            
            
            if($request->start_date !=''){
	            $start_date = date('Y-m-d',strtotime($request->start_date));
	        }else{
	            $start_date = date('Y-m-d');
	        }
	        
	        if($request->end_date !=''){
	            $end_date = date('Y-m-d',strtotime($request->end_date));
	        }else{
	            $end_date = date('Y-m-d');
	        }
	        
	        if($store == 1){
	            $sale = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,['US'],$child,4);
	            $inventory = ReportHelper::getAmazonInventory("inventory_report_decrum",$child);
	            $awd = ReportHelper::getAWDInventory("inventory_report_decrum_awd",$child);
            }else if($store == 6){
                $sale = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,['CA'],$child,4);
	            $inventory = ReportHelper::getAmazonInventory("inventory_report_decrum_ca",$child);
	            $awd = ReportHelper::getAWDInventory("inventory_report_decrum_ca_awd",$child);
            }
	        
            
                 
            $data=[
                'decrum_sale' => $sale,
                'decrum_inventory' => $inventory,
                'decrum_awd' => $awd,
                'last_start_date' => $start_date,
                'last_end_date' => $end_date,
            ];
            
            // dd($data);
            
            
            $json_encode = json_encode($data);
            file_put_contents($path_new,$json_encode);
            
            $html='Date Filter Applied : '.date('d-m-Y',strtotime($start_date)).' To '.date('d-m-Y',strtotime($end_date));
        
            return response()->json([
                'code' => 200,
                'html' => $html
            ]);
            
            
        }else{
            $html='';
            
	        
	        $json_encode = json_encode($data);
            file_put_contents($path_new,$json_encode);
            $stores=DB::table('store')->where('status','=','1')->whereIn('id',[1,6])->orderBy('id','ASC')->get();
            return view('datareports.stockDasboard',['date_text' => $html,'stores'=> $stores]);
        }
    }
    
    
    public function total_sale($sku,$dataArrayStock){
        $totalSale=0;
        
        // dd($dataArrayStock['decrum_sale']);
        
        if(isset($dataArrayStock['decrum_sale'][$sku])){
            $totalSale+=$dataArrayStock['decrum_sale'][$sku]['total_sale'];
        }
        
        return $totalSale;
    }
    
    public function stockCheck($sku,$dataStock,$child,$country_list=[],$stock_type){
        $total_stock=0;
        
        if(!empty($stock_type)){
            if(isset($dataStock['decrum_inventory'][$sku])){
                $decrum=$dataStock['decrum_inventory'][$sku];
                
                if(in_array(1,$stock_type)){
                    $total_stock+=$decrum['instock'];
                }
                
                if(in_array(2,$stock_type)){
                    $total_stock+=$decrum['inbound'];
                }
                
                if(in_array(3,$stock_type)){
                    $total_stock+=$decrum['reserved'];
                }
                
            } 
            
            if(in_array(4,$stock_type)){
                if(isset($dataStock['decrum_awd'][$sku])){
                    $awd=$dataStock['decrum_awd'][$sku];
                    $total_stock+=$awd['instock'];
                }
            }
            
        }else{
            if(isset($dataStock['decrum_inventory'][$sku])){
                $decrum=$dataStock['decrum_inventory'][$sku];
                $total_stock+=$decrum['instock'];
                $total_stock+=$decrum['inbound'];
                $total_stock+=$decrum['reserved'];
            }
            
            if(isset($dataStock['decrum_awd'][$sku])){
                $awd=$dataStock['decrum_awd'][$sku];
                $total_stock+=$awd['instock'];
            }
        }
        
        return $total_stock;
    }
    
    
    
    
    public function ajax_datatable(Request $request){
        if($request->ajax()){
            $child_sku_check=$request->child_sku;
            $opex_url=env('OPEX_URL');
            $login_id=auth()->user();
            
            
            // $gender=$request->gender;
            $is_discarded=$request->is_discarded;
            
            // $country_list=$request->countrySelector;
            $stock_type=$request->stockType;
            $data_show=$request->data_show;
            
            
            $path_new = storage_path() . "/data_reports/stockDashboard_".$login_id->id.".json";
	        $jsonData = file_get_contents($path_new);
            $dataSale = json_decode($jsonData, true);
            
            $columns = [
                0 =>'id' 
            ];
            
            
            $limit = $request->input('length');
            $start = $request->input('start');
            // $order = $columns[$request->input('order.0.column')];
            // $dir = $request->input('order.0.dir');
            $order = $columns[0];
            $dir = 'ASC';
        
            $url=asset('uploads/sku_images/').'/';
        
            $fields_single='prod_status,
                        group_id,
                        variation_design,
                        prod_design,
                        product_name,
                        grade,
                        CASE 
                            WHEN product_url != "" THEN product_url
                            ELSE CONCAT("'.$url.'", prod_img)
                        END as image';
        
            $fields_bundle='status as prod_status,
                        bundle_group as group_id,
                        bundle_set_variation as variation_design,
                        decrum_instock as prod_design,
                        bundle_name as product_name,
                        grade,
                        image_url as image';
            
            $is_discarded=$request->is_discarded;
            $child_sku=$request->child_sku;
            $occasional_sku=$request->occasional_sku;
            
            // dd($occasional_sku);
                
            $status='';
            
            $where_single=$where_bundle=' is_deleted = 0';
            
            if($is_discarded ==''){
                $where_single .=' AND prod_status = 1';
                $where_bundle .=' AND status = 1';
            }
            
            if($occasional_sku == ''){
                $where_single .=' AND occasion_status = 0';
                $where_bundle .=' AND occasion_status = 0';
            }else{
                $where_single .=' AND occasion_status = 1';
                $where_bundle .=' AND occasion_status = 1';
            }
            
            
            if(!empty($request->input('search.value'))){
                $search = trim($request->input('search.value'));
                
                $search_minus_e='-';
                
                if(preg_match("/{$search_minus_e}/i", strtolower($search))){
                    $exp=explode('-',$search);
                    $group_id=$exp[0];
                    $dalpha=$exp[1];
                    
                    $where_single.=' AND ( group_id = "'.$group_id.'" AND variation_design LIKE "%'.$dalpha.'%" )';
                }else{
                    $where_single.=' AND ( variation_design LIKE "%'.$search.'%" OR product_name LIKE "%'.$search.'%" )';
                    
                }
                
                $where_bundle.=' AND ( bundle_set_variation LIKE "%'.$search.'%" OR bundle_set_name LIKE "%'.$search.'%" )';
            }
            
            $results_bundle = DB::table('bundle')
                                ->selectRaw($fields_bundle)
                                ->whereRaw($where_bundle);
                                
            $results = DB::table('product_info_design')
                            ->selectRaw($fields_single)
                            ->whereRaw($where_single);
            
            $gsingle=$gbundle='';
            if($child_sku ==''){
                $results_bundle->groupBy('group_id');
                $results->groupBy(['group_id','prod_design']);
                
                $gsingle=' GROUP BY group_id,prod_design';
                $gbundle=' GROUP BY bundle_group';
            }
            
        $c='SELECT COUNT(*) AS allcount FROM (
                            SELECT group_id
                            FROM product_info_design
                            WHERE '.$where_single.$gsingle.'
                                                
                            UNION ALL
                        
                            SELECT bundle_group AS group_id
                            FROM bundle
                            WHERE '.$where_bundle.$gbundle.'
                            
                        ) t';
                        
                        // dd($c);
                
            $totalData = DB::select($c)[0]->allcount;
            
            $totalFiltered = $totalData;
                
            
            $results=$results->union($results_bundle);
            
            $stable=$results->get();
                
            if($limit !='-1'){
                $skus=$results->offset($start)->limit($limit)->get();
            }else{
                $skus=$results->get();
            }
            
            
            
            $data=[];
            
            $total_avg=$total_usable=$total_avail=0;
            if(!empty($skus)){
                foreach($stable as $row){
                    
                    // dd($row->variation_design);
                    
                    $group_id=$row->group_id;
                
                    $design1=explode('-',$row->variation_design);
                    $design1=isset($design1[1])?'-'.$design1[1]:'';
                    if($child_sku_check ==''){
                        if($design1){
                            $group_design=$row->group_id.$design1;
                        }else{
                            $group_design=$group_id;
                        }
                        
                        $product_name=explode(",",$row->product_name);
                        $product_name=$product_name[0];
                    }else{
                        $group_design=$row->variation_design;
                        $product_name=$row->product_name;
                    }
                    $sku=$group_design;
                    
                    $total_sale=$this->total_sale($sku,$dataSale);
                    
                    
                    $available_stock=$this->stockCheck($sku,$dataSale,$child_sku_check,[],$stock_type);
                    
                    $percentage=0;
                    if($total_sale !=0 && $available_stock !=0){
                        $percentage=($available_stock/$total_sale)*100;
                    }
                    
                    $percentage=round($percentage);
                    
                    $usable_stock=$total_sale;
                    if($percentage <100){
                        $usable_stock= ($usable_stock/100) * $percentage;
                        $usable_stock=round($usable_stock);
                    }
                    
                    $total_avg+=$total_sale;
                    $total_usable+=$usable_stock;
                    $total_avail+=$available_stock;
                }
                
                foreach ($skus as $row){
                    $url=$row->image;
                
                    $image='<a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image" id="product_img_'.$row->group_id.'">
                        <img src="'.$url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">
                    </a>';
                    
                    $group_id=$row->group_id;
                
                    $design1=explode('-',$row->variation_design);
                    $design1=isset($design1[1])?'-'.$design1[1]:'';
                    if($child_sku_check ==''){
                        if($design1){
                            $group_design=$row->group_id.$design1;
                        }else{
                            $group_design=$group_id;
                        }
                        
                        $product_name=explode(",",$row->product_name);
                        $product_name=$product_name[0];
                    }else{
                        $group_design=$row->variation_design;
                        $product_name=$row->product_name;
                    }
                    $sku=$group_design;
                    
                    
                    
                    
                    $is_discarded='<br><span class="badge badge-success"> Active</span>';
                    if($row->prod_status ==2 || $row->prod_status ==0 ){
                        $is_discarded='<br><span class="badge badge-danger"> Deactive</span>';
                    }
                    
                    $total_sale=$this->total_sale($sku,$dataSale);
                    $available_stock=$this->stockCheck($sku,$dataSale,$child_sku_check,[],$stock_type);
                    
                    $percentage=0;
                    if($total_sale !=0 && $available_stock !=0){
                        $percentage=($available_stock/$total_sale)*100;
                    }
                    
                //     if($sku =='131362'){
                //     dd($sku,$available_stock,$child,$country_list,$stock_type);
                // }
                    
                    $percentage=round($percentage);
                    
                    $usable_stock=$total_sale;
                    if($percentage <100){
                        $usable_stock= ($usable_stock/100) * $percentage;
                        $usable_stock=round($usable_stock);
                    }
                    
                    $new=[];
                    $new['title']=$product_name.$is_discarded;
                    $new['sku']=$sku;
                    // $new['gender']=$gender;
                	$new['checkbox']=$image;
                	$new['available_stock']=$available_stock;
                	$new['total_sale']=$total_sale;
                	$new['sale_percentage']=$percentage.'%';
                	$new['usable_stock']=$usable_stock;
                	
                	$data[]=$new;
                }
            }
            $instock_per=0;
            if($total_avg>0){
                $instock_per=($total_usable/$total_avg)*100;
                $instock_per=round($instock_per);
                
            }
            
            $json_data = [
                "draw"            => intval($request->input('draw')),  
                "recordsTotal"    => intval($totalData),  
                "recordsFiltered" => intval($totalFiltered), 
                "data"            => $data,
                'total_avg' => $total_avg,
                'total_usable' => $total_usable,
                'instock_per' => $instock_per,
                'total_avail' => $total_avail
            ];
            
            return response()->json($json_data);
        }
    }
    
   public function get_excel(Request $request){
        $login_id=auth()->user();
        $path_new = storage_path() . "/data_reports/stockDashboard_".$login_id->id.".json";
            
        $jsonData =file_get_contents($path_new);
        $dataSale = json_decode($jsonData, true);
        
        $file_name = 'stock_dashboard_'.date('d_m_Y'); 
        $url=asset('uploads/sku_images/').'/';
        
        $stock_type=$request->stockTypeSelector;
        $child_sku=$request->child_sku;
        $is_discarded=$request->discarded_sku;
        
        $fields_single='prod_status,
                        group_id,
                        variation_design,
                        prod_design,
                        product_name,
                        grade,
                        CASE 
                            WHEN product_url != "" THEN product_url
                            ELSE CONCAT("'.$url.'", prod_img)
                        END as image';
        
        $fields_bundle='status as prod_status,
                        bundle_group as group_id,
                        bundle_set_variation as variation_design,
                        decrum_instock as prod_design,
                        bundle_name as product_name,
                        grade,
                        image_url as image';
                        
        
        
            
        $status='';
        
        $where_single=$where_bundle=' is_deleted = 0';
        
        if($is_discarded ==''){
            $where_single .=' AND prod_status = 1';
            $where_bundle .=' AND status = 1';
        }
        
        $results_bundle = DB::table('bundle')
                            ->selectRaw($fields_bundle)
                            ->whereRaw($where_bundle);
                            
        $results = DB::table('product_info_design')
                        ->selectRaw($fields_single)
                        ->whereRaw($where_single);
        
        $gsingle=$gbundle='';
        if($child_sku ==''){
            $results_bundle->groupBy('group_id');
            $results->groupBy(['group_id','prod_design']);
            
            $gsingle=' GROUP BY group_id,prod_design';
            $gbundle=' GROUP BY bundle_group';
        }
        
   
            
        
        $results=$results->union($results_bundle);
        $skus=$results->get();
        
        
        $spreadsheet = new Spreadsheet();
        $spreadsheet->setActiveSheetIndex(0);
        $sheet = $spreadsheet->getActiveSheet();
        
        $sheet->setCellValue('A1', 'SKU');
        $sheet->setCellValue('B1', 'Product_Name');
        $sheet->setCellValue('C1', 'Available Stock');
        $sheet->setCellValue('D1', 'Total Sale');
        $sheet->setCellValue('E1', 'Stock %');
        $sheet->setCellValue('F1', 'Usable Stock');
        
        $rowCount=2;
        
        foreach($skus as $sku){
            $astatus='Active';
            if(in_array($sku->prod_status,[0,2])){
                $astatus='Discard';
            }
            
            $group_id=$sku->group_id;
            
            $design1=explode('-',$sku->variation_design);
            $design1=isset($design1[1])?'-'.$design1[1]:'';
            if($child_sku ==''){
                if($design1){
                    $group_design=$sku->group_id.$design1;
                }else{
                    $group_design=$group_id;
                }
                
                $product_name=explode(",",$sku->product_name);
                $product_name=$product_name[0];
            }else{
                $group_design=$sku->variation_design;
                $product_name=$sku->product_name;
            }
            
            $total_sale=$this->total_sale($group_design,$dataSale);
            $available_stock=$this->stockCheck($group_design,$dataSale,$child_sku,[],$stock_type);
                    
            $percentage=0;
            if($total_sale !=0 && $available_stock !=0){
                $percentage=($available_stock/$total_sale)*100;
            }
                    
            $percentage=round($percentage);
            
            $usable_stock=$total_sale;
            if($percentage <100){
                $usable_stock= ($usable_stock/100) * $percentage;
                $usable_stock=round($usable_stock);
            }
            
            $sheet->setCellValue('A'.$rowCount, $group_design);
            $sheet->setCellValue('B'.$rowCount, $product_name .' ('.$astatus.')');
            $sheet->setCellValue('C'.$rowCount, $available_stock);
            $sheet->setCellValue('D'.$rowCount, $total_sale);
            $sheet->setCellValue('E'.$rowCount, $percentage.'%');
            $sheet->setCellValue('F'.$rowCount, $usable_stock);
            $rowCount++;
        }
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
    
}