<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Models\Sku;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;

use App\Helpers\ReportHelper;
use PhpOffice\PhpSpreadsheet\Spreadsheet;


class SkuController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:sku-list');
        $this->middleware('permission:sku-create', ['only' => ['create','store']]);
        $this->middleware('permission:sku-edit', ['only' => ['show','edit']]);
        $this->middleware('permission:sku-delete', ['only' => ['delete']]);
        $this->middleware('permission:article-list', ['only' => ['articles']]);
        $this->middleware('permission:color-list', ['only' => ['colors']]);
        $this->middleware('permission:item-adjust', ['only' => ['item_adjust']]);
        $this->middleware('permission:add-new-bundle', ['only' => ['add_new_bundle']]);
        $this->middleware('permission:bundle-list', ['only' => ['bundle_list']]);
        $this->middleware('permission:design-list', ['only' => ['designs']]);


    }
    
    public function create(){
        $color=DB::table('product_color')->where('status',1)->get();
        $product_gender=DB::table('product_gender')->where('status',1)->get();
        $product_design=DB::table('product_design')->get();
        $product_type=DB::table('product_type')->get();
        $product_size=DB::table('product_size')->where('status',1)->get();
        $teams=DB::table('teams')->get();
        
        
        return view('sku.create',[
            'color' => $color,
            'product_gender' => $product_gender,
            'product_design' => $product_design,
            'teams' => $teams,
            'product_type' => $product_type,
            'product_size' => $product_size
        ]);
    }

    public function store(Request $request){
        
        $input = $request->all();
        // dd($input);
        
        if ($request->hasFile('file_img')) {
            $image = $request->file('file_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/sku_images');
            $image->move($destinationPath, $name);
            $file='prod_img';
            $f='product_url';
            $image_url=asset('uploads/sku_images/'.$name);
            $check_file=1;

        }else{
            $name=$input['image_url'];
            $file='product_url';
            $f='prod_img';
            $image_url=$name;
            $check_file=0;
        }
        
        $type=DB::table('product_type')->where('id',$input['product_type'])->first();
        $color=DB::table('product_color')->where('id',$input['color'])->first();
        
        $gender=1;
        $search_women=['women','womens','woman','female','girl'];
        $search_men=['men','mens','man','male','boy'];
        foreach ($search_women as $key => $value) {
            if(preg_match("/{$value}/i", strtolower($type->product_type))) {
                $gender=2;
            } 
        }

        if($input['product_type']<1000){
            if($input['product_type']<100){
                if($input['product_type']<10){
                    $input['product_type']='000'.$input['product_type'];
                }else{
                    $input['product_type']='00'.$input['product_type']; 
                }    
            }else{
                $input['product_type']='0'.$input['product_type'];
            }
        }
        
        if($input['color'] <10){
            $input['color']='0'.$input['color'];
        }
        
        if($input['design_check'] =='1'){
            $design_alpha=DB::table('design_alpha')->where('design_number',$input['design'])->first();
            $alpha=$design_alpha->design_alpha;
            $design_url=$input['design_image_url'];
        }else{
            $alpha='';
            $design_url='';
        }
        
        $group_id=$input['team'].$input['product_type'].$input['color'];
        
        if($input['design_check'] =='1'){
            if($input['variation_option'] =='2'){
                $product_size=DB::table('product_size')->where('status',1)->get();
                foreach ($product_size as $size) {
                    $variation_design=$input['team'].$input['product_type'].$input['color'].$size->id.'-'.$alpha;
                    $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
                    $var_id=DB::table('product_info_design')->where('variation_design',$variation_design)->get();
                    
                    if(count($var_id)>0){
                        return back()->with('has_error','Already Sku Register');
                    } 
                }
                $g_count=DB::table('type_images')->where('code',$group_id)->first();
                if($g_count==null){
                    $insert_type_images=[
                        'code' => $group_id,
                        'image' => $image_url
                    ];
            
                    DB::table('type_images')->insert($insert_type_images);
                }else{
                    if($image_url != $g_count->image){
                        $update_type_images=[
                            'image' => $image_url
                        ];
                        
                        DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                    }
                }
                foreach ($product_size as $size) {
                    $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
                    $variation_design=$input['team'].$input['product_type'].$input['color'].$size->id.'-'.$alpha;
                    
                    $v_count=DB::table('product_info')->where('variation_id',$variation_id)->first();
                    if($v_count==null){
                        $in_product_info=[
                           'product_name' => $type->product_type.' | '.$color->color.', '.$size->size,
                           'variation_id' => $variation_id,
                           'user_id' => auth()->id(),
                           'group_id' => $group_id,
                           'prod_status' => 1,
                           'team' => $input['team'],
                           'prod_gender' =>  $gender,
                           'prod_type'   => $type->id,
                           'prod_color' => $color->id,
                           'prod_size' => $size->id,
                           'Quantity' => '0',
                           'prod_variation' => $input['variation_option'],
                           'prod_design' =>1,
                            $f=>'',
                            $file => $name,
                           'created_at' => date('Y-m-d')
                        ]; 
                        Sku::create($in_product_info);
                    }else{
                       if($check_file){
                           if($v_count->prod_img != $name){
                                $up_arr=[
                                    'prod_img' => $name
                                ];
                                DB::table('product_info')->where('variation_id',$variation_id)->update($up_arr);
                           }
                       }else if($check_file ==0){
                            if($v_count->product_url != $name){
                                $up_arr=[
                                    'product_url' => $name
                                ];
                                
                                DB::table('product_info')->where('variation_id',$variation_id)->update($up_arr);
                           }
                       } 
                    }
                    $in_prod_info_design=[
                        'product_name' => $input['product_name'].' | '.$color->color.', '.$size->size,
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_design,
                        'user_id' => auth()->id(),
                        'group_id' => $group_id,
                        'prod_status' => 1,
                        'team' => $input['team'],
                        'prod_gender' =>  $gender,
                        'prod_type'   => $type->id,
                        'prod_color' => $color->id,
                        'prod_size' => $size->id,
                        'Quantity' => '0',
                        'prod_variation' => $input['variation_option'],
                        'prod_design' =>$input['design'],
                        'prod_img'=>'',
                        'product_url' => $design_url,
                        'created_at' => date('Y-m-d')
                    ];
                    
                    DB::table('product_info_design')->insert($in_prod_info_design);
                    
                    $insert_log=[
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_design,
                        'user_id' => auth()->user()->id,
                        'type_name' => 'ADD new  SKU', 
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    DB::table('sku_log')->insert($insert_log);
                }
            }else{
                $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
                $variation_design=$input['team'].$input['product_type'].$input['color'].$input['size'].'-'.$alpha;
                $product_size=DB::table('product_size')->where('id',$input['size'])->first();
                $var_id=DB::table('product_info_design')->where('variation_design',$variation_id)->get(); 
               
                $g_count=DB::table('type_images')->where('code',$group_id)->count();
                if($g_count==0){
                    $insert_type_images=[
                        'code' => $group_id,
                        'image' => $image_url
                    ];
            
                    DB::table('type_images')->insert($insert_type_images);
                }else{
                    if($image_url != $g_count->image){
                        $update_type_images=[
                            'image' => $image_url
                        ];
                        
                        DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                    }
                }
                
                $v_count=DB::table('product_info')->where('variation_id',$variation_id)->first();
                
                if($v_count ==null){
                    $in_product_info=[
                       'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                       'variation_id' => $variation_id,
                       'user_id' => auth()->id(),
                       'group_id' => $group_id,
                       'prod_status' => 1,
                       'team' => $input['team'],
                       'prod_gender' =>  $gender,
                       'prod_type'   => $type->id,
                       'prod_color' => $color->id,
                       'prod_size' => $input['size'],
                       'Quantity' => '0',
                       'prod_variation' => $input['variation_option'],
                       'prod_design' =>1,
                       $f=>'',
                       $file => $name,
                       'created_at' => date('Y-m-d')
                    ]; 
                    Sku::create($in_product_info);
                }else{
                   if($check_file){
                       if($v_count->prod_img != $name){
                            $up_arr=[
                                'prod_img' => $name
                            ];
                            DB::table('product_info')->where('variation_id',$variation_id)->update($up_arr);
                       }
                   }else if($check_file ==0){
                        if($v_count->product_url != $name){
                            $up_arr=[
                                'product_url' => $name
                            ];
                            
                            DB::table('product_info')->where('variation_id',$variation_id)->update($up_arr);
                       }
                   } 
                    
                }
                
                $in_prod_info_design=[
                    'product_name' => $input['product_name'].' | '.$color->color.', '.$product_size->size,
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_design,
                    'user_id' => auth()->id(),
                    'group_id' => $group_id,
                    'prod_status' => 1,
                    'team' => $input['team'],
                    'prod_gender' =>  $gender,
                    'prod_type'   => $type->id,
                    'prod_color' => $color->id,
                    'prod_size' => $input['size'],
                    'Quantity' => '0',
                    'prod_variation' => $input['variation_option'],
                    'prod_design' =>$input['design'],
                    'prod_img'=>'',
                    'product_url' => $design_url,
                    'created_at' => date('Y-m-d')
                ];
                
                DB::table('product_info_design')->insert($in_prod_info_design);
                
                $insert_log=[
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_design,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'ADD new  SKU', 
                    'created_date' => date('Y-m-d H:i:s')
                ];
                DB::table('sku_log')->insert($insert_log);
                
                
            }
        }else{
            if($input['variation_option'] =='2'){
                $product_size=DB::table('product_size')->where('status',1)->get();
                foreach ($product_size as $size) {
                    $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
                    $var_id=DB::table('product_info_design')->where('variation_design',$variation_id)->get();
                    
                    if(count($var_id)>0){
                        return back()->with('has_error','Already Sku Register');
                    }
                }
                
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
                
                DB::table('type_images')->insert($insert_type_images);
                
                foreach ($product_size as $size) {
                    $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
                    $in_product_info=[
                       'product_name' => $type->product_type.' | '.$color->color.', '.$size->size,
                       'variation_id' => $variation_id,
                       'user_id' => auth()->id(),
                       'group_id' => $group_id,
                       'prod_status' => 1,
                       'team' => $input['team'],
                       'prod_gender' =>  $gender,
                       'prod_type'   => $type->id,
                       'prod_color' => $color->id,
                       'prod_size' => $size->id,
                       'Quantity' => '0',
                       'prod_variation' => $input['variation_option'],
                       'prod_design' =>0,
                       $f=>'',
                       $file => $name,
                       'created_at' => date('Y-m-d')
                    ]; 
                    Sku::create($in_product_info);
                    
                    $in_prod_info_design=[
                        'product_name' => $input['product_name'].' | '.$color->color.', '.$size->size,
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_id,
                        'user_id' => auth()->id(),
                        'group_id' => $group_id,
                        'prod_status' => 1,
                        'team' => $input['team'],
                        'prod_gender' =>  $gender,
                        'prod_type'   => $type->id,
                        'prod_color' => $color->id,
                        'prod_size' => $size->id,
                        'Quantity' => '0',
                        'prod_variation' => $input['variation_option'],
                        'prod_design' =>0,
                        $f=>'',
                        $file => $name,
                        'created_at' => date('Y-m-d')
                    ];
                    
                    DB::table('product_info_design')->insert($in_prod_info_design);
                    
                    $insert_log=[
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_id,
                        'user_id' => auth()->user()->id,
                        'type_name' => 'ADD new  SKU', 
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    DB::table('sku_log')->insert($insert_log);
                }
           }else{
               $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
               $product_size=DB::table('product_size')->where('id',$input['size'])->first();
               $var_id=DB::table('product_info_design')->where('variation_design',$variation_id)->get();
               
                if(count($var_id)>0){
                    return back()->with('has_error','Already Sku Register');
                }
                
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
                
                DB::table('type_images')->insert($insert_type_images);
                
                $in_product_info=[
                   'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                   'variation_id' => $variation_id,
                   'user_id' => auth()->id(),
                   'group_id' => $group_id,
                   'prod_status' => 1,
                   'team' => $input['team'],
                   'prod_gender' =>  $gender,
                   'prod_type'   => $type->id,
                   'prod_color' => $color->id,
                   'prod_size' => $input['size'],
                   'Quantity' => '0',
                   'prod_variation' => $input['variation_option'],
                   'prod_design' =>0,
                   $f=>'',
                   $file => $name,
                   'created_at' => date('Y-m-d')
                ]; 
                Sku::create($in_product_info);
                    
                $in_prod_info_design=[
                    'product_name' => $input['product_name'].' | '.$color->color.', '.$product_size->size,
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_id,
                    'user_id' => auth()->id(),
                    'group_id' => $group_id,
                    'prod_status' => 1,
                    'team' => $input['team'],
                    'prod_gender' =>  $gender,
                    'prod_type'   => $type->id,
                    'prod_color' => $color->id,
                    'prod_size' => $input['size'],
                    'Quantity' => '0',
                    'prod_variation' => $input['variation_option'],
                    'prod_design' =>0,
                    $f=>'',
                    $file => $name,
                    'created_at' => date('Y-m-d')
                ];
                
                DB::table('product_info_design')->insert($in_prod_info_design);
                $insert_log=[
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_id,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'ADD new  SKU', 
                    'created_date' => date('Y-m-d H:i:s')
                ];
                DB::table('sku_log')->insert($insert_log);
           } 
        }
        
        
        // if($input['variation_option'] =='2'){
        //     $product_size=DB::table('product_size')->where('status',1)->get();
        //     foreach ($product_size as $size) {
        //         $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
        //         $var_id=Sku::where('variation_id',$variation_id)->get();
                
        //         if(count($var_id)>0){
        //             return back()->with('has_error','Already Sku Register');
        //         }
        //     }
        //     foreach ($product_size as $size) {
        //         $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
        //         $data=[
        //           'product_name' => $input['product_name'],
        //           'variation_id' => $variation_id,
        //           'user_id' => auth()->id(),
        //           'group_id' => $group_id,
        //           'prod_status' => 1,
        //           'team' => $input['team'],
        //           'prod_gender' =>  $gender,
        //           'prod_type'   => $input['product_type'],
        //           'prod_color' => $input['color'],
        //           'prod_size' => $size->id,
        //           'Quantity' => '0',
        //           'prod_variation' => $input['variation_option'],
        //           'prod_design' =>0,
        //           $f=>'',
        //           $file => $name,
        //           'created_at' => date('Y-m-d')
        //         ]; 
        //         Sku::create($data);
        //     }
            
        // }else{
        //     $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
        //     $var_id=Sku::where('variation_id',$variation_id)->get();
        //     // dd($var_id);
        //     if(count($var_id)>0){
        //         return back()->with('has_error','Already Sku Register');
        //     }
        //     $data=[
        //         'product_name' => $input['product_name'],
        //         'variation_id' => $variation_id,
        //         'group_id' => $group_id,
        //         'user_id' => auth()->id(),
        //         'prod_status' => 1,
        //         'team' => $input['team'],
        //         'prod_gender' =>  $gender,
        //         'prod_type'   => $input['product_type'],
        //         'prod_color' => $input['color'],
        //         'prod_size' => $input['size'],
        //         'Quantity' => '0',
        //         'prod_variation' => $input['variation_option'],
        //         'prod_design' =>0,
        //         $file => $name,
        //         $f=>'',
        //         'created_at' => date('Y-m-d')
        //      ]; 
        //      Sku::create($data);
        // }
        
        //show
        return redirect()->route('sku.with.design')->with('has_success','Sku [<strong>'.$input['product_name'].'</strong>] with Group [<strong>'.$group_id.'</strong>] Insert Successfully');
    }

    public function show($id){
        $color=DB::table('product_color')->where('status',1)->get();
        // $product_gender=DB::table('product_gender')->where('status',1)->get();
        $product_type=DB::table('product_type')->get();
        $product_size=DB::table('product_size')->where('status',1)->get();
        $product_design=DB::table('product_design')->get();
        $teams=DB::table('teams')->get();
        // $record = Sku::find($id);
        $record=DB::table('product_info_design')->where('id',$id)->first();
        $record2=Sku::where('variation_id',$record->variation_id)->first();
        // dd($record2);
        return view('sku.edit',[
            'record' => $record,
            'record2' => $record2,
            'color' => $color,
            // 'product_gender' => $product_gender,
            'teams' => $teams,
            'product_type' => $product_type,
            'product_size' => $product_size,
            'product_design' => $product_design
            ]);
    }

    public function edit($id,Request $request){
        $input = $request->all();
        $record = DB::table('product_info_design')->where('id',$id)->first();
        $record_design=Sku::where('variation_id',$record->variation_id)->first();
        if ($request->hasFile('file_img')) {
            $image = $request->file('file_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/sku_images');
            
            $image->move($destinationPath, $name);
            // $this->save();
            $file='prod_img';
            $f='product_url';
            $image_url=asset('uploads/sku_images/'.$name);
        }else{
            if($input['image_url'] !=''){
                $name=$input['image_url'];
                $file='product_url';
                $f='prod_img';
                $image_url=$name;
            }else{
                if($record_design->prod_img !=''){
                    $name=$record_design->prod_img;
                    $file='prod_img';
                    $f='product_url';
                    $image_url=$name;
                }else if($record_design->product_url !=''){
                    $name=$record_design->product_url;
                    $file='product_url';
                    $f='prod_img';
                    $image_url=$name;
                }
                
            }
            
        }
        
        $type=DB::table('product_type')->where('id',$input['product_type'])->first();
        $color=DB::table('product_color')->where('id',$input['color'])->first();
        
        $gender=1;
        $search_women=['women','womens','woman','female','girl'];
        $search_men=['men','mens','man','male','boy'];
        foreach ($search_women as $key => $value) {
            if(preg_match("/{$value}/i", strtolower($type->product_type))) {
                $gender=2;
            } 
        }
        
        
        
        if($input['product_type']<1000){
            if($input['product_type']<100){
                if($input['product_type']<10){
                    $input['product_type']='000'.$input['product_type'];
                }else{
                    $input['product_type']='00'.$input['product_type']; 
                }    
            }else{
                $input['product_type']='0'.$input['product_type'];
            }
        }
        
        if($input['color'] <10){
            $input['color']='0'.$input['color'];
        }
        
        if($input['design_check'] =='1'){
            $design_alpha=DB::table('design_alpha')->where('design_number',$input['design'])->first();
            $alpha=$design_alpha->design_alpha;
            $design_url=$input['design_image_url'];
        }else{
            $alpha='';
            $design_url='';
        }
        
        $group_id=$input['team'].$input['product_type'].$input['color'];
        
        if($input['design_check'] =='1'){
            $variation_design=$input['team'].$input['product_type'].$input['color'].$input['size'].'-'.$alpha;
            $check_var=DB::table('product_info_design')
                            ->where('variation_design',$variation_design)
                            ->where('id','!=',$id)
                            ->exists();
            if($check_var){
               return back()->with('has_error','Already Sku Register'); 
            }
            
            $g_count=DB::table('type_images')->where('code',$group_id)->first();
            if($g_count ==null){
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
        
                DB::table('type_images')->insert($insert_type_images);
            }else{
                if($image_url != $g_count->image){
                    $update_type_images=[
                        'image' => $image_url
                    ];
                    
                    DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                }
            }
            
            $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
            $product_size=DB::table('product_size')->where('id',$input['size'])->first();
            $check_var=Sku::where('variation_id',$variation_id)->first();
            
            if($check_var == null){
                $in_product_info=[
                   'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                   'variation_id' => $variation_id,
                   'user_id' => auth()->id(),
                   'group_id' => $group_id,
                   'prod_status' => 1,
                   'team' => $input['team'],
                   'prod_gender' =>  $gender,
                   'prod_type'   => $type->id,
                   'prod_color' => $color->id,
                   'prod_size' => $input['size'],
                   'Quantity' => '0',
                   'prod_variation' => 1,
                   'prod_design' =>1,
                   $f=>'',
                   $file => $name,
                   'created_at' => date('Y-m-d')
                ]; 
                Sku::create($in_product_info);
            }else{
                $update_arr=[
                    $f=>'',
                    $file => $name,
                ];
                
                $record_design->update($update_arr);
            }
            
            $update_design=[
                'product_name' => $input['product_name'],
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'group_id' => $group_id,
                'team' => $input['team'],
                'prod_gender' => $gender,
                'prod_type'   => $type->id,
                'prod_color' => $color->id,
                'prod_size' => $input['size'],
                'prod_design' =>$input['design'],
                'product_url' => $design_url
            ];
            
            DB::table('product_info_design')->where('id',$id)->update($update_design);
            
            $insert_log=[
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'user_id' => auth()->user()->id,
                'type_name' => 'Edit SKU', 
                'created_date' => date('Y-m-d H:i:s')
            ];
            DB::table('sku_log')->insert($insert_log);
            
        }else{
            $variation_design=$input['team'].$input['product_type'].$input['color'].$input['size'];
            $check_var=DB::table('product_info_design')
                            ->where('variation_design',$variation_design)
                            ->where('id','!=',$id)
                            ->exists();
            if($check_var){
               return back()->with('has_error','Already Sku Register'); 
            }
            
            $g_count=DB::table('type_images')->where('code',$group_id)->first();
            if($g_count == null){
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
        
                DB::table('type_images')->insert($insert_type_images);
            }else{
                if($image_url != $g_count->image){
                    $update_type_images=[
                        'image' => $image_url
                    ];
                    
                    DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                }
            }
            
            $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
            $product_size=DB::table('product_size')->where('id',$input['size'])->first();
            $check_var=Sku::where('variation_id',$variation_id)->first();
            
            if($check_var == null){
                $in_product_info=[
                   'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                   'variation_id' => $variation_id,
                   'user_id' => auth()->id(),
                   'group_id' => $group_id,
                   'prod_status' => 1,
                   'team' => $input['team'],
                   'prod_gender' =>  $gender,
                   'prod_type'   => $type->id,
                   'prod_color' => $color->id,
                   'prod_size' => $input['size'],
                   'Quantity' => '0',
                   'prod_variation' => 1,
                   'prod_design' =>0,
                   $f=>'',
                   $file => $name,
                   'created_at' => date('Y-m-d')
                ]; 
                Sku::create($in_product_info);
            }else{
                $update_arr=[
                    $f=>'',
                    $file => $name,
                ];
                
                $record_design->update($update_arr);
            }
            
            $update_design=[
                'product_name' => $input['product_name'],
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'group_id' => $group_id,
                'team' => $input['team'],
                'prod_gender' => $gender,
                'prod_type'   => $type->id,
                'prod_color' => $color->id,
                'prod_size' => $input['size'],
                'prod_design' =>$input['design'],
                $f=>'',
                $file => $name,
                
            ];
            
            DB::table('product_info_design')->where('id',$id)->update($update_design);
            
            $insert_log=[
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'user_id' => auth()->user()->id,
                'type_name' => 'Edit SKU', 
                'created_date' => date('Y-m-d H:i:s')
            ];
            DB::table('sku_log')->insert($insert_log);
        }
        
        
        
        
        
        // $var_id=Sku::where('variation_id',$variation_id)->where('id','!=',$id)->get();
        // if(count($var_id)>0){
        //     return back()->with('has_error','Already Sku Register');
        // }
        // $record = Sku::find($id);

        // $data=[
        //     'product_name' => $input['product_name'],
        //     'team' => $input['team'],
        //     'prod_gender' => '1',
        //     'prod_type'   => $input['product_type'],
        //     'prod_color' => $input['color'],
        //     'prod_size' => $input['size'],
        //     'Quantity' => '0',
        //     'prod_design' =>0,
        //     $file => $name,
        //     $f => '',
        //  ]; 
        //  $record = Sku::find($id);
        //  $record->update($data);
         return redirect()->route('sku.with.design')->with('has_success','Sku updated Successfully');

    }

    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i <$length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function delete($id){
        $record = DB::table('product_info_design')->where('id','=',$id)->first();
        if($record->prod_status=='1'){
            $data=[
                'prod_status' => 2
            ];
        }else{
            $data=[
                'prod_status' => 1
            ];
        }
       
        DB::table('product_info_design')->where('id','=',$id)->update($data);
        \Session::flash('has_success', 'Sku Updated Successfully'); 
        return true;
        
    }

    public function index(){
        $color=DB::table('product_color')->where('status',1)->get();
        $product_gender=DB::table('product_gender')->where('status',1)->get();
        return view('sku.index',[
            'color' => $color,
            'product_gender' => $product_gender,
        ]);
    }

    public function get_details(){
        $g=DB::table('product_gender')->get(['gender']);
        $t=DB::table('product_type')->get(['product_type']);
        $cc=DB::table('product_color')->get(['color']);
    }

    public function add_color_articles(Request $request){
        $input=$request->input;
        $type=$request->type;
        if ($request->hasFile('file_img')) {
            $image = $request->file('file_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/article_images');
            $image->move($destinationPath, $name);
            
        }else{
            $name='';
        }
        if($type=='1'){
            $table='product_color';
            $where='color';
        }else{
            $table='product_type';
            $where='product_type';
        }

        if (DB::table($table)->where($where, trim($input))->exists()) {
            echo 0;
        }else{
            if($type=='1'){
                $insert=[
                    $where => $input,
                    'status' => 1
                ];
            }else{
                $insert=[
                    $where => $input,
                    'article_img' => $name,
                    'article_url' => ($request->article_image_url !='')?$request->article_image_url:'',
                    'status' => 1
                ];
            }
            
            $res=DB::table($table)->insertGetId($insert);
            if($type=='1'){
                echo $res;
            }else{
                echo json_encode([
                    'id'=>$res,
                    'image' =>($request->article_image_url !='')? $request->article_image_url:asset('uploads/article_images/'.$name)
                ]);
            }
            
        }
    }
    
    public function add_design(Request $request){
        $input=$request->input;
        if ($request->hasFile('dfile_img')) {
            $image = $request->file('dfile_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/design');
            $image->move($destinationPath, $name);
            
        }else{
            $name='';
        }
        
        if(DB::table('product_design')->where('design_title',$input)->exists()){
            return response()->json(['error' =>1,'msg'=>'Already Exists in Design' ]);
        }else{
            $insert=[
                'design_title' => $input,
                'design_icon' => $name,
                'created_by' => auth()->user()->id,
                'created_at' => date('Y-m-d H:i:s'),
                'status' => 1
            ];
            $res=DB::table('product_design')->insertGetId($insert);
            if($res){
                return response()->json([
                    'error' =>0,
                    'id' => $res,
                    'text' => $input,
                    'msg' => 'Successfully Insert in Design'
                ]);
            }
        }
    }

    public function articlesC(Request $request){
        if($request->ajax()){
            $records=DB::table('product_type as pt')
                        ->leftJoin('articles as a', 'a.id', '=', 'pt.article_id')
                        ->leftJoin('segment as s', 's.id', '=', 'pt.segment_id')
                        ->selectRaw('pt.*,a.article,s.name as segment');
            $is_discarded=$request->discarded_sku;
            
            if($is_discarded ==''){
                $records->where('pt.status','1');
            }
            
            if($request->article !=''){
                $records->where('pt.article_id',$request->article);
            }
            
            if($request->segment !=''){
                $records->where('pt.segment_id',$request->segment);
            }
            
            if(!empty($request->input('search.value'))){
                $search = trim($request->input('search.value'));
                $records->whereRaw('pt.product_type LIKE "%'.$search.'%" OR a.article LIKE "%'.$search.'%" OR s.name LIKE "%'.$search.'%"');
            }
            
            // dd($records);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('ProductImg',function ($data){
                        if($data->article_url !=''){
                            $url=$data->article_url;
                            $img=' <img src="'.$data->article_url.'" class="rounded" alt="Cinque Terre" width="70" height="70">';
                        }else{
                            $url=asset('uploads/article_images/'.$data->article_img);
                            $img='<img src="'.asset('uploads/article_images/'.$data->article_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                        }
    
                        
                        $product_detail='<a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a>';
    
                        return $product_detail;
                    })
                    ->addColumn('articleDetail',function ($data){
                        $status='';
                        if($data->status=='1'){
                            $status='<span class="badge badge-success">Active</span>';
    
                        }elseif($data->status=='0'){
                            $status='<span class="badge badge-danger">Deactive</span>';
                        }
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                '.$data->product_type.'<br>'.$status.'<br>
                                </div>
                            </div>
                        ';
    
                        return $product_detail;
                    })
                    ->filterColumn('articleDetail',function($query,$keyword){
                        $query->whereRaw("LOWER(product_type) LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('articleDetail', function ($query, $order) {
                        $query->orderBy('product_type', $order);
                    })
                    ->addColumn('action', function($data){
                        if($data->status=='1'){
                            $status='Mark as deactive';
                            $delete =  route('sku.article.deactive',['id'=> $data->id,'type'=>2]);
                        }elseif($data->status=='0'){
                            $status='Mark as active';
                            $delete =  route('sku.article.deactive',['id'=> $data->id,'type'=>1]);

                        }
                        // $edit =  route('sku.article.edit',$data->id);
                        $edit='';

                    $options='<select name="options" id="options_'.$data->id.'" class="form-control form-control-sm options" onchange="get_options('.$data->id.')">
                        <option value="">Please select</option>
                        <option value="edit" data-link="'.$edit.'">Edit</option>
                         <option value="delete" data-link="'.$delete.'">'.$status.'</option>
                    </select>';
                    return $options;

                    })
                    ->rawColumns(['articleDetail','ProductImg','action'])
                    ->make(true);

        }else{
            $articles=DB::table('articles')->where('status','=',1)->get();
            $segments=DB::table('segment')->where('status','=',1)->get();
            return view('sku.articles',['articles' => $articles,'segments' => $segments]);
        }
    }

    public function colors(Request $request){
        if($request->ajax()){
            $records=DB::table('product_color');
            return Datatables::of($records)
                    ->addIndexColumn()
                    
                    ->addColumn('colorDetail',function ($data){
                        $status='';
                        if($data->status=='1'){
                            $status='<span class="badge badge-success">Active</span>';
    
                        }elseif($data->status=='0'){
                            $status='<span class="badge badge-danger">Deactive</span>';
                        }
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                '.$data->color.'<br>'.$status.'<br>
                                </div>
                            </div>
                        ';
                        return $product_detail;
                    })
                    ->filterColumn('colorDetail',function($query,$keyword){
                        $query->whereRaw("LOWER(color) LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('colorDetail', function ($query, $order) {
                        $query->orderBy('color', $order);
                    })
                    ->addColumn('action', function($data){
                        if($data->status=='1'){
                            $status='Mark as deactive';
                            $delete =  route('sku.color.deactive',['id'=> $data->id,'type'=>2]);
                        }elseif($data->status=='0'){
                            $status='Mark as active';
                            $delete =  route('sku.color.deactive',['id'=> $data->id,'type'=>1]);

                        }
                        // $edit =  route('sku.article.edit',$data->id);
                        $edit='';

                        $options='<select name="options" id="options_'.$data->id.'" class="form-control form-control-sm options" onchange="get_options('.$data->id.')">
                            <option value="">Please select</option>
                            <option value="edit" data-link="'.$edit.'">Edit</option>
                            <option value="delete" data-link="'.$delete.'">'.$status.'</option>
                        </select>';
                        return $options;

                    })
                    
                    ->rawColumns(['colorDetail','action'])
                    ->make(true);

        }else{
            return view('sku.colors');
        }
    }

    public function article_deactive($id,$type){
        $response=DB::table('product_type')
              ->where('id', $id)
              ->update(['status' => ($type==2)? 0:1]); 
        echo $response;
    }

    public function color_deactive($id,$type){
        $response=DB::table('product_color')
              ->where('id', $id)
              ->update(['status' => ($type==2)? 0:1]); 
        echo $response;
    }
    
    public function edit_article(Request $request){
        // dd($request->all());
        $id=$request->id;
        if($request->articl_name !=''){
            if ($request->hasFile('file_img')) {
                $image = $request->file('file_img');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/article_images');
                $image->move($destinationPath, $name);
                
            }else{
                $name='';
            }

            if(DB::table('product_type')->where('product_type', $request->articl_name)->where('id','!=',$id)->exists()){
                echo 0;
            }else{
                $update=[
                    'product_type' => $request->articl_name,
                    'article_img' => $name,
                    'article_url' => ($request->article_image_url !='')?$request->article_image_url:'',
                ];
                $res=DB::table('product_type')
                  ->where('id', $id)
                  ->update($update);
                  
                $this->sku_name_update($id,$request->articl_name);
                echo $res;
            }
        }else{
            $res=DB::table('product_type')->where('id',$id)->get();
            echo json_encode($res[0]);
        }
    }

    public function edit_color(Request $request){
        // dd($request->all());
        $id=$request->id;
        if($request->color_name !=''){
            if(DB::table('product_color')->where('color', $request->color_name)->where('id','!=',$id)->exists()){
                echo 0;
            }else{
                $update=[
                    'color' => $request->color_name,
                ];
                $res=DB::table('product_color')
                  ->where('id', $id)
                  ->update($update);
                echo $res;
            }
        }else{
            $res=DB::table('product_color')->where('id',$id)->get();
            echo json_encode($res[0]);
        }
    }

    public function get_products_excel(Request $request){
        $records=DB::table('product_info')->orderBy('group_id','ASC')->orderBy('prod_size','ASC')
                        ->where('is_deleted',0);
            
            
        $child_sku_check=$request->child_sku;
        $is_discarded=$request->discarded_sku;
        
        if($is_discarded ==''){
            $records->where('prod_status',1);
        }
        
        if($child_sku_check ==''){
            $records->groupBy('group_id')
                    ->selectRaw( 'prod_img,product_url,product_name,sum(Quantity) as decrum_qty,sum(uc_quantity) as urban_qty,prod_status,variation_id,group_id');
        }else{
            $records->selectRaw( 'prod_img,product_url,product_name,Quantity as decrum_qty,uc_quantity as urban_qty,prod_status,variation_id,group_id');
        }
        
        $title ='SKU List';
        $file_name='sku_list_'.date('Y_m_d_h_i_s');
        
        $objPHPExcel= new Spreadsheet();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->mergeCells("A1:H1");
        $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
        $objPHPExcel->getActiveSheet()->getStyle("A2:H2")->getFont()->setBold(true);
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'SKU');
        $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Status');
        $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'Decrum WH Instock');
        $objPHPExcel->getActiveSheet()->SetCellValue('E2', 'Urban WH Instock');
        
        
        if($records->count()>0){
            $counter=3;
            $sno=1;
            foreach($records->get() as $data){
                if($data->prod_status=='1'){
                    $status='Active';

                }elseif($data->prod_status=='2' || $data->prod_status=='0'){
                    $status='Discard';
                }
                
                if($child_sku_check ==''){
                    $productName=explode(',',$data->product_name);
                    $productName=$productName[0];
                }else{
                    $productName=$data->product_name;
                }
                
                if($child_sku_check ==''){
                    $group_id=$data->group_id;
                }else{
                    $group_id=$data->variation_id;
                }
                
                 
                 
                
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $group_id);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $productName);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $status);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $data->decrum_qty);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$counter, $data->urban_qty);
                    
                    
                $counter++;
                $sno++;    
            }
            
            
        }
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
    
    public function get_products(Request $request){
        if($request->ajax()){
            $records=DB::table('product_info')->orderBy('group_id','ASC')->orderBy('prod_size','ASC')
                        ->where('is_deleted',0);
            
            
            $child_sku_check=$request->child_sku;
            $is_discarded=$request->is_discarded;
            
            if($is_discarded ==''){
                $records->where('prod_status',1);
            }
            
            if($child_sku_check ==''){
                $records->groupBy('group_id')
                        ->selectRaw( 'prod_img,product_url,product_name,sum(Quantity) as decrum_qty,sum(uc_quantity) as urban_qty,prod_status,variation_id,group_id');
            }else{
                $records->selectRaw( 'prod_img,product_url,product_name,Quantity as decrum_qty,uc_quantity as urban_qty,prod_status,variation_id,group_id');
            }
            
            if(empty($request->input('search.value'))){
                if($request->color !=''){
                    $records->where('prod_color',$request->color);
                }
    
                if($request->gender !=''){
                    $records->where("prod_gender",$request->gender);
                }
            }else{
                $search = trim($request->input('search.value'));
                
                
                $records->where(function($query) use(&$search){
                    $query->where('variation_id','LIKE',"%{$search}%")
                        ->orWhere('product_name','LIKE',"%{$search}%");
                }); 
                
                
                
            }
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('ProductImg',function ($data){
                    if($data->product_url !=''){
                        $url=$data->product_url;
                        $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                    }else{
                        $url=asset('uploads/sku_images/'.$data->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                    }

                    
                    $product_detail='
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            
                    ';

                    return $product_detail;
                })
                ->addColumn('ProductDetail',function ($data) use(&$child_sku_check){
                    if($data->prod_status=='1'){
                        $status='<span class="badge badge-success">Active</span>';

                    }elseif($data->prod_status=='2' || $data->prod_status=='0'){
                        $status='<span class="badge badge-danger">Deactive</span>';
                    }
                    
                    if($child_sku_check ==''){
                        $productName=explode(',',$data->product_name);
                        $productName=$productName[0];
                    }else{
                        $productName=$data->product_name;
                    }
                    $product_detail=$productName.'<br>'.$status;

                    return $product_detail;
                })
                
                ->addColumn('decrum_quantity',function ($data){
                    return $data->decrum_qty;
                })
                ->addColumn('urban_quantity',function ($data){
                    return $data->urban_qty;
                })
                ->addColumn('action',function ($data) use(&$child_sku_check){
                    if($child_sku_check ==''){
                        $group_id=$data->group_id;
                        $date=date('Y-m-d');
                        $view_variation='<a href="javascript:;" tabindex="0" class="dropdown-item viewAllSku" data-sku="'.$group_id.'" data-start_date="'.$date.'" data-end_date="'.$date.'">View Variations</a>';
                    }else{
                        $group_id=$data->variation_id;
                        $view_variation='';
                    }
                    
                   
                    $html='<div class="input-group-btn">
                                <div class="btn-group">
                                    <button type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="dropdown-toggle btn btn-dark btn-sm">Action</button>
                                    <div tabindex="-1" aria-hidden="true" role="menu" class="dropdown-menu">
                                        '.$view_variation.'
                                    </div>
                                </div>
                            </div>';
                    
                    return $html;
                })
                ->addColumn('variation',function ($data) use(&$child_sku_check){
                    if($child_sku_check ==''){
                        $group_id=$data->group_id;
                    }else{
                        $group_id=$data->variation_id;
                    }
                    $product_detail=$group_id;

                    return $product_detail;
                })
                ->rawColumns(['ProductImg','ProductDetail','decrum_quantity','action','variation','urban_quantity'])
                ->make(true);
        }
    }

    public function item_adjust_update(Request $request){
        // dd($request->all());
        $input=$request->all();

        $record=Sku::find($input['product_info_id']);

        $stock=(int)$record->Quantity-(int)$input['item_adjust'];
        if($stock <0){
            $stock=0;
        }

        $insert=[
            'variation_id' => $record->variation_id,
            'product_info_id' => $input['product_info_id'],
            'reason_id' => $input['reason_id'],
            'quantity'=>$input['item_adjust'],
            'old_stock' => $record->Quantity,
            'new_stock' => $stock,
            'user_id' => auth()->user()->id,
            'created_date' => date('Y-m-d H:i:s'),
        ];

        DB::table('item_adjustment')->insert($insert);

        $record->update([
            'Quantity' => $stock,
        ]);

        echo '1';
    }

    public function item_adjust(Request $request){
        if($request->ajax()){
            $records=DB::table('item_adjustment')
                        ->join('product_info','product_info.variation_id','=','item_adjustment.variation_id')
                        ->join('damage_reason','damage_reason.id','=','item_adjustment.reason_id')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->Join('users','users.id','=','item_adjustment.user_id')
                        
                        ->select([
                            'item_adjustment.*',
                            'users.name',
                            'product_size.size',
                            'damage_reason.reason_name',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.product_name'
                        ]);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('productDetail',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }

                        $detail='
                        <div class="row">
                            <div class="col-md-2">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                            <div class="col-md-8">
                                '.$data->product_name.'<br>
                                <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                <span style="color:#D35400">Size : <strong>'.$data->size.'</strong></span>
                            </div>
                        </div>';

                        return $detail;
                    })
                    ->filterColumn('productDetail',function($query,$keyword){
                        $query->orWhereRaw("item_adjustment.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_size.size LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info.product_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('productDetail', function ($query, $order) {
                        $query->orderBy('item_adjustment.variation_id', $order);
                        $query->orderBy('product_size.size', $order);
                        $query->orderBy('product_info.product_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("item_adjustment.created_date LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('item_adjustment.created_date', $order);
                    })
                    ->rawColumns(['created_at','productDetail'])
                    ->make(true);
        }else{
            return view('sku.item_adjust');
        }
    }
    
    public function add_new_bundle(Request $request){
        if($request->isMethod('post')){
            // dd($request->all());
            if($request->variation_type =='1'){
                foreach($request->bundle_set_variation as $key=> $value){
                    $insert=[
                        'bundle_name' => $request->bundle_name,
                        'variation_type' => $request->variation_type,
                        'image_url' => $request->image_url,
                        'variation_qty' => count($request->sku),
                        'bundle_group' => $request->bundle_group[$key],
                        'set_no' => $request->set_no[$key],
                        'bundle_no' => $request->bundle_no[$key],
                        'bundle_set_name' => $request->bundle_set_name[$key],
                        'prod_size' => $request->prod_size[$key],
                        'bundle_set_variation' => $value,
                        'user_id' => auth()->user()->id,
                        'status' =>1,
                        'created_date' => date('Y-m-d H:i:s'),
                    ];
                    
                    
                    
                    $insert_id=DB::table('bundle')->insertGetId($insert);
                    
                    
                    foreach($request->sku as $k =>$v){
                        $design=explode('-',$v);
                        
                        
                        
                        $where=[
                            'variation_design' => $v
                        ];
                        
                        $sku_design=DB::table('product_info_design')->where($where)->first();
                        if(isset($design[1])){
                            $alpha=$sku_design->group_id.$request->prod_size[$key].'-'.$design[1];
                        }else{
                            $alpha=$sku_design->group_id.$request->prod_size[$key];
                        }
                        $insert_sku =[
                            'bundle_id' => $insert_id,//$insert_id
                            'bundle_no' => $request->bundle_no[$key],
                            'set_no' => $request->set_no[$key],
                            'variation_id' => $sku_design->group_id.$request->prod_size[$key],
                            'variation_design' => $alpha,
                            'variation_type' => $request->variation_type,
                            'bundle_set_variation' => $value,
                            'bundle_group' => $request->bundle_group[$key],
                            'quantity' => 1,
                            'created_date' => date('Y-m-d H:i:s'),
                            'user_id' => auth()->user()->id,
                            'prod_design' => $sku_design->prod_design
                        ];
                        DB::table('bundle_sets')->insert($insert_sku);
                        // echo "<pre>";
                        // print_r($insert_sku);
                        
                    }
                    
                }
                // exit;
            }else if($request->variation_type =='2'){
                $count=DB::table('bundle')->orderBy('id', 'desc')->first();
            
                if($count ==null){
                    $bundle_no=1;
                    $set_no=1;
                }else{
                    $bundle_no=($count->bundle_no)+1;
                    $set_no=($count->set_no)+1;
                }
            
                $b_no=$bundle_no;
                
                if($bundle_no<1000){
                    if($bundle_no<100){
                        if($bundle_no<10){
                            $bundle_no='000'.$bundle_no;
                        }else{
                            $bundle_no='00'.$bundle_no; 
                        }    
                    }else{
                        $bundle_no='0'.$bundle_no;
                    }
                }
                
                $insert=[
                    'bundle_name' => $request->bundle_name,
                    'variation_type' => $request->variation_type,
                    'image_url' => $request->image_url,
                    'variation_qty' => count($request->sku),
                    'bundle_group' => '4BUN'.$bundle_no,
                    'set_no' => $set_no,
                    'bundle_no' => $b_no,
                    'bundle_set_name' => $request->bundle_name,
                    'prod_size' => '0',
                    'bundle_set_variation' => '',
                    'user_id' => auth()->user()->id,
                    'status' =>1,
                    'created_date' => date('Y-m-d H:i:s'),
                ];
                $insert_id=DB::table('bundle')->insertGetId($insert);
                foreach($request->sku as $k =>$v){
                    $insert_sku =[
                        'bundle_id' => $insert_id,//
                        'bundle_no' => $b_no,
                        'set_no' => $set_no,
                        'variation_id' => $v,
                        'variation_type' => $request->variation_type,
                        'bundle_set_variation' => '',
                        'bundle_group' => '4BUN'.$bundle_no,
                        'quantity' => 1,
                        'created_date' => date('Y-m-d H:i:s'),
                        'user_id' => auth()->user()->id
                    ];
                    DB::table('bundle_sets')->insert($insert_sku);
                    
                }
                
            }
            
            return redirect()->route('add.new.bundle')->with('has_success','Bundle Inserted Successfully');
            
            
            
        }else{
            return view('sku.add_bundle');
        }
    }
    
    public function sku_list(Request $request){
        if ($request->ajax() ){//&& $request->input("search") !=''
            $page = $request->input('page');
            $resultCount = 10;
            $offset = ($page - 1) * $resultCount;

            // dd(($page - 1) );

            $breeds = DB::table('product_info_design')->leftJoin('product_design','product_design.id','=','product_info_design.prod_design')
                        
                        ->whereRaw('LOWER(product_info_design.product_name) LIKE ?','%' . $request->input("search"). '%')
                        ->orWhereRaw('LOWER(product_info_design.variation_id) LIKE ?',  '%' . $request->input("search"). '%')
                        // ->groupBy('product_info.group_id')
                        ->orderBy('product_info_design.product_name')
                        ->orderBy('product_info_design.variation_id')
                        ->skip($offset)
                        ->take($resultCount)
                        ->get([
                            'product_info_design.variation_design as id',
                            'product_info_design.product_name',
                            'product_info_design.variation_id',
                            'product_info_design.variation_design',
                            'product_info_design.group_id',
                            'product_design.design_title',
                            'product_info_design.prod_img',
                            'product_info_design.product_url',
                        ]);

            $count = DB::table('product_info_design')
                    ->whereRaw('LOWER(product_info_design.product_name) LIKE ?',  '%' . $request->input("search"). '%')
                    ->orWhereRaw('LOWER(product_info_design.variation_id) LIKE ?',  '%' . $request->input("search"). '%')
                    // ->groupBy('product_info.group_id')
                    ->orderBy('product_info_design.product_name')
                    ->orderBy('product_info_design.variation_id')->count();
            
            $endCount = $offset + $resultCount;
            $morePages = $count>$endCount;
            // dd($endCount > $count);
            $results = array(
                "results" => $breeds,
                "pagination" => array(
                    "more" => $morePages
                )
            );

            return response()->json($results);
        }

    }
    
    public function get_set_no(Request $request){
        if ($request->ajax() ){
            $bundle_name=$request->bundle_name;
            // $count=DB::table('bundle')->order('id','desc')->first();
            $count=DB::table('bundle')->orderBy('id', 'desc')->first();
            
            if($count ==null){
                $bundle_no=1;
                $set_no=1;
            }else{
                $bundle_no=($count->bundle_no)+1;
                $set_no=($count->set_no)+1;
            }
            
            $b_no=$bundle_no;
            
            if($bundle_no<1000){
                if($bundle_no<100){
                    if($bundle_no<10){
                        $bundle_no='000'.$bundle_no;
                    }else{
                        $bundle_no='00'.$bundle_no; 
                    }    
                }else{
                    $bundle_no='0'.$bundle_no;
                }
            }
            
            $product_size=DB::table('product_size')->where('status',1)->get();
            $html='';
            
            foreach($product_size as $size){
                $bundle_set_variation='4BUN'.$bundle_no.$size->id;
                $bundle_set_name=$bundle_name.' | Set '.$set_no.', '.$size->size;
                
                $html.='
                <tr>
                    <td>'.$bundle_set_variation.'
                        <input type="hidden" name="bundle_set_variation[]" value="'.$bundle_set_variation.'"/>
                        <input type="hidden" name="prod_size[]" value="'.$size->id.'"/>
                        <input type="hidden" name="bundle_group[]" value="4BUN'.$bundle_no.'"/>
                        <input type="hidden" name="bundle_no[]" value="'.$b_no.'"/>
                        <input type="hidden" name="set_no[]" value="'.$set_no.'"/>
                    </td>
                    <td><strong>'.$bundle_set_name.'</strong><input type="hidden" name="bundle_set_name[]" value="'.$bundle_set_name.'"/></td>
                    <td><a href="javascript:;" class="btn btn-sm btn-danger remove_button_tbl"><i class="fas fa-minus-circle"></i></a></td>
                </tr>';
            }
            

            
            return response()->json([
                'html' =>$html
            ]);
        }
    }
    
     public function get_sku_sale(Request $request){
        $login_user=auth()->user();
        
        $child_sku=$request->child_sku;
            
        $start_date=$request->start_date;
        $end_date=$request->end_date;
        
        $page=$request->page;
        
        
        
        if($child_sku ==''){
            $child=0;
        }else{
            $child=1;
        }
        
        $decrum_sale=ReportHelper::AmazonOrders('amazon_order_report_decrum', $start_date, $end_date, [], $child,4);
        $decrum_inventory=ReportHelper::getAmazonInventory('inventory_report_decrum',$child);
        
        // dd($decrum_inventory);
        
        $data=[
            'decrum_sale' => $decrum_sale,
            'decrum_inventory' => $decrum_inventory
        ];
        
        $json_encode = json_encode($data);
            
        $path_new = storage_path() . "/data_reports/".$page."_".$login_user->id.".json";
        file_put_contents($path_new,$json_encode);
        
        return response()->json([
            'code' => '200',
            'message' => 'Data Updated Successfully'
        ]);
    }
    
    public function get_bundle_excel(Request $request){
            $userList=DB::table('users')->select(['id','name'])->get()->pluck('name','id')->toArray();
            
            $is_discarded=$request->discarded_sku;
            $child_sku=$request->child_sku;
            // dd($userList);
            $records=DB::table('bundle')
                        ->select(['bundle.*']);
                        
            if($is_discarded ==''){
                $records->where('status','1');
            }
            
            if($child_sku ==''){
                $records->groupBy('bundle_group');
                $child=0;
            }else{
                $child=1;
            }
            
            $login_id=auth()->user();
            $path_new = storage_path() . "/data_reports/bundleSale_".$login_id->id.".json";
            $jsonData = file_get_contents($path_new);
            $dataArrayStock = json_decode($jsonData, true);
            
            $title ='Bundle SKU List';
            $file_name='bundle_sku_list_'.date('Y_m_d_h_i_s');
            
            $objPHPExcel= new Spreadsheet();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->mergeCells("A1:H1");
            $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle("A2:H2")->getFont()->setBold(true);
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Bundle SKU');
            $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Bundle Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Status');
            $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'Total Sale');
            $objPHPExcel->getActiveSheet()->SetCellValue('E2', 'Total Instock');
            $objPHPExcel->getActiveSheet()->SetCellValue('F2', 'Total Inbound');
            $objPHPExcel->getActiveSheet()->SetCellValue('G2', 'Created By');
            $objPHPExcel->getActiveSheet()->SetCellValue('H2', 'Created Date');
            
            if($records->count()>0){
                $counter=3;
                $sno=1;
                $total_qty=0;
                
                foreach ($records->get() as $r){
                    if($child_sku !=''){
                        $name=$r->bundle_set_name;
                        $sku=$r->bundle_set_variation;
                    }else{
                        $name=explode(',',$r->bundle_set_name);
                        $name=$name[0];
                        $sku=$r->bundle_group; 
                    }
                    
                    $total_sale=0;
                    if(isset($dataArrayStock['decrum_sale'][$sku])){
                        $decrum=$dataArrayStock['decrum_sale'][$sku];
                        $total_sale=$decrum['total_sale'];
                    }
                    
                    $total_instock=$total_inbound=0;
                    if(isset($dataArrayStock['decrum_inventory'][$sku])){
                        $decrum=$dataArrayStock['decrum_inventory'][$sku];
                        $total_instock=$decrum['instock'];
                        $total_inbound=$decrum['inbound'];
                    }
                    
                    $username='';
                    if(isset($userList[$r->user_id])){
                        $username=$userList[$r->user_id];
                    }
                    
                    $created_date=date('d-m-Y',strtotime($r->created_date));
                    
                    $status='Active';
                    
                    if(in_array($r->status,[0,2])){
                        $status='Discard';
                    }
                    
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $sku);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $name);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $status);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $total_sale);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$counter, $total_instock);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$counter, $total_inbound);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$counter, $username);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$counter, $created_date);
                    
                    $counter++;
                    $sno++;
                }
                
            }
            
            $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
            $objWriter->setPreCalculateFormulas(false);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
            header('Cache-Control: max-age=0');
            set_time_limit(500);
            ini_set('memory_limit', '-1');
            // ob_clean();
            $objWriter->save('php://output');
            exit;
        
    }
    
    public function bundle_list(Request $request){
        if ($request->ajax()){
            $userList=DB::table('users')->select(['id','name'])->get()->pluck('name','id')->toArray();
            
            
            $is_discarded=$request->is_discarded;
            $child_sku=$request->child_sku;
            
            $start_date=$request->start_date;
            $end_date=$request->end_date;
            
            $records=DB::table('bundle')
                        ->select([
                            'bundle.*'
                        ]);
                        
            if($is_discarded ==''){
                $records->where('status','1');
            }
            
            if($child_sku ==''){
                $records->groupBy('bundle_group');
                $child=0;
            }else{
                $child=1;
            }
            
            if(!empty($request->input('search.value'))){
                $search = trim($request->input('search.value'));
                $records->where(function($query) use(&$search){
                    $query->where('bundle_set_variation','LIKE',"%{$search}%")
                        ->orWhere('bundle_set_name','LIKE',"%{$search}%");
                });
            }
            
            $login_id=auth()->user();
            $path_new = storage_path() . "/data_reports/bundleSale_".$login_id->id.".json";
            $jsonData = file_get_contents($path_new);
            $dataArrayStock = json_decode($jsonData, true);
            
            
            
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('bundleImage',function($data) use ($child_sku){
                        if($data->image_url !=''){
                            $url=$data->image_url;
                            $img=' <img src="'.$data->image_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                        }else{
                            $url=asset('uploads/backend/no_image.png');
                            $img='<img src="'.asset('uploads/backend/no_image.png').'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                        }
                        
                        $display="";
                        if($child_sku ==''){
                            $display='style="display:none"';
                        }
 
                        $detail='
                                <div class="form-check">
                                    <div class="checkbox">
                                        <label for="checkbox1" class="form-check-label ">
                                            <input type="checkbox" value="'.$data->id.'" data-variation="'.$data->bundle_set_variation.'" class="form-check-input bulk_id " '.$display.'>
                                        </label>
                                    </div>
                                </div>
                                <a class="single_image ml-4" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>';

                        return $detail;
                    })
                    ->addColumn('bundleDetail',function($data) use(&$child_sku){
                        if($data->bundle_set_variation !=''){
                            $variation=$data->bundle_set_variation;
                        }else{
                            $variation='No Variation';
                        }
                        
                        $status='<span class="badge badge-danger">Deactive</span>';
                        if($data->status=='1'){
                            $status='<span class="badge badge-success">Active</span>';
                        }
                        
                        if($child_sku !=''){
                            $name=$data->bundle_set_name;
                        }else{
                            $name=explode(',',$data->bundle_set_name);
                            $name=$name[0];
                        }
                        
                        $detail2='<div>'.$name.'<br>
                                '.$status.'
                            </div>';

                        return $detail2;
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                     
                    ->addColumn('created_by', function($data) use(&$userList){
                        $username='';
                        if(isset($userList[$data->user_id])){
                            $username=$userList[$data->user_id];
                        }
                        
                        return $username;
                     })
                     ->addColumn('bundle_variation', function($data) use(&$child_sku){
                        if($child_sku !=''){
                            $sku=$data->bundle_set_variation;
                        }else{
                           $sku=$data->bundle_group; 
                        }
                         
                        return $sku;
                     })
                     
                     ->addColumn('total_sale', function($data) use(&$dataArrayStock,&$child_sku){
                         if($child_sku !=''){
                            $sku=$data->bundle_set_variation;
                        }else{
                           $sku=$data->bundle_group; 
                        }
                        
                        $total_sale=0;
                        if(isset($dataArrayStock['decrum_sale'][$sku])){
                            $decrum=$dataArrayStock['decrum_sale'][$sku];
                            $total_sale=$decrum['total_sale'];
                        }
                        return $total_sale;
                     })
                     ->addColumn('decrum_instock', function($data) use(&$dataArrayStock,&$child_sku){
                        if($child_sku !=''){
                            $sku=$data->bundle_set_variation;
                        }else{
                           $sku=$data->bundle_group; 
                        }
                        
                        
                        
                        $total_instock=0;
                        if(isset($dataArrayStock['decrum_inventory'][$sku])){
                            $decrum=$dataArrayStock['decrum_inventory'][$sku];
                            $total_instock=$decrum['instock'];
                        }
                        return $total_instock;
                     })
                     ->addColumn('decrum_inbound', function($data) use(&$dataArrayStock,&$child_sku){
                        if($child_sku !=''){
                            $sku=$data->bundle_set_variation;
                        }else{
                           $sku=$data->bundle_group; 
                        }
                    
                        $total_inbound=0;
                        if(isset($dataArrayStock['decrum_inventory'][$sku])){
                            $decrum=$dataArrayStock['decrum_inventory'][$sku];
                            $total_inbound=$decrum['inbound'];
                        }
                        return $total_inbound;
                     })
                     ->addColumn('action', function($data) use(&$child_sku,&$start_date,&$end_date){
                        if($child_sku !=''){
                            $sku=$data->bundle_set_variation;
                            $view_variation='';
                        }else{
                           $sku=$data->bundle_group;
                           $view_variation='<a href="javascript:;" tabindex="0" class="dropdown-item viewAllSku" data-sku="'.$sku.'" data-start_date="'.$start_date.'" data-end_date="'.$end_date.'">View Variations</a>';
                        }
                        
                        $status='Mark as active';
                        $type=1;
                        if($data->status == '1'){
                            $status='Mark as deactive';
                            $type=2;
                        }
                        
                        if($child_sku ==''){
                            $view_variation.='<a href="javascript:;" tabindex="0" class="dropdown-item active_deactive" data-type="'.$type.'" data-sku="'.$sku.'" data-start_date="'.$start_date.'" data-end_date="'.$end_date.'">'.$status.'</a>';
                        }
                        $html='<div class="input-group-btn">
                                    <div class="btn-group">
                                        <button type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="dropdown-toggle btn btn-dark btn-sm">Action</button>
                                        <div tabindex="-1" aria-hidden="true" role="menu" class="dropdown-menu">
                                            '.$view_variation.'
                                        </div>
                                    </div>
                                </div>';
                        
                        return $html;
                         
                        
                     })
                    ->rawColumns(['created_at','bundleImage','bundleDetail','created_by','total_sale','decrum_instock','decrum_inbound','action'])
                    ->make(true);
            
            
        }else{
            $login_id=auth()->user();
            $path_new = storage_path() . "/data_reports/bundleSale_".$login_id->id.".json";
            $dataArrayStock=[];
            
            $json_encode = json_encode($dataArrayStock);
            file_put_contents($path_new,$json_encode);
            
            return view('sku.bundle_list');
        }
    }
    
    public function bundle_deactive(Request $request){
        $id=$request->id;
        $type=$request->type;
        
        $response=DB::table('bundle')
              ->where('bundle_group', $id)
              ->update(['status' => ($type==2)? 0:1]); 
        echo $response;
    }
    
    public function designs(Request $request){
        if($request->ajax()){
            $records=DB::table('product_design');
            
            $is_discarded=$request->discarded_sku;
            
            if($is_discarded ==''){
                $records->where('status','1');
            }
            
            $alphaList=DB::table('design_alpha')->get()->pluck('design_alpha','design_number')->toArray();
            
            // dd($alphaList[1]);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('designImg',function ($data){
                        if($data->design_icon !=''){
                            $url=asset('uploads/design/'.$data->design_icon);
                            $img='<img src="'.asset('uploads/design/'.$data->design_icon).'" class="rounded" alt="Cinque Terre" width="70" height="70">';
                        }else{
                           $url=asset('uploads/backend/no_image.png');
                            $img='<img src="'.asset('uploads/backend/no_image.png').'" class="rounded" alt="Cinque Terre" width="70" height="70">';
                        }
    
                        
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                    <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a>
                                </div>
                            </div>
                        ';
    
                        return $product_detail;
                    })
                    ->addColumn('designDetail',function ($data){
                        return $data->design_title;
                    })
                    ->filterColumn('designDetail',function($query,$keyword){
                        $query->whereRaw("LOWER(design_title) LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('designDetail', function ($query, $order) {
                        $query->orderBy('design_title', $order);
                    })
                    
                    ->addColumn('status',function ($data){
                        
                        $status='<span class="badge badge-success">Active</span>';
                        if($data->status !=1){
                            $status='<span class="badge badge-danger">Deactive</span>';
                        }
    
                        return $status;
                    })
                    
                    ->addColumn('design_code',function ($data) use(&$alphaList){
                        $design_code='';
                        if(isset($alphaList[$data->id])){
                            $design_code=$alphaList[$data->id];
                        }
                        
                        return $design_code;
                    })
                    
                    ->addColumn('action', function($data){
                        if($data->status=='1'){
                            $status='Mark as deactive';
                            $delete =  route('sku.design.deactive',['id'=> $data->id,'type'=>2]);
                        }elseif($data->status=='0'){
                            $status='Mark as active';
                            $delete =  route('sku.design.deactive',['id'=> $data->id,'type'=>1]);

                        }
                        // $edit =  route('sku.article.edit',$data->id);
                        $edit='';

                    $options='<select name="options" id="options_'.$data->id.'" class="form-control form-control-sm options" onchange="get_options('.$data->id.')">
                        <option value="">Please select</option>
                        <option value="edit" data-link="'.$edit.'">Edit</option>
                         <option value="delete" data-link="'.$delete.'">'.$status.'</option>
                    </select>';
                    return $options;

                    })
                    
                    ->rawColumns(['designDetail','designImg','status','design_code','action'])
                    ->make(true);

        }else{
            return view('sku.design');
        }
    }
    
    public function edit_design(Request $request){
        // dd($request->all());
        $id=$request->id;
        if($request->design_name !=''){
            if ($request->hasFile('dfile_img')) {
                $image = $request->file('dfile_img');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/design');
                $image->move($destinationPath, $name);
                
            }else{
                $name='';
            }

            if(DB::table('product_design')->where('design_title', $request->design_name)->where('id','!=',$id)->exists()){
                echo 0;
            }else{
                $update=[
                    'design_title' => $request->design_name,
                    'design_icon' => $name,
                ];
                $res=DB::table('product_design')
                  ->where('id', $id)
                  ->update($update);
                
                echo $res;
            }
        }else{
            $res=DB::table('product_design')->where('id',$id)->get();
            echo json_encode($res[0]);
        }
    }
    
    public function design_deactive($id,$type){
        $response=DB::table('product_design')
              ->where('id', $id)
              ->update(['status' => ($type==2)? 0:1]); 
        echo $response;
    }
    
    public function type_images(Request $request){
        if($request->ajax()){
            $records=DB::table('product_info')
                        ->orderBy('group_id','ASC')
                        ->groupBy('group_id')
                        ->where('is_deleted','=',0)
                        ->selectRaw('product_name,group_id,prod_status,product_url,prod_img');
                        
            $is_discarded=$request->is_discarded;
            if($is_discarded ==''){
                $records->where('prod_status',1);
            }
            
            if(!empty($request->input('search.value'))){
                $search = trim($request->input('search.value'));
                $records->where(function($query) use(&$search){
                        $query->where('group_id','LIKE',"%{$search}%")
                            ->orWhere('product_name','LIKE',"%{$search}%");
                    });
            }
            // dd($records);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('productName',function($data){
                        $productName=explode(',',$data->product_name);
                        $productName=$productName[0];
                        
                        return $productName;
                        
                    })
                    ->addColumn('status',function($data){
                        $status='Active';
                        if(in_array($data->prod_status,[0,2])){
                            $status='Discard';
                        }
                        
                        return $status;
                        
                    })
                    ->addColumn('designImg',function ($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                        }
    
                        
                        $product_detail='<a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a>';
    
                        return $product_detail;
                    })
                    ->addColumn('sku',function ($data){
                        
                        
                        return $data->group_id;
                    })
                    
                    
                    ->rawColumns(['productName','sku','designImg','status'])
                    ->make(true);

        }else{
            return view('sku.type_images');
        }
    }
    
    public function get_single_excel(Request $request){
        $login_id=auth()->user();
        $path_new = storage_path() . "/data_reports/skuSale_".$login_id->id.".json";
        $jsonData = file_get_contents($path_new);
        $dataArrayStock = json_decode($jsonData, true);
        
        $records=DB::table('product_info_design')->orderBy('group_id','ASC')->orderBy('prod_design','ASC')->orderBy('prod_size','ASC')
            ->select([
                'product_url','prod_img','group_id','variation_design','variation_id','prod_status','prod_design','id','product_name','prod_type'
            ])
        ->where('is_deleted',0);
        
        $child_sku_check=$request->child_sku;
        $is_discarded=$request->discarded_sku;
        
        if($is_discarded ==''){
            $records->where('prod_status',1);
        }
        
        if($child_sku_check ==''){
            $records->groupBy('group_id')->groupBy('prod_design');
        }
        
        $title ='Single SKU List';
            $file_name='single_sku_list_'.date('Y_m_d_h_i_s');
            
        $results = DB::table('product_type as pt')
            ->leftJoin('articles as a', 'a.id', '=', 'pt.article_id')
            ->leftJoin('segment as s', 's.id', '=', 'pt.segment_id')
            ->where('pt.status', 1)
            ->select('pt.id', 'a.article', 's.name as segment')
            ->get();
            
        $formattedResult=collect($results)->pluck(null,'id')->toArray();
            
        $objPHPExcel= new Spreadsheet();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
        $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
        $objPHPExcel->getActiveSheet()->getStyle("A2:F2")->getFont()->setBold(true);
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Product SKU');
        $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Product Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Segment');
        $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'Article');
        $objPHPExcel->getActiveSheet()->SetCellValue('E2', 'Status');
        $objPHPExcel->getActiveSheet()->SetCellValue('F2', 'Total Sale');
        $objPHPExcel->getActiveSheet()->SetCellValue('G2', 'Total Instock');
        $objPHPExcel->getActiveSheet()->SetCellValue('H2', 'Total Inbound');
        
        if($records->count()>0){
                $counter=3;
                $sno=1;
                $total_qty=0;
                
                foreach ($records->get() as $data){
                    if($child_sku_check ==''){
                        $design=explode('-',$data->variation_design);
                        $design=isset($design[1])?'-'.$design[1]:'';
                        
                        if($design){
                            $group_id=$data->group_id.$design;
                        }else{
                            $group_id=$data->group_id;
                        }
                        
                        $productName=explode(',',$data->product_name);
                        $productName=$productName[0];
                    }else{
                        $group_id=$data->variation_design;
                        $productName=$data->product_name;
                    }
                    
                    $sku=$group_id;
                    
                    $status='Active';
                    if(in_array($data->prod_status,[0,2])){
                        $status='Discard';
                    }
                    
                    $total_sale=0;
                    if(isset($dataArrayStock['decrum_sale'][$sku])){
                        $decrum=$dataArrayStock['decrum_sale'][$sku];
                        $total_sale=$decrum['total_sale'];
                    }
                    
                    $total_instock=$total_inbound=0;
                    if(isset($dataArrayStock['decrum_inventory'][$sku])){
                        $decrum=$dataArrayStock['decrum_inventory'][$sku];
                        $total_instock=$decrum['instock'];
                        $total_inbound=$decrum['inbound'];
                    }
                    
                    $checka=$checks='NF';
                    if(isset($formattedResult[$data->prod_type])){
                        $checka=$formattedResult[$data->prod_type]->article;
                    }
                    
                    if(isset($formattedResult[$data->prod_type])){
                        $checks=$formattedResult[$data->prod_type]->segment;
                    }
                    
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $sku);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $productName);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $checks);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $checka);
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$counter, $status);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$counter, $total_sale);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$counter, $total_instock);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$counter, $total_inbound);
                    
                    
                    $counter++;
                    $sno++;
                    
                    
                    
                }
        }
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
        
        
    }
    
    public function get_products_with(Request $request){
        if($request->ajax()){
            $records=DB::table('product_info_design')->orderBy('group_id','ASC')->orderBy('prod_design','ASC')->orderBy('prod_size','ASC')
                ->select([
                    'product_url','prod_img','group_id','variation_design','variation_id','prod_status','prod_design','id','product_name','prod_type'
                ])
            ->where('is_deleted',0);
            
            $child_sku_check=$request->child_sku;
            $is_discarded=$request->is_discarded;
            
            if($is_discarded ==''){
                $records->where('prod_status',1);
            }
            
            if($child_sku_check ==''){
                $records->groupBy('group_id')->groupBy('prod_design');
            }
            
            $start_date=$request->start_date;
            $end_date=$request->end_date;
            
            if(empty($request->input('search.value'))){
                if($request->size !=''){
                    $records->where('prod_size',$request->size);
                }
    
                if($request->color !=''){
                    $records->where('prod_color',$request->color);
                }
    
                if($request->gender !='' && $request->gender !='Gender'){
                    $records->where("prod_gender",$request->gender);
                }
    
                if($request->status !=''){
                    $records->where("prod_status",$request->status);
                }
                
                if($request->design !=''){
                    $records->where("prod_design",$request->design);
                }
            }else{
                $search = trim($request->input('search.value'));
                
                if($child_sku_check ==''){
                    $search_minus_e='-';
                    if(preg_match("/{$search_minus_e}/i", strtolower($search))){
                        $exp=explode('-',$search);
                        $group_id=$exp[0];
                        $dalpha=$exp[1];
                        
                        $records->whereRaw('group_id = "'.$group_id.'" AND variation_design LIKE "%'.$dalpha.'%"');
                    }else{
                        $records->where(function($query) use(&$search){
                            $query->where('variation_design','LIKE',"%{$search}%")
                                ->orWhere('product_name','LIKE',"%{$search}%");
                        });
                    }    
                }else{
                   $records->where(function($query) use(&$search){
                        $query->where('variation_design','LIKE',"%{$search}%")
                            ->orWhere('product_name','LIKE',"%{$search}%");
                    }); 
                }
                
                
            }
            
            $login_id=auth()->user();
            $path_new = storage_path() . "/data_reports/skuSale_".$login_id->id.".json";
            $jsonData = file_get_contents($path_new);
            $dataArrayStock = json_decode($jsonData, true);
            
            $results = DB::table('product_type as pt')
            ->leftJoin('articles as a', 'a.id', '=', 'pt.article_id')
            ->leftJoin('segment as s', 's.id', '=', 'pt.segment_id')
            ->where('pt.status', 1)
            ->select('pt.id', 'a.article', 's.name as segment')
            ->get();
            
            $formattedResult=collect($results)->pluck(null,'id')->toArray();
            
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('ProductImg',function ($data) use(&$child_sku_check){
                    if($data->product_url !=''){
                        $url=$data->product_url;
                        $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                    }else{
                        $url=asset('uploads/sku_images/'.$data->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                    }
                    
                    $st=explode('-',$data->variation_design);
                    $alpha=isset($st[1])?$st[1]:'N/F';
                    
                    $count_number=DB::table('product_info_design')
                                    ->where('group_id',$data->group_id)
                                    ->where('prod_design',$data->prod_design)
                                    ->select([
                                        DB::raw("count(id) as total_sku,GROUP_CONCAT(prod_size SEPARATOR ',')")
                                    ])->first();
                    $display='';
                    if($child_sku_check ==''){
                        $display='style="display:none"';
                    }
                    
                    $product_detail='
                                <div class="form-check">
                                    <div class="checkbox">
                                        <label for="checkbox1" class="form-check-label ">
                                            <input type="checkbox" value="'.$data->id.'" data-total_sku="'.$count_number->total_sku.'" data-group_id="'.$data->group_id.'" data-alpha="'.$alpha.'" data-variation="'.$data->variation_id.'" data-variation_design="'.$data->variation_design.'" class="form-check-input bulk_id" '.$display.'>
                                        </label>
                                    </div>
                                </div>
                                
                                <a class="single_image ml-4" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            ';

                    return $product_detail;
                })
                ->addColumn('ProductDetail',function ($data) use(&$child_sku_check){
                    $status='';
                    if($data->prod_status=='1'){
                        $status='<span class="badge badge-success">Active</span>';

                    }elseif($data->prod_status=='2' || $data->prod_status=='0'){
                        $status='<span class="badge badge-danger">Deactive</span>';
                    }
                    
                    if($child_sku_check ==''){
                        $productName=explode(',',$data->product_name);
                        $productName=$productName[0];
                    }else{
                        $productName=$data->product_name;
                    }
                    
                    
                    
                    $product_detail=$productName.'<br>'.$status;

                    return $product_detail;
                })
                ->addColumn('variation',function ($data) use(&$child_sku_check){
                    if($child_sku_check ==''){
                        $design=explode('-',$data->variation_design);
                        $design=isset($design[1])?'-'.$design[1]:'';
                        
                        if($design){
                            $group_id=$data->group_id.$design;
                        }else{
                            $group_id=$data->group_id;
                        }    
                    }else{
                        $group_id=$data->variation_design;
                    }
                    $product_detail=$group_id;

                    return $product_detail;
                })
                ->addColumn('options',function ($data) use(&$child_sku_check,&$start_date,&$end_date){
                    if($child_sku_check ==''){
                        $design=explode('-',$data->variation_design);
                        $design=isset($design[1])?'-'.$design[1]:'';
                        
                        if($design){
                            $group_id=$data->group_id.$design;
                        }else{
                            $group_id=$data->group_id;
                        }
                        
                        $view_variation='<a href="javascript:;" tabindex="0" class="dropdown-item viewAllSku" data-sku="'.$group_id.'" data-start_date="'.$start_date.'" data-end_date="'.$end_date.'">View Variations</a>';
                    }else{
                        $group_id=$data->variation_design;
                        $view_variation='';
                    }
                    
                    if(Gate::check('sku-delete')){
                        if($data->prod_status==1){
                            $label="Mark as Deactive";
                            $type='0';
                        }else{
                            $label="Mark as Active";
                            $type='1';
                        }
                        $delete_option='<a href="javascript:;" class="dropdown-item update_status" data-type="'.$type.'" data-sku="'.$group_id.'" id="delete_'.$group_id.'">'.$label.'</a>';
                    }else{
                        $delete_option='';
                    }
                    
                    
                    $html='';
                    if($child_sku_check ==''){
                        $ids=DB::table('product_info_design')
                                    ->where('group_id',$data->group_id)
                                    ->where('prod_design',$data->prod_design)
                                    ->selectRaw("GROUP_CONCAT(id SEPARATOR ';') as ids")->first()->ids;
                        // dd($ids);         
                        // $ids=base64_encode($ids);
                        
                        // $route=route("bulk.edit.sku", $ids);
                        
                        if(Gate::check('sku-edit')){
                            $edit_option='<a href="javascript:;" tabindex="0" class="dropdown-item editBtn" data-ids="'.$ids.'">Edit</a>';
                        }else{
                            $edit_option='';
                        }
                        
                        $html='<div class="input-group-btn">
                                    <div class="btn-group">
                                        <button type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="dropdown-toggle btn btn-dark btn-sm">Action</button>
                                        <div tabindex="-1" aria-hidden="true" role="menu" class="dropdown-menu">
                                        '.$view_variation.'<div class="dropdown-divider"></div>'.$edit_option.$delete_option.'
                                        </div>
                                    </div>
                                </div>';
                        
                        
                    }
                    
                    return $html;
                    
                    
                    
                })
                ->addColumn('total_sale',function ($data) use(&$dataArrayStock,&$child_sku_check){
                    if($child_sku_check ==''){
                        $design=explode('-',$data->variation_design);
                        $design=isset($design[1])?'-'.$design[1]:'';
                        
                        if($design){
                            $group_id=$data->group_id.$design;
                        }else{
                            $group_id=$data->group_id;
                        }    
                    }else{
                        $group_id=$data->variation_design;
                    }
                    $sku=$group_id;
                    
                    $total_sale=0;
                    if(isset($dataArrayStock['decrum_sale'][$sku])){
                        $decrum=$dataArrayStock['decrum_sale'][$sku];
                        $total_sale=$decrum['total_sale'];
                    }
                    return $total_sale;
                })
                ->addColumn('decrum_instock',function ($data) use(&$dataArrayStock,&$child_sku_check){
                    if($child_sku_check ==''){
                        $design=explode('-',$data->variation_design);
                        $design=isset($design[1])?'-'.$design[1]:'';
                        
                        if($design){
                            $group_id=$data->group_id.$design;
                        }else{
                            $group_id=$data->group_id;
                        }    
                    }else{
                        $group_id=$data->variation_design;
                    }
                    $sku=$group_id;

                    $total_instock=0;
                    if(isset($dataArrayStock['decrum_inventory'][$sku])){
                        $decrum=$dataArrayStock['decrum_inventory'][$sku];
                        $total_instock=$decrum['instock'];
                    }
                    return $total_instock;
                })
                ->addColumn('decrum_inbound',function ($data) use(&$dataArrayStock,&$child_sku_check){
                    if($child_sku_check ==''){
                        $design=explode('-',$data->variation_design);
                        $design=isset($design[1])?'-'.$design[1]:'';
                        
                        if($design){
                            $group_id=$data->group_id.$design;
                        }else{
                            $group_id=$data->group_id;
                        }    
                    }else{
                        $group_id=$data->variation_design;
                    }
                    $sku=$group_id;

                    $total_inbound=0;
                    if(isset($dataArrayStock['decrum_inventory'][$sku])){
                        $decrum=$dataArrayStock['decrum_inventory'][$sku];
                        $total_inbound=$decrum['inbound'];
                    }
                    return $total_inbound;
                })
                
                ->addColumn('article',function ($data) use(&$formattedResult){
                    $check='NF';
                    
                    if(isset($formattedResult[$data->prod_type])){
                        $check=$formattedResult[$data->prod_type]->article;
                    }
                    
                    return $check;
                })
                ->addColumn('segment',function ($data) use(&$formattedResult){
                    $check='NF';
                    
                    if(isset($formattedResult[$data->prod_type])){
                        $check=$formattedResult[$data->prod_type]->segment;
                    }
                    
                    return $check;
                })
                ->rawColumns(['ProductImg','ProductDetail','options','total_sale','decrum_instock','decrum_inbound','variation','article','segment'])
                ->make(true);
        }else{
            $login_id=auth()->user();
            $path_new = storage_path() . "/data_reports/skuSale_".$login_id->id.".json";
            $dataArrayStock=[];
            
            $json_encode = json_encode($dataArrayStock);
            file_put_contents($path_new,$json_encode);
             
            return view('sku.index_with_design');
        }
    }
    
    
    public function single_deactive(Request $request){
        if($request->ajax()){
            $sku=$request->sku;
            $type=$request->type; 
            
            $exp=explode('-',$sku);
            $group_id=$exp[0];
            $dalpha=isset($exp[1])? $exp[1]:'';
            
            
            
            if($dalpha !=''){
                $whereRaw='group_id = "'.$group_id.'" AND variation_design LIKE "%'.$dalpha.'%" and is_deleted=0';
            }else{
                $whereRaw='group_id = "'.$group_id.'" AND variation_design NOT LIKE "%-%" and is_deleted=0';
            }
            
            $check=DB::table('product_info_design')->whereRaw($whereRaw)->get();
            
            if($check->count()>0){
                $update=[
                    'prod_status' => $type
                ];
                
                
                DB::table('product_info_design')->whereRaw($whereRaw)->update($update);
                
                if($type ==0){
                    $status ='prod_status = 1';
                }else{
                    $status ='prod_status IN (0,2)';
                }
                
                $check=DB::table('product_info_design')
                    ->where('group_id','=',$group_id)
                    ->where('is_deleted','=',0)
                    ->whereRaw($status)
                    ->get();
                // dd($check);
                
                $runUpdate=0;
                if($type ==0){
                    if($check->count()==0){
                        $runUpdate=1;
                    }
                }else{
                    if($check->count()>0){
                        $runUpdate=1;
                    }
                }
                    
                if($runUpdate){
                    DB::table('product_info')
                        ->where('group_id','=',$group_id)
                        ->where('is_deleted','=',0)
                        ->update($update);
                }
                
                $data=[
                    'code' => 200,
                    'message' => 'Status Updated Successfully'
                ];
                
            }else{
                $data=[
                    'code' => 400,
                    'message' => 'Error In Status Updation'
                ]; 
            }
            
            return response()->json($data);
        
        }
    }
    
    public function prod_color_check($data)
    {
        foreach($data as $key => $r)
        {
            $color=DB::table('product_color')->where('id',$r['id'])->where('color',$r['color'])->get();
            
            if($color->count() == 0)
            {
                $colour = $r['color'];
                
                DB::table('product_color')->insert(['id'=>$r['id'],'color'=>$colour,'status'=>1]);
            }
            
        }
    }
    
    public function prod_design_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_design=DB::table('product_design')->where('id',$r['id'])->where('design_title',$r['design_title'])->get();
            
            if($product_design->count() == 0)
            {
                DB::table('product_design')->insert($r);
            }
            
        }
    }
    
    public function prod_type_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_type=DB::table('product_type')->where('id',$r['id'])->where('product_type',$r['product_type'])->get();
            
            if($product_type->count() == 0)
            {
                DB::table('product_type')->insert($r);
            }
            
        }
    }
    
    public function prod_type_images_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_type=DB::table('type_images')->where('id',$r['id'])->where('code',$r['code'])->get();
            
            if($product_type->count() == 0)
            {
                DB::table('type_images')->insert($r);
            }
            
        }
    }
    
    public function prod_info_design_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_type=DB::table('product_info_design')
            ->where('variation_id',$r['variation_id'])
            ->where('group_id',$r['group_id'])
            ->where('variation_design',$r['variation_design'])
            ->get();
            
            if($product_type->count() == 0)
            {
                unset($r['id']);
                DB::table('product_info_design')->insert($r);
            }
            
        }
    }
    
    
    public function prod_info_main_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_type=DB::table('product_info')
            ->where('variation_id',$r['variation_id'])
            ->where('group_id',$r['group_id'])
            ->get();
            
            if($product_type->count() == 0)
            {
                unset($r['id']);
                DB::table('product_info')->insert($r);
 
            }
            
        }
    }
    
    public function GetCronData()
    {
        $url = "https://esireopex.com/miniopex_pro/api/cronapi";
        
        $file = file_get_contents($url);
        
        $resp = json_decode($file,true);
        
        $this->prod_color_check($resp['product_color']);
        
        $this->prod_design_check($resp['product_design']);
        
        $this->prod_type_check($resp['product_type']);
           
        $this->prod_info_design_check($resp['product_info_design']);
           
        $this->prod_type_images_check($resp['type_images']);
        
        $this->prod_info_main_check($resp['product_info']);
        
        return response()->json(['code'=>200]);
        
        // echo "<pre>";
        // print_r($resp['product_info']);
        // echo "</pre>";
    }
    
    // added by sufian check sku variation_id 03-01-22 
    public function check_variation_id(Request $request){
        if($request->ajax()){
            $variation_id=$request->variation_id;
            
            $product_info=DB::table('type_images')->where('code',$variation_id)->get();
            $row=[];
            $founded=0;
            if($product_info->count()>0){
                $row=$product_info->first();
                $founded=1;
            }
            
            return response()->json(['code' => '200','row' => $row,'founded' => $founded]);
        }
    }
    
    ///bulk added added by sufian 01-02-23
    public function bulk_bundle_update_status(Request $request){
        if($request->ajax()){
            // dd($request->all());
            $id_list=$request->id_list;
            $status=$request->status;
            
            $arr=explode(';',$id_list);
            
            foreach ($arr as $val){
                DB::table('bundle')->where('id',$val)->update(['status' => $status]);
            }
            
            return response()->json(['code' => '200' ,'message' => 'status updated successfully']);
        }
    }
    
    public function bulk_edit_bundle($id){
        $exp=explode(';',$id);
        $allrecord=DB::table('bundle')->whereIn('id',$exp)->get();
        $record=DB::table('bundle')->where('id',$exp[0])->first();
        $count_number=DB::table('product_info_design')
                                    ->where('group_id',$data->group_id)
                                    ->where('prod_design',$data->prod_design)
                                    ->select([
                                        DB::raw("count(id) as total_sku,GROUP_CONCAT(prod_size SEPARATOR ',') as prod_size")
                                    ])->first();
        $size_array=explode(',',$count_number->prod_size);
        
        $product_size=DB::table('product_size')->where('status',1)->whereNotIn('size',$size_array)->get();
        $record_bundle_set=DB::table('bundle_sets')->where('bundle_set_variation',$record->bundle_set_variation)->where('is_deleted',0)->get();
        
        return view('sku.bulk_bundle_edit',['ids'=>$id,'product_size' => $product_size,'record'=>$record,'record_bundle_set'=>$record_bundle_set,'allrecord' => $allrecord]);
    }
    
    public function bulk_edit_sku($id){
        $new_id=$this->decrypt($id);
        
        $exp=explode(';',$new_id);
        // dd($exp);
        $color=DB::table('product_color')->where('status',1)->get();
        // $product_gender=DB::table('product_gender')->where('status',1)->get();
        $product_type=DB::table('product_type')->get();
        
        $product_design=DB::table('product_design')->get();
        $teams=DB::table('teams')->get();
        
        $record=DB::table('product_info_design')->where('id',$exp[0])->first();
        
        $count_number=DB::table('product_info_design')
                                    ->where('group_id',$record->group_id)
                                    ->where('prod_design',$record->prod_design)
                                    ->select([
                                        DB::raw("count(id) as total_sku,GROUP_CONCAT(prod_size SEPARATOR ',') as prod_size")
                                    ])->first();
        $size_array=explode(',',$count_number->prod_size);
        // dd($size_array);
        
        $product_size=DB::table('product_size')->where('status',1)->whereNotIn('id',$size_array)->get();
        // dd($product_size);
        $record2=Sku::where('variation_id',$record->variation_id)->first();
        return view('sku.bulk_edit',[
            'record' => $record,
            'record2' => $record2,
            'ids' =>$new_id,
            'color' => $color,
            'teams' => $teams,
            'product_type' => $product_type,
            'product_size' => $product_size,
            'product_design' => $product_design
        ]);
    }
    
    public function bulk_update($id,Request $request){
        // dd($request->all());
        $exp=explode(';',$id);
        
        // dd($exp);
        $id_first=$exp[0];
        
        $image_url='';
        if ($request->hasFile('file_img')) {
            $image = $request->file('file_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/sku_images');
            
            $image->move($destinationPath, $name);
            $image_url=asset('uploads/sku_images/'.$name);
        }
        
        $change_var=[];
        foreach($exp as $val){
            $chv=$this->edit_new($val,$id,$image_url,$request);
            $change_var[]=$chv;
            
        }
    
        $add_new_size=$request->add_new_size;
        
        
        if($add_new_size=='yes'){
            $size_array=$request->size;
            if(count($size_array)>0){
                foreach($size_array as $size_id){
                    $change_var[]=$this->add_new_size($id_first,$size_id);
                }
            }
        }
        return redirect()->route('sku.with.design')->with('has_info',implode('<br/>',$change_var));
        
    }
    
    public function add_new_size($id,$size_id){
        //adding productinfodesign
        $record = DB::table('product_info_design')->where('id',$id)->first();
        
        $size=DB::table('product_size')->where('id',$size_id)->first();
        
        $t=explode(',',$record->product_name);
        $title=$t[0];
        
        $var_design=explode('-',$record->variation_design);
        $alpha=isset($var_design[1])?$var_design[1]:'';
        $group_id=$record->group_id;
        
        if($alpha !=''){
            $variation_design=$group_id.$size_id.'-'.$alpha;
            $variation_id=$group_id.$size_id;
        }else{
            $variation_design=$group_id.$size_id;
            $variation_id=$group_id.$size_id;
        }
        
        $check_design=DB::table('product_info_design')->where('variation_design',$variation_design)->where('is_deleted',0)->get();
        
        if($check_design->count()==0){
            $in_prod_info_design=[
                'product_name' => $title.', '.$size->size,
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'user_id' => auth()->id(),
                'group_id' => $record->group_id,
                'prod_status' => 1,
                'team' => $record->team,
                'prod_gender' =>  $record->prod_gender,
                'prod_type'   => $record->prod_type,
                'prod_color' => $record->prod_color,
                'prod_size' => $size_id,
                'Quantity' => '0',
                'prod_variation' => $record->prod_variation,
                'prod_design' =>$record->prod_design,
                'prod_img'=>$record->prod_img,
                'product_url' => $record->product_url,
                'created_at' => date('Y-m-d')
            ];
                    
            DB::table('product_info_design')->insert($in_prod_info_design);
            
            $insert_log=[
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'user_id' => auth()->user()->id,
                'type_name' => 'ADD new  SKU', 
                'created_date' => date('Y-m-d H:i:s')
            ];
            
            DB::table('sku_log')->insert($insert_log);
        }
        
        //adding productinfo
        $record_info = DB::table('product_info')->where('variation_id',$record->variation_id)->where('is_deleted',0)->first();
        
        $t=explode(',',$record_info->product_name);
        $ntitle=$t[0];
        
        $group_id=$record_info->group_id;
        $nvariation_id=$group_id.$size_id;
        
        $check=DB::table('product_info')->where('variation_id',$nvariation_id)->where('is_deleted',0)->get();
        if($check->count()==0){
            
            $in_product_info=[
                'product_name' => $ntitle.', '.$size->size,
                'variation_id' => $nvariation_id,
                'user_id' => auth()->id(),
                'group_id' => $record_info->group_id,
                'prod_status' => 1,
                'team' => $record_info->team,
                'prod_gender' =>  $record_info->prod_gender,
                'prod_type'   => $record_info->prod_type,
                'prod_color' => $record_info->prod_color,
                'prod_size' => $size_id,
                'Quantity' => '0',
                'prod_variation' => $record_info->prod_variation,
                'prod_design' =>$record_info->prod_design,
                'prod_img'=>    $record_info->prod_img,
                'product_url' => $record_info->product_url,
                'created_at' => date('Y-m-d')
            ]; 
            Sku::create($in_product_info);
        }else{
            $update_arr=[
                'prod_img'=>    $record->prod_img,
                'product_url' => $record->product_url,
            ];
            DB::table('product_info')->where('variation_id',$nvariation_id)->update($update_arr);
        }
        
        return '<span class="text-success">New SKU added Successfully ['.$variation_design.']</span>';
    }
    
    public function edit_new($id,$list,$image_url2,$request){
        // dd($request->all());
        $input = $request->all();
        $record = DB::table('product_info_design')->where('id',$id)->first();
        $record_design=Sku::where('variation_id',$record->variation_id)->first();
        if ($request->hasFile('file_img')) {
            $file='prod_img';
            $f='product_url';
            $image_url=$image_url2;
            
            $pathinfo = pathinfo($image_url2);
            $name=$pathinfo['filename'].'.'.$pathinfo['extension'];
            
            // $name=$image_url2;
        }else{
            if($input['image_url'] !=''){
                $name=$input['image_url'];
                $file='product_url';
                $f='prod_img';
                $image_url=$name;
            }else{
                if($record_design->prod_img !=''){
                    $name=$record_design->prod_img;
                    $file='prod_img';
                    $f='product_url';
                    $image_url=asset('uploads/sku_images/'.$name);
                }else if($record_design->product_url !=''){
                    $name=$record_design->product_url;
                    $file='product_url';
                    $f='prod_img';
                    $image_url=$name;
                }
                
            }
            
        }
        
        $type=DB::table('product_type')->where('id',$input['product_type'])->first();
        $color=DB::table('product_color')->where('id',$input['color'])->first();
        $size=DB::table('product_size')->where('id',$record_design->prod_size)->first();
        
        $gender=1;
        $search_women=['women','womens','woman','female','girl'];
        $search_men=['men','mens','man','male','boy'];
        foreach ($search_women as $key => $value) {
            if(preg_match("/{$value}/i", strtolower($type->product_type))) {
                $gender=2;
            } 
        }
        
        
        
        if($input['product_type']<1000){
            if($input['product_type']<100){
                if($input['product_type']<10){
                    $input['product_type']='000'.$input['product_type'];
                }else{
                    $input['product_type']='00'.$input['product_type']; 
                }    
            }else{
                $input['product_type']='0'.$input['product_type'];
            }
        }
        
        if($input['color'] <10){
            $input['color']='0'.$input['color'];
        }
        
        if($input['design_check'] =='1'){
            $design_alpha=DB::table('design_alpha')->where('design_number',$input['design'])->first();
            $alpha=$design_alpha->design_alpha;
            $design_url=$input['design_image_url'];
        }else{
            $alpha='';
            $design_url='';
        }
        
        $group_id=$input['team'].$input['product_type'].$input['color'];
        
        if($input['design_check'] =='1'){
            $variation_design=$input['team'].$input['product_type'].$input['color'].$size->id.'-'.$alpha;
            $check_var=DB::table('product_info_design')
                            ->where('variation_design',$variation_design)
                            ->where('id','!=',$id)
                            ->exists();
            if($check_var){
            //   return back()->with('has_error','Already Sku Register [ '.$variation_design.' ]'); 
            return '<span class="text-danger">Already Sku Register [ '.$variation_design.' ]<span>';
            }
            
            $g_count=DB::table('type_images')->where('code',$group_id)->first();
            if($g_count ==null){
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
        
                DB::table('type_images')->insert($insert_type_images);
            }else{
                if($image_url != $g_count->image){
                    $update_type_images=[
                        'image' => $image_url
                    ];
                    
                    DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                }
            }
            
            $variation_id=$input['team'].$input['product_type'].$input['color'].$record_design->prod_size;
            $product_size=DB::table('product_size')->where('id',$record_design->prod_size)->first();
            $check_var=Sku::where('variation_id',$variation_id)->first();
            
            if($check_var == null){
                $in_product_info=[
                   'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                   'variation_id' => $variation_id,
                   'user_id' => auth()->id(),
                   'group_id' => $group_id,
                   'prod_status' => 1,
                   'team' => $input['team'],
                   'prod_gender' =>  $gender,
                   'prod_type'   => $type->id,
                   'prod_color' => $color->id,
                   'prod_size' => $record_design->prod_size,
                   'Quantity' => '0',
                   'prod_variation' => 1,
                   'prod_design' =>1,
                   $f=>'',
                   $file => $name,
                   'created_at' => date('Y-m-d')
                ]; 
                Sku::create($in_product_info);
            }else{
                $update_arr=[
                    $f=>'',
                    $file => $name,
                ];
                
                $record_design->update($update_arr);
            }
            
            $update_design=[
                'product_name' => $input['product_name'].' | '.$color->color.', '.$product_size->size,
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'group_id' => $group_id,
                'team' => $input['team'],
                'prod_gender' => $gender,
                'prod_type'   => $type->id,
                'prod_color' => $color->id,
                'prod_size' => $record_design->prod_size,
                'prod_design' =>$input['design'],
                'product_url' => $design_url
            ];
            
            DB::table('product_info_design')->where('id',$id)->update($update_design);
            
            $insert_log=[
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'user_id' => auth()->user()->id,
                'type_name' => 'Edit SKU', 
                'created_date' => date('Y-m-d H:i:s')
            ];
            DB::table('sku_log')->insert($insert_log);
            
        }else{
            $variation_design=$input['team'].$input['product_type'].$input['color'].$record_design->prod_size;
            $check_var=DB::table('product_info_design')
                            ->where('variation_design',$variation_design)
                            ->where('id','!=',$id)
                            ->exists();
            if($check_var){
                // $array=[
                //     'message' => 'Already Sku Register [ '.$variation_design.' ]',
                //     'error' => 'yes'
                // ];
            //   return redirect('sku.with.design')->with('has_error','Already Sku Register [ '.$variation_design.' ]');
                return '<span class="text-danger">Already Sku Register [ '.$variation_design.' ]<span>';
            }
            
            $g_count=DB::table('type_images')->where('code',$group_id)->first();
            if($g_count == null){
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
        
                DB::table('type_images')->insert($insert_type_images);
            }else{
                if($image_url != $g_count->image){
                    $update_type_images=[
                        'image' => $image_url
                    ];
                    
                    DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                }
            }
            
            $variation_id=$input['team'].$input['product_type'].$input['color'].$record_design->prod_size;
            // $product_size=DB::table('product_size')->where('id',$input['size'])->first();
            $product_size=DB::table('product_size')->where('id',$record_design->prod_size)->first();
            $check_var=Sku::where('variation_id',$variation_id)->first();
            
            if($check_var == null){
                $in_product_info=[
                   'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                   'variation_id' => $variation_id,
                   'user_id' => auth()->id(),
                   'group_id' => $group_id,
                   'prod_status' => 1,
                   'team' => $input['team'],
                   'prod_gender' =>  $gender,
                   'prod_type'   => $type->id,
                   'prod_color' => $color->id,
                   'prod_size' => $record_design->prod_size,
                   'Quantity' => '0',
                   'prod_variation' => 1,
                   'prod_design' =>0,
                   $f=>'',
                   $file => $name,
                   'created_at' => date('Y-m-d')
                ]; 
                Sku::create($in_product_info);
            }else{
                $update_arr=[
                    $f=>'',
                    $file => $name,
                    'prod_design' =>0,
                ];
                
                $record_design->update($update_arr);
            }
            
            $update_design=[
                'product_name' => $input['product_name'].' | '.$color->color.', '.$product_size->size,
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'group_id' => $group_id,
                'team' => $input['team'],
                'prod_gender' => $gender,
                'prod_type'   => $type->id,
                'prod_color' => $color->id,
                'prod_size' => $record_design->prod_size,
                'prod_design' =>0,
                // 'prod_design' =>0,
                $f=>'',
                $file => $name,
                
            ];
            
            DB::table('product_info_design')->where('id',$id)->update($update_design);
            
            $insert_log=[
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'user_id' => auth()->user()->id,
                'type_name' => 'Edit SKU', 
                'created_date' => date('Y-m-d H:i:s')
            ];
            DB::table('sku_log')->insert($insert_log);
        }
        
        return '<span class="text-success">SKU Updated Successfully ['.$variation_design.']</span>';
    }
    
    public function decrypt($encoded) {
        $encoded =base64_decode($encoded);
        $decoded = "";
        for( $i = 0; $i < strlen($encoded); $i++ ) {
            $b = ord($encoded[$i]);
            $a = $b ^ 51;  // <-- must be same number used to encode the character
            $decoded .= chr($a);
        }
        return $decoded;
    }
    
    public function sku_name_update($id='',$article_name=''){
        
        $product_info = DB::table('product_info')->where('prod_type',$id)->get();
        // dd($product_info);
        if(count($product_info)>0){
            foreach ($product_info as $key => $value){
                $exp=explode(',',$value->product_name);
                $size=$exp[1];
                $exp2=explode('|',$exp[0]);
                $color=$exp2[1];
                
                $product_name=$article_name.' |'.$color.','.$size;
                
                $update_arr=[
                    'product_name' => $product_name
                ];
                
                DB::table('product_info')->where('id', $value->id)->update($update_arr);
                
                $insert_log=[
                    'variation_id' => $value->variation_id,
                    'variation_design' => $value->variation_design,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'Edit SKU', 
                    'created_date' => date('Y-m-d H:i:s')
                ];
                DB::table('sku_log')->insert($insert_log);
            }
        }
    }
    
    //added by sufian 22-5-24
    public function get_sku_list(Request $request){
        if($request->ajax()){
            $sku =$request->sku;
            $start_date =$request->start_date;
            $end_date =$request->end_date;
            $table_name=$request->table_name;
            
            $decrum_sale=ReportHelper::AmazonSingleOrders('amazon_order_report_decrum', $start_date, $end_date, [], $sku);
            $decrum_inventory=ReportHelper::getAmazonSingleInventory('inventory_report_decrum',$sku);
            
            // dd($decrum_sale);
            
            $tr='';
            $td='';
            if(in_array($table_name,['bundle','product_info_design'])){
                $tr='<th>SKU</th>
                    <th>Name</th>
                    <th>Total Sale</th>
                    <th>Decrum InStock</th>
                    <th>Decrum InBound</th>';
                    
                if($table_name=='bundle'){
                    $field='bundle_set_name as name, bundle_set_variation as sku';
                    $where='bundle_group = "'.$sku.'" AND is_deleted=0';
                    
                }else if($table_name=='product_info_design'){
                    $field='product_name as name, variation_design as sku';
                    
                    $search_minus_e='-';
                    if(preg_match("/{$search_minus_e}/i", strtolower($sku))){
                        $exp=explode('-',$sku);
                        $group_id=$exp[0];
                        $dalpha=$exp[1];
                        
                        $where='group_id = "'.$group_id.'" AND variation_design LIKE "%'.$dalpha.'%" AND is_deleted=0';
                    }else{
                        $where='group_id = "'.$sku.'" AND variation_design NOT LIKE "%-%" AND is_deleted=0';
                    }
                }
                
                $get=DB::table($table_name)->whereRaw($where)->selectRaw($field)->orderBy('sku','ASC')->get();
                
                $totalS=$totalI=$totalB=0;
                
                if($get->count()>0){
                    foreach($get as $r){
                        $total_sale=0;
                        
                        if(isset($decrum_sale[$r->sku])){
                            $decrum=$decrum_sale[$r->sku];
                            $total_sale=$decrum->total_sale;
                        }
                        
                        $totalS+=$total_sale;
                        
                        $total_instock=$total_inbound=0;
                        if(isset($decrum_inventory[$r->sku])){
                            $decrum=$decrum_inventory[$r->sku];
                            $total_instock=$decrum->instock;
                            $total_inbound=$decrum->inbound;
                        }
                        
                        $totalI+=$total_instock;
                        $totalB+=$total_inbound;
                        
                        $td.='<tr><td>'.$r->sku.'</td>
                        <td>'.$r->name.'</td>
                        <td>'.$total_sale.'</td>
                        <td>'.$total_instock.'</td>
                        <td>'.$total_inbound.'</td></tr>';
                    }
                    
                    $td.='<tr><td class="table-light" colspan="2"><span class="float-right font-weight-bold">Total</span></td>
                        
                        <td>'.$totalS.'</td>
                        <td>'.$totalI.'</td>
                        <td>'.$totalB.'</td></tr>';
                }
                
            }else{
                 $tr='<th>SKU</th>
                    <th>Name</th>
                    <th>Decrum WH Instock</th>
                    <th>Urban  WH InStock</th>
                    ';
                $field='product_name as name, variation_id as sku,Quantity,uc_quantity';
                $where='group_id = "'.$sku.'" AND is_deleted=0';    
                $get=DB::table($table_name)->whereRaw($where)->selectRaw($field)->orderBy('sku','ASC')->get();
                
                if($get->count()>0){
                    $totalQ=$totalU=0;
                    foreach($get as $r){
                        $totalQ+=$r->Quantity;
                        $totalU+=$r->uc_quantity;
                        
                        $td.='<tr><td>'.$r->sku.'</td>
                        <td>'.$r->name.'</td>
                        <td>'.$r->Quantity.'</td>
                        <td>'.$r->uc_quantity.'</td>';
                    }
                    
                    $td.='<tr>
                        <td class="table-light" colspan="2"><span class="float-right font-weight-bold">Total</span></td>
                        <td>'.$totalQ.'</td>
                        <td>'.$totalU.'</td></tr>';
                }
            }
            
            $html='<table class="table table-bordered table-striped" id="tblSKU" cellspacing="0" width="100%">
                                    <thead class="table-dark text-white">
                                        <tr>
                                           '.$tr.' 
                                        </tr>
                                    </thead>
                                    <tbody>
                                        '.$td.'
                                    </tbody>
                                </table>';
                                
            return response()->json([
                'code' => 200,
                'html' => $html
            ]);
        }
        
    }
    
    public function segment_article(Request $request){
        if($request->ajax()){
            $segment_id=$request->segment_id;
            $article_id=$request->article;
            $color_id=$request->color;
            $design_id=$request->design;
            
            $results = DB::table('segment_article_color_design as sa')
            ->leftJoin('articles as a', 'sa.article_id', '=', 'a.id')
            ->where('sa.segment_id','=',$segment_id)
            ->select('sa.article_id', 'a.article')
            ->groupBy('sa.article_id')
            ->get();
            
            $html='<option value="">Select article</option>';
            
            
            
            // dd($results);
            
            if($results->count()>0){
                foreach ($results as $r){
                    $selected='';
                    if($article_id ==$r->article_id){
                        $selected='selected';    
                    }
                    $html.='<option value="'.$r->article_id.'" '.$selected.'>'.$r->article.'</option>';
                }
            }
            
            $results = DB::table('segment_article_color_design as sa')
            ->leftJoin('product_color as c', 'sa.color_id', '=', 'c.id')
            ->where('sa.segment_id','=',$segment_id)
            ->select('sa.color_id', 'c.color')
            ->groupBy('sa.color_id');
            
            if($article_id !=''){
                $results->where('sa.article_id','=',$article_id);
            }
            
            $chtml='<option value="">Select color</option>';
            
            // dd($results);
            
            if($results->count()>0){
                foreach ($results->get() as $r){
                    $selected='';
                    if($color_id ==$r->color_id){
                        $selected='selected';    
                    }
                    
                    $chtml.='<option value="'.$r->color_id.'" '.$selected.'>'.$r->color.'</option>';
                }
            }
            
            $results = DB::table('segment_article_color_design as sa')
            ->leftJoin('product_design as c', 'sa.design_id', '=', 'c.id')
            ->where('sa.segment_id','=',$segment_id)
            ->where('sa.design_id','!=',0)
            ->select('sa.design_id', 'c.design_title')
            ->groupBy('sa.design_id');
            
            if($article_id !=''){
                $results->where('sa.article_id','=',$article_id);
            }
            
            if($color_id !=''){
                $results->where('sa.color_id','=',$color_id);
            }
            
            $selected='';
            if($design_id =='ALL'){
                $selected='selected';    
            }
            
            $dhtml='<option value="" '.$selected.'>Select design</option>';
            $dhtml.='<option value="ALL" '.$selected.'>ALL</option>';
            
            // dd($results);
            
            if($results->count()>0){
                foreach ($results->get() as $r){
                    $selected='';
                    if($design_id ==$r->design_id){
                        $selected='selected';    
                    }
                    $dhtml.='<option value="'.$r->design_id.'" '.$selected.'>'.$r->design_title.'</option>';
                }
            }
            
            return response()->json([
                'code' => 200,
                'html' => $html,
                'chtml' => $chtml,
                'dhtml' => $dhtml
            ]);
        }
    }
    
    public function articles(Request $request){
        if($request->ajax()){
            $columns = [
                0 =>'pid.group_id' 
            ];
            
            
            $limit = $request->input('length');
            $start = $request->input('start');
            // $order = $columns[$request->input('order.0.column')];
            // $dir = $request->input('order.0.dir');
            $order = $columns[0];
            $dir = 'ASC';
            
            
            $segment=$request->segment;
            $article=$request->article;
            $color=$request->color;
            $design=$request->design;
            
            
            $url=asset('uploads/sku_images/').'/';

            $select_arr=[
                'pi.product_name as pname',
                'pid.group_id',
                'pid.product_name',
                'pid.variation_design',
                'CASE 
                    WHEN pid.product_url != "" THEN pid.product_url
                    ELSE CONCAT("'.$url.'", pid.prod_img)
                END AS image',
                'CASE 
                    WHEN pi.product_url != "" THEN pi.product_url
                    ELSE CONCAT("'.$url.'", pi.prod_img)
                END AS article_img'
                ];
            
            $where_arr=[
                ' pid.is_deleted = 0',
                ' pid.prod_status = 1'
            ];
            
            $join_arr=[
                ' LEFT JOIN product_info as pi ON pi.group_id = pid.group_id'
            ];
            
            
            
            
            $search_arr=[
                ' pid.group_id LIKE "%{search}%"',
                ' pid.product_name LIKE "%{search}%"'
            ];
            
            $select_arr[]='c.color';
            $join_arr[]=' LEFT JOIN product_color as c ON c.id = pid.color_id';
            $search_arr[]=' c.color LIKE "%{search}%"';
            
            
                
            if($segment !=''){
                $select_arr[]='s.name as segment';
                $join_arr[]=' LEFT JOIN segment as s ON s.id = pid.segment_id';
                $where_arr[]=' pid.segment_id = '.$segment;
                $search_arr[]=' s.name LIKE "%{search}%"';
            }
            
            if($article !=''){
                $select_arr[]='a.article';
                $join_arr[]=' LEFT JOIN articles as a ON a.id = pid.article_id';
                $where_arr[]=' pid.article_id = '.$article;
                $search_arr[]=' a.article LIKE "%{search}%"';
            }
            
            if($color !=''){
                $where_arr[]=' pid.color_id = '.$color;
            }
            
            if($design !=''){
                $select_arr[]='d.design_title';
                $join_arr[]=' LEFT JOIN product_design as d ON d.id = pid.prod_design';
                
                if($design !='ALL'){
                    $where_arr[]=' pid.prod_design = '.$design;
                }
                
                
                $search_arr[]=' d.design_title LIKE "%{search}%"';
                $groupBy='pid.prod_design,pid.group_id';
            }else{
                $groupBy='pid.group_id';
            }
            
            if(!empty($request->input('search.value'))){
                $search = trim($request->input('search.value'));
                $search_minus_e='-';
                
                if(preg_match("/{$search_minus_e}/i", strtolower($search))){
                    $exp=explode('-',$search);
                    $group_id=$exp[0];
                    $dalpha=$exp[1];
                    
                    $searchN='( pid.group_id = "'.$group_id.'" AND pid.variation_design LIKE "%'.$dalpha.'%" )';
                    $where_arr[]=$searchN;
                }else{
                    $searchN = '( '.implode(' OR ',$search_arr).' )';
                    $searchN=str_replace("{search}",$search,$searchN);
                    $where_arr[]=$searchN;
                }
            }
            
            $select=implode(',',$select_arr);
            $join=implode(' ',$join_arr);
            $where= implode(' AND ', $where_arr);
            
            $sql= 'SELECT 
                        '.$select.' 
                    FROM 
                        product_info_design as pid'
                    .$join.'
                    WHERE 
                        '.$where.'
                    GROUP BY '.$groupBy.'
                    ORDER BY pid.group_id';
            
            
            $sql1='select count(*) as aggregate from ('.$sql.') count_row_table';
            
            // dd($sql1);
            
            $totalData = DB::select($sql1)[0]->aggregate;
            $totalFiltered = $totalData;
            
                    
            
            if($limit !='-1'){
                $sql.=' limit '.$limit.' offset '.$start;
            }
            
            $skus=DB::select($sql);
            
            $dataN=[];
            if(count($skus)>0){
                foreach($skus as $data){
                    $group_id=$data->group_id;
                    
                    $design1=explode('-',$data->variation_design);
                    $design1=isset($design1[1])?'-'.$design1[1]:'';
                    
                    if($design1){
                        $group_design=$data->group_id.$design1;
                    }else{
                        $group_design=$group_id;
                    } 
                    
                       
                    if($design !='' || $design =='ALL'){
                        $sku=$group_design;
                        $product_name=explode(",",$data->product_name);
                        $product_name=$product_name[0];
                        $url=$data->image;
                    }else{
                        $sku=$group_id;
                        $product_name=explode("| ",$data->pname);
                        $product_name=$product_name[0];
                        $product_name=$product_name.' | '.$data->color;
                        $url=$data->article_img;
                    }
                    
                    $product_detail='<a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    <img src="'.$url.'" class="rounded" alt="Cinque Terre" width="70" height="70">
                                </a>';
                    
                    $new=[];
                    
                    $new['image']=$product_detail;
                    $new['sku']=$sku;
                    $new['name']=$product_name;
                    
                    $new['segment']=($segment !='' && isset($segment))? $data->segment:'';
                    $new['article']=($article !='' && isset($article))? $data->article:'';
                    $new['color']=($color !='' && isset($color))? $data->color:'';
                    $new['design']=($design !='' && isset($design))? $data->design_title:'';
                    $new['total_sale']=0;
                    
                    $dataN[]=$new;
                }
            }
            $json_data = [
                "draw"            => intval($request->input('draw')),  
                "recordsTotal"    => intval($totalData),  
                "recordsFiltered" => intval($totalFiltered), 
                "data"            => $dataN
            ];
            
            return response()->json($json_data);
        }else{
            $articles=DB::table('articles')->where('status','=',1)->get();
            $segments=DB::table('segment')->where('status','=',1)->get();
            $colors=DB::table('product_color')->where('status','=',1)->get();
            $designs=DB::table('product_design')->where('status','=',1)->get();
            return view('sku.articles',['articles' => $articles,'segments' => $segments,"colors" => $colors,'designs' => $designs]);
        }
    }
}
