<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Models\Sku;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;


class SkuController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:sku-list');
        $this->middleware('permission:sku-create', ['only' => ['create','store']]);
        $this->middleware('permission:sku-edit', ['only' => ['show','edit']]);
        $this->middleware('permission:sku-delete', ['only' => ['delete']]);
        $this->middleware('permission:article-list', ['only' => ['articles']]);
        $this->middleware('permission:color-list', ['only' => ['colors']]);
        $this->middleware('permission:item-adjust', ['only' => ['item_adjust']]);
        $this->middleware('permission:add-new-bundle', ['only' => ['add_new_bundle']]);
        $this->middleware('permission:bundle-list', ['only' => ['bundle_list']]);
        $this->middleware('permission:design-list', ['only' => ['designs']]);


    }
    
    public function create(){
        $color=DB::table('product_color')->where('status',1)->get();
        $product_gender=DB::table('product_gender')->where('status',1)->get();
        $product_design=DB::table('product_design')->get();
        $product_type=DB::table('product_type')->get();
        $product_size=DB::table('product_size')->where('status',1)->get();
        $teams=DB::table('teams')->get();
        
        
        return view('sku.create',[
            'color' => $color,
            'product_gender' => $product_gender,
            'product_design' => $product_design,
            'teams' => $teams,
            'product_type' => $product_type,
            'product_size' => $product_size
        ]);
    }

    public function store(Request $request){
        
        $input = $request->all();
        // dd($input);
        
        if ($request->hasFile('file_img')) {
            $image = $request->file('file_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/sku_images');
            $image->move($destinationPath, $name);
            $file='prod_img';
            $f='product_url';
            $image_url=asset('uploads/sku_images/'.$name);
            $check_file=1;

        }else{
            $name=$input['image_url'];
            $file='product_url';
            $f='prod_img';
            $image_url=$name;
            $check_file=0;
        }
        
        $type=DB::table('product_type')->where('id',$input['product_type'])->first();
        $color=DB::table('product_color')->where('id',$input['color'])->first();
        
        $gender=1;
        $search_women=['women','womens','woman','female','girl'];
        $search_men=['men','mens','man','male','boy'];
        foreach ($search_women as $key => $value) {
            if(preg_match("/{$value}/i", strtolower($type->product_type))) {
                $gender=2;
            } 
        }

        if($input['product_type']<1000){
            if($input['product_type']<100){
                if($input['product_type']<10){
                    $input['product_type']='000'.$input['product_type'];
                }else{
                    $input['product_type']='00'.$input['product_type']; 
                }    
            }else{
                $input['product_type']='0'.$input['product_type'];
            }
        }
        
        if($input['color'] <10){
            $input['color']='0'.$input['color'];
        }
        
        if($input['design_check'] =='1'){
            $design_alpha=DB::table('design_alpha')->where('design_number',$input['design'])->first();
            $alpha=$design_alpha->design_alpha;
            $design_url=$input['design_image_url'];
        }else{
            $alpha='';
            $design_url='';
        }
        
        $group_id=$input['team'].$input['product_type'].$input['color'];
        
        if($input['design_check'] =='1'){
            if($input['variation_option'] =='2'){
                $product_size=DB::table('product_size')->where('status',1)->get();
                foreach ($product_size as $size) {
                    $variation_design=$input['team'].$input['product_type'].$input['color'].$size->id.'-'.$alpha;
                    $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
                    $var_id=DB::table('product_info_design')->where('variation_design',$variation_design)->get();
                    
                    if(count($var_id)>0){
                        return back()->with('has_error','Already Sku Register');
                    } 
                }
                $g_count=DB::table('type_images')->where('code',$group_id)->first();
                if($g_count==null){
                    $insert_type_images=[
                        'code' => $group_id,
                        'image' => $image_url
                    ];
            
                    DB::table('type_images')->insert($insert_type_images);
                }else{
                    if($image_url != $g_count->image){
                        $update_type_images=[
                            'image' => $image_url
                        ];
                        
                        DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                    }
                }
                foreach ($product_size as $size) {
                    $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
                    $variation_design=$input['team'].$input['product_type'].$input['color'].$size->id.'-'.$alpha;
                    
                    $v_count=DB::table('product_info')->where('variation_id',$variation_id)->first();
                    if($v_count==null){
                        $in_product_info=[
                           'product_name' => $type->product_type.' | '.$color->color.', '.$size->size,
                           'variation_id' => $variation_id,
                           'user_id' => auth()->id(),
                           'group_id' => $group_id,
                           'prod_status' => 1,
                           'team' => $input['team'],
                           'prod_gender' =>  $gender,
                           'prod_type'   => $type->id,
                           'prod_color' => $color->id,
                           'prod_size' => $size->id,
                           'Quantity' => '0',
                           'prod_variation' => $input['variation_option'],
                           'prod_design' =>1,
                            $f=>'',
                            $file => $name,
                           'created_at' => date('Y-m-d')
                        ]; 
                        Sku::create($in_product_info);
                    }else{
                       if($check_file){
                           if($v_count->prod_img != $name){
                                $up_arr=[
                                    'prod_img' => $name
                                ];
                                DB::table('product_info')->where('variation_id',$variation_id)->update($up_arr);
                           }
                       }else if($check_file ==0){
                            if($v_count->product_url != $name){
                                $up_arr=[
                                    'product_url' => $name
                                ];
                                
                                DB::table('product_info')->where('variation_id',$variation_id)->update($up_arr);
                           }
                       } 
                    }
                    $in_prod_info_design=[
                        'product_name' => $input['product_name'].' | '.$color->color.', '.$size->size,
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_design,
                        'user_id' => auth()->id(),
                        'group_id' => $group_id,
                        'prod_status' => 1,
                        'team' => $input['team'],
                        'prod_gender' =>  $gender,
                        'prod_type'   => $type->id,
                        'prod_color' => $color->id,
                        'prod_size' => $size->id,
                        'Quantity' => '0',
                        'prod_variation' => $input['variation_option'],
                        'prod_design' =>$input['design'],
                        'prod_img'=>'',
                        'product_url' => $design_url,
                        'created_at' => date('Y-m-d')
                    ];
                    
                    DB::table('product_info_design')->insert($in_prod_info_design);
                    
                    $insert_log=[
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_design,
                        'user_id' => auth()->user()->id,
                        'type_name' => 'ADD new  SKU', 
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    DB::table('sku_log')->insert($insert_log);
                }
            }else{
                $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
                $variation_design=$input['team'].$input['product_type'].$input['color'].$input['size'].'-'.$alpha;
                $product_size=DB::table('product_size')->where('id',$input['size'])->first();
                $var_id=DB::table('product_info_design')->where('variation_design',$variation_id)->get(); 
               
                $g_count=DB::table('type_images')->where('code',$group_id)->count();
                if($g_count==0){
                    $insert_type_images=[
                        'code' => $group_id,
                        'image' => $image_url
                    ];
            
                    DB::table('type_images')->insert($insert_type_images);
                }else{
                    if($image_url != $g_count->image){
                        $update_type_images=[
                            'image' => $image_url
                        ];
                        
                        DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                    }
                }
                
                $v_count=DB::table('product_info')->where('variation_id',$variation_id)->first();
                
                if($v_count ==null){
                    $in_product_info=[
                       'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                       'variation_id' => $variation_id,
                       'user_id' => auth()->id(),
                       'group_id' => $group_id,
                       'prod_status' => 1,
                       'team' => $input['team'],
                       'prod_gender' =>  $gender,
                       'prod_type'   => $type->id,
                       'prod_color' => $color->id,
                       'prod_size' => $input['size'],
                       'Quantity' => '0',
                       'prod_variation' => $input['variation_option'],
                       'prod_design' =>1,
                       $f=>'',
                       $file => $name,
                       'created_at' => date('Y-m-d')
                    ]; 
                    Sku::create($in_product_info);
                }else{
                   if($check_file){
                       if($v_count->prod_img != $name){
                            $up_arr=[
                                'prod_img' => $name
                            ];
                            DB::table('product_info')->where('variation_id',$variation_id)->update($up_arr);
                       }
                   }else if($check_file ==0){
                        if($v_count->product_url != $name){
                            $up_arr=[
                                'product_url' => $name
                            ];
                            
                            DB::table('product_info')->where('variation_id',$variation_id)->update($up_arr);
                       }
                   } 
                    
                }
                
                $in_prod_info_design=[
                    'product_name' => $input['product_name'].' | '.$color->color.', '.$product_size->size,
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_design,
                    'user_id' => auth()->id(),
                    'group_id' => $group_id,
                    'prod_status' => 1,
                    'team' => $input['team'],
                    'prod_gender' =>  $gender,
                    'prod_type'   => $type->id,
                    'prod_color' => $color->id,
                    'prod_size' => $input['size'],
                    'Quantity' => '0',
                    'prod_variation' => $input['variation_option'],
                    'prod_design' =>$input['design'],
                    'prod_img'=>'',
                    'product_url' => $design_url,
                    'created_at' => date('Y-m-d')
                ];
                
                DB::table('product_info_design')->insert($in_prod_info_design);
                
                $insert_log=[
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_design,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'ADD new  SKU', 
                    'created_date' => date('Y-m-d H:i:s')
                ];
                DB::table('sku_log')->insert($insert_log);
                
                
            }
        }else{
            if($input['variation_option'] =='2'){
                $product_size=DB::table('product_size')->where('status',1)->get();
                foreach ($product_size as $size) {
                    $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
                    $var_id=DB::table('product_info_design')->where('variation_design',$variation_id)->get();
                    
                    if(count($var_id)>0){
                        return back()->with('has_error','Already Sku Register');
                    }
                }
                
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
                
                DB::table('type_images')->insert($insert_type_images);
                
                foreach ($product_size as $size) {
                    $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
                    $in_product_info=[
                       'product_name' => $type->product_type.' | '.$color->color.', '.$size->size,
                       'variation_id' => $variation_id,
                       'user_id' => auth()->id(),
                       'group_id' => $group_id,
                       'prod_status' => 1,
                       'team' => $input['team'],
                       'prod_gender' =>  $gender,
                       'prod_type'   => $type->id,
                       'prod_color' => $color->id,
                       'prod_size' => $size->id,
                       'Quantity' => '0',
                       'prod_variation' => $input['variation_option'],
                       'prod_design' =>0,
                       $f=>'',
                       $file => $name,
                       'created_at' => date('Y-m-d')
                    ]; 
                    Sku::create($in_product_info);
                    
                    $in_prod_info_design=[
                        'product_name' => $input['product_name'].' | '.$color->color.', '.$size->size,
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_id,
                        'user_id' => auth()->id(),
                        'group_id' => $group_id,
                        'prod_status' => 1,
                        'team' => $input['team'],
                        'prod_gender' =>  $gender,
                        'prod_type'   => $type->id,
                        'prod_color' => $color->id,
                        'prod_size' => $size->id,
                        'Quantity' => '0',
                        'prod_variation' => $input['variation_option'],
                        'prod_design' =>0,
                        $f=>'',
                        $file => $name,
                        'created_at' => date('Y-m-d')
                    ];
                    
                    DB::table('product_info_design')->insert($in_prod_info_design);
                    
                    $insert_log=[
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_id,
                        'user_id' => auth()->user()->id,
                        'type_name' => 'ADD new  SKU', 
                        'created_date' => date('Y-m-d H:i:s')
                    ];
                    DB::table('sku_log')->insert($insert_log);
                }
           }else{
               $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
               $product_size=DB::table('product_size')->where('id',$input['size'])->first();
               $var_id=DB::table('product_info_design')->where('variation_design',$variation_id)->get();
               
                if(count($var_id)>0){
                    return back()->with('has_error','Already Sku Register');
                }
                
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
                
                DB::table('type_images')->insert($insert_type_images);
                
                $in_product_info=[
                   'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                   'variation_id' => $variation_id,
                   'user_id' => auth()->id(),
                   'group_id' => $group_id,
                   'prod_status' => 1,
                   'team' => $input['team'],
                   'prod_gender' =>  $gender,
                   'prod_type'   => $type->id,
                   'prod_color' => $color->id,
                   'prod_size' => $input['size'],
                   'Quantity' => '0',
                   'prod_variation' => $input['variation_option'],
                   'prod_design' =>0,
                   $f=>'',
                   $file => $name,
                   'created_at' => date('Y-m-d')
                ]; 
                Sku::create($in_product_info);
                    
                $in_prod_info_design=[
                    'product_name' => $input['product_name'].' | '.$color->color.', '.$product_size->size,
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_id,
                    'user_id' => auth()->id(),
                    'group_id' => $group_id,
                    'prod_status' => 1,
                    'team' => $input['team'],
                    'prod_gender' =>  $gender,
                    'prod_type'   => $type->id,
                    'prod_color' => $color->id,
                    'prod_size' => $input['size'],
                    'Quantity' => '0',
                    'prod_variation' => $input['variation_option'],
                    'prod_design' =>0,
                    $f=>'',
                    $file => $name,
                    'created_at' => date('Y-m-d')
                ];
                
                DB::table('product_info_design')->insert($in_prod_info_design);
                $insert_log=[
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_id,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'ADD new  SKU', 
                    'created_date' => date('Y-m-d H:i:s')
                ];
                DB::table('sku_log')->insert($insert_log);
           } 
        }
        
        
        // if($input['variation_option'] =='2'){
        //     $product_size=DB::table('product_size')->where('status',1)->get();
        //     foreach ($product_size as $size) {
        //         $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
        //         $var_id=Sku::where('variation_id',$variation_id)->get();
                
        //         if(count($var_id)>0){
        //             return back()->with('has_error','Already Sku Register');
        //         }
        //     }
        //     foreach ($product_size as $size) {
        //         $variation_id=$input['team'].$input['product_type'].$input['color'].$size->id;
        //         $data=[
        //           'product_name' => $input['product_name'],
        //           'variation_id' => $variation_id,
        //           'user_id' => auth()->id(),
        //           'group_id' => $group_id,
        //           'prod_status' => 1,
        //           'team' => $input['team'],
        //           'prod_gender' =>  $gender,
        //           'prod_type'   => $input['product_type'],
        //           'prod_color' => $input['color'],
        //           'prod_size' => $size->id,
        //           'Quantity' => '0',
        //           'prod_variation' => $input['variation_option'],
        //           'prod_design' =>0,
        //           $f=>'',
        //           $file => $name,
        //           'created_at' => date('Y-m-d')
        //         ]; 
        //         Sku::create($data);
        //     }
            
        // }else{
        //     $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
        //     $var_id=Sku::where('variation_id',$variation_id)->get();
        //     // dd($var_id);
        //     if(count($var_id)>0){
        //         return back()->with('has_error','Already Sku Register');
        //     }
        //     $data=[
        //         'product_name' => $input['product_name'],
        //         'variation_id' => $variation_id,
        //         'group_id' => $group_id,
        //         'user_id' => auth()->id(),
        //         'prod_status' => 1,
        //         'team' => $input['team'],
        //         'prod_gender' =>  $gender,
        //         'prod_type'   => $input['product_type'],
        //         'prod_color' => $input['color'],
        //         'prod_size' => $input['size'],
        //         'Quantity' => '0',
        //         'prod_variation' => $input['variation_option'],
        //         'prod_design' =>0,
        //         $file => $name,
        //         $f=>'',
        //         'created_at' => date('Y-m-d')
        //      ]; 
        //      Sku::create($data);
        // }
        
        //show
        return redirect()->route('sku.with.design')->with('has_success','Sku [<strong>'.$input['product_name'].'</strong>] with Group [<strong>'.$group_id.'</strong>] Insert Successfully');
    }

    public function show($id){
        $color=DB::table('product_color')->where('status',1)->get();
        // $product_gender=DB::table('product_gender')->where('status',1)->get();
        $product_type=DB::table('product_type')->get();
        $product_size=DB::table('product_size')->where('status',1)->get();
        $product_design=DB::table('product_design')->get();
        $teams=DB::table('teams')->get();
        // $record = Sku::find($id);
        $record=DB::table('product_info_design')->where('id',$id)->first();
        $record2=Sku::where('variation_id',$record->variation_id)->first();
        // dd($record2);
        return view('sku.edit',[
            'record' => $record,
            'record2' => $record2,
            'color' => $color,
            // 'product_gender' => $product_gender,
            'teams' => $teams,
            'product_type' => $product_type,
            'product_size' => $product_size,
            'product_design' => $product_design
            ]);
    }

    public function edit($id,Request $request){
        $input = $request->all();
        $record = DB::table('product_info_design')->where('id',$id)->first();
        $record_design=Sku::where('variation_id',$record->variation_id)->first();
        if ($request->hasFile('file_img')) {
            $image = $request->file('file_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/sku_images');
            
            $image->move($destinationPath, $name);
            // $this->save();
            $file='prod_img';
            $f='product_url';
            $image_url=asset('uploads/sku_images/'.$name);
        }else{
            if($input['image_url'] !=''){
                $name=$input['image_url'];
                $file='product_url';
                $f='prod_img';
                $image_url=$name;
            }else{
                if($record_design->prod_img !=''){
                    $name=$record_design->prod_img;
                    $file='prod_img';
                    $f='product_url';
                    $image_url=$name;
                }else if($record_design->product_url !=''){
                    $name=$record_design->product_url;
                    $file='product_url';
                    $f='prod_img';
                    $image_url=$name;
                }
                
            }
            
        }
        
        $type=DB::table('product_type')->where('id',$input['product_type'])->first();
        $color=DB::table('product_color')->where('id',$input['color'])->first();
        
        $gender=1;
        $search_women=['women','womens','woman','female','girl'];
        $search_men=['men','mens','man','male','boy'];
        foreach ($search_women as $key => $value) {
            if(preg_match("/{$value}/i", strtolower($type->product_type))) {
                $gender=2;
            } 
        }
        
        
        
        if($input['product_type']<1000){
            if($input['product_type']<100){
                if($input['product_type']<10){
                    $input['product_type']='000'.$input['product_type'];
                }else{
                    $input['product_type']='00'.$input['product_type']; 
                }    
            }else{
                $input['product_type']='0'.$input['product_type'];
            }
        }
        
        if($input['color'] <10){
            $input['color']='0'.$input['color'];
        }
        
        if($input['design_check'] =='1'){
            $design_alpha=DB::table('design_alpha')->where('design_number',$input['design'])->first();
            $alpha=$design_alpha->design_alpha;
            $design_url=$input['design_image_url'];
        }else{
            $alpha='';
            $design_url='';
        }
        
        $group_id=$input['team'].$input['product_type'].$input['color'];
        
        if($input['design_check'] =='1'){
            $variation_design=$input['team'].$input['product_type'].$input['color'].$input['size'].'-'.$alpha;
            $check_var=DB::table('product_info_design')
                            ->where('variation_design',$variation_design)
                            ->where('id','!=',$id)
                            ->exists();
            if($check_var){
               return back()->with('has_error','Already Sku Register'); 
            }
            
            $g_count=DB::table('type_images')->where('code',$group_id)->first();
            if($g_count ==null){
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
        
                DB::table('type_images')->insert($insert_type_images);
            }else{
                if($image_url != $g_count->image){
                    $update_type_images=[
                        'image' => $image_url
                    ];
                    
                    DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                }
            }
            
            $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
            $product_size=DB::table('product_size')->where('id',$input['size'])->first();
            $check_var=Sku::where('variation_id',$variation_id)->first();
            
            if($check_var == null){
                $in_product_info=[
                   'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                   'variation_id' => $variation_id,
                   'user_id' => auth()->id(),
                   'group_id' => $group_id,
                   'prod_status' => 1,
                   'team' => $input['team'],
                   'prod_gender' =>  $gender,
                   'prod_type'   => $type->id,
                   'prod_color' => $color->id,
                   'prod_size' => $input['size'],
                   'Quantity' => '0',
                   'prod_variation' => 1,
                   'prod_design' =>1,
                   $f=>'',
                   $file => $name,
                   'created_at' => date('Y-m-d')
                ]; 
                Sku::create($in_product_info);
            }else{
                $update_arr=[
                    $f=>'',
                    $file => $name,
                ];
                
                $record_design->update($update_arr);
            }
            
            $update_design=[
                'product_name' => $input['product_name'],
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'group_id' => $group_id,
                'team' => $input['team'],
                'prod_gender' => $gender,
                'prod_type'   => $type->id,
                'prod_color' => $color->id,
                'prod_size' => $input['size'],
                'prod_design' =>$input['design'],
                'product_url' => $design_url
            ];
            
            DB::table('product_info_design')->where('id',$id)->update($update_design);
            
            $insert_log=[
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'user_id' => auth()->user()->id,
                'type_name' => 'Edit SKU', 
                'created_date' => date('Y-m-d H:i:s')
            ];
            DB::table('sku_log')->insert($insert_log);
            
        }else{
            $variation_design=$input['team'].$input['product_type'].$input['color'].$input['size'];
            $check_var=DB::table('product_info_design')
                            ->where('variation_design',$variation_design)
                            ->where('id','!=',$id)
                            ->exists();
            if($check_var){
               return back()->with('has_error','Already Sku Register'); 
            }
            
            $g_count=DB::table('type_images')->where('code',$group_id)->first();
            if($g_count == null){
                $insert_type_images=[
                    'code' => $group_id,
                    'image' => $image_url
                ];
        
                DB::table('type_images')->insert($insert_type_images);
            }else{
                if($image_url != $g_count->image){
                    $update_type_images=[
                        'image' => $image_url
                    ];
                    
                    DB::table('type_images')->where('id',$g_count->id)->update($update_type_images);
                }
            }
            
            $variation_id=$input['team'].$input['product_type'].$input['color'].$input['size'];
            $product_size=DB::table('product_size')->where('id',$input['size'])->first();
            $check_var=Sku::where('variation_id',$variation_id)->first();
            
            if($check_var == null){
                $in_product_info=[
                   'product_name' => $type->product_type.' | '.$color->color.', '.$product_size->size,
                   'variation_id' => $variation_id,
                   'user_id' => auth()->id(),
                   'group_id' => $group_id,
                   'prod_status' => 1,
                   'team' => $input['team'],
                   'prod_gender' =>  $gender,
                   'prod_type'   => $type->id,
                   'prod_color' => $color->id,
                   'prod_size' => $input['size'],
                   'Quantity' => '0',
                   'prod_variation' => 1,
                   'prod_design' =>0,
                   $f=>'',
                   $file => $name,
                   'created_at' => date('Y-m-d')
                ]; 
                Sku::create($in_product_info);
            }else{
                $update_arr=[
                    $f=>'',
                    $file => $name,
                ];
                
                $record_design->update($update_arr);
            }
            
            $update_design=[
                'product_name' => $input['product_name'],
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'group_id' => $group_id,
                'team' => $input['team'],
                'prod_gender' => $gender,
                'prod_type'   => $type->id,
                'prod_color' => $color->id,
                'prod_size' => $input['size'],
                'prod_design' =>$input['design'],
                $f=>'',
                $file => $name,
                
            ];
            
            DB::table('product_info_design')->where('id',$id)->update($update_design);
            
            $insert_log=[
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'user_id' => auth()->user()->id,
                'type_name' => 'Edit SKU', 
                'created_date' => date('Y-m-d H:i:s')
            ];
            DB::table('sku_log')->insert($insert_log);
        }
        
        
        
        
        
        // $var_id=Sku::where('variation_id',$variation_id)->where('id','!=',$id)->get();
        // if(count($var_id)>0){
        //     return back()->with('has_error','Already Sku Register');
        // }
        // $record = Sku::find($id);

        // $data=[
        //     'product_name' => $input['product_name'],
        //     'team' => $input['team'],
        //     'prod_gender' => '1',
        //     'prod_type'   => $input['product_type'],
        //     'prod_color' => $input['color'],
        //     'prod_size' => $input['size'],
        //     'Quantity' => '0',
        //     'prod_design' =>0,
        //     $file => $name,
        //     $f => '',
        //  ]; 
        //  $record = Sku::find($id);
        //  $record->update($data);
         return redirect()->route('sku.with.design')->with('has_success','Sku updated Successfully');

    }

    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i <$length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function delete($id){
        $record = Sku::find($id);
        if($record->prod_status=='1'){
            $data=[
                'prod_status' => 2
            ];
        }else{
            $data=[
                'prod_status' => 1
            ];
        }
       
        $record->update($data);
        \Session::flash('has_success', 'Sku Updated Successfully'); 
        return true;
        
    }

    public function index(){
        $reasons=DB::table('damage_reason')->get();
        $product_size=DB::table('product_size')->where('status',1)->get();
        $color=DB::table('product_color')->where('status',1)->get();
        $product_gender=DB::table('product_gender')->where('status',1)->get();
        // dd($product_size);
        return view('sku.index',[   
            'reasons' => $reasons,
            'product_size' => $product_size,
            'color' => $color,
            'product_gender' => $product_gender,
        ]);
    }

    public function get_details(){
        $g=DB::table('product_gender')->get(['gender']);
        $t=DB::table('product_type')->get(['product_type']);
        $cc=DB::table('product_color')->get(['color']);
    }

    public function add_color_articles(Request $request){
        $input=$request->input;
        $type=$request->type;
        if ($request->hasFile('file_img')) {
            $image = $request->file('file_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/article_images');
            $image->move($destinationPath, $name);
            
        }else{
            $name='';
        }
        if($type=='1'){
            $table='product_color';
            $where='color';
        }else{
            $table='product_type';
            $where='product_type';
        }

        if (DB::table($table)->where($where, trim($input))->exists()) {
            echo 0;
        }else{
            if($type=='1'){
                $insert=[
                    $where => $input,
                    'status' => 1
                ];
            }else{
                $insert=[
                    $where => $input,
                    'article_img' => $name,
                    'article_url' => ($request->article_image_url !='')?$request->article_image_url:'',
                    'status' => 1
                ];
            }
            
            $res=DB::table($table)->insertGetId($insert);
            if($type=='1'){
                echo $res;
            }else{
                echo json_encode([
                    'id'=>$res,
                    'image' =>($request->article_image_url !='')? $request->article_image_url:asset('uploads/article_images/'.$name)
                ]);
            }
            
        }
    }
    
    public function add_design(Request $request){
        $input=$request->input;
        if ($request->hasFile('dfile_img')) {
            $image = $request->file('dfile_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/design');
            $image->move($destinationPath, $name);
            
        }else{
            $name='';
        }
        
        if(DB::table('product_design')->where('design_title',$input)->exists()){
            return response()->json(['error' =>1,'msg'=>'Already Exists in Design' ]);
        }else{
            $insert=[
                'design_title' => $input,
                'design_icon' => $name,
                'created_by' => auth()->user()->id,
                'created_at' => date('Y-m-d H:i:s'),
            ];
            $res=DB::table('product_design')->insertGetId($insert);
            if($res){
                return response()->json([
                    'error' =>0,
                    'id' => $res,
                    'text' => $input,
                    'msg' => 'Successfully Insert in Design'
                ]);
            }
        }
    }

    public function articles(Request $request){
        if($request->ajax()){
            $records=DB::table('product_type');
            // dd($records);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('ProductImg',function ($data){
                        if($data->article_url !=''){
                            $url=$data->article_url;
                            $img=' <img src="'.$data->article_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/article_images/'.$data->article_img);
                            $img='<img src="'.asset('uploads/article_images/'.$data->article_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }
    
                        
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                    <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a>
                                </div>
                            </div>
                        ';
    
                        return $product_detail;
                    })
                    ->addColumn('articleDetail',function ($data){
                        $status='';
                        if($data->status=='1'){
                            $status='<span class="badge badge-success">Active</span>';
    
                        }elseif($data->status=='0'){
                            $status='<span class="badge badge-danger">Deactive</span>';
                        }
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                '.$data->product_type.'<br>'.$status.'<br>
                                </div>
                            </div>
                        ';
    
                        return $product_detail;
                    })
                    ->filterColumn('articleDetail',function($query,$keyword){
                        $query->whereRaw("LOWER(product_type) LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('articleDetail', function ($query, $order) {
                        $query->orderBy('product_type', $order);
                    })
                    ->addColumn('action', function($data){
                        if($data->status=='1'){
                            $status='Mark as deactive';
                            $delete =  route('sku.article.deactive',['id'=> $data->id,'type'=>2]);
                        }elseif($data->status=='0'){
                            $status='Mark as active';
                            $delete =  route('sku.article.deactive',['id'=> $data->id,'type'=>1]);

                        }
                        // $edit =  route('sku.article.edit',$data->id);
                        $edit='';

                    $options='<select name="options" id="options_'.$data->id.'" class="form-control options" onchange="get_options('.$data->id.')">
                        <option value="">Please select</option>
                        <option value="edit" data-link="'.$edit.'">Edit</option>
                         <option value="delete" data-link="'.$delete.'">'.$status.'</option>
                    </select>';
                    return $options;

                    })
                    ->rawColumns(['articleDetail','ProductImg','action'])
                    ->make(true);

        }else{
            return view('sku.articles');
        }
    }

    public function colors(Request $request){
        if($request->ajax()){
            $records=DB::table('product_color');
            return Datatables::of($records)
                    ->addIndexColumn()
                    
                    ->addColumn('colorDetail',function ($data){
                        $status='';
                        if($data->status=='1'){
                            $status='<span class="badge badge-success">Active</span>';
    
                        }elseif($data->status=='0'){
                            $status='<span class="badge badge-danger">Deactive</span>';
                        }
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                '.$data->color.'<br>'.$status.'<br>
                                </div>
                            </div>
                        ';
                        return $product_detail;
                    })
                    ->filterColumn('colorDetail',function($query,$keyword){
                        $query->whereRaw("LOWER(color) LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('colorDetail', function ($query, $order) {
                        $query->orderBy('color', $order);
                    })
                    ->addColumn('action', function($data){
                        if($data->status=='1'){
                            $status='Mark as deactive';
                            $delete =  route('sku.color.deactive',['id'=> $data->id,'type'=>2]);
                        }elseif($data->status=='0'){
                            $status='Mark as active';
                            $delete =  route('sku.color.deactive',['id'=> $data->id,'type'=>1]);

                        }
                        // $edit =  route('sku.article.edit',$data->id);
                        $edit='';

                        $options='<select name="options" id="options_'.$data->id.'" class="form-control options" onchange="get_options('.$data->id.')">
                            <option value="">Please select</option>
                            <option value="edit" data-link="'.$edit.'">Edit</option>
                            <option value="delete" data-link="'.$delete.'">'.$status.'</option>
                        </select>';
                        return $options;

                    })
                    
                    ->rawColumns(['colorDetail','action'])
                    ->make(true);

        }else{
            return view('sku.colors');
        }
    }

    public function article_deactive($id,$type){
        $response=DB::table('product_type')
              ->where('id', $id)
              ->update(['status' => ($type==2)? 0:1]); 
        echo $response;
    }

    public function color_deactive($id,$type){
        $response=DB::table('product_color')
              ->where('id', $id)
              ->update(['status' => ($type==2)? 0:1]); 
        echo $response;
    }

    public function edit_article(Request $request){
        // dd($request->all());
        $id=$request->id;
        if($request->articl_name !=''){
            if ($request->hasFile('file_img')) {
                $image = $request->file('file_img');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/article_images');
                $image->move($destinationPath, $name);
                
            }else{
                $name='';
            }

            if(DB::table('product_type')->where('product_type', $request->articl_name)->where('id','!=',$id)->exists()){
                echo 0;
            }else{
                $update=[
                    'product_type' => $request->articl_name,
                    'article_img' => $name,
                    'article_url' => ($request->article_image_url !='')?$request->article_image_url:'',
                ];
                $res=DB::table('product_type')
                  ->where('id', $id)
                  ->update($update);
                echo $res;
            }
        }else{
            $res=DB::table('product_type')->where('id',$id)->get();
            echo json_encode($res[0]);
        }
    }

    public function edit_color(Request $request){
        // dd($request->all());
        $id=$request->id;
        if($request->color_name !=''){
            if(DB::table('product_color')->where('color', $request->color_name)->where('id','!=',$id)->exists()){
                echo 0;
            }else{
                $update=[
                    'color' => $request->color_name,
                ];
                $res=DB::table('product_color')
                  ->where('id', $id)
                  ->update($update);
                echo $res;
            }
        }else{
            $res=DB::table('product_color')->where('id',$id)->get();
            echo json_encode($res[0]);
        }
    }

    public function get_products(Request $request){
        if($request->ajax()){
            $records=Sku::orderBy('product_name','ASC')->orderBy('group_id','ASC')->orderBy('prod_size','ASC')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->select([
                            'product_info.*',
                            'product_size.size'
                        ]);
            if($request->size !=''){
                $records->where('product_info.prod_size',$request->size);
            }

            if($request->color !=''){
                $records->where('product_info.prod_color',$request->color);
            }

            if($request->gender !='' && $request->gender !='Gender'){
                $records->whereRaw("product_info.product_name LIKE ?", ["%{$request->gender}%"]);
            }

            if($request->status !=''){
                $records->where("product_info.prod_status",$request->status);
            }
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('ProductImg',function ($data){
                    if($data->product_url !=''){
                        $url=$data->product_url;
                        $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                    }else{
                        $url=asset('uploads/sku_images/'.$data->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                    }

                    
                    $product_detail='
                        <div class="row" >
                            <div class="col-md-12" id="image_'.$data->id.'">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                        </div>
                    ';

                    return $product_detail;
                })
                ->addColumn('ProductDetail',function ($data){
                    // $g=DB::table('product_gender')->where('id',$data->prod_gender)->get(['gender']);
                    // $t=DB::table('product_type')->where('id',$data->prod_type)->get(['product_type']);
                    // $cc=DB::table('product_color')->where('id',$data->prod_color)->get(['color']);
                    $status='';
                    if($data->prod_status=='1'){
                        $status='<span class="badge badge-success">Active</span>';

                    }elseif($data->prod_status=='2'){
                        $status='<span class="badge badge-danger">Deactive</span>';
                    }
                    $product_detail='
                        <div class="row" >
                            <div class="col-md-12" id="detail_'.$data->id.'">
                            '.$data->product_name.'<br>'.$status.'<br>
                            <span class="text-primary">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                            <span class="text-success">Group id : <strong>'.$data->group_id.'</strong></span><br>
                            
                            <span style="display:none" class="text-info" id="size_"'.$data->id.'">Size: <strong>'.$data->size.'</strong></span><br>
                            </div>
                        </div>
                    ';//// '.$g[0]->gender.'._'.$data->product_name.'_'.$cc[0]->color.'<br>'.$status.'<br>

                    return $product_detail;
                })
                ->filterColumn('ProductDetail',function($query,$keyword){
                    $query->orWhereRaw("LOWER(product_info.product_name) LIKE ?", ["%{$keyword}%"])
                            ->orWhereRaw("product_info.variation_id LIKE ?", ["%{$keyword}%"])
                            ->orWhereRaw("product_info.group_id LIKE ?", ["%{$keyword}%"]);
                            // $query->orderBy('product_info.group_id', 'desc');
                    
                })
                ->orderColumn('ProductDetail', function ($query, $order) {
                    $query->orderBy('product_info.id', 'ASC');
                    $query->orderBy('product_info.variation_id', $order)
                        ->orderBy('product_info.product_name', $order);
                })
                ->addColumn('quantity',function ($data){
                    return '<span id="qty_'.$data->id.'">'.$data['Quantity'].'</span>';
                })
                ->filterColumn('quantity',function($query,$keyword){
                    $query->orWhereRaw("product_info.Quantity LIKE ?", ["%{$keyword}%"]);
                })
                ->orderColumn('quantity', function ($query, $order) {
                    $query->orderBy('product_info.Quantity', $order);
                })
                ->addColumn('options',function ($data){
                    $show =  route('sku.delete',$data->id);
                    $edit =  route('sku.edit',$data->id);

                    // if(Gate::check('sku-edit')){
                    //     $edit_option='<option class="text-info text-md" value="edit" data-link="'.$edit.'">&#xf044; Edit</option>';
                    // }else{
                    //     $edit_option='';
                    // }

                    // if(Gate::check('sku-delete')){
                    //     if($data->prod_status==1){
                    //         $class="text-danger";
                    //         $label="Mark as Deactive";
                    //     }else{
                    //         $class="text-success";
                    //         $label="Mark as Active";
                    //     }
                    //     $delete_option='<option class="'.$class.' text-md"value="delete" data-link="'.$show.'">&#xf06e; '.$label.'</option>';
                    // }else{
                    //     $delete_option='';
                    // }
                    if(Gate::check('item-adjust')){
                        if($data->Quantity != 0){
                            $adjust='<option value="adjustment" style="color:#e2b870;">&#xf146; Item Adjustment</option>';
                        }else{
                            $adjust='';
                        }
                    }else{
                        $adjust='';
                    }
                    

                    $options='<select name="options" id="options_'.$data->id.'" class="form-control options" onchange="get_options('.$data->id.')">
                    <option value="">&#xf245; Please select</option>
                    '.$adjust.'
                    
                    </select>';//$edit_option.$delete_option.
                    return $options;
                })
                ->rawColumns(['ProductImg','ProductDetail','quantity','options'])
                ->make(true);
        }
    }

    public function item_adjust_update(Request $request){
        // dd($request->all());
        $input=$request->all();

        $record=Sku::find($input['product_info_id']);

        $stock=(int)$record->Quantity-(int)$input['item_adjust'];
        if($stock <0){
            $stock=0;
        }

        $insert=[
            'variation_id' => $record->variation_id,
            'product_info_id' => $input['product_info_id'],
            'reason_id' => $input['reason_id'],
            'quantity'=>$input['item_adjust'],
            'old_stock' => $record->Quantity,
            'new_stock' => $stock,
            'user_id' => auth()->user()->id,
            'created_date' => date('Y-m-d H:i:s'),
        ];

        DB::table('item_adjustment')->insert($insert);

        $record->update([
            'Quantity' => $stock,
        ]);

        echo '1';
    }

    public function item_adjust(Request $request){
        if($request->ajax()){
            $records=DB::table('item_adjustment')
                        ->join('product_info','product_info.variation_id','=','item_adjustment.variation_id')
                        ->join('damage_reason','damage_reason.id','=','item_adjustment.reason_id')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->Join('users','users.id','=','item_adjustment.user_id')
                        
                        ->select([
                            'item_adjustment.*',
                            'users.name',
                            'product_size.size',
                            'damage_reason.reason_name',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.product_name'
                        ]);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('productDetail',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }

                        $detail='
                        <div class="row">
                            <div class="col-md-2">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                            <div class="col-md-8">
                                '.$data->product_name.'<br>
                                <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                <span style="color:#D35400">Size : <strong>'.$data->size.'</strong></span>
                            </div>
                        </div>';

                        return $detail;
                    })
                    ->filterColumn('productDetail',function($query,$keyword){
                        $query->orWhereRaw("item_adjustment.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_size.size LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info.product_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('productDetail', function ($query, $order) {
                        $query->orderBy('item_adjustment.variation_id', $order);
                        $query->orderBy('product_size.size', $order);
                        $query->orderBy('product_info.product_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("item_adjustment.created_date LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('item_adjustment.created_date', $order);
                    })
                    ->rawColumns(['created_at','productDetail'])
                    ->make(true);
        }else{
            return view('sku.item_adjust');
        }
    }
    
    public function add_new_bundle(Request $request){
        if($request->isMethod('post')){
            // dd($request->all());
            if($request->variation_type =='1'){
                foreach($request->bundle_set_variation as $key=> $value){
                    $insert=[
                        'bundle_name' => $request->bundle_name,
                        'variation_type' => $request->variation_type,
                        'image_url' => $request->image_url,
                        'variation_qty' => count($request->sku),
                        'bundle_group' => $request->bundle_group[$key],
                        'set_no' => $request->set_no[$key],
                        'bundle_no' => $request->bundle_no[$key],
                        'bundle_set_name' => $request->bundle_set_name[$key],
                        'prod_size' => $request->prod_size[$key],
                        'bundle_set_variation' => $value,
                        'user_id' => auth()->user()->id,
                        'status' =>1,
                        'created_date' => date('Y-m-d H:i:s'),
                    ];
                    
                    
                    
                    $insert_id=DB::table('bundle')->insertGetId($insert);
                    
                    
                    foreach($request->sku as $k =>$v){
                        $design=explode('-',$v);
                        
                        
                        
                        $where=[
                            'variation_design' => $v
                        ];
                        
                        $sku_design=DB::table('product_info_design')->where($where)->first();
                        if(isset($design[1])){
                            $alpha=$sku_design->group_id.$request->prod_size[$key].'-'.$design[1];
                        }else{
                            $alpha=$sku_design->group_id.$request->prod_size[$key];
                        }
                        $insert_sku =[
                            'bundle_id' => $insert_id,//$insert_id
                            'bundle_no' => $request->bundle_no[$key],
                            'set_no' => $request->set_no[$key],
                            'variation_id' => $sku_design->group_id.$request->prod_size[$key],
                            'variation_design' => $alpha,
                            'variation_type' => $request->variation_type,
                            'bundle_set_variation' => $value,
                            'bundle_group' => $request->bundle_group[$key],
                            'quantity' => 1,
                            'created_date' => date('Y-m-d H:i:s'),
                            'user_id' => auth()->user()->id,
                            'prod_design' => $sku_design->prod_design
                        ];
                        DB::table('bundle_sets')->insert($insert_sku);
                        // echo "<pre>";
                        // print_r($insert_sku);
                        
                    }
                    
                }
                // exit;
            }else if($request->variation_type =='2'){
                $count=DB::table('bundle')->orderBy('id', 'desc')->first();
            
                if($count ==null){
                    $bundle_no=1;
                    $set_no=1;
                }else{
                    $bundle_no=($count->bundle_no)+1;
                    $set_no=($count->set_no)+1;
                }
            
                $b_no=$bundle_no;
                
                if($bundle_no<1000){
                    if($bundle_no<100){
                        if($bundle_no<10){
                            $bundle_no='000'.$bundle_no;
                        }else{
                            $bundle_no='00'.$bundle_no; 
                        }    
                    }else{
                        $bundle_no='0'.$bundle_no;
                    }
                }
                
                $insert=[
                    'bundle_name' => $request->bundle_name,
                    'variation_type' => $request->variation_type,
                    'image_url' => $request->image_url,
                    'variation_qty' => count($request->sku),
                    'bundle_group' => '4BUN'.$bundle_no,
                    'set_no' => $set_no,
                    'bundle_no' => $b_no,
                    'bundle_set_name' => $request->bundle_name,
                    'prod_size' => '0',
                    'bundle_set_variation' => '',
                    'user_id' => auth()->user()->id,
                    'status' =>1,
                    'created_date' => date('Y-m-d H:i:s'),
                ];
                $insert_id=DB::table('bundle')->insertGetId($insert);
                foreach($request->sku as $k =>$v){
                    $insert_sku =[
                        'bundle_id' => $insert_id,//
                        'bundle_no' => $b_no,
                        'set_no' => $set_no,
                        'variation_id' => $v,
                        'variation_type' => $request->variation_type,
                        'bundle_set_variation' => '',
                        'bundle_group' => '4BUN'.$bundle_no,
                        'quantity' => 1,
                        'created_date' => date('Y-m-d H:i:s'),
                        'user_id' => auth()->user()->id
                    ];
                    DB::table('bundle_sets')->insert($insert_sku);
                    
                }
                
            }
            
            return redirect()->route('add.new.bundle')->with('has_success','Bundle Inserted Successfully');
            
            
            
        }else{
            return view('sku.add_bundle');
        }
    }
    
    public function sku_list(Request $request){
        if ($request->ajax() ){//&& $request->input("search") !=''
            $page = $request->input('page');
            $resultCount = 10;
            $offset = ($page - 1) * $resultCount;

            // dd(($page - 1) );

            $breeds = DB::table('product_info_design')->leftJoin('product_design','product_design.id','=','product_info_design.prod_design')
                        
                        ->whereRaw('LOWER(product_info_design.product_name) LIKE ?','%' . $request->input("search"). '%')
                        ->orWhereRaw('LOWER(product_info_design.variation_id) LIKE ?',  '%' . $request->input("search"). '%')
                        // ->groupBy('product_info.group_id')
                        ->orderBy('product_info_design.product_name')
                        ->orderBy('product_info_design.variation_id')
                        ->skip($offset)
                        ->take($resultCount)
                        ->get([
                            'product_info_design.variation_design as id',
                            'product_info_design.product_name',
                            'product_info_design.variation_id',
                            'product_info_design.variation_design',
                            'product_info_design.group_id',
                            'product_design.design_title',
                            'product_info_design.prod_img',
                            'product_info_design.product_url',
                        ]);

            $count = DB::table('product_info_design')
                    ->whereRaw('LOWER(product_info_design.product_name) LIKE ?',  '%' . $request->input("search"). '%')
                    ->orWhereRaw('LOWER(product_info_design.variation_id) LIKE ?',  '%' . $request->input("search"). '%')
                    // ->groupBy('product_info.group_id')
                    ->orderBy('product_info_design.product_name')
                    ->orderBy('product_info_design.variation_id')->count();
            
            $endCount = $offset + $resultCount;
            $morePages = $count>$endCount;
            // dd($endCount > $count);
            $results = array(
                "results" => $breeds,
                "pagination" => array(
                    "more" => $morePages
                )
            );

            return response()->json($results);
        }

    }
    
    public function get_set_no(Request $request){
        if ($request->ajax() ){
            $bundle_name=$request->bundle_name;
            // $count=DB::table('bundle')->order('id','desc')->first();
            $count=DB::table('bundle')->orderBy('id', 'desc')->first();
            
            if($count ==null){
                $bundle_no=1;
                $set_no=1;
            }else{
                $bundle_no=($count->bundle_no)+1;
                $set_no=($count->set_no)+1;
            }
            
            $b_no=$bundle_no;
            
            if($bundle_no<1000){
                if($bundle_no<100){
                    if($bundle_no<10){
                        $bundle_no='000'.$bundle_no;
                    }else{
                        $bundle_no='00'.$bundle_no; 
                    }    
                }else{
                    $bundle_no='0'.$bundle_no;
                }
            }
            
            $product_size=DB::table('product_size')->where('status',1)->get();
            $html='';
            
            foreach($product_size as $size){
                $bundle_set_variation='4BUN'.$bundle_no.$size->id;
                $bundle_set_name=$bundle_name.' | Set '.$set_no.', '.$size->size;
                
                $html.='
                <tr>
                    <td>'.$bundle_set_variation.'
                        <input type="hidden" name="bundle_set_variation[]" value="'.$bundle_set_variation.'"/>
                        <input type="hidden" name="prod_size[]" value="'.$size->id.'"/>
                        <input type="hidden" name="bundle_group[]" value="4BUN'.$bundle_no.'"/>
                        <input type="hidden" name="bundle_no[]" value="'.$b_no.'"/>
                        <input type="hidden" name="set_no[]" value="'.$set_no.'"/>
                    </td>
                    <td><strong>'.$bundle_set_name.'</strong><input type="hidden" name="bundle_set_name[]" value="'.$bundle_set_name.'"/></td>
                    <td><a href="javascript:;" class="btn btn-sm btn-danger remove_button_tbl"><i class="fas fa-minus-circle"></i></a></td>
                </tr>';
            }
            

            
            return response()->json([
                'html' =>$html
            ]);
        }
    }
    
    public function bundle_list(Request $request){
        if ($request->ajax()){
            $records=DB::table('bundle')
                        ->Join('users','users.id','=','bundle.user_id')
                        ->select([
                            'bundle.*',
                            'users.name',
                        ]);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('bundleImage',function($data){
                        if($data->image_url !=''){
                            $url=$data->image_url;
                            $img=' <img src="'.$data->image_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/backend/no_image.png');
                            $img='<img src="'.asset('uploads/backend/no_image.png').'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }

                        $detail='
                                <input type="checkbox" value="'.$data->id.'" data-variation="'.$data->bundle_set_variation.'" class="form-check-input bulk_id ml-2"><br>
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>';

                        return $detail;
                    })
                    ->addColumn('bundleDetail',function($data){
                        if($data->bundle_set_variation !=''){
                            $variation=$data->bundle_set_variation;
                        }else{
                            $variation='No Variation';
                        }
                        
                        $status='<span class="badge badge-danger">Deactive</span>';
                        if($data->status=='1'){
                            $status='<span class="badge badge-success">Active</span>';
                        }
                        $detail2='<div>'.$data->bundle_set_name.'<br>
                                <span class="text-success">Bundle SKU : <strong>'.$variation.'</strong></span><br>
                                <span class="text-info">Bundle Group : <strong>'.$data->bundle_group.'</strong></span><br>
                                '.$status.'
                            </div>';

                        return $detail2;
                    })
                    ->filterColumn('bundleDetail',function($query,$keyword){
                        $query->orWhereRaw("bundle.bundle_set_name LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("bundle.bundle_set_variation LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("bundle.bundle_group LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('bundleDetail', function ($query, $order) {
                        $query->orderBy('bundle.bundle_set_name', $order);
                        $query->orderBy('bundle.bundle_set_variation', $order);
                        $query->orderBy('bundle.bundle_group', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("bundle.created_date LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('bundle.created_date', $order);
                    })
                    ->rawColumns(['created_at','bundleImage','bundleDetail'])
                    ->make(true);
            
            
        }else{
            return view('sku.bundle_list');
        }
    }
    
    public function designs(Request $request){
        if($request->ajax()){
            $records=DB::table('product_design');
            // dd($records);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('designImg',function ($data){
                        if($data->design_icon !=''){
                            $url=asset('uploads/design/'.$data->design_icon);
                            $img='<img src="'.asset('uploads/design/'.$data->design_icon).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }else{
                           $url=asset('uploads/backend/no_image.png');
                            $img='<img src="'.asset('uploads/backend/no_image.png').'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }
    
                        
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                    <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a>
                                </div>
                            </div>
                        ';
    
                        return $product_detail;
                    })
                    ->addColumn('designDetail',function ($data){
                        
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                '.$data->design_title.'
                                </div>
                            </div>
                        ';
    
                        return $product_detail;
                    })
                    ->filterColumn('designDetail',function($query,$keyword){
                        $query->whereRaw("LOWER(design_title) LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('designDetail', function ($query, $order) {
                        $query->orderBy('design_title', $order);
                    })
                    
                    ->rawColumns(['designDetail','designImg'])
                    ->make(true);

        }else{
            return view('sku.design');
        }
    }
    
    public function type_images(Request $request){
        if($request->ajax()){
            $records=DB::table('type_images')
                        ->orderBy('code','ASC');
            // dd($records);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('productName',function($data){
                        $array = substr(strstr($data->code,"4"), 1);
                        $type=substr($array, 0, 4);
                        $color = substr($array, -2);
 
                        if($type<10){
                            $type=str_replace("0","",$type);
                        }
                        
                        $type = (int)$type;

  
                        if($color<10){
                            $color=str_replace("0","",$color);
                        }
                        
                        $t=DB::table('product_type')->where('id',$type)->first();
                        if($t ==null){
                            return 'not check ';
                        }
                        $c=DB::table('product_color')->where('id',$color)->first();
                        
                        $type=isset($t->product_type)?$t->product_type:'NO Check ';
                        return '<strong>'.$type.' | '.$c->color.'</strong>';
                        
                    })
                    ->addColumn('designImg',function ($data){
                        if($data->image !=''){
                            $url=$data->image;
                            $img='<img src="'.$data->image.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }else{
                           $url=asset('uploads/backend/no_image.png');
                            $img='<img src="'.asset('uploads/backend/no_image.png').'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }
    
                        
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                    <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a>
                                </div>
                            </div>
                        ';
    
                        return $product_detail;
                    })
                    ->addColumn('designDetail',function ($data){
                        
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                '.$data->code.'
                                </div>
                            </div>
                        ';
    
                        return $product_detail;
                    })
                    ->filterColumn('designDetail',function($query,$keyword){
                        $query->whereRaw("LOWER(code) LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('designDetail', function ($query, $order) {
                        $query->orderBy('code', $order);
                    })
                    
                    ->rawColumns(['productName','designDetail','designImg'])
                    ->make(true);

        }else{
            return view('sku.type_images');
        }
    }
    
    public function get_products_with(Request $request){
        if($request->ajax()){
            $records=DB::table('product_info_design')->orderBy('group_id','ASC')->orderBy('prod_design','ASC')->orderBy('prod_size','ASC')
                        ->join('product_size','product_size.id','=','product_info_design.prod_size')
                        ->leftJoin('product_design','product_info_design.prod_design','=','product_design.id')
                        ->select([
                            'product_info_design.*',
                            'product_size.size',
                            'product_design.design_title'
                        ]);
            if($request->size !=''){
                $records->where('product_info_design.prod_size',$request->size);
            }

            if($request->color !=''){
                $records->where('product_info_design.prod_color',$request->color);
            }

            if($request->gender !='' && $request->gender !='Gender'){
                $records->whereRaw("product_info_design.product_name LIKE ?", ["%{$request->gender}%"]);
            }

            if($request->status !=''){
                $records->where("product_info_design.prod_status",$request->status);
            }
            
            if($request->design !=''){
                $records->where("product_info_design.prod_design",$request->design);
            }
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('ProductImg',function ($data){
                    if($data->product_url !=''){
                        $url=$data->product_url;
                        $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                    }else{
                        $url=asset('uploads/sku_images/'.$data->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                    }

                    
                    $product_detail='
                        <div class="row" >
                            <div class="col-md-12" id="image_'.$data->id.'">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                        </div>
                    ';

                    return $product_detail;
                })
                ->addColumn('ProductDetail',function ($data){
                    $status='';
                    if($data->prod_status=='1'){
                        $status='<span class="badge badge-success">Active</span>';

                    }elseif($data->prod_status=='2'){
                        $status='<span class="badge badge-danger">Deactive</span>';
                    }
                    
                    if($data->prod_design !='0'){
                        $design='<span class="text-danger">SKU with Design  : <strong>'.$data->variation_design.'</strong></span><br>';
                    }else{
                        $design='';
                    }
                    $product_detail='
                        <div class="row" >
                            <div class="col-md-12" id="detail_'.$data->id.'">
                            '.$data->product_name.'<br>'.$status.'<br>
                            <span class="text-primary">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                            '.$design.'
                            <span class="text-success">Group id : <strong>'.$data->group_id.'</strong></span><br>
                            </div>
                        </div>
                    ';

                    return $product_detail;
                })
                ->filterColumn('ProductDetail',function($query,$keyword){
                    $query->orWhereRaw("LOWER(product_info_design.product_name) LIKE ?", ["%{$keyword}%"])
                            ->orWhereRaw("product_info_design.variation_id LIKE ?", ["%{$keyword}%"])
                            ->orWhereRaw("product_info_design.group_id LIKE ?", ["%{$keyword}%"]);
                })
                ->orderColumn('ProductDetail', function ($query, $order) {
                    $query->orderBy('product_info_design.product_name', $order)
                        ->orderBy('product_info_design.variation_id', $order)
                        ->orderBy('product_info_design.group_id', $order);
                })
                ->addColumn('options',function ($data){
                    $show =  route('sku.delete',$data->id);
                    $edit =  route('sku.edit',$data->id);

                    if(Gate::check('sku-edit')){
                        $edit_option='<option class="text-info text-md" value="edit" data-link="'.$edit.'">&#xf044; Edit</option>';
                    }else{
                        $edit_option='';
                    }

                    if(Gate::check('sku-delete')){
                        if($data->prod_status==1){
                            $class="text-danger";
                            $label="Mark as Deactive";
                        }else{
                            $class="text-success";
                            $label="Mark as Active";
                        }
                        $delete_option='<option class="'.$class.' text-md"value="delete" data-link="'.$show.'">&#xf06e; '.$label.'</option>';
                    }else{
                        $delete_option='';
                    }
                    // if(Gate::check('item-adjust')){
                    //     if($data->Quantity != 0){
                    //         $adjust='<option value="adjustment" style="color:#e2b870;">&#xf146; Item Adjustment</option>';
                    //     }else{
                    //         $adjust='';
                    //     }
                    // }else{
                    //     $adjust='';
                    // }
                    

                    $options='<select name="options" id="options_'.$data->id.'" class="form-control options" onchange="get_options('.$data->id.')">
                    <option value="">&#xf245; Please select</option>
                    '.$edit_option.$delete_option.'
                    
                    </select>';
                    return $options;
                })
                ->rawColumns(['ProductImg','ProductDetail','options'])
                ->make(true);
        }else{
            $product_size=DB::table('product_size')->where('status',1)->get();
            $color=DB::table('product_color')->where('status',1)->get();
            $product_gender=DB::table('product_gender')->where('status',1)->get();
            $product_design=DB::table('product_design')->get();
            // dd($product_size);
            return view('sku.index_with_design',[   
                'product_size' => $product_size,
                'color' => $color,
                'product_gender' => $product_gender,
                'product_design' => $product_design
            ]);
        }
    }
    
    public function prod_color_check($data)
    {
        foreach($data as $key => $r)
        {
            $color=DB::table('product_color')->where('id',$r['id'])->where('color',$r['color'])->get();
            
            if($color->count() == 0)
            {
                $colour = $r['color'];
                
                DB::table('product_color')->insert(['id'=>$r['id'],'color'=>$colour,'status'=>1]);
            }
            
        }
    }
    
    public function prod_design_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_design=DB::table('product_design')->where('id',$r['id'])->where('design_title',$r['design_title'])->get();
            
            if($product_design->count() == 0)
            {
                DB::table('product_design')->insert($r);
            }
            
        }
    }
    
    public function prod_type_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_type=DB::table('product_type')->where('id',$r['id'])->where('product_type',$r['product_type'])->get();
            
            if($product_type->count() == 0)
            {
                DB::table('product_type')->insert($r);
            }
            
        }
    }
    
    public function prod_type_images_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_type=DB::table('type_images')->where('id',$r['id'])->where('code',$r['code'])->get();
            
            if($product_type->count() == 0)
            {
                DB::table('type_images')->insert($r);
            }
            
        }
    }
    
    public function prod_info_design_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_type=DB::table('product_info_design')
            ->where('variation_id',$r['variation_id'])
            ->where('group_id',$r['group_id'])
            ->where('variation_design',$r['variation_design'])
            ->get();
            
            if($product_type->count() == 0)
            {
                unset($r['id']);
                DB::table('product_info_design')->insert($r);
            }
            
        }
    }
    
    
    public function prod_info_main_check($data)
    {
        foreach($data as $key => $r)
        {
            $product_type=DB::table('product_info')
            ->where('variation_id',$r['variation_id'])
            ->where('group_id',$r['group_id'])
            ->get();
            
            if($product_type->count() == 0)
            {
                unset($r['id']);
                DB::table('product_info')->insert($r);
 
            }
            
        }
    }
    
    public function GetCronData()
    {
        $url = "https://esireopex.com/miniopex_pro/api/cronapi";
        
        $file = file_get_contents($url);
        
        $resp = json_decode($file,true);
        
        $this->prod_color_check($resp['product_color']);
        
        $this->prod_design_check($resp['product_design']);
        
        $this->prod_type_check($resp['product_type']);
           
        $this->prod_info_design_check($resp['product_info_design']);
           
        $this->prod_type_images_check($resp['type_images']);
        
        $this->prod_info_main_check($resp['product_info']);
        
        return response()->json(['code'=>200]);
        
        // echo "<pre>";
        // print_r($resp['product_info']);
        // echo "</pre>";
    }
    
    // added by sufian check sku variation_id 03-01-22 
    public function check_variation_id(Request $request){
        if($request->ajax()){
            $variation_id=$request->variation_id;
            
            $product_info=DB::table('type_images')->where('code',$variation_id)->get();
            $row=[];
            $founded=0;
            if($product_info->count()>0){
                $row=$product_info->first();
                $founded=1;
            }
            
            return response()->json(['code' => '200','row' => $row,'founded' => $founded]);
        }
    }
    
    ///bulk added added by sufian 01-02-23
    public function bulk_bundle_update_status(Request $request){
        if($request->ajax()){
            // dd($request->all());
            $id_list=$request->id_list;
            $status=$request->status;
            
            $arr=explode(';',$id_list);
            
            foreach ($arr as $val){
                DB::table('bundle')->where('id',$val)->update(['status' => $status]);
            }
            
            return response()->json(['code' => '200' ,'message' => 'status updated successfully']);
        }
    }
    
    public function bulk_edit_bundle($id){
        $exp=explode(';',$id);
        $allrecord=DB::table('bundle')->whereIn('id',$exp)->get();
        $record=DB::table('bundle')->where('id',$exp[0])->first();
        $product_size=DB::table('product_size')->where('status',1)->get();
        $record_bundle_set=DB::table('bundle_sets')->where('bundle_set_variation',$record->bundle_set_variation)->where('is_deleted',0)->get();
        
        return view('sku.bulk_bundle_edit',['ids'=>$id,'product_size' => $product_size,'record'=>$record,'record_bundle_set'=>$record_bundle_set,'allrecord' => $allrecord]);
    }
}
