<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Illuminate\Support\Facades\Gate;

class ShippmentController extends Controller
{
    public function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:upload-shippment',['only' => ['index','shippment_list']]);
    }
    
    public function index(Request $request){
        if($request->ajax()){
            if($request->hasFile('file_upload')){
                $input = $request->all();
                $count=DB::table('shipment')->where('shipment_id',$input['shippment_id'])->count();
                if($count>0){
                    return response()->json([
                        'error_msg' => 'Shipment Already Exists',
                        'sale_id' => 0,
                        'error' =>1,
                    ]);
                }
                $image = $request->file('file_upload');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/upload_excel');
                $image->move($destinationPath, $name);
                
                
                
                $insert=[
                    'file_name' => $name,
                    'orignal_name' => $image->getClientOriginalName(),
                    'store_id' =>$input['store_selection'],
                    'cargo_select' => $input['cargo_select'],
                    'city_name' => $input['city_name'],
                    'state_name' => $input['state_name'],
                    'shipment_id' => $input['shippment_id'],
                    'comment_box' => $input['comment_box'],
                    'created_at' => date('Y-m-d H:i:s'),
                    'user_id' =>auth()->user()->id,
                    'status' =>0,
                ];
                
                $response=DB::table('shipment')->insertGetId($insert);

                $insert_excel=[
                    'file_name' => $name,
                    'original_name' => $image->getClientOriginalName(),
                    'type' => '3',
                    'type_name' => 'Shipment Upload',
                    'status' => '1',
                    'uploaded_by' => auth()->user()->id,
                    'upload_date' => date('Y-m-d')
                ];
                
    
                $insert_data=DB::table('upload_excel')->insert($insert_excel);
                
                $this->import_shippment($name,$image->getClientOriginalExtension(),$input['shippment_id']);
                
                return response()->json([
                    'error_msg' => 'Shippment Upload Successfully',
                    'sale_id' => $insert_data,
                    'error' =>0,
                ]);
            }
            
        }else{
            $stores=DB::table('store')->get();
            return view('shippment.index',['stores' => $stores]);
        }
    }
    
    public function shippment_list(Request $request){
        
        if($request->ajax()){
            $records=DB::table('shipment')
                        ->join('store','store.id','=','shipment.store_id')
                        ->join('users','users.id','=','shipment.user_id')
                        ->select([
                            'store.strong_name',
                            'users.name',
                            'shipment.*'
                        ]);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('ship_history', function($data){
                        if($data->box_label_status =='1'){
                            $rem=(int)$data->total_shipment_qty - (int)$data->total_remaining_quantity;
                            $html='<div>
                                    <span class="text-info">Total SKU : <strong>'.$data->total_sku.'</strong></span><br>
                                    <span style="color:#D35400">Total QTY : <strong>'.$data->total_shipment_qty.'</strong></span><br>
                                    <span class="text-primary">Remaining SKU : <strong>'.$data->total_remaining_sku.'</strong></span><br>
                                    <span class="text-danger">Remaining QTY : <strong>'.$data->total_remaining_quantity.'</strong></span><br>
                                    <span class="text-success">Shipped QTY : <strong>'.$rem.'</strong></span><br>
                                ';
                        }else{
                            $html='<div>';
                        }
                        
                        if($data->complete_status =='1'){
                            $html.='<span class="badge badge-success">Shipment Complete</span>';
                        }else{
                            $html.='<span class="badge badge-info">Shiping InProcess</span>';
                        }
                        if($data->box_label_status =='1'){
                            $html.='<span class="badge badge-primary">Box Label Uploaded</span>';
                        }else{
                            $html.='<span class="badge badge-danger">Pending Box Label</span>';
                        }
                         $html.='</div>';
                        return $html;
                    })
                    ->addColumn('action',function($data){
                        $download=route('upload.shippment.download',$data->id);
                        $start_scan=route('shippment.start.scan',$data->shipment_id);
                        $download_scan=route('shippment.scan.download',$data->shipment_id);
                        $view_scan=route('shippment.view.scan',$data->shipment_id);
                        $print_label=route('shippment.print.label',$data->shipment_id);
                        if($data->status =='1'){
                            $class="btn btn-sm btn-primary freeze_check";
                            $disabled='style="display:none;"';
                            $icon='fas fa-unlock';
                            $title='Un Freeze';
                        }else{
                            $class="btn btn-sm btn-danger freeze_check";
                            $disabled="";
                            $icon='fas fa-lock';
                            $title='Freeze';
                        }
                        
                        if($data->complete_status =='1'){
                            $style_complete='style="display:none;"';
                        }else{
                            $style_complete='';
                        }
                        
                        if($data->complete_status =='0'){
                            $style_complete_zero='style="display:none;"';
                        }else{
                            $style_complete_zero='';
                        }
                        
                        if($data->box_label_status =='1'){
                            $style_complete_box='style="display:none;"';
                        }else{
                            $style_complete_box='';
                        }
                        
                        $options='
                        <select name="options" '.$disabled.' id="options_'.$data->id.'" class="form-control options" onchange="get_options('.$data->id.')">
                        <option value="">Please select</option>
                        <option value="5" data-link="'.$print_label.'" '.$style_complete.'>Print Label</option>
                        <option value="2" data-link="'.$start_scan.'"  '.$style_complete.'>Start Scanning</option>
                        <option value="3" data-link="'.$view_scan.'" >View Scanned</option>
                        <option value="1" data-link="'.$download.'">Download File</option>
                        <option value="4" data-link="'.$download_scan.'" >Download Scanned File</option>
                        <option value="6" data-link="'.$data->shipment_id.'" '.$style_complete_zero.' '.$style_complete_box.'>Upload Box Label</option>
                        
                        
                        </select>';
                        
                        if(Gate::check('freeze-check-shipment')){
                            $options.='<br><a href="javascript:;" class="'.$class.'" data-id="'.$data->id.'"><i class="'.$icon.'"></i> '.$title.'</a>';
                        }
                        
                        
                        return $options;
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_at));
                    })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("shippment.created_at LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('shippment.created_at', $order);
                    })
                    ->rawColumns(['action','created_at','ship_history'])
                    ->make(true);
                        
        }
        
    }
    
    public function upload_box_label(Request $request){
        if($request->ajax()){
            // dd($request->all());
            $shipment_id=$request->shipment_id;
            $shipment_data=DB::table('shipment')->where('shipment_id',$shipment_id)->first();
            if ($request->hasFile('file_img')) {
                $image = $request->file('file_img');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/upload_pdf');
                $image->move($destinationPath, $name);
                
                $insert_excel=[
                    'file_name' => $name,
                    'original_name' => $image->getClientOriginalName(),
                    'type' => '4',
                    'type_name' => 'Upload Box label',
                    'status' => '1',
                    'uploaded_by' => auth()->user()->id,
                    'upload_date' => date('Y-m-d')
                ];
            

                $insert_data=DB::table('upload_excel')->insert($insert_excel);
                
                $total=DB::table('shipment_info')->where('shipment_id',$shipment_id)->where('remaining_qty','!=','0')->first([
                    DB::raw('count(id) as total_remaining_sku'),
                    DB::raw('sum(remaining_qty) as total_remaining_qty')
                ]);
                
                $total_actual=DB::table('shipment_info')->where('shipment_id',$shipment_id)->first([
                    DB::raw('count(id) as 	total_sku'),
                    DB::raw('sum(expected_qnt) as total_shipment_qty')
                ]);
                
                
                $total_shipment_qty=($total_actual->total_shipment_qty !=NULL)?$total_actual->total_shipment_qty:0;
                $total_sku=($total_actual->total_sku !=NULL)?$total_actual->total_sku:0;
                $total_remaining_sku=($total->total_remaining_sku !=NULL)?$total->total_remaining_sku:0;
                $total_remaining_qty=($total->total_remaining_qty !=NULL)?$total->total_remaining_qty:0;
                
                $update_arr=[
                    'updated_date' => date('Y-m-d'),
                    'total_shipment_qty' => $total_shipment_qty,
                    'total_sku' => $total_sku,
                    'total_remaining_sku' => $total_remaining_sku,
                    'total_remaining_quantity' => $total_remaining_qty
                ];
                
                
                $insert_box_label=[
                    'file_name' => $name,
                    'original_name' => $image->getClientOriginalName(),
                    'store_id' => $shipment_data->store_id,
                    'shipment_id' => $shipment_id,
                    'shipment_type' => $shipment_data->cargo_select,
                    'created_date' => date('Y-m-d H:i:s'),
                    'user_id' => auth()->user()->id,
                    'total_remaining_sku' => $total_remaining_sku,
                    'total_remaining_qty' => $total_remaining_qty
                ];
                // dd($insert_box_label);
                $in_data=DB::table('upload_box_label')->insertGetId($insert_box_label);
                
                if($in_data){
                    $shipment_info_data=DB::table('shipment_info')->where('shipment_id',$shipment_id)->get();
                    // shipment_info_data=DB::table('shipment_info')->where('shipment_id',$shipment_id)->where('remaining_qty','!=','0')->get();
                    // dd($shipment_info_data);
                    if(count($shipment_info_data)>0){
                        foreach($shipment_info_data as $row){
                            $explode=explode('-',$row->opex_sku);
                            $variation_id=$explode[0];
                            $variation_design=$row->opex_sku;
                            
                            $filled_qty=(int)$row->expected_qnt - (int)$row->remaining_qty;
                            
                            if($filled_qty>0){
                                $store_id=$shipment_data->store_id;
                                $shipment_type=$shipment_data->cargo_select;
                                $this->minus_processed_order_quantity($variation_design,$store_id,$shipment_type,$filled_qty);
                                $this->processed_order_minus($shipment_id,$variation_id,$variation_design,$store_id,$shipment_type,$filled_qty);
                            }
                            
                            // $insert_process=[
                            //     'variation_id' => $variation_id,
                            //     'variation_design' => $variation_design,
                            //     'approve_qty' => $row->remaining_qty,
                            //     'given_qty' => $row->remaining_qty,
                            //     'urgent_status' => 1,
                            //     'processed_status' => 0,
                            //     'user_id' => auth()->user()->id,
                            //     'created_date' => date('Y-m-d H:i:s'),
                            //     'store_id' => $shipment_data->store_id,
                            //     'shipment_type' => $shipment_data->cargo_select,
                            // ];
                            
                            // DB::table('process_orders')->insert($insert_process);
                            
                            // $where_qty=[
                            //     'variation_id' => $variation_id,
                            //     'variation_design' => $variation_design,
                            //     'store_id' => $shipment_data->store_id,
                            //     'shipment_type' => $shipment_data->cargo_select,
                            // ];
                            
                            // $count1=DB::table('process_order_quantity')->where($where_qty)->first();
                            
                            
                            // if($count1 ==null){
                            //     $insert_qty=[
                            //         'variation_id' => $variation_id,
                            //         'variation_design' => $variation_design,
                            //         'store_id' => $shipment_data->cargo_select,
                            //         'shipment_type' => $shipment_data->cargo_select,
                            //         'created_date' => date('Y-m-d H:i:s'),
                            //         'created_by' => auth()->user()->id,
                            //         'process_qty' => $row->remaining_qty,
                            //         'receiving_qty' => $row->remaining_qty,
                            //     ];
                                
                            //     DB::table('process_order_quantity')->insert($insert_qty);
                            // }else{
                            //     $qty2=(int)$row->remaining_qty + (int)$count1->process_qty;
                            //     $update_qty=[
                            //         'updated_date' => date('Y-m-d H:i:s'),
                            //         'updated_by' => auth()->user()->id,
                            //         'process_qty' => $qty2,
                            //         'receiving_qty' => $qty2
                            //     ];
                            //     DB::table('process_order_quantity')->where($where_qty)->update($update_qty);
                            // }
                        }
                    }
                    
                    
                }
                
                
                
            }
            $update_arr['box_label_id']=$in_data;
            $update_arr['box_label_status']=1;
            $update_arr['status']=1;
            DB::table('shipment')->where('shipment_id',$shipment_id)->update($update_arr);
            return response()->json([
                'code' => 200,
                'msg' => 'Successfully Shipment Completed',
            ]);
        }
    }
    
    public function minus_processed_order_quantity($variation_design,$store_id,$shippment_type,$filled_qty){
        $explode=explode('-',$variation_design);
        $variation_id=$explode[0];
        
        $where_processed=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'store_id' => $store_id,
            'shipment_type' => $shippment_type,
            'status' => 0
        ];
                
        $check=DB::table('processed_order_quantity')->where($where_processed)->get();
        
        if($check->count()>0){
            $row=$check->first();
            
            $qty=(int)$row->receiving_qty - (int)$filled_qty;
            $update=[
                
                'receiving_qty' => ($qty <=0)?0:$qty,
                'updated_date' => date('Y-m-d H:i:s'),
                'updated_by' => auth()->user()->id,
            ];
            
            if($qty<=0){
                $update['status']=1;
            }
            DB::table('processed_order_quantity')->where($where_processed)->update($update);
        }
    }
    
    public function processed_order_minus($shipment_id,$variation_id,$variation_design,$store_id,$shipment_type,$qty){
        
        $actual_approve=$qty;
        $where=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type,
            'shipment_ready_status' => 0,
        ];
        
        
        
        $list=DB::table('processed_orders')->where($where)->get();
        if($list->count()>0){
            foreach($list as $record){
                $given_qty=$record->filled_qty;
                $approve_qty=$record->approve_qty;
                
                if($qty<=$given_qty){
                    $up_qty=$qty;
                    $given_qty=$given_qty-$qty;
                    $qty=0;
                }else{
                    $up_qty=$given_qty;
                    $qty=(int)$qty - (int)$given_qty;
                    $given_qty=0;
                    
                }
                
                $which=preg_replace('/[0-9]+/', '', str_replace('-','',$record->pr_id));
                
                $insert_log=[
                    'variation_id' => $variation_id,
                    'pr_id' => $record->pr_id,
                    'given_qty' => $up_qty,
                    'supplier_id' =>0,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'Shipped Against '.$which.' Shipment ID : '.$shipment_id,
                    'created_date' => date('Y-m-d H:i:s')
                ];

                $insert_data=DB::table('item_log')->insert($insert_log);
                
                
                $update_rec=['filled_qty' => $given_qty];
                
                $up=DB::table('processed_orders')->where('id',$record->id);
                
                $up->update($update_rec);
                
                if($given_qty <=0){
                    $up->update(['shipment_ready_status' => 1]);
                }
                
                if($qty==0){
                    break;
                }
            }
        }
    }
    
    public function shipment_freeze(Request $request){
        if($request->ajax()){
            $id=$request->id;
            $shipment=DB::table('shipment')->where('id',$id)->first();
            
            if($shipment !=null){
                if($shipment->status =='1'){
                    $status=0;
                }else if($shipment->status =='0'){
                    $status=1;
                }
                
                $update=[
                    'status' => $status,
                    'updated_date' => date('Y-m-d'),
                    'updated_by' => auth()->user()->id
                ];
                DB::table('shipment')->where('id',$id)->update($update);
                return response()->json([
                    'response' => 'success'
                ]);
            }
        }
    }
    
    public function import_shippment($file_name,$extension,$shipment_id){
        if($extension == 'csv'){
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
        } elseif($extension == 'xlsx') {
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        } else {
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
        }

        $spreadsheet = $reader->load(public_path('/uploads/upload_excel/'.$file_name));
        $allDataInSheet = $spreadsheet->getActiveSheet();
        $lastRow = $allDataInSheet->getHighestRow();
        
        if(preg_match('/^Shipment ID/im', $allDataInSheet->getCell('A1')->getValue())){
            $count1=1;
        }else if(preg_match('/^Pack group/im', $allDataInSheet->getCell('A2')->getValue())){
            $count1=2;
        }
        
        if(isset($count1)){
            for ($row = 1; $row <= $lastRow; $row++) {
            if($count1==1){
                if($row < 5)
                {
                    continue;
                }
                if(strlen(trim($allDataInSheet->getCell('B'.$row)->getValue())) == 0)
                {
                    continue;
                }
                
                $opex_sku=trim($allDataInSheet->getCell('C'.$row)->getValue());
                preg_match('#\[(.*?)\]#', $opex_sku, $match);
                
                
                
                $opex_sku=(isset($match[1]))?$match[1]:'';
                if(!isset($match[1])){
                    
                   DB::table('shipment_info')->where('shipment_id', $shipment_id)->delete();
                   $shipmentData=DB::table('shipment')->where('shipment_id', $shipment_id)->first();
                   unlink(public_path('uploads/upload_excel/'.$shipmentData->file_name));
                   DB::table('shipment')->where('shipment_id', $shipment_id)->delete();
                   DB::table('upload_excel')->where('file_name', $shipmentData->file_name)->delete();
                   
                   echo json_encode([
                       'error_msg' => 'Opex SKU not found in excel at row:'.$row.' in Product Name And FNSKU is <strong>('.trim($allDataInSheet->getCell('D'.$row)->getValue()).')</strong> Please Add [Opex SKU]  
                                        <br>
                                        Example : <strong>Mens Long Sleeve Shirt Full Sleeve Henley Style | [4912294] Henley LGS Set 1 - L</strong>',
                        'sale_id' => 01,
                        'error' =>1,
                       ]);
                    exit;
                }
                    

                $data = [
                
                    'shipment_id'=>$shipment_id,
                    'sku'=>trim($allDataInSheet->getCell('A'.$row)->getValue()),
                    'asin'=>trim($allDataInSheet->getCell('B'.$row)->getValue()),
                    'fnsku'=>trim($allDataInSheet->getCell('D'.$row)->getValue()),
                    'product'=>trim($allDataInSheet->getCell('C'.$row)->getValue()),
                    'expected_qnt'=>trim($allDataInSheet->getCell('I'.$row)->getValue()),
                    'remaining_qty' => trim($allDataInSheet->getCell('I'.$row)->getValue()),
                    'user_id'=>auth()->user()->id,
                    'created_at' => date('Y-m-d H:i:s'),
                    'opex_sku' => $opex_sku
                ];


            }else if($count1==2){
                if($row < 6)
                {
                    continue;
                }
                if(strlen(trim($allDataInSheet->getCell('B'.$row)->getValue())) == 0)
                {
                    continue;
                }
                
                $opex_sku=trim($allDataInSheet->getCell('B'.$row)->getValue());
                preg_match('#\[(.*?)\]#', $opex_sku, $match);
                $opex_sku=(isset($match[1]))?$match[1]:'';
                
                if(!isset($match[1])){
                    
                   DB::table('shipment_info')->where('shipment_id', $shipment_id)->delete();
                   $shipmentData=DB::table('shipment')->where('shipment_id', $shipment_id)->first();
                   unlink(public_path('uploads/upload_excel/'.$shipmentData->file_name));
                   DB::table('shipment')->where('shipment_id', $shipment_id)->delete();
                   DB::table('upload_excel')->where('file_name', $shipmentData->file_name)->delete();
                   
                   echo json_encode([
                       'error_msg' => 'Opex SKU not found in excel at row:'.$row.' in Product Name And FNSKU is <strong>('.trim($allDataInSheet->getCell('E'.$row)->getValue()).')</strong> Please Add [Opex SKU]  
                                        <br>
                                        Example : <strong>Mens Long Sleeve Shirt Full Sleeve Henley Style | [4912294] Henley LGS Set 1 - L</strong>',
                        'sale_id' => 01,
                        'error' =>1,
                       ]);
                    exit;
                }

                $data = [
                
                    'shipment_id'=>$shipment_id,
                    'sku'=>trim($allDataInSheet->getCell('A'.$row)->getValue()),
                    'asin'=>trim($allDataInSheet->getCell('D'.$row)->getValue()),
                    'fnsku'=>trim($allDataInSheet->getCell('E'.$row)->getValue()),
                    'product'=>trim($allDataInSheet->getCell('B'.$row)->getValue()),
                    'expected_qnt'=>trim($allDataInSheet->getCell('J'.$row)->getValue()),
                    'remaining_qty' => trim($allDataInSheet->getCell('J'.$row)->getValue()),
                    'user_id'=>auth()->user()->id,
                    'created_at' => date('Y-m-d H:i:s'),
                    'opex_sku' => $opex_sku
                ];
            }
             
            DB::table('shipment_info')->insert($data);
		}
        }else{
            DB::table('shipment_info')->where('shipment_id', $shipment_id)->delete();
            $shipmentData=DB::table('shipment')->where('shipment_id', $shipment_id)->first();
            unlink(public_path('uploads/upload_excel/'.$shipmentData->file_name));
            DB::table('shipment')->where('shipment_id', $shipment_id)->delete();
            DB::table('upload_excel')->where('file_name', $shipmentData->file_name)->delete();
           
            echo json_encode([
               'error_msg' => 'Please import correct file, did not match excel sheet column',
                'sale_id' => 01,
                'error' =>1,
               ]);
            exit;
            
        }
        
        
        
        
    }
    
    public function start_scan($shipment_id){
        $shipment_data=DB::table('shipment')->where('shipment_id',$shipment_id)->first();
        
        if($shipment_data->complete_status =='1'){
            return abort(404);
        }
        
        return view('shippment.scan',['shipment_id'=>$shipment_id]);
    }
    
    public function add_box(Request $request){
        $input=$request->all();
        $data = [
           
         'shipment_id'=>$input['shipment_id'],  
         'box_id'=>$input['box_id'], 
         'box_weight'=>$input['box_weight'], 
         'box_length'=>$input['box_length'], 
         'box_width'=>$input['box_width'], 
         'box_height'=>$input['box_height'],
         'user_id'=>auth()->user()->id,
         'created_at' => date('Y-m-d H:i:s'),
           
       ]; 
       
       $count=DB::table('box_info')->where([
           'shipment_id'=>$input['shipment_id'],  
            'box_id'=>$input['box_id'],
         ])->count();
         
        if($count>0){
            $insert_data=DB::table('box_info')->where([
            'shipment_id'=>$input['shipment_id'],  
            'box_id'=>$input['box_id'],
            ])->update($data);
        }else{
            $insert_data=DB::table('box_info')->insert($data);
        }
        
        echo $insert_data;
        
       
       
    }
    
    public function get_all_boxes_info(Request $request){
        $shipment_id = $request->shipment_id;
        
        $data=DB::table('box_info')->where('shipment_id',$shipment_id)->get();
        
        // $query = $this->db->query("SELECT * FROM box_info WHERE shipment_id='$shipment_id'"); 
        return response()->json([
            'code' => 200,
            'data' => $data
            ]);
        
        // $this->output
        //     ->set_content_type('application/json')
        //     ->set_output(json_encode(array('code' =>200,'data'=>$query->result())));
    }
    
    public function get_box_weight_info(Request $request){
       $shipment_id = $request->shipment_id;
       $box_id = $request->box_id;
       
       $data=DB::table('box_info')->where('shipment_id',$shipment_id)->where('box_id',$box_id)->first();
        
    //   $query = $this->db->query("SELECT * FROM box_info WHERE shipment_id='$shipment_id' AND box_id='$box_id'");
       
       if($data !==null){
            return response()->json([
                'code' => 200,
                'data' => $data
            ]);
       }else{
            return response()->json([
                'code' => 400,
            ]); 
       }
    //   if($query->num_rows() > 0)
    //   {
          
    //         $this->output
    //         ->set_content_type('application/json')
    //         ->set_output(json_encode(array('code' =>200,'data'=>$query->row())));
           
    //   }else
    //   {
        
    //         $this->output
    //         ->set_content_type('application/json')
    //         ->set_output(json_encode(array('code' =>400)));
           
    //   }
        
    }
    
    public function complete_status(Request $request){
        $shipment_id = $request->shipment_id;
        $shipment_data=DB::table('shipment')->where('shipment_id',$request->shipment_id)->count();
        
        if($shipment_data >0){
            $update=[
                'complete_status' =>1,
                'completed_date' => date('Y-m-d'),
                'completed_by' => auth()->user()->id
            ];
            
            DB::table('shipment')->where('shipment_id',$request->shipment_id)->update($update);
            return response()->json([
               'code' =>200,
               'msg'=>'Shipment has been Completed',
            ]);
        }
        
    }
    
    public function get_product_img_by_fnsku(Request $request){
       $fnsku = $request->fnsku;
       
       $shipment_id = $request->shipment_id;
       
       //added by sufian
       $box_id=$request->box_id;
       if(DB::table('scanning')->where(['fnsku' => $fnsku,'shipment_id' => $shipment_id,'box_id'=>$box_id])->count()>0){
           return response()->json([
               'code' =>400,
               'msg'=>'Already Exist in This box',
            ]);
       }
       
       
                            
       $check=DB::table('shipment_info')
                ->leftJoin( DB::raw('bundle as b'),'b.bundle_set_variation','=','shipment_info.opex_sku')
                ->leftJoin( DB::raw('product_info_design as c'),'c.variation_design','=','shipment_info.opex_sku')
                ->where([
                   'shipment_id'=>$request->shipment_id,
                   'fnsku' => $fnsku
                   ])->first([
                       DB::raw('IF (shipment_info.opex_sku LIKE  "%BUN%",b.bundle_set_variation,c.variation_design)'),
                       'c.*',
                       'b.*',
                       'shipment_info.*'
                       
                ]);
        // $check->count();  
       
       if($check!== null){
           if($check->remaining_qty ==0){
                return response()->json([
                   'code' =>400,
                   'msg' => 'Expected Quantity of this Fnsku is completed'
                ]);
           }
           
        //   $expected_qnt = $check->expected_qnt;
           $expected_qnt = $check->remaining_qty;
           
           return response()->json([
               'code' =>200,
               'expected_qty'=>$expected_qnt,
               'data' =>$check 
            ]);
       }else{
          return response()->json([
               'code' =>400,
               'msg' => 'Sorry This Fnsku not exist!'
            ]); 
       }
       
//       if($check->num_rows() > 0){
           
           
               
//               $expected_qnt = $check->row()->expected_qnt;
           
//           $query = $this->db->query("SELECT po.fnsku,pi.product_name,pi.prod_img,pi.prod_asin  FROM processed_orders po 
// LEFT JOIN product_info pi ON pi.id = po.product_id
// WHERE po.fnsku='$fnsku' LIMIT 1");
       
//       if($query->num_rows() > 0)
//       {
         
//               $this->output
//             ->set_content_type('application/json')
//             ->set_output(json_encode(array('code' =>200,'data'=>$query->row(),'expected_qty'=>$expected_qnt)));
           
//       }else
//       {
           
//             $this->output
//             ->set_content_type('application/json')
//             ->set_output(json_encode(array('code' =>400)));
           
//       }
           
//       }else{
           
//              $this->output
//             ->set_content_type('application/json')
//             ->set_output(json_encode(array('code' =>400)));
           
//       }
   }
   
    public function add_qty_inbox(Request $request){
        $where=[
            'shipment_id'=>$request->shipment_id,
            'fnsku'=>$request->fnsku
        ];
        
        $check=DB::table('shipment_info')->where($where)->first();
        $shipment_data=DB::table('shipment')->where('shipment_id',$request->shipment_id)->first();
        if($check !==null){
            //added by sufian
            $remaining_qty=(int)$check->remaining_qty - (int)$request->qty;
            $remaining_qty=($remaining_qty<0)?0:$remaining_qty;
            DB::table('shipment_info')->where($where)->update([
                'remaining_qty' =>$remaining_qty
            ]);
        }
        $data = [
            'shipment_id'=>$request->shipment_id,
            'box_id'=>$request->box_id,
            'fnsku'=>$request->fnsku,
            'qty'=>$request->qty,
            'user_id'=>auth()->user()->id,
            'created_at' => date('Y-m-d H:i:s'),
        ];
        
        $count=DB::table('scanning')->where([
            'shipment_id'=>$request->shipment_id,
            'box_id'=>$request->box_id,
            'fnsku'=>$request->fnsku,
        ])->count();
        
        if($count>0){
            DB::table('scanning')->where([
                'shipment_id'=>$request->shipment_id,
                'box_id'=>$request->box_id,
                'fnsku'=>$request->fnsku,
            ])->update($data);
        }else{
            DB::table('scanning')->insert($data);
        }
        
        return response()->json(['code' => 200]); 
    }
    public function get_cart_table_data(Request $request){
        $query=DB::table('scanning')
                    ->leftjoin('shipment_info','shipment_info.fnsku','=','scanning.fnsku')
                    ->where([
                        'scanning.shipment_id' => $request->shipment_id,
                        'scanning.box_id' => $request->box_id,
                        'shipment_info.shipment_id' => $request->shipment_id
                    ])
                    ->groupBy('scanning.fnsku')
                    ->orderBy('scanning.created_at','desc')
                    ->get([
                        'scanning.*',
                        'scanning.id as record_id',
                        'shipment_info.product',
                        'shipment_info.expected_qnt'
                    ]);
        if(count($query)>0){
            return response()->json([
                'code' =>200,
                'data' => $query
            ]);
        }else{
            return response()->json([
                'code' =>400,
            ]);
        }
//       $query = $this->db->query("SELECT s.*,s.id record_id,p.product_name,p.prod_img,si.expected_qnt FROM scanning s 
// LEFT JOIN processed_orders ps ON ps.fnsku=s.fnsku
// LEFT JOIN product_info p ON p.id=ps.product_id
// LEFT JOIN shipment_info si ON si.shipment_id=s.shipment_id AND si.fnsku=s.fnsku
// WHERE s.shipment_id ='".trim($this->input->post('shipment_id'))."' AND s.box_id='".$this->input->post('box_id')."' GROUP BY s.fnsku ORDER BY s.created_at DESC");
        

            
        
        
        // if($query->num_rows() > 0){
        //       $this->output
        //     ->set_content_type('application/json')
        //     ->set_output(json_encode(array('code' =>200,'data'=>$query->result())));
        // }else{
        //       $this->output
        //     ->set_content_type('application/json')
        //     ->set_output(json_encode(array('code' =>400)));
        // }
    }
    
    public function delete_cart_item(Request $request){
        $check=DB::table('scanning')->where('id' , $request->id)->first();
        $where=[
            'shipment_id'=>$check->shipment_id,
            'fnsku'=>$check->fnsku
        ];
        
        $check1=DB::table('shipment_info')->where($where)->first();
        
        
        if($check1 !==null){
            
        //added by sufian
            $remaining_qty=(int)$check1->remaining_qty+(int)$check->qty;
            $check1=DB::table('shipment_info')->where($where)->update([
                'remaining_qty' => ($remaining_qty<0)?0:$remaining_qty
            ]);
        }
        
        
        DB::table('scanning')->where('id' , $request->id)->delete();
        return response()->json([
            'code' => 200
        ]);
    }
    
    public function get_all_shipment_data(Request $request){
        
        $shipment_id = $request->shipment_id;
        $query =DB::table('scanning')->where('shipment_id',$shipment_id)->get();
        
        // $query = $this->db->query("SELECT * FROM scanning WHERE shipment_id='$shipment_id'"); 
        return response()->json([
            'code' => 200,
            'data' => $query
        ]);
        // $this->output
        //     ->set_content_type('application/json')
        //     ->set_output(json_encode(array('code' =>200,'data'=>$query->result())));
    }
    
    public function download_file($id,Request $request){
        $check=DB::table('shipment')->where('id',$id)->first();
        if($check !==null){
            $filename=$check->file_name;
            $pathToFile = asset('uploads/upload_excel/'.$filename);
            
            return response()->json([
                'error'=>0,
                'download_file'=>$pathToFile,
                'file_name' =>$check->orignal_name,
                
            ]);
        }else{
            return response()->json([
                'error'=>1,
            ]);  
        }
        
        
        
        
    }
    
    public function shipment_export($shipment){
        $objPHPExcel= new Spreadsheet();
         
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->getStyle("A1:Z200")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Merchant SKU');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'ASIN');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'FNSKU');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Title');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Expected QTY');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Boxed QTY');

        $cellArr = ["G","H","I","J"
        ,"K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","AA","AB","AC","AD","AE","AF","AG","AH","AI","AJ","AK","AL","AM","AN","AO","AP","AQ","AR","AS","AT","AU","AV","AW","AX","AY","AZ"];
               
        // dd($objPHPExcel);
        
        $boxes_query =DB::table('scanning')->where('shipment_id',$shipment)->groupBy('box_id')->get();
        
        
        // $boxes_query = $this->db->query("SELECT box_id FROM `scanning` WHERE shipment_id='$shipment' GROUP BY box_id");
    
        if(count($boxes_query) > 0)
        {
            foreach($boxes_query as $key => $box){
               
               $objPHPExcel->getActiveSheet()->SetCellValue($cellArr[$key].'1', 'Box '.$box->box_id.' - QTY');
            }
        }
        
        
        
        $query=DB::table('shipment_info')->where('shipment_id',$shipment)->get();
      
        // $query = $this->db->where('shipment_id',$shipment)->get('shipment_info');
       
        if(count($query) > 0){
            $count = 2;
            foreach($query as $row){
                // echo "<pre>";print_r($row);
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$count, $row->sku);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$count, $row->asin);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$count, $row->fnsku);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$count, $row->product);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$count, $row->expected_qnt);
                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$count, 0); 
     
                $total_fnsku_qty = 0;
                if(count($boxes_query) > 0){
                    foreach($boxes_query as $key => $box){  
                        $box_qty = $this->get_fnsku_scanned_qty($shipment,$box->box_id,$row->fnsku); 
                        $objPHPExcel->getActiveSheet()->SetCellValue($cellArr[$key].$count, $box_qty);
                        $total_fnsku_qty+=$box_qty;
                    }
                }
      
                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$count, $total_fnsku_qty);
      
                $count++;
            }
  
            $boxcount =  $count+4;
            $boxcountone = $count+3;
            $boxcounttwo = $count+1;
  
            // $objPHPExcel->getActiveSheet()->SetCellValue('G'.$boxcounttwo, 'Boxes Summary');
                
            // $objPHPExcel->getActiveSheet()->SetCellValue('A'.$boxcountone, 'Box');
            // $objPHPExcel->getActiveSheet()->SetCellValue('B'.$boxcountone, 'Weight of box (lbs.)');
            // $objPHPExcel->getActiveSheet()->SetCellValue('C'.$boxcountone, 'Box length (in.)');
            // $objPHPExcel->getActiveSheet()->SetCellValue('D'.$boxcountone, 'Box width (in.)');
            // $objPHPExcel->getActiveSheet()->SetCellValue('E'.$boxcountone, 'Box height (in.)');
            
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$boxcounttwo+1, 'Box');
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$boxcounttwo+2, 'Weight of box (lbs.)');
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$boxcounttwo+3, 'Box length (in.)');
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$boxcounttwo+4, 'Box width (in.)');
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$boxcounttwo+5, 'Box height (in.)');
            if(count($boxes_query) > 0){
                foreach($boxes_query as $key => $box){   
                    $box_id = $box->box_id;
                    
                    $query=DB::table('box_info')->where('shipment_id',$shipment)->where('box_id',$box_id)->first();
                    // $query = $this->db->query("SELECT * FROM box_info WHERE shipment_id='$shipment' AND box_id='$box_id'");
                    
                    if($query !==null){
                        $weight = $query->box_weight;
                        $length = $query->box_length;
                        $width  = $query->box_width;
                        $height = $query->box_height;
                    }else{
                        $weight = 0;
                        $length = 0;
                        $width  = 0;
                        $height = 0;
                    }
                    
                    $objPHPExcel->getActiveSheet()->SetCellValue($cellArr[$key].$boxcounttwo+1, 'Box '.$box->box_id.' - QTY');
                    $objPHPExcel->getActiveSheet()->SetCellValue($cellArr[$key].$boxcounttwo+2, $weight);
                    $objPHPExcel->getActiveSheet()->SetCellValue($cellArr[$key].$boxcounttwo+3, $length);
                    $objPHPExcel->getActiveSheet()->SetCellValue($cellArr[$key].$boxcounttwo+4, $width);
                    $objPHPExcel->getActiveSheet()->SetCellValue($cellArr[$key].$boxcounttwo+5, $width);
                    // $objPHPExcel->getActiveSheet()->SetCellValue('G'.$boxcounttwo, 'Box '.$box->box_id.' - QTY');
                    // $objPHPExcel->getActiveSheet()->SetCellValue('B'.$boxcount, $weight);
                    // $objPHPExcel->getActiveSheet()->SetCellValue('C'.$boxcount, $length);
                    // $objPHPExcel->getActiveSheet()->SetCellValue('D'.$boxcount, $width);
                    // $objPHPExcel->getActiveSheet()->SetCellValue('E'.$boxcount, $width);
                    // $boxcounttwo++;
            
                }
            }
        }
        
        //  ob_end_clean();
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
        $objWriter->setPreCalculateFormulas(false);
        // $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($objPHPExcel, 'Xlsx');
        $file_name = $shipment."_".date('Y_m_d_h_i_s');
        // dd($objWriter);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        // header('Content-Disposition: attachment;filename="your_name.xls"');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;

       
   }
    
    public function get_fnsku_scanned_qty($shipment,$boxid,$fnsku){
        $query =DB::table('scanning')
                ->where([
                    'shipment_id' =>$shipment,
                    'box_id' => $boxid,
                    'fnsku' => $fnsku
                ])->first();
    //   $query = $this->db->query("SELECT qty FROM scanning WHERE shipment_id='$shipment' AND box_id='$boxid' AND fnsku='$fnsku'");
       
       if($query !==null){
           return $query->qty;
           
       }else{
           return 0;
       }
   }
   
    public function view_scan_list($shipment_id,Request $request){
        if($request->ajax()){
            
            $box_id=$request->box;
            $records=DB::table('scanning')
                    ->join('shipment_info','shipment_info.fnsku','=','scanning.fnsku')
                    ->where('scanning.shipment_id',$shipment_id)
                    ->groupBy('scanning.fnsku')
                    ->groupBy('scanning.box_id')
                    ->select([
                        'scanning.*',
                        'scanning.id as record_id',
                        'shipment_info.product',
                        'shipment_info.expected_qnt'
                    ]);
            if($box_id !=''){
                $records->where('scanning.box_id',$box_id);
            }
            
            return Datatables::of($records)->make(true);
            
        }else{
            $query=DB::table('scanning')->where('shipment_id',$shipment_id)->groupBy('box_id')->get();
            return view('shippment.view_scan',['shipment_id'=>$shipment_id,'shipment_boxes' => $query]);
        }
        
    }
    
    public function shipment_print_label($shipment_id,Request $request){
        if($request->ajax()){
            $records=DB::table('shipment_info')
                            ->leftJoin( DB::raw('bundle as b'),'b.bundle_set_variation','=','shipment_info.opex_sku')
                            ->leftJoin( DB::raw('product_info_design as c'),'c.variation_design','=','shipment_info.opex_sku')
                            ->leftJoin('product_design','product_design.id','=','c.prod_design')
                            ->orderBy('c.id','ASC')
                            ->orderBy('c.variation_id','ASC')
                            ->orderBy('c.prod_size','ASC')
                            ->orderBy('c.prod_design','ASC')
                            ->where('shipment_info.shipment_id',$shipment_id)
                            ->select([
                                DB::raw('IF (shipment_info.opex_sku LIKE  "%BUN%",b.bundle_set_variation,c.variation_design)'),
                                'c.variation_id',
                                'c.variation_design',
                                'c.product_name',
                                'c.prod_img',
                                'c.product_url',
                                'c.prod_asin',
                                'shipment_info.fnsku',
                                'shipment_info.id',
                                'product_design.design_title',
                                'shipment_info.expected_qnt',
                                'b.bundle_set_variation',
                                'b.bundle_set_name',
                                'b.image_url'
                            ]);
                            
        return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('product_img',function($data){
                        
                        if($data->bundle_set_variation !=''){
                            if($data->image_url !=''){
                                $url=$data->image_url;
                                $img=' <img src="'.$data->image_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                            }else{
                                $url=asset('uploads/sku_images/'.$data->prod_img);
                                $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                            }
                        }else{
                           if($data->product_url !=''){
                                $url=$data->product_url;
                                $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                            }else{
                                $url=asset('uploads/sku_images/'.$data->prod_img);
                                $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                            } 
                        }
                        
    
                        $product_detail='
                            <div class="form-check">
                                <div class="checkbox">
                                    <input type="checkbox" id="id_check_'.$data->id.'" name="id_check[]" value="'.$data->id.'" data-qty="'.$data->expected_qnt.'" class="form-check-input id_check"><br>
                                    <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a><br>
                                </div>
                            </div>
                                    
                                    
                                
                        ';
                        return $product_detail;
                    })
                    ->addColumn('product_name',function ($data){
                        
                        if($data->bundle_set_variation !=''){
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-12">
                                    '.$data->bundle_set_name.'<br>
                                    <span class="text-success">SKU : <strong>'.$data->bundle_set_variation.'</strong></span><br>
                                    </div>
                                </div>';
                            return $product_detail;
                        }
                        
                        if($data->product_name !=''){
                            if($data->design_title !=''){
                                $status='<span class="text-danger">Design : <strong>'.$data->design_title.'</strong></span>';
                            }else{
                                $status='<span class="text-danger">Design : <strong>No Design</strong></span>';;
                            }
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-12">
                                    '.$data->product_name.'<br>
                                    <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                    <span style="color:#D35400">SKU with Design : <strong>'.$data->variation_design.'</strong></span><br>'.$status.'
                                    </div>
                                </div>
                            ';
                        }else{
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-6">
                                    '.$data->variation_id.'
                                    </div>
                                </div>
                            ';
                        }
                        return $product_detail;
                    })
                    ->filterColumn('product_name',function($query,$keyword){
                        $query->orWhereRaw("c.product_name LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("c.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("c.variation_design LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('product_name', function ($query, $order) {
                        $query->orderBy('c.product_name', $order);
                    })
                    ->addColumn('action',function ($data){
                        return '<a href="javascript:;" id="print_label_'.$data->id.'" data-id="'.$data->id.'" class="btn btn-sm btn-primary print_label">
                        <i class="fas fa-barcode"></i> Print label</a>';
                    })
                    ->rawColumns(['product_img','product_name','action'])
                    ->make(true);
        }else{
            $shipment_data=DB::table('shipment')->where('shipment_id',$shipment_id)->first();
            if($shipment_data->complete_status =='1'){
                return abort(404);
            }
            return view('shippment.print_label',['shipment_id'=>$shipment_id]);
        }
    }
    
    public function show_print_label(Request $request){
        if($request->ajax()){
            $id=$request->id;
            $record=DB::table('shipment_info')
                            ->leftJoin( DB::raw('bundle as b'),'b.bundle_set_variation','=','shipment_info.opex_sku')
                            ->leftJoin( DB::raw('product_info_design as c'),'c.variation_design','=','shipment_info.opex_sku')
                            ->where('shipment_info.id',$id)
                            ->first([
                                DB::raw('IF (shipment_info.opex_sku LIKE  "%BUN%",b.bundle_set_variation,c.variation_design)'),
                                'c.product_name',
                                'b.bundle_set_variation',
                                'b.bundle_set_name',
                                'shipment_info.fnsku',
                                'shipment_info.expected_qnt'
                            ]);
            $html='';
            $generator = new \Picqer\Barcode\BarcodeGeneratorPNG();
            for($i=1;$i<=$record->expected_qnt;$i++){
                if($record->bundle_set_variation !=''){
                    $p_name=$record->bundle_set_name;
                }else{
                    $p_name=$record->product_name;
                }
                $html .= '
                    <div style="text-align:center;border:solid 0px;font-family:Calibri;font-weight:600;margin-top:10px;">
                        <div class="text-left product-name" style="background-color: yellow;float:left;padding-left:10px;padding-right:10px;padding-bottom:10px;width:315px !important;">
			                <div style="margin-top:5px;font-weight:bold;margin:5px;">
                    
                                 <img  src="data:image/png;base64,' . base64_encode($generator->getBarcode($record->fnsku, $generator::TYPE_CODE_128, 2,50)) . '" style="width:90%;" />
                           
                                 <br />
                                <span  style="font-size:20px !important;">'.$record->fnsku.'</span>
                                <br />
                                <center>
                                <div  style="font-size: 19px;font-weight:600px;
                    width: 75% !important;
                    text-align: center !important;">'.$p_name.'</div>
                              
                                </div>
                			      </center>
                         </div>
                         
                         </div>
                ';
            }
            
            return response()->json([
                'success'=>true,
                'html' => $html
            ]);
        }
    }
    
    public function bulk_print(Request $request){
        if($request->ajax()){
            $id=$request->array1;
            $records=DB::table('shipment_info')
                            ->leftJoin( DB::raw('bundle as b'),'b.bundle_set_variation','=','shipment_info.opex_sku')
                            ->leftJoin( DB::raw('product_info_design as c'),'c.variation_design','=','shipment_info.opex_sku')
                            ->whereIn('shipment_info.id',$id)
                            ->select([
                                DB::raw('IF (shipment_info.opex_sku LIKE  "%BUN%",b.bundle_set_variation,c.variation_design)'),
                                'c.product_name',
                                'b.bundle_set_variation',
                                'b.bundle_set_name',
                                'shipment_info.fnsku',
                                'shipment_info.expected_qnt'
                            ]);
            $html='';
            $generator = new \Picqer\Barcode\BarcodeGeneratorPNG();
                            
            foreach($records->get() as $row){
                for($i=1;$i<=$row->expected_qnt;$i++){
                    if($row->bundle_set_variation !=''){
                        $p_name=$row->bundle_set_name;
                    }else{
                        $p_name=$row->product_name;
                    }
                    $html .= '
                        <div style="text-align:center;border:solid 0px;font-family:Calibri;font-weight:600;margin-top:10px;">
                            <div class="text-left product-name" style="background-color: yellow;float:left;padding-left:10px;padding-right:10px;padding-bottom:10px;width:315px !important;">
    			                <div style="margin-top:5px;font-weight:bold;margin:5px;">
                        
                                     <img  src="data:image/png;base64,' . base64_encode($generator->getBarcode($row->fnsku, $generator::TYPE_CODE_128, 2,50)) . '" style="width:90%;" />
                               
                                     <br />
                                    <span  style="font-size:20px !important;">'.$row->fnsku.'</span>
                                    <br />
                                    <center>
                                    <div  style="font-size: 19px;font-weight:600px;
                        width: 75% !important;
                        text-align: center !important;">'.$p_name.'</div>
                                  
                                    </div>
                    			      </center>
                             </div>
                             
                             </div>
                    ';
                }
            }
            
            
            
            return response()->json([
                'success'=>true,
                'html' => $html
            ]);
        }
    }
}
