<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use PDF;
use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

use Helper;

class ScoreCardController extends Controller
{
    public $active_store =[1,6,11];
    
    function __construct(){
        $this->middleware(['auth']);
    }

    public function qcScoreCard(Request $request){
        if($request->ajax()){
            // dd($request->all());
            
            $start_date=$request->start_date;
            $end_date=$request->end_date;
            
            $record = DB::table('qc_person as qp')
                        ->leftJoin('qc_check_list as qcl', function($join) use ($start_date, $end_date) {
                            $join->on('qp.id', '=', 'qcl.qc_id')
                                 ->whereRaw('DATE(qcl.qc_date) >= ? AND DATE(qcl.qc_date) <= ?', [$start_date, $end_date]);
                        })
                        ->where('qp.status', '=', 1)
                        ->selectRaw('qp.name as name, IFNULL(SUM(qcl.total_stock), 0) as total_stock')
                        ->groupBy('qp.id')
                        ->get();
                
            $formated=collect($record)->pluck('total_stock','name')->toArray();
            
            $records=DB::select('SELECT 
                    DATE_FORMAT(dr.date, "%d-%m-%Y") as qc_date, 
                    qp.name as name, 
                    qp.id as qc_id,
                    IFNULL(SUM(qcl.ok_stock), 0) as ok_stock,
                    IFNULL(SUM(qcl.alter_stock), 0) as alter_stock,
                    IFNULL(SUM(qcl.total_stock), 0) as total_stock
                FROM 
                    (
                        SELECT start_date + INTERVAL seq DAY AS date
                        FROM (
                            SELECT t0 + t1 * 10 + t2 * 100 AS seq
                            FROM (
                                SELECT 0 AS t0 UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9
                            ) AS t0
                            CROSS JOIN (
                                SELECT 0 AS t1 UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9
                            ) AS t1
                            CROSS JOIN (
                                SELECT 0 AS t2 UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9
                            ) AS t2
                        ) AS seq_nums
                        JOIN (
                            SELECT DATE("'.$start_date.'") AS start_date, DATE("'.$end_date.'") AS end_date
                        ) AS DateRangeParams 
                        ON DATE_ADD(DateRangeParams.start_date, INTERVAL seq DAY) BETWEEN DateRangeParams.start_date AND DateRangeParams.end_date
                    ) AS dr
                LEFT JOIN 
                    qc_person qp ON 1=1 -- We need this to ensure all dates are included
                LEFT JOIN 
                    qc_check_list qcl ON qp.id = qcl.qc_id AND DATE(qcl.qc_date) = dr.date
                WHERE 
                    qp.status = 1
                GROUP BY 
                    dr.date, qp.id
                ORDER BY 
                    dr.date;');
            $formatedN=collect($records)->groupBy('name')->toArray();
        
            
            $data=[
                'totalCount' => $formated,
                'ListTbl' => $formatedN
            ];
            
            return response()->json([
                'code' => '200',
                'list' => $data
            ]);
            
        }else{
            $suppliers=Supplier::latest()->whereNotIn('id',[1,2])->where('status','=',1)->get();
            $qc_person=DB::table('qc_person')->where('status','=',1)->get();
            return view('scorecard.index',['suppliers' => $suppliers,'qc_person' => $qc_person]);
        }
    }
    
    
    public function addQcCheckList(Request $request){
        if($request->ajax()){
            
            $insert=[
                'qc_id' => $request->qc_id,
                'qc_date' => $request->date_picker,
                'qc_type' => $request->qc_type,
                'supplier_id' => ($request->supplier !='')?$request->supplier:0,
                'ok_stock' => $request->ok_stock,
                'alter_stock' => $request->alter_stock,
                'total_stock' => $request->total_stock,
                'created_date' => date('Y-m-d'),
                'created_by' => auth()->user()->id,
                'variation_type' => $request->variation_type
            ]; 
            
            DB::table('qc_check_list')->insert($insert);
            
            return response()->json(['code' => 200,'message' => 'QC CheckList Added Successfully']);
        }
    }
    
    public function getDateData(Request $request){
        if($request->ajax()){
            $date=date('Y-m-d',strtotime($request->qc_date));
            $qc_id=$request->qc_id;
            
            $get=DB::table('qc_check_list')
                ->where([
                    'qc_date' => $date,
                    'qc_id' => $qc_id
                ])->get();
            
            $code=400;
            $data=[];    
            if($get->count()>0){
                $code=200;
                $data=$get;
            }
            
            return response()->json([
                'code' => $code,
                'data' => $data
            ]);
        }
    }
}
