<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use App\Models\Sku;
use App\Mail\SendMail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use PhpOffice\PhpSpreadsheet\Spreadsheet;


class SaleOrderController extends Controller
{
    public function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:sale-orders',['only' => ['index','sale_order']]);
        $this->middleware('permission:approve-sale-orders',['only' => ['sale_select']]);
        $this->middleware('permission:pending-sale-orders',['only' => ['sale_select']]);
    }

    public function send_email(){
        $details = [
            'title' => 'Mail from ItSolutionStuff.com',
            'body' => 'This is for testing email using smtp',
            'url' => 'https://www.itsolutionstuff.com'
        ];

        // Mail::to(['admin@gmail.com','admin2@gmail.com'])->send(new SendMail($details,'Sale Order Uploaded'));
    }

    public function index(Request $request){
        if($request->hasFile('file_upload')){
            // dd($request->all());
            $image = $request->file('file_upload');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/upload_excel');
            $image->move($destinationPath, $name);

            $input = $request->all();

            $insert=[
                'file_name' => $name,
                'orignal_name' => $image->getClientOriginalName(),
                'store_id' =>$input['store_selection'],
                'cargo_select' => $input['cargo_select'],
                'shippment_id' => $input['shippment_id'],
                'comment_box' => $input['comment_box'],
                'created_at' => date('Y-m-d H:i:s'),
                'user_id' =>auth()->user()->id
            ];


            $response=DB::table('sale_orders')->insertGetId($insert);

            $insert_excel=[
                'file_name' => $name,
                'original_name' => $image->getClientOriginalName(),
                'type' => '2',
                'type_name' => 'Sale Order',
                'status' => '1',
                'uploaded_by' => auth()->user()->id,
                'upload_date' => date('Y-m-d')
            ];
            

            $insert_data=DB::table('upload_excel')->insert($insert_excel);

            $extension=$image->getClientOriginalExtension();
 
            if($extension == 'csv'){
                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
            } elseif($extension == 'xlsx') {
                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
            } else {
                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
            }

            $spreadsheet = $reader->load(public_path('/uploads/upload_excel/'.$name));
            $allDataInSheet = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

            // dd($allDataInSheet);

            $arrayCount = count($allDataInSheet);
            $flag = 0;
            $createArray = array('sno', 'sku','order qty');
            $makeArray = array("sno" => "sno ","sku" => "sku","orderqty" => "order qty");
            $SheetDataKey = array();

            foreach ($allDataInSheet as $dataInSheet) {
                foreach ($dataInSheet as $key => $value) {
                    if (in_array(trim($value), $createArray)) {
                        $value = preg_replace('/\s+/', '', $value);
                        $SheetDataKey[trim($value)] = $key;
                    } 
                }
            }
            
            $dataDiff = array_diff_key($makeArray, $SheetDataKey);
            // dd($dataDiff);  

            if (empty($dataDiff)) {
                $flag = 1;
            }
            $fetchData=array();
            $sale_quantity=0;
            $total_item=0;
            if($flag==1){
                for ($i = 2; $i <= $arrayCount; $i++) {
                    $sku = $SheetDataKey['sku'];
                    $sale_order_qty = $SheetDataKey['orderqty'];

                    $sku = filter_var(trim($allDataInSheet[$i][$sku]), FILTER_SANITIZE_STRING);
                    $sale_order_qty = filter_var(trim($allDataInSheet[$i][$sale_order_qty]), FILTER_SANITIZE_STRING);

                    $output = preg_replace( '/[^0-9]/', '', $sale_order_qty );

                    if($output){
                        $sale_quantity+=$sale_order_qty;
                        $total_item++;
                        $insert=[
                            'sale_order_id' => $response,
                            'variation_id' => $sku,
                            'sale_order_qty' => $sale_order_qty,
                            'created_at' => date('Y-m-d H:i:s'),
                            'user_id' =>auth()->user()->id
                        ];
                        $insert_data=DB::table('sale_order_list')->insert($insert);

                        $insert_log=[
                            'variation_id' => $sku,
                            'pr_id' => 0,
                            'given_qty' => $sale_order_qty,
                            'supplier_id' =>0,
                            'user_id' => auth()->user()->id,
                            'type_name' => 'Sale Order Upload',
                            'created_date' => date('Y-m-d H:i:s')
                        ];
                
                        $insert_data=\DB::table('item_log')->insert($insert_log);

                    }
                }
                DB::table('sale_orders')
                        ->where('id', $response)
                        ->update(['total_items' => $total_item,'sale_order_qty' =>$sale_quantity ]);
                $this->send_email();
                return response()->json([
                    'error_msg' => 'SuccessFully Uploaded Excel',
                    'sale_id' => $response,
                    'error' =>0,
                ]);
                

            }else{
                unlink(public_path('uploads/upload_excel/'.$name));
                $id=$response;
                DB::table('sale_orders')->where('id', $id)->delete();
                DB::table('upload_excel')->where('file_name',$name)->delete();

                return response()->json([
                    'error_msg' => 'Please import correct file, did not match excel sheet column',
                    'error' =>1,
                ]);
            }

        }else{
            $stores=DB::table('store')->get();
            return view('sale_order.index',['stores' => $stores]);
        }
        
    }


    public function sale_order(Request $request){
        $id=$request->id;
        $records=DB::table('sale_order_list')
                    ->where('sale_order_list.sale_order_id',$id)
                    ->join('product_info','product_info.variation_id','=','sale_order_list.variation_id')
                    
                    ->select([
                        'sale_order_list.*',
                        'product_info.product_name',
                        'product_info.Quantity',
                        'product_info.prod_img',
                        'product_info.product_url',
                    ]);
        if($request->status !=''){
            $records->where('sale_order_list.status',$request->status);
        }
        return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('product_img',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }
    
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                    <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a><br>
                                </div>
                            </div>
                        ';
                        return $product_detail;
                    })
                    ->addColumn('sale_order_id',function($data){
                        
                        if($data->Quantity<$data->sale_order_qty){
                            $qty='<label class="text-danger">'.$data->sale_order_qty.'</label>
                            <button type="button" class="btn btn-sm btn-info btn_adjust float-right" data-id="'.$data->id.'" data-sale="'.$data->sale_order_qty.'"><i class="fas fa-check"></i></button>';
                        }else{
                            $qty='<label class="text-info">'.$data->sale_order_qty.'</label>' ;
                        }

                        return $qty;
                    })
                    ->rawColumns(['product_img','sale_order_id'])
                    ->make(true);

    }

    public function adjust(Request $request){
        $input=$request->all();
        $data=DB::table('sale_order_list')->where('id',$input['id'])->first();
        $response=DB::table('sale_order_list')
                ->where('id', $input['id'])
                ->update(['sale_order_qty' => $input['quantity']]);
        
        $sale_order_id=$data->sale_order_id;
        $data_sale=DB::table('sale_orders')->where('id',$sale_order_id)->first();
        $sale_qty=(int)($data_sale->sale_order_qty)-((int)$input['sale_order_qty']-(int)$input['quantity']);
        $response=DB::table('sale_orders')
                ->where('id', $sale_order_id)
                ->update(['sale_order_qty' => $sale_qty]);

        if($response){
            $insert=[
                'sale_order_list_id' => $input['id'],
                'sale_order_qty' => $input['sale_order_qty'],
                'sale_adjust_qty' => $input['quantity'],
                'created_at' => date('Y-m-d H:i:s'),
                'user_id' =>auth()->user()->id
            ];
            $insert_data=DB::table('sale_order_adjust')->insert($insert);
            $insert_log=[
                'variation_id' => $data->variation_id,
                'pr_id' => 0,
                'given_qty' => $input['quantity'],
                'supplier_id' =>0,
                'user_id' => auth()->user()->id,
                'type_name' => 'Sale Order Adjust',
                'created_date' => date('Y-m-d H:i:s')
            ];
    
            $insert_data=DB::table('item_log')->insert($insert_log);
            echo $insert_data;
        }
        
    }

    public function update_status(Request $request){
        $input=$request->all();
        $type=$input['type'];
       
        if($type=='1'){
            $data=DB::table('sale_orders')->where('id',$input['id'])->first();
            unlink(public_path('uploads/upload_excel/'.$data->file_name));
            DB::table('sale_order_list')->where('sale_order_id', $input['id'])->delete();
            $d=DB::table('sale_order_list')->where('sale_order_id', $input['id'])->get();
            
            foreach ($d as $sale) {
                $insert_log=[
                    'variation_id' => $sale->variation_id,
                    'pr_id' => 0,
                    'given_qty' => $sale->sale_order_qty,
                    'supplier_id' =>0,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'Sale Order Cancelled',
                    'created_date' => date('Y-m-d H:i:s')
                ];
        
                $insert_data=DB::table('item_log')->insert($insert_log);
            }

            
            echo 1;
        }else if($type=='2'){
            DB::table('sale_orders')->where('id', $input['id'])->update(['status' => '1']);
            DB::table('sale_order_list')->where('sale_order_id', $input['id'])->update(['status' => '1']);
            $d=DB::table('sale_order_list')->where('sale_order_id', $input['id'])->get();
            foreach ($d as $sale) {
                $insert_log=[
                    'variation_id' => $sale->variation_id,
                    'pr_id' => 0,
                    'given_qty' => $sale->sale_order_qty,
                    'supplier_id' =>0,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'Sale Order Approve',
                    'created_date' => date('Y-m-d H:i:s')
                ];
        
                $insert_data=DB::table('item_log')->insert($insert_log);

                $sku=Sku::where('variation_id',$sale->variation_id)->first();

                $qty=(int)$sku->Quantity-(int)$sale->sale_order_qty;
                $sku::where('variation_id',$sale->variation_id)->update([
                    'Quantity' => ($qty<0)?0:$qty
                ]);
            }
            
            echo '1';
        }else if($type=='3'){
            DB::table('sale_orders')->where('id', $input['id'])->update(['status' => '2']);
            DB::table('sale_order_list')->where('sale_order_id', $input['id'])->update(['status' => '2']);
            $d=DB::table('sale_order_list')->where('sale_order_id', $input['id'])->get();
            foreach ($d as $sale) {
                $insert_log=[
                    'variation_id' => $sale->variation_id,
                    'pr_id' => 0,
                    'given_qty' => $sale->sale_order_qty,
                    'supplier_id' =>0,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'Sale Order Pending',
                    'created_date' => date('Y-m-d H:i:s')
                ];
        
                $insert_data=DB::table('item_log')->insert($insert_log);
            }
            echo '1';
        }else if($type=='4'){
            // dd($input['ids']);
            $ids=$input['ids'];
            foreach ($ids as $key => $value) {
                DB::table('sale_orders')->where('id', $value)->update(['status' => '1']);
                DB::table('sale_order_list')->where('sale_order_id', $value)->update(['status' => '1']);
                $d1=DB::table('sale_order_list')->where('sale_order_id', $value)->get();

                foreach ($d1 as $sale) {
                    $insert_log=[
                        'variation_id' => $sale->variation_id,
                        'pr_id' => 0,
                        'given_qty' => $sale->sale_order_qty,
                        'supplier_id' =>0,
                        'user_id' => auth()->user()->id,
                        'type_name' => 'Sale Order Approve',
                        'created_date' => date('Y-m-d H:i:s')
                    ];
            
                    $insert_data=DB::table('item_log')->insert($insert_log);

                    $sku=Sku::where('variation_id',$sale->variation_id)->first();

                    $qty=(int)$sku->Quantity-(int)$sale->sale_order_qty;
                    $sku::where('variation_id',$sale->variation_id)->update([
                        'Quantity' => ($qty<0)?0:$qty
                    ]);
                }
                
            }
            echo '1';
        }
       
    }

    public function sale_select(Request $request,$string){
        if($request->ajax()){
            $records=DB::table('sale_orders')
                        ->join('users','users.id','=','sale_orders.user_id')
                        ->join('store','sale_orders.store_id','=','store.id')
                        
                        ->select(['sale_orders.*','users.name','store.strong_name']);
            if($request->type=='1'){
                $records->where('status','1');
            }else{
                $records->where('status','2');
            }
            return Datatables::of($records)
                            ->addIndexColumn()
                            ->addColumn('checkbox_data',function($data){
                                return '<th><input class="allChecked" type="checkbox" value="'.$data->id.'" data-check="'.$data->id.'" name="checked_id[]" id="allcheck_'.$data->id.'"></th>';
                            })
                            ->addColumn('created_at',function($data){
                                return date('d-m-Y',strtotime($data->created_at));
                            })
                            
                            ->filterColumn('created_at',function($query,$keyword){
                                $keyword=date('Y-m-d',strtotime($keyword));
                                $query->orWhereRaw("sale_orders.created_at LIKE ?", ["%{$keyword}%"]);
                            })
                           
                            ->orderColumn('created_at', function ($query, $order) {
                                $query->orderBy('sale_orders.created_at', $order);
                            })
                            ->addColumn('cargo_selection',function($data){
                                if($data->cargo_select=='1'){
                                    $label='<label class="badge badge-success">Air Cargo</label>';
                                }else if($data->cargo_select=='2'){
                                    $label='<label class="badge badge-success">Ship Cargo</label>';
                                }
                                return $label;
                            })
                            ->filterColumn('cargo_selection',function($query,$keyword){
                                $cargo=['air','Air','Air Cargo','AirCargo','aircargo','ship','Ship','Ship Cargo','ShipCargo','shipcargo','cargo','Cargo'];
                                $air=['air','Air','Air Cargo','AirCargo','aircargo'];
                                $ship=['ship','Ship','Ship Cargo','ShipCargo','shipcargo'];
                                if(in_array($keyword,$cargo)){
                                    if(in_array($keyword,$air)){
                                        $keyword='1';
                                        $query->orWhereRaw("sale_orders.cargo_select LIKE ?", ["%{$keyword}%"]);

                                    }else if(in_array($keyword,$ship)){
                                        $keyword='2';
                                        $query->orWhereRaw("sale_orders.cargo_select LIKE ?", ["%{$keyword}%"]);

                                    }else{
                                        $keyword='1';
                                        $query->orWhereRaw("sale_orders.cargo_select LIKE ?", ["%{$keyword}%"]);
                                        $keyword='2';
                                        $query->orWhereRaw("sale_orders.cargo_select LIKE ?", ["%{$keyword}%"]);
                                    }
                                }
                            })
                           
                            ->orderColumn('cargo_selection', function ($query, $order) {
                                $query->orderBy('sale_orders.cargo_select', $order);
                            })
                            ->addColumn('action',function($data){
                                $button='
                                <a class="btn btn-sm btn-primary download_btn" id="download_'.$data->id.'" href="'.asset('uploads/upload_excel/'.$data->file_name).'" download ="'.$data->orignal_name.'"><i class="fas fa-download"></i> Download</a>';
                                return $button;
                            })
                            ->rawColumns(['created_at','action','cargo_selection','checkbox_data'])
                            ->make(true);

        }else{
            if(in_array($string,['approve','pending']) ){
                return view('sale_order.approve',['sale_string' => $string]);
            }else{
                return abort(404);
            }
        }
    }
}
