<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \DB;
use Illuminate\Support\Facades\Blade;

use App\Helpers\ReportHelper;
use DataTables;


class ReturnController extends Controller
{

    public function __construct(){
        $this->middleware('auth')->except(['Test']);
    }

    public function index(Request $request){
        $login_id=auth()->user();
        $path_new = storage_path() . "/data_reports/skuanalytics_".$login_id->id.".json";


       if($request->ajax()){
            $start_date=$request->start_date;
            $end_date=$request->end_date;

            if($request->child_sku !=''){
               $child=1;
            }else{
               $child=0;
            }


            $data=[
                'start_date' => $start_date,
                'end_date' => $end_date,
                'child' => $child
            ];

            $swr=$this->store_wise_req($data);
            $data['swr'] = $swr;
            $json_encode = json_encode($data);
            file_put_contents($path_new,$json_encode);

            return response()->json(['code' => '200']);
        }else{
            $data  = [];
            $json_encode = json_encode($data);
            file_put_contents($path_new,$json_encode);

            return view('datareports.returnDashboard');
        }

    }

    public function ajax_datatable(Request $request){
        if($request->ajax()){
            $child_sku_check=$request->child_sku;
            $opex_url=env('OPEX_URL');
            $login_id=auth()->user();




            $path_new = storage_path() . "/data_reports/skuanalytics_".$login_id->id.".json";
	        $jsonData = file_get_contents($path_new);
            $dataSale = json_decode($jsonData, true);

            if(!$dataSale || !isset($dataSale['swr'])) {
                return DataTables::of([])->make(true);
            }

            return Datatables::of($dataSale['swr']['data'])
                ->addIndexColumn()
                ->addColumn('action', function ($row) {
                    return '<button class="btn btn-primary btn-sm viewReturnSku" data-sku="'.$row['sku'].'" data-title="'.$row['product_title'].'">View Comments</button>';
                })
                ->rawColumns(['action'])
                ->with([
                    'totalSale' => $dataSale['swr']['totalSale'],
                    'totalFull' => $dataSale['swr']['totalFull'],
                    'percentage' => $dataSale['swr']['percentage'],
                    'totalOverAllSale' => $dataSale['swr']['totalOverAllSale'],
                    'totalOverAllReturn' => $dataSale['swr']['totalOverAllReturn'],
                    'overAllPercentage' => $dataSale['swr']['overAllPercentage'],
                    'oPercentage' => $dataSale['swr']['oPercentage']
                ])->make(true);
        }
    }
    
    
    
    public function get_sku_detail($child){
        $where_single = 'is_deleted = 0 AND prod_status = 1';
        $where_bundle = 'is_deleted = 0 AND status = 1';

        // Prepare base queries
        $results_single = DB::table('product_info_design')
            ->selectRaw('group_id, variation_design, product_name,occasion_status')
            ->whereRaw($where_single);
        
        $results_bundle = DB::table('bundle')
            ->selectRaw('bundle_group as group_id, bundle_set_variation as variation_design, bundle_name as product_name,occasion_status')
            ->whereRaw($where_bundle);
        
        // Apply groupBy if needed
        if ($child == '0') {
            $results_single->groupBy(['group_id', 'prod_design']);
            $results_bundle->groupBy('group_id');
        }

        // Merge both queries
        $results = $results_single->union($results_bundle)->get();

        // Now map and pluck efficiently
        $skuDetail = collect($results)->mapWithKeys(function ($sku) use ($child) {
            if ($child == '0') {
                $variationParts = explode('-', $sku->variation_design, 2);
                $suffix = isset($variationParts[1]) ? '-' . $variationParts[1] : '';
                $group_design = $suffix ? $sku->group_id . $suffix : $sku->group_id;
        
                $product_name = explode(',', $sku->product_name, 2)[0];
            } else {
                $group_design = $sku->variation_design;
                $product_name = $sku->product_name;
            }
        
            return [
                $group_design => [
                    'sku' => $group_design,
                    'product_name' => $product_name,
                    'occasion_status' => $sku->occasion_status
                ]
            ];
        })->toArray();
        
        return $skuDetail;
    }
    public function store_wise_req($data){
        extract($data);
        
        $totalSale = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,[],$child,4);
        $totalRefund = ReportHelper::AmazonReturns('amazon_return_report_decrum', $start_date, $end_date, $child,4);
        $skuDetail = $this->get_sku_detail($child);
        
        $data_danger=$data_warning=$data_normal=[];
        
        $totalSaleN=0;
        $totalFull=0;
        // dd($skuDetail);
        foreach($totalRefund as $key => $list){
            // dd($list);
            
            $l= (array)$list;
            $sku = $l['sku'];
            $total_full =$l['total_returns'];
            
            $total_sale=0;
            if(isset($totalSale[$sku])){
                $ts=(array)$totalSale[$sku];
                $total_sale=$ts['total_sale'];
            }
            $product_title='NF';
            
            // dd($skuDetail[$sku]);
            
            $occasion_status=0;
            if(isset($skuDetail[$sku])){
                $product_title=$skuDetail[$sku]['product_name'];
                $occasion_status=$skuDetail[$sku]['occasion_status'];
            }

            $fr_per=($total_sale !=0)?round($total_full*100/$total_sale):0;

            //added by sufian 27-5-25
            $higher_refund=0;
            if($fr_per >20 && $total_sale > 10){
                $higher_refund=2;//danger
            }else if(($fr_per > 15 && $fr_per < 20 ) && $total_sale > 10){
                $higher_refund=1; // yellow
            }
            
            $data = [
                'sku' => $sku,
                'product_title' => $product_title,
                'total_sale' => $total_sale,
                'total_full' => $total_full,
                'fr_per' => $fr_per,
                'higher_refund' => $higher_refund,
            ];

            switch ($higher_refund) {
                case 2:
                    $data_danger[] = $data;
                    break;
                case 1:
                    $data_warning[] = $data;
                    break;
                default:
                    $data_normal[] = $data;
                    break;
            }
            
            $totalSaleN+=$total_sale;
            $totalFull+=$total_full;
        }

        $percentage = 0;
        if($totalSaleN > 0){
            $percentage = round($totalFull * 100 / $totalSaleN, 2);
        }

        $data = array_merge($data_danger, $data_warning, $data_normal);
        
        $totalOverAllSale = ReportHelper::AmazonTotalOrders("amazon_order_report_decrum", $start_date,$end_date,[],4);
        $totalOverAllReturn = ReportHelper::AmazonTotalReturns("amazon_return_report_decrum", $start_date,$end_date,4);
        
        $overAllPercentage=($totalOverAllSale !=0)?round($totalOverAllReturn*100/$totalOverAllSale):0;
        
        // dd($totalOverAllSale,$totalOverAllReturn);
        
        return [
            'totalSale' => $totalSaleN,
            'totalFull' => $totalFull,
            'percentage' => $percentage,
            'data' => $data,
            'totalOverAllSale' => $totalOverAllSale,
            'totalOverAllReturn' => $totalOverAllReturn,
            'overAllPercentage' => $overAllPercentage,
            'oPercentage' => $totalOverAllSale.' / '.$totalOverAllReturn.' / '.$overAllPercentage.'%'
        ];

    }
    
    public function update_action_status(Request $request){
        if($request->ajax()){
            $array=$request->array;

            $actionCases = '';
            $dateCases = '';
            $userCases = '';
            $ids = [];

            foreach ($array as $update) {
                $id = $update['id'];
                $price = $update['action_status'];
                $date = "'" . now() . "'"; // manually quoting date
                $user = auth()->user()->id; // assuming you want to set the current user's ID

                $actionCases .= "WHEN id = {$id} THEN {$price} ";
                $dateCases .= "WHEN id = {$id} THEN {$date} ";
                $userCases .= "WHEN id = {$id} THEN {$user} ";

                $ids[] = $id;
            }

            $ids = implode(',', $ids);

            $sql = "
                UPDATE loop_return_entry
                SET
                    action_status = CASE {$actionCases} END,
                    action_date = CASE {$dateCases} END,
                    action_updated_by = CASE {$userCases} END
                WHERE id IN ({$ids})
            ";

            // dd($sql);

            DB::statement($sql);


            return response()->json(['code' => '200','message' => 'Action updated successfully']);
        }
    }


}

?>
