<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class ReportInventoryController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:upload-reports');
    }
    
    public function index(Request $request){
        if($request->isMethod('post')){
            if($request->hasFile('file_upload')){
                $input = $request->all();
                
                $image = $request->file('file_upload');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/txt_upload');
                $image->move($destinationPath, $name);
                
                $insert=[
                    'file_name' => $name,
                    'original_name' => $image->getClientOriginalName(),
                    'report_type' =>$input['report_type'],
                    'store_id' => $input['store_selection'],
                    'created_date' => date('Y-m-d H:i:s'),
                    'user_id' =>28,
                ];
                
                $file_id=DB::table('report_inventory_upload')->insertGetId($insert);
                
                $res=$this->import_txt($name,$file_id,$input['report_type'],$input['store_selection']);
                
                if($res){
                   return response()->json([
                        'error' => '0',
                        'msg' => 'Record Successfully Uploaded'
                    ]); 
                }else{
                    return response()->json([
                        'error' => '1',
                        'msg' => 'Error in Uploading'
                    ]);
                }
                
                
                
            }
        }else{
            $stores=DB::table('store')->whereIn('id',[1,4])->get();
            return view('report_inventory.index',['stores'=> $stores]);
        }
    }
    
    public function import_txt($file_name='',$file_id='',$type_one,$store_id){
        $conents_arr   = file(asset('/uploads/txt_upload/'.$file_name),FILE_IGNORE_NEW_LINES);//$file_name
        $conents_arr[array_key_first($conents_arr)]=rtrim(rtrim($conents_arr[array_key_first($conents_arr)], "\r"),"\t");
        
        // dd($conents_arr[array_key_first($conents_arr)]);
        // $type_one=2;
        // $store_id=1;
        if($type_one =='1'){
            $findValKeys=array(
                'amazon-order-id',
                "purchase-date",
                "order-status",
                "product-name",
                "sku","asin",
                "item-status",
                "quantity",
                "item-price",
                "fulfillment-channel",
                "sales-channel",
                "merchant-order-id",
                "currency",
                "shipping-price",
            );
        }else if($type_one =='2'){
            $findValKeys=array(
                "sku",
                "fnsku",	
                "asin",
                "product-name",
                "condition",
                "your-price",
                "mfn-listing-exists",
                "mfn-fulfillable-quantity",	
                "afn-listing-exists",
                "afn-warehouse-quantity",	
                "afn-fulfillable-quantity",	
                "afn-unsellable-quantity",	
                "afn-reserved-quantity",
                "afn-total-quantity",
                "per-unit-volume",
                "afn-inbound-working-quantity",
                "afn-inbound-shipped-quantity",
                "afn-inbound-receiving-quantity",	
                "afn-researching-quantity",
                "afn-reserved-future-supply",	
                "afn-future-supply-buyable"
            );
        }else if($type_one =='3'){
            $findValKeys=array(
                "sku",
                "fnsku",
                "asin",
                "product-name",
                "reserved_qty",
                "reserved_customerorders",
                "reserved_fc-transfers",
                "reserved_fc-processing",
            );
        }
        
        if($store_id=='1'){
            $store_data=[
                'decrum_instock' => 0,
                'decrum_inbound' => 0,
            ];
        }else if($store_id=='4'){
            $store_data=[
                'axfashion_instock' => 0,
                'axfashion_inbound' => 0
            ];
        }
        
        $arrIndex=$this->findIndex($findValKeys,explode("	",$conents_arr[array_key_first($conents_arr)]));
        
        // dd($arrIndex);
        
        DB::table('product_info_design')->update($store_data);
        DB::table('fba_inventory_report')->where('store_id',$store_id)->delete();
        $jsonArr=array();
        // $asins=DB::table('product_info_design')->pluck('prod_asin')->all();
        $variation_design=DB::table('product_info_design')->pluck('variation_design')->all();
        
        if($type_one =='1'){
            if($store_id=='1'){
                $tbl="amazon_order_report_decrum";
            }else if($store_id =='4'){
                $tbl="amazon_order_report_axfashion";
            }
            $now_date = date('Y-m-d H:i:s');
            
            
            foreach($conents_arr as $key=>$row){
                $code = json_encode(utf8_encode($row), true);
            	$exp = str_replace('"','',$code);
            	$expp = explode('\n',$exp);
            	$data = explode('\t',$expp[0]);
            	
            	$product_name=(isset($data[10])) ? $data[10] : 0;
            	$amazon_order_id=(isset($data[0])) ? $data[0] : 0;
            	
            	$order_status=(isset($data[4])) ? $data[4] : 0;
            	$sales_channel=(isset($data[6])) ? $data[6] : 0;
            	
            // 	$arrList['order_status'] !='Cancelled' && $arrList['sales_channel'] !="Amazon.ca" && $arrList['sales_channel'] !="Amazon.com.mx" && $arrList['sales_channel'] !="Amazon.com.mx" &&$arrList['sales_channel'] !="Non-Amazon" && !strpos($arrList['product_name'], '[1')
            	
            	$check=\DB::table($tbl)->where('amazon_order_id',$amazon_order_id)->get();
            	
            	if($check->count()==0){
            	    $opex_sku=trim($product_name);
                    preg_match('#\[(.*?)\]#', $opex_sku, $match);
                    $opex_sku=(isset($match[1]))?$match[1]:'';
                    
                    if(isset($match[1])){
                        $start_number=$opex_sku[0];
                        if($start_number =='4' && $order_status !='Cancelled' && $sales_channel !="Amazon.ca" && $sales_channel !="Amazon.com.mx" && $sales_channel !="Non-Amazon"){
                            $variation_design=$opex_sku;
                            $exp=explode('-',$variation_design);
                            $variation_id=$exp[0];
                            $group_id=substr( $variation_id, 0, -1);
                        
                            $data_for_insert= [
                                'amazon_order_id'=>(isset($data[0])) ? $data[0] : 0,
                                'merchant_order_id'=>(isset($data[1])) ? $data[1] : 0 ,
                                'purchase_date'=>(isset($data[2])) ? $data[2] : 0 ,
                                'order_status'=>(isset($data[4])) ? $data[4] : 0 ,
                                'fulfillment_channel'=>(isset($data[5])) ? $data[5] : 0,
                                'sales_channel'=>(isset($data[6])) ? $data[6] : 0,
                                'product_name'=>(isset($data[10])) ? $data[10] : 0,
                                'sku'=>(isset($data[11])) ? $data[11] : 0,
                                'asin'=>(isset($data[12])) ? $data[12] : 0,
                                'item_status'=>(isset($data[13])) ? $data[13] : 0,
                                'quantity'=>(isset($data[14])) ? $data[14] : 0,
                                'currency'=>(isset($data[15])) ? $data[15] : 0,
                                'item_price'=>(isset($data[16])) ? $data[16] : 0,
                                'shipping_price'=>(isset($data[18])) ? $data[18] : 0,
                                'variation_design' => $opex_sku,
                                'variation_id' => $variation_id,
                                'created_at'=>$now_date,
                                'created_by'=>auth()->user()->id,
                                'group_id' => $group_id,
                                'file_id' => $file_id
                            ];
                            
                            $res=\DB::table($tbl)->insert($data_for_insert);
                        }
                    }
                }
            }
            
        }else if($type_one =='2'){
            foreach($conents_arr as $key=>$value){
                if ($key !== 0) {
                    $conents_arr[$key]  = rtrim($value, "\r");
                    $arr=explode("	",$conents_arr[$key]);
                    $new=$this->IndexVal($arrIndex,$arr,explode("	",$conents_arr[array_key_first($conents_arr)]),$type_one);
                    
                    $opex_sku=trim($new['product_name']);
                    preg_match('#\[(.*?)\]#', $opex_sku, $match);
                    $opex_sku=(isset($match[1]))?$match[1]:'';
                    if(!isset($match[1])){
                        continue;
                    }
                    // in_array($new['asin'],$asins)
                    if(in_array($opex_sku,$variation_design)){
                        //in_array($opex_sku,$variation_design);
                        $new['created_date'] = date('Y-m-d H:i:s');
                        $new['file_id'] = 1;
                        $new['store_id']= $store_id;
                        if($store_id=='1'){
                            $store_update=[
                                'decrum_instock' => (int)$new['afn_fulfillable_quantity'],
                                'decrum_inbound' => (int)$new['afn_inbound_working_quantity'] + (int)$new['afn_inbound_shipped_quantity'],
                            ];
                        }else if($store_id=='4'){
                            $store_update=[
                                'axfashion_instock' => (int)$new['afn_fulfillable_quantity'],
                                'axfashion_inbound' => (int)$new['afn_inbound_working_quantity'] + (int)$new['afn_inbound_shipped_quantity']
                            ];
                        }
                        DB::table('product_info_design')->where('prod_asin',$new['asin'])->update($store_update);
                        // DB::table('product_info_design')->where('variation_design',$opex_sku)->update($store_update);
                        $res=DB::table('fba_inventory_report')->insert($new);
                    }
                    
                }    
            }
        }
        
        
        if($res){
            return $res;   
        }
    }
    
    public function findIndex($findValkeys,$arr){
        $arrList=array();
        foreach ($findValkeys as $key => $value) {
            $arrList[] = array_search($value,array_values($arr));
        }
        return $arrList;
    }
    
    public function IndexVal($indexs,$arr,$arr0,$order){
        $arrList=array();
        foreach ($indexs as $key => $value) {
            $arrList[str_replace('-','_',$arr0[$value])]=$arr[$value];
        }

        if($order ==1){
            if($arrList['order_status'] !='Cancelled' && $arrList['sales_channel'] !="Amazon.ca" && $arrList['sales_channel'] !="Amazon.com.mx" && $arrList['sales_channel'] !="Amazon.com.mx" &&$arrList['sales_channel'] !="Non-Amazon" && !strpos($arrList['product_name'], '[1')){
                return $arrList;
            }else{
                return array();
            }
        }else{
            return $arrList;
        }    
    }
    
    public function report_list(Request $request){
        if($request->ajax()){
            $records=DB::table('report_inventory_upload')
                            ->join('store','store.id','=','report_inventory_upload.store_id')
                            ->join('users','users.id','=','report_inventory_upload.user_id')
                            ->select(['report_inventory_upload.*','store.strong_name','users.name']);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('action',function($data){
                        $product_detail='<a  class="btn btn-primary btn-sm" href="'.asset('uploads/txt_upload/'.$data->file_name).'" download="'.$data->original_name.'">
                            <i class="fas fa-download"></i> Download
                        </a>';
                        return $product_detail;
                    })
                    ->addColumn('created_at',function ($data){
                    $created='<span>'.date('d-m-Y', strtotime($data->created_date)).'</span>';
                    return $created;
                })
                    ->rawColumns(['action','created_at'])
                    ->make(true);
        }
    }
}

