<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Models\Sku;
use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

use Helper;

class RawController extends Controller
{
    function __construct(){
        
        $this->middleware(['auth']);
    }
    
    public function add_sku(Request $request){
        if($request->ajax()){
            $product_name = $request->product_name;
            $category =$request->category;
            $unit =$request->unit;
            $quantity=$request->quantity;
    
           
            
            $cexplode=explode('-',$category);
            $cat_id=$cexplode[0];
            $cat_name=$cexplode[1];
            
            $uexplode=explode('-',$unit);
            $unit_id=$uexplode[0];
            $unit_name=$uexplode[1];
            
             $lastOrderId=DB::table('raw_sku_list')->max('id');
            
            $prefix = '0000';
		    $pid=$lastOrderId+1;
		    $pd = sprintf( '%04d', ($prefix + $pid) );
		    
		    $sku='4RAW'.$cat_id.$unit_id.$pd;
		    $image_url='';
		    
		    if ($request->hasFile('file_img')) {
                $image = $request->file('file_img');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/upload_raw');
                $image->move($destinationPath, $name);
                $image_url='uploads/upload_raw/'.$name;
            }
            
            $insert=[
                'raw_sku' => $sku,
                'raw_name' => $product_name,
                'raw_image' => $image_url,
                'raw_unit_id' => $unit_id,
                'raw_unit_name' => $unit_name,
                'quantity' => $quantity,
                'raw_category_id' => $cat_id,
                'raw_category_name' => $cat_name,
                'created_date' => date('Y-m-d H:i:s'),
                'created_by' => auth()->user()->id
            ];
            
            DB::table('raw_sku_list')->insert($insert);
		    
		    return response()->json([
		        'code' => 200,
		        'message' => 'Add Raw SKU Successfully'
		    ]);
            
            
            
        }else{
            $units=DB::table('raw_unit')->where('status','=',1)->get();
            $categories=DB::table('raw_category')->where('status','=',1)->get();
            return view('raw.add_sku',['units' => $units, 'categories' => $categories]);
        }
    }
    
    public function add_unit_category(Request $request){
        if($request->ajax()){
            $name=$request->name;
            $table_name = $request->table_name;
            
            $insert=[
                $table_name => $name,
                'status' => 1,
                'created_date' => date('Y-m-d H:i:s'),
                'created_by' => auth()->user()->id
            ];
            
            $cat_id=DB::table($table_name)->insertGetId($insert);
            
            $result=DB::table($table_name)->where('status','=',1)->get();
            
            $html='<option value="">Please select</option>';
            if($result->count()>0){
                foreach($result as $r){
                    $selected ='';
                    
                    if($r->id == $cat_id){
                        $selected='selected';
                    }
                    $html.='<option value="'.$r->id.'-'.$r->{$table_name}.'" '.$selected.'>'.$r->{$table_name}.'</option>';
                }
            }
            
            return response()->json([
                'code' => 200,
                'html' => $html
            ]);
            
            // dd($insert);
        }
    }
    
    
    public function raw_list(Request $request){
        if($request->ajax()){
            $result=DB::table('raw_sku_list')->where('is_deleted',0)->orderByDesc('created_date');
            
            if($request->unit !=''){
                $result->where('raw_unit_id',$request->unit);
            }

            if($request->category !=''){
                $result->where('raw_category_id',$request->category);
            }
            
            return Datatables::of($result)
                ->addIndexColumn()
                ->addColumn('ProductImg',function ($data){
                    $url=asset($data->raw_image);
                    $img='<img src="'.$url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                    
                    $product_detail='
                        <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                            '.$img.'
                        </a>';

                    return $product_detail;
                })
                ->addColumn('action',function ($data){
                    $delete_option=$edit_option='';
                    
                    if(auth()->user()->can('raw-sku-delete')){
                        $delete_option = '<option value="delete">&#128465; Delete Raw SKU</option>';
                    }
                    
                    if(auth()->user()->can('add-raw-sku')){
                        $edit_option = '<option value="edit">&#9998; Edit Raw SKU</option>';
                    }
                    
                    if($delete_option !='' || $edit_option !=''){
                        $options='<select name="options" id="options_'.$data->id.'" class="form-control options" onchange="get_options('.$data->id.')">
                        <option value="">&#xf245; Please select</option>
                        '.$edit_option.'
                        '.$delete_option.'
                        </select>';
                    }else{
                        $options='';
                    }
                    
                    
                    
                    return $options;
                    
                     
                })
                ->rawColumns(['ProductImg','action'])
                ->make(true);
        }else{
            $units=DB::table('raw_unit')->where('status','=',1)->get();
            $categories=DB::table('raw_category')->where('status','=',1)->get();
            return view('raw.index',['units' => $units, 'categories' => $categories]);
        }
    }
    
    public function editRawSku($id){
        $query = DB::table('raw_sku_list')->where('id',$id)->get();
        
        if($query->count() > 0){
            $row = $query->first();
            
            return response()->json([
                'status' => true,
                'data' => $row
            ]);
        }
        else{
            return response()->json([
                'status' => true,
                'data' => ''
            ]);
        }
    }
    
    public function updateRawSku(Request $request){
        $query = DB::table('raw_sku_list')->where('id',$request->raw_sku_id)->first();
        
        $category =$request->category;
        $unit =$request->unit;
        
        $cexplode=explode('-',$category);
        $cat_id=$cexplode[0];
        $cat_name=$cexplode[1];
            
        $uexplode=explode('-',$unit);
        $unit_id=$uexplode[0];
        $unit_name=$uexplode[1];
        
        if ($request->hasFile('file_img')) {
                $image = $request->file('file_img');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/upload_raw');
                $image->move($destinationPath, $name);
                $image_url='uploads/upload_raw/'.$name;
        }
        
        
        $update = [
            'raw_name'=> $request->product_name,
            'raw_unit_id'=> $unit_id,
            'raw_unit_name'=>$unit_name,
            'raw_category_id'=>$cat_id,
            'raw_category_name'=>$cat_name,
            'raw_image' => $image_url ?? $query->raw_image
        ];
        
        if($request->quantity !=''){
            $update['quantity'] = $request->quantity;
            
            
            $log_detail= 'Inventory Update <strong> old stock : "'.$query->quantity.'"  =>  New Stock: "'.$request->quantity.'"</strong> From Raw SKU List Page';
            
            $insert_log=[
                'variation_id' => $query->raw_sku,
                'pr_id' => 'RawSKUQuantityUpdate',
                'given_qty' => $request->quantity,
                'supplier_id' =>0,
                'user_id' => auth()->user()->id,
                'type_name' => $log_detail,
                'created_date' => date('Y-m-d H:i:s')
            ];
    
            $insert_data=DB::table('item_log')->insert($insert_log);
        }
        
        
        DB::table('raw_sku_list')->where('id',$request->raw_sku_id)->update($update);
        
        return response()->json([
                'status' => true,
        ]);
    }
    
    public function deleteRawSku($id){
        $query = DB::table('raw_sku_list')->where('id',$id)->get();
        
        if($query->count() > 0){
            
            $first=$query->first();
            
            DB::table('raw_sku_list')->where('id',$id)->update([
                'is_deleted' => 1
            ]);
            
            $log_detail= 'Raw SKU <strong>'.$first->raw_sku.'</strong> was deleted From Raw SKU List Page';
            
            $insert_log=[
                'variation_id' => $first->raw_sku,
                'pr_id' => 'RawSKUQuantityUpdate',
                'given_qty' => 0,
                'supplier_id' =>0,
                'user_id' => auth()->user()->id,
                'type_name' => $log_detail,
                'created_date' => date('Y-m-d H:i:s')
            ];
    
            $insert_data=DB::table('item_log')->insert($insert_log);
            
            return response()->json([
                'status' => true,
            ]);
        }
    }
    
    public function checkType(Request $request,$string){
        if($request->ajax()){
            // dd($request->all());
            
            $supplier_id=$request->supplier;
            
            $st='CHKIN';
            $type=1;
            if($string=='checkOut'){
                $st='CHKOUT';
                $type=2;
            }
            
            $po_serial=Helper::get_sup_po_no($supplier_id);
            $pr_id_other=date('dmy').$st;
            $po_id=$pr_id_other.'-'.$po_serial;
            
            // dd($po_id);
            $narr=[];
            foreach ($request->sku as $key => $value) {
                $chk=DB::table('raw_sku_list')->where('raw_sku','=',$value)->first();
                
                if($chk){
                    $qty=$chk->quantity;
                    if($type ==1){
                       $qty=$qty + $request->quantity[$key];
                       
                    }else{
                        $qty=$qty - $request->quantity[$key];
                    }
                    
                    DB::table('raw_sku_list')->where('raw_sku','=',$value)->update(['quantity' => ($qty>0)?$qty:0]);
                }
                
                $insert=[
                    'raw_sku' => $value,
                    'given_qty' => $request->quantity[$key],
                    'supplier_id' => $supplier_id,
                    'type' => $type,
                    'assign_date' => date('Y-m-d H:i:s'),
                    'assign_id' => $po_id,
                    'status' => 1,
                    'assign_by' => auth()->user()->id
                ]; 
                
                $narr[]=$insert;
            }
            
            DB::table('assign_quantity_raw')->insert($narr);
            
            return response()->json([
                'code' => 200,
                'message' => 'Assign Quantity Successfully'
            ]);
        }else{
            if(in_array($string,['checkIn','checkOut'])){
                $units=DB::table('raw_unit')->where('status','=',1)->get();
                $categories=DB::table('raw_category')->where('status','=',1)->get();
                $suppliers=Supplier::latest()->whereNotIn('id',[1,2])->where('status','=',1)->where('type','like','%2%')->get();
                return view('raw.raw_check',['units' => $units, 'categories' => $categories,'suppliers' => $suppliers,'string'=>$string]); 
            }else{
                return abort(404);
            }
            
            
        }
    }
    
    public function sku_list(Request $request){
        if ($request->ajax() ){//&& $request->input("search") !=''
            $page = $request->input('page');
            $string = $request->input('string');
            $resultCount = 10;
            $offset = ($page - 1) * $resultCount;
            
            $search=trim($request->input("search"));

            $breeds=DB::table('raw_sku_list')->whereRaw('(LOWER(raw_name) LIKE "%'.$search.'%"  OR raw_sku LIKE "%'.$search.'%")')->orderBy('raw_sku');
                        
            if($string =='checkOut'){
                $breeds->where('quantity','!=',0);
            }
                        
            $count=$breeds->get()->count();
            
            $skuList=$breeds->skip($offset)->take($resultCount)->selectRaw('raw_sku as id,raw_name,raw_image,quantity,raw_unit_name')->where('is_deleted','=',0)->get();

            $endCount = $offset + $resultCount;
            $morePages = $count>$endCount;
            // dd($endCount > $count);
            $results = [
                "results" => $skuList,
                "pagination" => [
                    "more" => $morePages
                ]
            ];

            return response()->json($results);
        }

    }
    
    public function index(){
        
    }

    public function gatepass(Request $request){
        if($request->ajax()){
            $input=$request->all();
            $supplier_id=$input['supplier_id'];
            $start_date=date('Y-m-d',strtotime($input['start_date']));
            $end_date=date('Y-m-d',strtotime($input['end_date']));
            
            $records=DB::table('assign_quantity_raw')->where('supplier_id',$supplier_id)
            ->where(DB::raw('DATE(assign_quantity_raw.assign_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(assign_quantity_raw.assign_date)'),'<=',$end_date)
            ->groupBy('assign_id')
            ->select([
                'assign_quantity_raw.*',
            ]);
            
            if(empty($request->input('search.value'))){
                if($request->type !=''){
                    $records->where('type',$request->type);
                }
            }else{
                $search=trim($request->input('search.value'));
                $records->whereRaw('assign_id LIKE "%'.$search.'%"');
            }
            
            $suppliers=Supplier::latest()->where('id','!=','1')->where('id','!=','2')->get()->pluck('supplier_name','id')->toArray();
            // dd($suppliers);
            
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('assign_date',function($data){
                    $assign_date=date('d-m-y H:i:s A',strtotime($data->assign_date));
                    return $assign_date;
                })
                ->addColumn('supplier_name',function ($data) use(&$suppliers){
                   $sup=isset($suppliers[$data->supplier_id])?$suppliers[$data->supplier_id]:'NF';
                    return $sup;
                })
                
                ->addColumn('type_name',function ($data){
                   $sup=($data->type ==1)?'Check In': 'Check Out';
                    return $sup;
                })
                ->addColumn('action',function ($data){
                   $sup='<a href="javascript:;" data-assign_id="'.$data->assign_id.'" data-supplier_id="'.$data->supplier_id.'" data-type="'.$data->type.'" class="btn btn-sm btn-info viewgatePass"/>view</a>';
                    return $sup;
                })
                
                
                ->rawColumns(['supplier_name','assign_date','type_name','action'])
                ->make(true);
            
        }else{
            $suppliers=Supplier::latest()->whereNotIn('id',[1,2])->where('status','=','1')->where('type','LIKE','%2%')->get();
            return view('raw.gatepass',['suppliers' => $suppliers]);
        }
    }
    
    public function make_gate_pass_pdf(Request $request){
        $input=$request->all();
        $assign_id=$input['assign_id'];
        $supplier_id=$input['supplier_id'];
        $type=$input['type'];
        
        
        if($supplier_id !=''){
            $supplier_data=Supplier::where('id' , $supplier_id)->first('supplier_name');
            $supplier_name=$supplier_data->supplier_name;
        }
        
        $type=($type ==1)?'Check In': 'Check Out';
        
        $records=DB::table('assign_quantity_raw')->where('assign_quantity_raw.assign_id',$assign_id)
            ->join('raw_sku_list','raw_sku_list.raw_sku','=','assign_quantity_raw.raw_sku')
            ->select([
                'assign_quantity_raw.assign_id',
                'assign_quantity_raw.raw_sku',
                'raw_sku_list.raw_name',
                'assign_quantity_raw.given_qty',
                'raw_sku_list.raw_unit_name',
                'assign_quantity_raw.assign_date',
            ])->orderBy('assign_quantity_raw.id','desc');
            
        
            
        
            $html=view('pdf.raw_gatepass',[
                'records' => $records->get(),
                'supplier_name' => $supplier_name,
                'assign_id' => $assign_id,
                'type' => $type
            ])->render();
            
            return response()->json(['success' => 1,'html' => $html]);
            
        
            
        
    }

    
}
