<?php

namespace App\Http\Controllers\Admin;
use PDF;
use DataTables;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class ProcessOrderController extends Controller
{
    public function __construct(){
        $this->middleware(['auth']);
    }
    
    public function index(Request $request){
        if($request->ajax()){
            
            
            $records=DB::table('process_order_quantity')
                        ->groupBy('process_order_quantity.variation_design','process_order_quantity.store_id','process_order_quantity.shipment_type')
                        ->join('product_info_design','product_info_design.variation_design','=','process_order_quantity.variation_design')
                        ->join('product_info','product_info.variation_id','=','process_order_quantity.variation_id')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.variation_design','ASC')
                        ->orderBy('product_info_design.prod_size','ASC')
                        ->orderBy('product_info_design.prod_design','ASC')
                        ->where('process_order_quantity.status','0')
                        ->select([
                            'process_order_quantity.variation_id',
                            'process_order_quantity.id',
                            'process_order_quantity.variation_design',
                            DB::raw('sum(process_order_quantity.receiving_qty) as approve_qty'),
                            'process_order_quantity.created_date',
                            'process_order_quantity.urgent_status',
                            
                            'product_info_design.product_name',
                            'product_info.Quantity',
                            'product_info_design.prod_img',
                            'product_info_design.product_url',
                            'process_order_quantity.store_id',
                            'process_order_quantity.shipment_type',
                            
                        ]);
            
            $records->where('store_id',$request->store);
            $records->where('shipment_type',$request->shipment_type);
            
            $arr=$this->total_assign_quantity($request->store,$request->shipment_type);
            
            // dd($arr);
            
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('product_img',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }
    
                        $product_detail='
                            <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                '.$img.'
                            </a><br>
                        ';
                        return $product_detail;
                    })
                    ->addColumn('product_name',function ($data){
                        
                        if($data->product_name !=''){
                            
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-12">
                                    '.$data->product_name.'<br>
                                    <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                    <span style="color:#D35400">SKU with Design : <strong>'.$data->variation_design.'</strong></span><br>
                                    </div>
                                </div>
                            ';
                        }else{
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-6">
                                    '.$data->variation_id.'
                                    </div>
                                </div>
                            ';
                        }
                        return $product_detail;
                    })
                    ->filterColumn('product_name',function($query,$keyword){
                        $query->orWhereRaw("product_info_design.product_name LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info_design.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info_design.variation_design LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('product_name', function ($query, $order) {
                        $query->orderBy('product_info_design.product_name', $order);
                    })
                    
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('process_orders.created_date', $order);
                    })
                    ->addColumn('created_at',function ($data){
                        // style="display:none;
                        $created='<div class="form-check">
                                    <div class="checkbox">
                                        <input type="checkbox" id="id_check_'.$data->id.'" name="id_check[]" value="'.$data->id.'" class="form-check-input id_check" style="display:none;"><br>
                                        <h3 class="text-primary">'.\Carbon\Carbon::parse($data->created_date)->diffForHumans().'</h3>
                                    </div>
                                </div>
                            ';
                        return $created;
                    })
                    ->addColumn('instock',function($data) use(&$arr){
                        // $count=DB::select('Select (sum(receive_qty)-sum(receiving_qty)) as total_assign
                        //         from assign_quantity 
                        //         where variation_id ="'.$data->variation_id.'"
                        //         AND supplier_id ="1" AND status="0"');
                        
                        // if($count[0]->total_assign !=null){
                        //     $qty_stock=(int)$count[0]->total_assign;
                        //     if($qty_stock <0){
                        //         $qty_stock=0;
                        //     }
                        //     $product_detail='<span id="instock2_'.$data->id.'" class="text-dark">'.$qty_stock .'</span>';
                        //     return $product_detail;
                        // }
                        
                        if(isset($arr[$data->variation_id])){
                            if($arr[$data->variation_id]<=$data->approve_qty){
                                $qty_stock=$arr[$data->variation_id];
                                $arr[$data->variation_id]=0;
                            }elseif($arr[$data->variation_id]>$data->approve_qty){
                                $qty_stock=$data->approve_qty;
                                $arr[$data->variation_id]=$arr[$data->variation_id] - $data->approve_qty;
                            }
                            $dq=$arr[$data->variation_id];
                        }else{
                           $qty_stock=0; 
                           $dq=0;
                        }
                        
                        return '<span id="instock2_'.$data->id.'" class="text-dark" data-qty="'.$dq.'">'.$qty_stock.'</span>';
                    })
                    ->addColumn('receiving_input',function($data){
                        // if($data->urgent_status=='1'){
                        //     $status='<span class="badge badge-danger">Urgent</span>
                        //     <br>
                        //     <a href="javascript:;" style="display:none" id="assign_qty_'.$data->id.'" data-id="'.$data->id.'"  class="float-right btn btn-success btn-sm ml-1 assign_qty">
                        //         <i class="fas fa-check"></i> Update Quantity
                        //     </a>';
                        // }else{
                        //     $status='<a href="javascript:;" style="display:none" id="assign_qty_'.$data->id.'" data-id="'.$data->id.'"  class="float-right btn btn-success btn-sm ml-1 assign_qty">
                        //         <i class="fas fa-check"></i> Update Quantity
                        //     </a>';
                        // }
                        
                        $status='';
                        // <input type="hidden" id="pr_id_'.$data->id.'" name="pr_id[]" value="'.$data->pr_id.'"/>
                        // <input type="text" id="instock_'.$data->id.'" name="instock[]" value="'.$data->Quantity.'"/>
                            // 
                        $hidden='
                            <input type="hidden" id="assignid_'.$data->id.'" name="id[]" value="'.$data->id.'"/>
                            <input type="hidden" id="store_id_'.$data->id.'" name="store_id[]" value="'.$data->store_id.'"/>
                            <input type="hidden" id="shipment_type_'.$data->id.'" name="shipment_type[]" value="'.$data->shipment_type.'"/>
                            <input type="hidden" id="urgent_status_'.$data->id.'" name="urgent_status[]" value="'.$data->urgent_status.'"/>
                            
                            <input type="hidden" id="variation_design_'.$data->id.'" name="variation_design[]" value="'.$data->variation_design.'"/>
                            <input type="hidden" id="variation_id_'.$data->id.'" name="variation_id[]" value="'.$data->variation_id.'"/>
                            <input type="hidden" id="approve_qty_'.$data->id.'" name="approve_qty[]" value="'.$data->approve_qty.'"/>
                            <input type="text" class="form-control form-control-sm has-success input_filled" data-id="'.$data->id.'" id="filled_qty_'.$data->id.'" name="filled_qty[]" placeholder="0" />
                            <span id="error_'.$data->id.'" class="text-danger text-sm" style="display:none"></span><br>'.$status;
                            
                        return $hidden;//<input type="hidden" id="approve_qty_'.$data->id.'" name="approve_qty_[]" value="'.$data->approve_qty.'"/>

                    })
                    ->addColumn('given_qty',function($data){
                        // $where_qty=[
                        //     'variation_id' => $data->variation_id,
                        //     'variation_design' => $data->variation_design,
                        //     'store_id' => $data->store_id,
                        //     'shipment_type' => $data->shipment_type
                        // ];
                        // $count1=DB::table('process_order_quantity')->where($where_qty)->first();
                        
                        return $data->approve_qty;
                    })
                    ->addColumn('size',function($data){
                        $name=explode(',',$data->product_name);
                        return $name[1];
                    })
                    ->rawColumns(['product_img','instock','product_name','receiving_input','created_at','given_qty','size'])
                    ->make(true);
            
        }else{
            $stores=DB::table('store')->whereIn('id',[1,4,6])->get();
            return view('process_order.index',['stores'=> $stores]);
        }
    }
    
    public function total_assign_quantity($store_id,$shippment_type){
        $where=[
            // 'process_order_quantity.status' => 0,
            'assign_quantity.status' => 0,
            'assign_quantity.supplier_id' => 1,
            // 'process_order_quantity.store_id' => $store_id,
            // 'process_order_quantity.shipment_type' => $shippment_type
        ];
        
        // $list=DB::table('process_order_quantity')
        //             ->where($where)
        //             ->rightJoin('assign_quantity','process_order_quantity.variation_id','=','assign_quantity.variation_id')
        //             ->groupBy('process_order_quantity.variation_id','assign_quantity.variation_id')
        //             ->select([
        //                 'process_order_quantity.variation_id',
        //                 \DB::raw('(sum(assign_quantity.receive_qty)-sum(assign_quantity.receiving_qty)) as total_assign')
        //             ])->get();
                    
        $list=DB::table('assign_quantity')
                ->where($where)
                ->groupBy('assign_quantity.variation_id')
                ->select([
                        'assign_quantity.variation_id',
                        \DB::raw('(sum(assign_quantity.receive_qty)-sum(assign_quantity.receiving_qty)) as total_assign')
                    ])->get();
        
        $arr=[];
        foreach($list as $li){
            $arr[$li->variation_id]=$li->total_assign;
        }
        
        return $arr;
    }
    
    public function send_to_process(Request $request){
        if($request->ajax()){
            // dd($request->all());
            // $input=$request->all();
            
            foreach($request->array as $key => $input){
                $insert=[
                    'variation_id' => $input['variation_id'],
                    'variation_design' => $input['variation_design'],
                    'approve_qty' => $input['approve_qty'],
                    'filled_qty' => $input['filled_qty'],
                    'urgent_status' => 0,
                    'shipment_ready_status' => 0,
                    // 'pr_id' => $input['pr_id'],
                    'user_id' => auth()->user()->id,
                    'created_date' => date('Y-m-d H:i:s'),
                    'store_id' => $input['store_id'],
                    'shipment_type' => $input['shipment_type']
                ];
                $insert_data=DB::table('processed_orders')->insert($insert);
                
                $insert_log=[
                    'variation_id' => $input['variation_id'],
                    // 'pr_id' => $input['pr_id'],
                    'given_qty' => $input['filled_qty'],
                    'supplier_id' =>0,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'Ready For Shipment',
                    'created_date' => date('Y-m-d H:i:s')
                ];
    
                $insert_data=DB::table('item_log')->insert($insert_log);
                
                $where_processed=[
                    'variation_id' => $input['variation_id'],
                    'variation_design' => $input['variation_design'],
                    'store_id' => $input['store_id'],
                    'shipment_type' => $input['shipment_type'],
                    'status' => 0
                ];
                
                $check=DB::table('processed_order_quantity')->where($where_processed)->get();
                
                if($check->count()>0){
                    $row=$check->first();
                    $update=[
                        'process_qty' => (int)$row->process_qty + (int)$input['filled_qty'],
                        'receiving_qty' => (int)$row->receiving_qty + (int)$input['filled_qty'],
                        'updated_date' => date('Y-m-d H:i:s'),
                        'updated_by' => auth()->user()->id,
                    ];
                    DB::table('processed_order_quantity')->where($where_processed)->update($update);
                }else{
                    $insert=[
                        'variation_id' => $input['variation_id'],
                        'variation_design' => $input['variation_design'],
                        'process_qty' => $input['filled_qty'],
                        'receiving_qty' => $input['filled_qty'],
                        'urgent_status' => 0,//$input['urgent_status']
                        'status' => 0,
                        'created_by' => auth()->user()->id,
                        'created_date' => date('Y-m-d H:i:s'),
                        'store_id' => $input['store_id'],
                        'shipment_type' => $input['shipment_type']
                    ];
                    $insert_data=DB::table('processed_order_quantity')->insert($insert);
                }
                
                // if($input['approve_qty']==$input['filled_qty']){
                //     $where=[
                //         'variation_design' => $input['variation_design'],
                //         'store_id' => $input['store_id'],
                //         'shipment_type' => $input['shipment_type']
                //     ];
                    
                //     DB::table('process_orders')->where($where)->update([
                //         'processed_status' => 1
                //     ]);
                // }
                
                $where_qty=[
                    'variation_id' => $input['variation_id'],
                    'variation_design' => $input['variation_design'],
                    'store_id' => $input['store_id'],
                    'shipment_type' => $input['shipment_type'],
                    'status' => 0
                ];
                $count1=DB::table('process_order_quantity')->where($where_qty)->first();
                $qty2=(int)$count1->receiving_qty - (int)$input['filled_qty'] ;
                $update_qty=[
                    'updated_date' => date('Y-m-d H:i:s'),
                    'updated_by' => auth()->user()->id,
                    'receiving_qty' => ($qty2<0)?0:$qty2,
                ];
                
                if($qty2 <=0){
                    $update_qty['status']=1;
                }
                
                DB::table('process_order_quantity')->where($where_qty)->update($update_qty);
                
                $this->instock_minus($input['variation_id'],$input['filled_qty']);
            }
            return response()->json([
                'error' => '0',
                'message' => 'success'
            ], 200);
            
        }
    }
    
    public function instock_minus($variation_id,$qty2){
        $where=['variation_id' => $variation_id];
        
        $product_info=DB::table('product_info')->where($where)->first();
        
        $qty=$product_info->Quantity;
        
        $qty=$qty-$qty2;
        DB::table('product_info')->where($where)->update(['Quantity' => ($qty<0)?0:$qty]);
        $this->assign_quantity_minus($variation_id,$qty2);
        
    }
    
    public function assign_quantity_minus($variation_id,$qty){
        $list=DB::table('assign_quantity')
                    ->where('variation_id',$variation_id)
                    ->where('status',0)
                    ->where('supplier_id',1)
                    ->select(['receive_qty','receiving_qty','id'])->get();
        // dd($list);
        $actual_qty=$qty;
        $aaqty=0;
        
        $count=1;
        
        if($list->count()>0){
            foreach ($list as $record){
                $receive_qty=$record->receive_qty;
                $receiving_qty=$record->receiving_qty;
                
                $remaining=(int)$receive_qty-(int)$receiving_qty;
                // if($count==2){
                //     dd($q);
                // }
                // dd($remaining);
                
                if($qty<=$remaining){
                    $up_qty=$qty;
                    $qty=0;
                }else{
                    $up_qty=$remaining;
                    $qty=(int)$qty - (int)$remaining;
                }
                
                // if($count==2){
                //     dd($qty);
                // }
                
                // dd($qty);
                
                $actual_rec=(int)$receiving_qty + (int)$up_qty;
                $update_rec=['receiving_qty' =>  $actual_rec,'received_by' => auth()->user()->id, 'received_at'=>date('Y-m-d H:i:s')];
                
                $up=DB::table('assign_quantity')->where('id',$record->id);
                
                $up->update($update_rec);
                
                if($receive_qty==$actual_rec){
                    $up->update(['status' => 1]);
                }
                
                if($qty==0){
                    break;
                }
                $count++;
            }
        }
    }
    
    public function processed_order(Request $request){
        if($request->ajax()){
            // $start_date=date('Y-m-d',strtotime($request->start_date));
            // $end_date=date('Y-m-d',strtotime($request->end_date));
            $records=DB::table('processed_order_quantity')
                        ->groupBy('processed_order_quantity.variation_design','processed_order_quantity.store_id','processed_order_quantity.shipment_type')
                        ->join('product_info_design','product_info_design.variation_design','=','processed_order_quantity.variation_design')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.prod_size','ASC')
                        ->orderBy('product_info_design.prod_design','ASC')
                        ->where('processed_order_quantity.status','0')
                        // ->where('processed_order_quantity.bundle_status','0')//added by sufian
                        // ->where(DB::raw('DATE(processed_orders.created_date)'),'>=',$start_date)
                        // ->where(DB::raw('DATE(processed_orders.created_date)'),'<=',$end_date)
                        ->select([
                            'processed_order_quantity.variation_id',
                            'processed_order_quantity.id',
                            'processed_order_quantity.variation_design',
                            DB::raw('sum(processed_order_quantity.receiving_qty) as filled_qty'),
                            DB::raw('sum(processed_order_quantity.process_qty) as approve_qty'),
                            'processed_order_quantity.created_date',
                            'processed_order_quantity.urgent_status',
                            'product_info_design.product_name',
                            // 'product_info.Quantity',
                            'product_info_design.prod_img',
                            'product_info_design.product_url',
                            'processed_order_quantity.store_id',
                            'processed_order_quantity.shipment_type',
                            // 'processed_orders.pr_id',
                        ]);
            
            $records->where('store_id',$request->store);
            $records->where('shipment_type',$request->shipment_type);
            
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('product_img',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }
    
                        $product_detail='
                            
                                    <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a><br>
                                    
                                
                        ';
                        return $product_detail;
                    })
                    ->addColumn('product_name',function ($data){
                        
                        if($data->product_name !=''){
                            // if($data->design_title !=''){
                            //     $status='<span class="text-danger">Design : <strong>'.$data->design_title.'</strong></span>';
                            // }else{
                            //     $status='<span class="text-danger">Design : <strong>No Design</strong></span>';;
                            // }
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-12">
                                    '.$data->product_name.'<br>
                                    <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                    <span style="color:#D35400">SKU with Design : <strong>'.$data->variation_design.'</strong></span><br>
                                    </div>
                                </div>
                            ';
                        }else{
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-6">
                                    '.$data->variation_id.'
                                    </div>
                                </div>
                            ';
                        }
                        return $product_detail;
                    })
                    ->filterColumn('product_name',function($query,$keyword){
                        $query->orWhereRaw("product_info_design.product_name LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info_design.variation_id LIKE ?", ["%{$keyword}%"]);
                        // $query->orWhereRaw("product_info_design.variation_design LIKE ?", ["%{$keyword}%"]);
                    })
                    ->filterColumn('filled_qty',function($query,$keyword){
                        // $query->orWhereRaw("product_info_design.product_name LIKE ?", ["%{$keyword}%"]);
                        // $query->orWhereRaw("product_info_design.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info_design.variation_design LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('product_name', function ($query, $order) {
                        $query->orderBy('product_info_design.product_name', $order);
                    })
                    ->addColumn('created_at',function ($data){
                        
                        $date='<div class="form-check">
                                    <div class="checkbox">
                                        <input type="checkbox" id="id_check_'.$data->id.'" name="id_check[]" value="'.$data->variation_design.'" class="form-check-input id_check"><br>
                                        <h1 class="text-primary">'.date("jS", strtotime($data->created_date)).'</h1>
                                        <span class="text-primary font-weight-bold">'.date("F-Y", strtotime($data->created_date)).'</span>
                                    </div>
                                </div>';
                        return $date;
                    })
                    ->addColumn('instock',function ($data){
                        $instock='';
                        // if($data->store_id ==1){
                        //     $instock='<span class="text-dark">Decrum InStock : <strong class="text-info">'.$data->decrum_instock.'</strong></span><br>
                        //         <span class="text-dark">Decrum InBound : <strong class="text-info">'.$data->decrum_inbound.'</strong></span>';
                        // }else if($data->store_id ==4){
                        //     $instock='<span class="text-dark">AxFashion InStock : <strong class="text-info">'.$data->axfashion_instock.'</strong></span><br>
                        //         <span class="text-dark">AxFashion InBound : <strong class="text-info">'.$data->axfashion_inbound.'</strong></span>';
                        // }
                        
                        return $instock;
                    })
                    ->addColumn('size',function($data){
                        $name=explode(',',$data->product_name);
                        return $name[1];
                    })
                    ->rawColumns(['product_img','product_name','created_at','instock','size'])
                    ->make(true);
        }else{
            $stores=DB::table('store')->whereIn('id',[1,4,6])->get();
            return view('process_order.processed_order',['stores'=> $stores]);
        }
    }
    
    public function export_processed_order_for_ship(Request $request){
        if($request->isMethod('post')){
            
            $start_date=date('Y-m-d',strtotime($request->start_date));
            $end_date=date('Y-m-d',strtotime($request->end_date));
            $store_id=$request->store_id2;
            $shipment_type=$request->shipment_type2;
            $variation_list=explode(',',$request->variation_list);
            
            if(count($variation_list)>0 && $request->variation_list !=''){
                $in_array=1;
            }else{
                $in_array=0;
            }
            
            
            
            
            $objPHPExcel= new Spreadsheet();
            $objPHPExcel->setActiveSheetIndex(0);
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Variation id');
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Variation Design');
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Product Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Size');
            // $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'ASIN');
            // $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Created Date');
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Given QTY');
            // $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Filled QTY');
            
            
            
            if($in_array ==1){
                $records=DB::table('processed_order_quantity')
                        ->groupBy('processed_order_quantity.variation_design','processed_order_quantity.store_id','processed_order_quantity.shipment_type')
                        ->join('product_info_design','product_info_design.variation_design','=','processed_order_quantity.variation_design')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.prod_size','ASC')
                        ->orderBy('product_info_design.prod_design','ASC')
                        ->where('processed_order_quantity.status','0')
                        // ->where('processed_orders.bundle_status','0')//added by sufian
                        ->where('processed_order_quantity.shipment_type',$shipment_type)
                        ->where('processed_order_quantity.store_id',$store_id)
                        // ->where(DB::raw('DATE(processed_orders.created_date)'),'>=',$start_date)
                        // ->where(DB::raw('DATE(processed_orders.created_date)'),'<=',$end_date)
                        ->whereIn('processed_order_quantity.variation_design',$variation_list)
                        
                        ->get([
                            'processed_order_quantity.variation_id',
                            'processed_order_quantity.variation_design',
                            'product_info_design.product_name',
                            // 'product_size.size',
                            // 'product_info_design.prod_asin',
                            'processed_order_quantity.created_date',
                            DB::raw('sum(processed_order_quantity.process_qty) as approve_qty'),
                            DB::raw('sum(processed_order_quantity.receiving_qty) as filled_qty'),
                        ]);
                
            }else if($in_array ==0){
                $records=DB::table('processed_order_quantity')
                        ->groupBy('processed_order_quantity.variation_design','processed_order_quantity.store_id','processed_order_quantity.shipment_type')
                        ->join('product_info_design','product_info_design.variation_design','=','processed_order_quantity.variation_design')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.prod_size','ASC')
                        ->orderBy('product_info_design.prod_design','ASC')
                        ->where('processed_order_quantity.status','0')
                        // ->where('processed_orders.bundle_status','0')//added by sufian
                        ->where('processed_order_quantity.shipment_type',$shipment_type)
                        ->where('processed_order_quantity.store_id',$store_id)
                        // ->where(DB::raw('DATE(processed_orders.created_date)'),'>=',$start_date)
                        // ->where(DB::raw('DATE(processed_orders.created_date)'),'<=',$end_date)
                        // ->whereIn('processed_order_quantity.variation_design',$variation_list)
                        
                        ->get([
                            'processed_order_quantity.variation_id',
                            'processed_order_quantity.variation_design',
                            'product_info_design.product_name',
                            // 'product_size.size',
                            // 'product_info_design.prod_asin',
                            'processed_order_quantity.created_date',
                            DB::raw('sum(processed_order_quantity.process_qty) as approve_qty'),
                            DB::raw('sum(processed_order_quantity.receiving_qty) as filled_qty')
                        ]);
            }
            
            if(count($records)>0){
                    $count = 2;
                    foreach($records as $record){
                        $name=explode(',',$record->product_name);
                        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$count,$record->variation_id);
                        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$count,$record->variation_design);
                        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$count,$record->product_name);
                        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$count,$name[1]);
                        // $objPHPExcel->getActiveSheet()->SetCellValue('E'.$count,$record->prod_asin);
                        // $objPHPExcel->getActiveSheet()->SetCellValue('F'.$count,date('d-m-Y',strtotime($record->created_date)));
                        // $objPHPExcel->getActiveSheet()->SetCellValue('G'.$count,$record->approve_qty);
                        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$count,$record->filled_qty);
                        $count++;
                    }
                    
                    $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
                    
                    $store_name=DB::table('store')->where('id',$store_id)->first('strong_name');
                    // echo $store_name;exit;
                    
                    if($shipment_type =="1"){
                        $shipment_name='air_cargo';
                    }else{
                        $shipment_name='sea_cargo';
                    }
                    
                    $file_name = 'processed_order_'.$store_name->strong_name."_".$shipment_name."_".date('Y_m_d_h_i_s');
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
                    header('Cache-Control: max-age=0');
                    // ob_clean();
                    $objWriter->save('php://output');
                    exit();
            }
        }
    }
    
    
    //added by sufian
    public function bundle_list(Request $request){
        if($request->ajax()){
            $records=DB::table('bundle_list_pr_wise')
                            ->join('bundle','bundle.bundle_set_variation','=','bundle_list_pr_wise.bundle_set_variation')
                            ->where('bundle_list_pr_wise.status',0)
                            ->groupBy('bundle_list_pr_wise.bundle_set_variation','bundle_list_pr_wise.store_id','bundle_list_pr_wise.shipment_type')
                            ->select([
                                'bundle_list_pr_wise.id',
                                'bundle.variation_qty',
                                'bundle.image_url',
                                'bundle.bundle_set_name',
                                'bundle_list_pr_wise.approve_qty',
                                'bundle_list_pr_wise.given_qty',
                                DB::raw('sum(bundle_list_pr_wise.remaining_qty) as remaining_qty'),
                                'bundle_list_pr_wise.bundle_set_variation',
                                'bundle_list_pr_wise.pr_id'
                            ]);
                            
            if($request->store !=''){
                $records->where('bundle_list_pr_wise.store_id',$request->store);
            }
            
            if($request->shipment_type !=''){
                $records->where('bundle_list_pr_wise.shipment_type',$request->shipment_type);
            }
                            
            return Datatables::of($records) 
                        ->addIndexColumn()
                        ->addColumn('bundleImage',function($data){
                            if($data->image_url !=''){
                                $url=$data->image_url;
                                $img=' <img src="'.$data->image_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                            }else{
                                $url=asset('uploads/backend/no_image.png');
                                $img='<img src="'.asset('uploads/backend/no_image.png').'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                            }
                            
                            $detail='<div class="form-check">
                                        <div class="checkbox">
                                            <input type="checkbox" id="id_check_'.$data->id.'" name="id_check[]" value="'.$data->bundle_set_variation.'" class="form-check-input id_check"><br>
                                            <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                                '.$img.'
                                            </a>
                                        </div>
                                    </div>
                                    ';
    
                            return $detail;
                        })
                        ->addColumn('bundleDetail',function($data){
                                if($data->bundle_set_variation !=''){
                                    $variation=$data->bundle_set_variation;
                                }else{
                                    $variation='No Variation';
                                }
                                $detail2='<div>'.$data->bundle_set_name.'<br>
                                        <span class="text-success">Bundle SKU : <strong>'.$variation.'</strong></span><br>
                                    </div>';
        
                                return $detail2;
                        })
                        ->filterColumn('bundleDetail',function($query,$keyword){
                            $query->orWhereRaw("bundle.bundle_set_name LIKE ?", ["%{$keyword}%"]);
                            $query->orWhereRaw("bundle_list_pr_wise.bundle_set_variation LIKE ?", ["%{$keyword}%"]);
                        })
                        ->orderColumn('bundleDetail', function ($query, $order) {
                            $query->orderBy('bundle.bundle_set_name', $order);
                            $query->orderBy('bundle_list_pr_wise.bundle_set_variation', $order);
                        })
                        ->addColumn('instock',function($data){
                                // $instock=0;
                                $instock_arr=[];
                                
                                $where=['bundle_set_variation' => $data->bundle_set_variation];
                                $lists=DB::table('bundle_sets')->where($where)->get();
                                
                                
                                $html='';
                                foreach($lists as $list){
                                    $where_variation=['variation_id' => $list->variation_id];
                                    
                                    $sku=DB::table('product_info')->where($where_variation)->first();
                                    $count=DB::select('Select sum(filled_qty) as total_assign 
                                        from processed_orders 
                                        where variation_id ="'.$list->variation_id.'" AND variation_design="'.$list->variation_design.'"
                                        AND shipment_ready_status="0"');
                                        if($count[0]->total_assign !=null){
                                            $qty_stock=(int)$sku->Quantity - (int)$count[0]->total_assign;
                                            if($qty_stock <0){
                                                $qty_stock=0;
                                            }
                                        }else{
                                            $qty_stock=$sku->Quantity;
                                        }
                                        $html.='<span class="text-info" title="'.$sku->product_name.'">'.$list->variation_id.' : <strong>'.$qty_stock.'</strong></span><br>';
                                    
                                        // $instock+=$qty_stock;
                                        $instock_arr[]=$qty_stock;
                                        
                                }
                                
                                $html.='<hr><span class="text-primary">Total InStock : <strong>'.min($instock_arr)*$data->variation_qty.'</strong></span>';
                                
                                
                                
                                // $instock=($instock)/$data->variation_qty;
                                
                                $detail='<span class="text-success">Available Bundle : <strong id="avail_'.$data->id.'">'.min($instock_arr).'</strong></span><hr>'.$html;
                                // return round($instock,0,PHP_ROUND_HALF_DOWN);
                                return $detail;
                        })
                        ->addColumn('orderqty',function($data){
                            $instock=0;
                                
                                $where=['bundle_set_variation' => $data->bundle_set_variation];
                                $lists=DB::table('bundle_sets')->where($where)->get();
                                
                                
                            
                                $html='';
                                foreach($lists as $list){
                                    $where_variation=['variation_id' => $list->variation_id];
                                    $qty=((int)$list->quantity * (int)$data->remaining_qty);
                                    $sku=DB::table('product_info')->where($where_variation)->first();
                                    $html.='<span class="text-info" title="'.$sku->product_name.'">'.$list->variation_id.' : <strong>'.$qty.'</strong></span><br>';
                                    
                                    $instock+=$qty;
                                }
                                
                                $html.='<hr><span class="text-danger">Out from InStock : <strong>'.$instock.'</strong></span>';
                                
                                
                                
                                $instock=($instock)/$data->variation_qty;
                                
                                $detail='<span class="text-primary">Order Quantity : <strong id="outstock_'.$data->id.'">'.(int)$instock.'</strong></span><hr>'.$html;
                                // return round($instock,0,PHP_ROUND_HALF_DOWN);
                                return $detail;
                        })
                        ->addColumn('supply_qty',function($data){
                            $html='
                                <input type="text" class="form-control form-control-sm supply_qty" name="supply_qty_'.$data->id.'" id="supply_qty_'.$data->id.'" data-id="'.$data->id.'"/>
                                <input type="hidden" class="form-control form-control-sm pr_id" name="pr_id_'.$data->id.'" id="pr_id_'.$data->id.'"  value="'.$data->pr_id.'"/>
                                <br><span id="error_'.$data->id.'" class="text-danger text-sm" style="display:none"></span><br>
                                ';
                            
                            return $html;
                        })
                        ->rawColumns(['bundleImage','bundleDetail','instock','orderqty','supply_qty'])
                        ->make(true);
            
        }else{
            $stores=DB::table('store')->whereIn('id',[1,4,6])->get();
            return view('process_order.bundle_list',['stores' => $stores]);//create new view in process_order folder name bundle_list
        }
    }
    
    public function add_bundle_processed(Request $request){
        if($request->all()){
            $input=$request ->all();
            // dd($input);
            foreach($input['array'] as $key => $value){
                $insert_last=[
                    'bundle_set_variation' => $value['bundle_set_variation'],
                    'store_id' => $value['store_id'],
                    'shipment_type' => $value['shipment_type'],
                    'order_qty' => $value['order_qty'],
                    'receiving_qty' => $value['supply_qty'],
                    'user_id' => auth()->user()->id,
                    'created_date' => date('Y-m-d H:i:s'),
                    'bundle_pr_wise_id' => $value['id']
                ];
                
                DB::table('bundle_processed')->insert($insert_last);
                
                $where_variation=['bundle_set_variation' => $value['bundle_set_variation']];
                $lists=DB::table('bundle_sets')->where($where_variation)->get();
                
                foreach($lists as $list){
                    $insert_processed=[
                        'variation_id' => $list->variation_id,
                        'variation_design' => $list->variation_design,
                        'approve_qty' => ((int)$list->quantity * (int)$value['supply_qty']),
                        'filled_qty' => ((int)$list->quantity * (int)$value['supply_qty']),
                        'shipment_ready_status' => 0,
                        'bundle_status' => 1,
                        'pr_id' => $value['pr_id'],
                        'user_id' => auth()->user()->id,
                        'created_date' => date('Y-m-d H:i:s'),
                        'store_id' => $value['store_id'],
                        'shipment_type' => $value['shipment_type']
                    ];
                    
                    DB::table('processed_orders')->insert($insert_processed);
                }
                
                $where_id=[
                    'id' => $value['id'],
                ];
                
                $data1=DB::table('bundle_list_pr_wise')->where($where_id)->first();
                
                if($data1->remaining_qty ==$value['supply_qty']){
                    $update_arr['status']=1;
                }
                
                $update_arr['remaining_qty']=(int)$data1->remaining_qty - (int)$value['supply_qty'];
                $update_arr['given_qty']=$value['supply_qty'];
                
                DB::table('bundle_list_pr_wise')->where($where_id)->update($update_arr);
                
                
            }
            
            return response()->json([
                    'success'=>1
                ]);
        }
    }
    
    public function picklist_pdf(Request $request){
        if($request->isMethod('post')){
            $id_list= explode(',',$request->id_list);
            $store_id=$request->store_id2;
            $shipment_type=$request->shipment_type2;
            
            $records=DB::table('bundle_list_pr_wise')
                            ->join('bundle','bundle.bundle_set_variation','=','bundle_list_pr_wise.bundle_set_variation')
                            ->whereIn('bundle_list_pr_wise.id',$id_list)
                            ->get([
                                'bundle_list_pr_wise.id',
                                'bundle.variation_qty',
                                'bundle.image_url',
                                'bundle.bundle_set_name',
                                'bundle_list_pr_wise.approve_qty',
                                'bundle_list_pr_wise.given_qty',
                                'bundle_list_pr_wise.remaining_qty',
                                'bundle_list_pr_wise.bundle_set_variation',
                                'bundle_list_pr_wise.pr_id'
                            ]);
            $html = '<table style="border-collapse: collapse;">';    
            foreach($records as $record){
                $name=explode(',' ,$record->bundle_set_name);
                $imgxyz = (empty($record->image_url)) ? asset('backend/no_image.png') : $record->image_url;

               
              $html.='<tr style="border:1px solid black;">
              
                <td style="border:1px solid black;">
                    <a href="'.$imgxyz.'" target="_blank"><img src="'.$imgxyz.'" width="150" height="150"></a>
                </td>
                <td style="vertical-align: top;border:1px solid black;">'.$name[0].'<br /> Bundle variation :'.$record->bundle_set_variation.'</td>
                <td style="vertical-align: top;border:1px solid black;">Size<br />'.$name[1].'</td>
                <td style="vertical-align: top;border:1px solid black;text-align:center;">Given Qty<br />'.$record->given_qty.'</td>
              
              </tr>';
                
            }
            
            $html.='</table>';
            
            $store_name=DB::table('store')->where('id',$store_id)->first('strong_name');
            // echo $store_name;exit;
            
            if($shipment_type =="1"){
                $shipment_name='air_cargo';
            }else{
                $shipment_name='sea_cargo';
            }
            
            $pdf = PDF::loadHtml($html)->setPaper('A4', 'portrait');
        
            return $pdf->download('picklist_'.$store_name->strong_name.'_'.$shipment_name.'_'.date('d_m_Y').'.pdf');
        }
    }
}
