<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use App\Models\Sku;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

use App\Helpers\ReportHelper;


class POController extends Controller
{
    
    public function __construct(){
        $this->middleware(['auth']);
    }
    
    public function index(Request $request){
        $login_user=auth()->user();
        $path_new = storage_path() . "/data_reports/poSaleStock_".$login_user->id.".json";
        $dataArrayStock=[];
        $today_date=date('d-m-Y');
        
        
        
        if($request->ajax()){
            $country_list=$request->countrySelector;
            
            $title=$request->title;
            $withOutSpaceTitle=trim(str_replace('<br>','_',$title));
            $store=$request->store;
            
            if($request->start_date !=''){
                $start_date = date('Y-m-d',strtotime($request->start_date));
            }else{
                $start_date = date('Y-m-d');
            }
    	        
            if($request->end_date !=''){
                $end_date = date('Y-m-d',strtotime($request->end_date));
            }else{
                $end_date = date('Y-m-d');
            }
        
            if($request->child_sku !=''){
               $child=1;
            }else{
               $child=0;
            }
            
            if($store == 1){
	            $sale = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,['US'],$child,4);
	            $inventory = ReportHelper::getAmazonInventory("inventory_report_decrum",$child);
	            $awd = ReportHelper::getAWDInventory("inventory_report_decrum_awd",$child);
            }else if($store == 6){
                $sale = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,['CA'],$child,4);
	            $inventory = ReportHelper::getAmazonInventory("inventory_report_decrum_ca",$child);
	            $awd = ReportHelper::getAWDInventory("inventory_report_decrum_ca_awd",$child);
            }
            
            $shipment=$this->getPODetail($store,$child);
            
            
            $dataArrayStock=[
                'lastUpdateDate' => $today_date,
                'sale' => $sale,
                'inventory' => $inventory,
                'awd' => $awd,
                'po' => $shipment['po'],
                'ready_to_ship' => $shipment['ready_to_ship'],
            ];
            
            // dd($dataArrayStock['ready_to_ship']);
                
            $json_encode = json_encode($dataArrayStock);
            
            // dd($json_encode);
            file_put_contents($path_new,$json_encode);
            
            $html='';
        
            return response()->json([
                'code' => 200,
                'html' => $html
            ]);
            
            
        }else{
            $json_encode = json_encode($dataArrayStock);
            file_put_contents($path_new,$json_encode);
            
            $stores=DB::table('store')->where('status','=','1')->whereIn('id',[1,6])->orderBy('id','ASC')->get();
            return view('datareports.poDashboard',['stores'=> $stores]);
        }
        
    }
    
    public function getPODetail($store_id,$child){
        if($child){
           $groupbybundle='variation_design';
           $column='bundle_set_variation as variation_design';
           
           $columnSingle='variation_design';
           $groupbySingle='variation_design';
           
           $pluck='variation_design';
           
        }else{
            $groupbybundle='variation_design';
            $column='LEFT(bundle_set_variation, LENGTH(bundle_set_variation) - 1) as variation_design';
            
            $columnSingle='CASE 
                        WHEN variation_design LIKE \'%-%\' THEN 
                            CONCAT(
                                LEFT(SUBSTRING_INDEX(variation_design, \'-\', 1), LENGTH(SUBSTRING_INDEX(variation_design, \'-\', 1)) - 1),
                                \'-\',
                                SUBSTRING_INDEX(variation_design, \'-\', -1)
                            )
                        ELSE 
                            LEFT(variation_design, LENGTH(variation_design) - 1)
                    END AS variation_design_new';
            
            $groupbySingle='variation_design_new';
            
            $pluck='variation_design_new';
        }
        
        $check=DB::table('process_order_quantity')
                ->where('status',0)
                ->whereRaw('store_id = "'.$store_id.'" AND shipment_type IN (1,2)')
                ->selectRaw($columnSingle.', sum(receiving_qty) as approve_qty')
                ->groupBy($groupbySingle)
                ->get();
                
        
                
        $po_single=collect($check)->pluck(null,$pluck)->toArray();
        
        
        
        
        $check=\DB::table('bundle_list_pr_wise')
            ->where('status',0)
            ->whereRaw('store_id = "'.$store_id.'" AND shipment_type IN (1,2)')
            ->selectRaw($column.', sum(given_qty) as approve_qty')
            ->groupBy($groupbybundle)
            ->get();
        
        $po_bundle=collect($check)->pluck(null,$groupbybundle)->toArray();
        
        
        $po = $po_single + $po_bundle;
        
        
        
        $check=DB::table('processed_order_quantity')
                ->where('status',0)
                ->whereRaw('store_id = "'.$store_id.'" AND shipment_type IN (1,2)')
                ->selectRaw($columnSingle.', sum(receiving_qty) as approve_qty')
                ->groupBy($groupbySingle)
                ->get();
        
        // dd($check);
                
        $ready_to_ship=collect($check)->pluck(null,$pluck)->toArray();
        
        return [
            'po' => $po,
            'ready_to_ship' => $ready_to_ship
        ];
    }
    
    public function clearFilter(Request $request){
        if($request->ajax()){
            $login_id=auth()->user();
            $path_new = storage_path() . "/data_reports/poSaleStock_".$login_id->id.".json";
            $dataArrayStock=[];
            
            $json_encode = json_encode($dataArrayStock);
            file_put_contents($path_new,$json_encode);
            
            return response()->json([
                'code' => 200,
                'message' => 'Clear Filter'
            ]);
        }
    }
    
    public function ajax_datatable(Request $request){
        $login_id=auth()->user();
        $path_new = storage_path() . "/data_reports/poSaleStock_".$login_id->id.".json";
            
        $jsonData =file_get_contents($path_new);
        $dataArrayStock = json_decode($jsonData, true);
        
        
        $sale = isset($dataArrayStock['sale'])? $dataArrayStock['sale']:[];
        $inventory = isset($dataArrayStock['inventory'])? $dataArrayStock['inventory']:[];
        $awd = isset($dataArrayStock['awd'])? $dataArrayStock['awd']:[];
        $po = isset($dataArrayStock['po'])? $dataArrayStock['po']:[];
        $ready_to_ship = isset($dataArrayStock['ready_to_ship'])? $dataArrayStock['ready_to_ship']:[];
        
        // dd($dataArrayStock);
            
        
        
        $data_show=$request->data_show;
            
        if($data_show ==0){
            return DataTables::of([])->make(true);
        }
        
        $columns = [
            0 =>'id' 
        ];
            
            
        $limit = $request->input('length');
        $start = $request->input('start');
        // $order = $columns[$request->input('order.0.column')];
        // $dir = $request->input('order.0.dir');
        $order = $columns[0];
        $dir = 'ASC';
        
        $url=asset('uploads/sku_images/').'/';
        
        $fields_single='prod_status,
                        group_id,
                        variation_design,
                        prod_design,
                        product_name,
                        grade,
                        CASE 
                            WHEN product_url != "" THEN product_url
                            ELSE CONCAT("'.$url.'", prod_img)
                        END as image';
        
        $fields_bundle='status as prod_status,
                        bundle_group as group_id,
                        bundle_set_variation as variation_design,
                        decrum_instock as prod_design,
                        bundle_name as product_name,
                        grade,
                        image_url as image';
            
        $is_discarded=$request->is_discarded;
        $child_sku=$request->child_sku;
            
        $status='';
        
        $where_single=$where_bundle=' is_deleted = 0';
        
        if($is_discarded ==''){
            $where_single .=' AND prod_status = 1';
            $where_bundle .=' AND status = 1';
        }
            
            
        if(!empty($request->input('search.value'))){
            $search = trim($request->input('search.value'));
            
            $search_minus_e='-';
            
            if(preg_match("/{$search_minus_e}/i", strtolower($search))){
                $exp=explode('-',$search);
                $group_id=$exp[0];
                $dalpha=$exp[1];
                
                $where_single.=' AND ( group_id = "'.$group_id.'" AND variation_design LIKE "%'.$dalpha.'%" )';
            }else{
                $where_single.=' AND ( variation_design LIKE "%'.$search.'%" OR product_name LIKE "%'.$search.'%" )';
                
            }
            
            $where_bundle.=' AND ( bundle_set_variation LIKE "%'.$search.'%" OR bundle_set_name LIKE "%'.$search.'%" )';
        }
        
        $results_bundle = DB::table('bundle')
                            ->selectRaw($fields_bundle)
                            ->whereRaw($where_bundle);
                            
        $results = DB::table('product_info_design')
                        ->selectRaw($fields_single)
                        ->whereRaw($where_single);
        
        $gsingle=$gbundle='';
        if($child_sku ==''){
            $results_bundle->groupBy('group_id');
            $results->groupBy(['group_id','prod_design']);
            
            $gsingle=' GROUP BY group_id,prod_design';
            $gbundle=' GROUP BY bundle_group';
        }
        
    $c='SELECT COUNT(*) AS allcount FROM (
                        SELECT group_id
                        FROM product_info_design
                        WHERE '.$where_single.$gsingle.'
                                            
                        UNION ALL
                    
                        SELECT bundle_group AS group_id
                        FROM bundle
                        WHERE '.$where_bundle.$gbundle.'
                        
                    ) t';
                    
                    // dd($c);
            
        $totalData = DB::select($c)[0]->allcount;
        
        $totalFiltered = $totalData;
            
        
        $results=$results->union($results_bundle);
            
        if($limit !='-1'){
            $skus=$results->offset($start)->limit($limit)->get();
        }else{
            $skus=$results->get();
        }
        
        $data = [];
            
        if($skus->count()>0){
            foreach($skus as $sku){
                
                $url=$sku->image;
                
                $image='<a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image" id="product_img_'.$sku->group_id.'">
                        <img src="'.$url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">
                    </a>';
                
                
                
                
                            
                $astatus='<span class="badge badge-success">Active</span>';
                if(in_array($sku->prod_status,[0,2])){
                    $astatus='<span class="badge badge-danger">Discard</span>';
                }
                
                $group_id=$sku->group_id;
                
                $design1=explode('-',$sku->variation_design);
                $design1=isset($design1[1])?'-'.$design1[1]:'';
                if($child_sku ==''){
                    if($design1){
                        $group_design=$sku->group_id.$design1;
                    }else{
                        $group_design=$group_id;
                    }
                    
                    $product_name=explode(",",$sku->product_name);
                    $product_name=$product_name[0];
                }else{
                    $group_design=$sku->variation_design;
                    $product_name=$sku->product_name;
                }
                
                $totalSale=0;
                if(isset($sale[$group_design])){
                    
                    $totalSale=$sale[$group_design]['total_sale'];
                }
                
                $totalReady=0;
                if(isset($ready_to_ship[$group_design])){
                    $totalReady=$ready_to_ship[$group_design]['approve_qty'];
                }
                
                $totalAwdInstock=0;
                $totalAwdInbound=0;
                if(isset($awd[$group_design])){
                    // dd($awd[$group_design]);
                    $totalAwdInstock=$awd[$group_design]['instock'];
                    $totalAwdInbound=$awd[$group_design]['inbound'];
                }
                
                $totalInstock=0;
                $totalInbound=0;
                $totalReserved=0;
                if(isset($inventory[$group_design])){
                    $totalInstock=$inventory[$group_design]['instock'];
                    $totalInbound=$inventory[$group_design]['inbound'];
                    $totalReserved=$inventory[$group_design]['reserved'];
                }
                
                $totalPo=0;
                if(isset($po[$group_design])){
                    $totalPo=$po[$group_design]['approve_qty'];
                }
                
                $new=[];
                $new['ProductImg'] = $image;
                $new['variation']= $group_design;
                $new['ProductDetail']='<span class="text-wrap" style="width: 1rem;">'.$product_name.'</span><br>'.$astatus;
                $new['grade']=$sku->grade;
                $new['totalSale']=$totalSale;
                $new['totalReady']=$totalReady;
                $new['totalAwdInstock']=$totalAwdInstock;
                $new['totalAwdInbound']=$totalAwdInbound;
                $new['totalInstock']=$totalInstock;
                $new['totalInbound']=$totalInbound;
                $new['totalReserved']=$totalReserved;
                $new['totalPo']=$totalPo;
                
                $data[] = $new;
            }
        }
        
        $json_data = [
            "draw"            => intval($request->input('draw')),  
            "recordsTotal"    => intval($totalData),  
            "recordsFiltered" => intval($totalFiltered), 
            "data"            => $data
        ];
        
        return response()->json($json_data);
    }
    
    public function get_excel(Request $request){
        $login_id=auth()->user();
        $path_new = storage_path() . "/data_reports/poSaleStock_".$login_id->id.".json";
            
        $jsonData =file_get_contents($path_new);
        $dataArrayStock = json_decode($jsonData, true);
        
        
        $sale = isset($dataArrayStock['sale'])? $dataArrayStock['sale']:[];
        $inventory = isset($dataArrayStock['inventory'])? $dataArrayStock['inventory']:[];
        $awd = isset($dataArrayStock['awd'])? $dataArrayStock['awd']:[];
        $po = isset($dataArrayStock['po'])? $dataArrayStock['po']:[];
        $ready_to_ship = isset($dataArrayStock['ready_to_ship'])? $dataArrayStock['ready_to_ship']:[];
        
        $file_name = 'po_dashboard_'.date('d_m_Y'); 
        $url=asset('uploads/sku_images/').'/';
        
        $fields_single='prod_status,
                        group_id,
                        variation_design,
                        prod_design,
                        product_name,
                        grade,
                        CASE 
                            WHEN product_url != "" THEN product_url
                            ELSE CONCAT("'.$url.'", prod_img)
                        END as image';
        
        $fields_bundle='status as prod_status,
                        bundle_group as group_id,
                        bundle_set_variation as variation_design,
                        decrum_instock as prod_design,
                        bundle_name as product_name,
                        grade,
                        image_url as image';
                        
        $child_sku=$request->child_sku;
        $is_discarded=$request->is_discarded;
        
            
        $status='';
        
        $where_single=$where_bundle=' is_deleted = 0';
        
        if($is_discarded ==''){
            $where_single .=' AND prod_status = 1';
            $where_bundle .=' AND status = 1';
        }
        
        $results_bundle = DB::table('bundle')
                            ->selectRaw($fields_bundle)
                            ->whereRaw($where_bundle);
                            
        $results = DB::table('product_info_design')
                        ->selectRaw($fields_single)
                        ->whereRaw($where_single);
        
        $gsingle=$gbundle='';
        if($child_sku ==''){
            $results_bundle->groupBy('group_id');
            $results->groupBy(['group_id','prod_design']);
            
            $gsingle=' GROUP BY group_id,prod_design';
            $gbundle=' GROUP BY bundle_group';
        }
        
   
            
        
        $results=$results->union($results_bundle);
        $skus=$results->get();
        
        
        $spreadsheet = new Spreadsheet();
        $spreadsheet->setActiveSheetIndex(0);
        $sheet = $spreadsheet->getActiveSheet();
        
        $sheet->setCellValue('A1', 'SKU');
        $sheet->setCellValue('B1', 'Product_Name');
        $sheet->setCellValue('C1', 'Grade');
        $sheet->setCellValue('D1', 'Total Sale');
        $sheet->setCellValue('E1', 'ReadyToShip Stock');
        $sheet->setCellValue('F1', 'AWD Instock');
        $sheet->setCellValue('G1', 'Amazon Instock');
        $sheet->setCellValue('H1', 'Amazon Inbound');
        $sheet->setCellValue('I1', 'Amazon Reserved');
        $sheet->setCellValue('J1', 'PO');
        
        $rowCount=2;
        
        foreach($skus as $sku){
            $astatus='Active';
            if(in_array($sku->prod_status,[0,2])){
                $astatus='Discard';
            }
            
            $group_id=$sku->group_id;
            
            $design1=explode('-',$sku->variation_design);
            $design1=isset($design1[1])?'-'.$design1[1]:'';
            if($child_sku ==''){
                if($design1){
                    $group_design=$sku->group_id.$design1;
                }else{
                    $group_design=$group_id;
                }
                
                $product_name=explode(",",$sku->product_name);
                $product_name=$product_name[0];
            }else{
                $group_design=$sku->variation_design;
                $product_name=$sku->product_name;
            }
            
            $totalSale=0;
            if(isset($sale[$group_design])){
                
                $totalSale=$sale[$group_design]['total_sale'];
            }
            
            $totalReady=0;
            if(isset($ready_to_ship[$group_design])){
                $totalReady=$ready_to_ship[$group_design]['approve_qty'];
            }
            
            $totalAwdInstock=0;
            $totalAwdInbound=0;
            if(isset($awd[$group_design])){
                // dd($awd[$group_design]);
                $totalAwdInstock=$awd[$group_design]['instock'];
                $totalAwdInbound=$awd[$group_design]['inbound'];
            }
            
            $totalInstock=0;
            $totalInbound=0;
            $totalReserved=0;
            if(isset($inventory[$group_design])){
                $totalInstock=$inventory[$group_design]['instock'];
                $totalInbound=$inventory[$group_design]['inbound'];
                $totalReserved=$inventory[$group_design]['reserved'];
            }
            
            $totalPo=0;
            if(isset($po[$group_design])){
                $totalPo=$po[$group_design]['approve_qty'];
            }
            
            $sheet->setCellValue('A'.$rowCount, $group_design);
            $sheet->setCellValue('B'.$rowCount, $product_name .' ('.$astatus.')');
            $sheet->setCellValue('C'.$rowCount, $sku->grade);
            $sheet->setCellValue('D'.$rowCount, $totalSale);
            $sheet->setCellValue('E'.$rowCount, $totalReady);
            $sheet->setCellValue('F'.$rowCount, $totalAwdInstock);
            $sheet->setCellValue('G'.$rowCount, $totalInstock);
            $sheet->setCellValue('H'.$rowCount, $totalInbound);
            $sheet->setCellValue('I'.$rowCount, $totalReserved);
            $sheet->setCellValue('J'.$rowCount, $totalPo);
            $rowCount++;
        }
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
}
