<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\Sku;

class OrderReportController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:order-report');
    }
    
    public function report_list(Request $request){
        if($request->ajax()){
            $draw = $request->post('draw');
            $start = $request->post("start");
            $rowperpage = $request->post("length"); // total number of rows per page

            $columnIndex_arr = $request->post('order');
            $columnName_arr = $request->post('columns');
            $order_arr = $request->post('order');
            $search_arr = $request->post('search');
            
            $store_id=$request->store_id;
            $start_date=date('Y-m-d',strtotime($request->start_date));
            $end_date=date('Y-m-d',strtotime($request->end_date));
            
            
            $searchValue = $search_arr['value']; // Search value
            
            $totalRecords = DB::select('SELECT COUNT(*) as allcount FROM (SELECT COUNT(*) FROM product_info GROUP BY group_id) t')[0]->allcount;
            // dd($totalRecords);
            
            if($searchValue !=''){
                $sql='SELECT COUNT(*) as allcount FROM (SELECT COUNT(*) FROM product_info where 
                                product_name like "%'.$searchValue.'%" OR 
                                variation_id like "%'.$searchValue.'%" OR 
                                group_id like "%'.$searchValue.'%" GROUP BY group_id) t';
                $totalRecordswithFilter=DB::select($sql)[0]->allcount;
                $records = Sku::groupBy('group_id')
                                ->where('product_name', 'like', '%' . $searchValue . '%')
                                ->orWhere('variation_id', 'like', '%' . $searchValue . '%')
                                ->orWhere('group_id', 'like', '%' . $searchValue . '%');
            }else{
                $totalRecordswithFilter =$totalRecords;
                $records = Sku::groupBy('group_id');
            
            }
            
            if($rowperpage !='-1'){
                $records->offset($start)->take($rowperpage);
            }
            
            if(isset($columnIndex_arr[0]['column'])){
                $columnIndex = $columnIndex_arr[0]['column']; // Column index
                $columnName = $columnName_arr[$columnIndex]['data']; // Column name
                $columnSortOrder = $order_arr[0]['dir']; // asc or desc
                $records->orderBy($columnName, $columnSortOrder);
            }else{
                $records->orderBy('group_id','ASC');
            }
            
            $data = array();
            $product_size=DB::table('product_size')->where('status',1)->get();
            
            if(!empty($records->get())){
                foreach($records->get() as $sku){
                    $nestedData=array();
                    $total=0;
                    
                    if($sku->product_url !=''){
                        $url=$sku->product_url;
                        $img=' <img src="'.$sku->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">';
                    }else{
                        $url=asset('uploads/sku_images/'.$sku->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$sku->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">';
                    }
                    
                    $nestedData['image_url']='<a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image" id="product_img_'.$sku->group_id.'">
                                                '.$img.'
                                            </a>';
                                            
                    $sp=explode(",",$sku->product_name);
                    $nestedData['group_id']=$sku->group_id;
                    $nestedData['product_name']=$sp[0];
                    
                    foreach($product_size as $ps){
                        $variation_id=$sku->group_id.$ps->id;
                        $qty=$this->get_total_sale($variation_id,$store_id,$start_date,$end_date);
                        $total+=$qty;
                        $nestedData[$ps->size]=$qty;
                    }
                    
                    $nestedData['total']=$total;
                    $data[] = $nestedData;
                    
                    
                }
            }
            
            $response = array(
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordswithFilter,
                "aaData" => $data,
            );
            
            echo json_encode($response);
            
            // ->skip($start)
            // ->take($rowperpage)
            // ->get();
            
            // $records = Sku::orderBy($columnName, $columnSortOrder)
            // ->where('students.name', 'like', '%' . $searchValue . '%')
            // ->orWhere('students.email', 'like', '%' . $searchValue . '%')
            // ->orWhere('students.branch', 'like', '%' . $searchValue . '%')
            // ->select('students.*')
            // ->skip($start)
            // ->take($rowperpage)
            // ->get();

            


            
            
            
        }else{
            $product_size=DB::table('product_size')->where('status',1)->get();
            $stores=DB::table('store')->whereIn('id',[1,4,6])->get();
            return view('order_report.index',['stores' => $stores,'product_sizes' => $product_size]);
        }
    }
    
    public function get_total_sale($variation_id,$store_id,$start_date,$end_date){
        if($store_id=='1'){
            $tbl='amazon_order_report_decrum';
        }else if($store_id=='4'){
            $tbl='amazon_order_report_axfashion';
        }else{
            $tbl='amazon_order_report_axfashion';
        }
        
        $record=DB::table($tbl)
                    ->where(DB::raw('Date(purchase_date)'),'>=',$start_date)
                    ->where(DB::raw('Date(purchase_date)'),'<=',$end_date)
                    ->where('variation_id',$variation_id)
                    ->count();
                    
        return $record;
    }
}
