<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Mail\SendMail;
use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class OrderController extends Controller
{
    public function __construct(){
        $this->middleware(['auth'])->except('store');
    }
    public function index(){
        $stores=DB::table('store')->whereIn('id',[1,4,6])->get();
        $pr_list=DB::table('purchase_order_quantity')->where('status',0)->groupBy('pr_id')->select(['pr_id'])->get();
        // dd($pr_list);
        
        $purchase_order_qty=DB::table('purchase_order_quantity')
                        ->join('product_info','product_info.variation_id','=','purchase_order_quantity.variation_id')
                        ->where('purchase_order_quantity.status','0')
                        ->first([
                                DB::raw('sum(purchase_order_quantity.remaining_qty) as remaining'),
                                DB::raw('sum(product_info.Quantity) as quantity')
                                ]);
        // dd($purchase_order_qty);
        // $purchase_order_qty=DB::table('purchase_order_quantity')->first()
        return view('purchase_order.index',['stores' => $stores,'purchase_order_qty' => $purchase_order_qty,'pr_list' => $pr_list]);
    }

    public function send_email($to,$cc,$bcc,$subject,$view,$details){
        $mail=Mail::to($to);
        
        if($cc !=''){
            $mail->cc($cc);
        }
        if($bcc !=''){
            $mail->bcc($bcc);
        }
        
        $mail->send(new SendMail($details,$subject,$view));
    }
    
    //production_order
    public function po_number($store_id,$shipment_type){
        $store_data=DB::table('store')->where('id',$store_id)->first();
        
        if($shipment_type=='1'){
            $cargo='AIR';
        }elseif($shipment_type=='2'){
            $cargo='SEA';
        }
        
        $po_name=date('dmy').$store_data->short_name.$cargo;
        $where=array('prefix_pr' => $po_name);
        $get_pr=DB::table('pr_data')->where($where)->get();
        
        if(count($get_pr)>0){
            if(count($get_pr)>1){
                $count=count($get_pr)+1;
                $pr_id=$po_name.'-'.($count-1);
            }else{
                $pr_id=$po_name.'-1';
            }
    
            $in_pr_data=[
                'pr_name' => $pr_id,
                'store_id' => $store_id,
                'shipment_type' => $shipment_type,
                'created_date' => date('Y-m-d H:i:s'),
                'user_id' => auth()->user()->id,
                'prefix_pr' => $po_name
            ];
            $ac_prId=$pr_id;
    
        }else{
            $in_pr_data=[
                'pr_name' => $po_name,
                'store_id' => $store_id,
                'shipment_type' => $shipment_type,
                'created_date' => date('Y-m-d H:i:s'),
                'user_id' => auth()->user()->id,
                'prefix_pr' => $po_name
            ];
            $ac_prId=$po_name;
        }
        $ins_id=DB::table('pr_data')->insertGetId($in_pr_data);
        
        return $ac_prId;
    }

    public function allOrders(Request $request){
        if ($request->ajax()) {
            
            $pr_id=$request->pr_id;
            $records=DB::table('purchase_order_quantity')
                        ->join('product_info','product_info.variation_id','=','purchase_order_quantity.variation_id')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->orderBy('purchase_order_quantity.pr_id','DESC')
                        ->orderBy('purchase_order_quantity.variation_id','ASC')
                        ->orderBy('product_info.prod_size','ASC')
                        ->where('purchase_order_quantity.status','0')
                        ->where('purchase_order_quantity.pr_id',$request->pr_id)
                        ->select([
                            'purchase_order_quantity.variation_id',
                            'purchase_order_quantity.order_qty',
                            'purchase_order_quantity.remaining_qty',
                            'purchase_order_quantity.pr_id',
                            'purchase_order_quantity.id',
                            'purchase_order_quantity.created_date',
                            'purchase_order_quantity.is_urgent',
                            'product_info.product_name',
                            'product_info.Quantity',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_size.size'
                        ]);
            // if($pr_id !=''){
            //     $records->where('purchase_order_quantity.pr_id',$request->pr_id);
            // }
                        
            
            // dd($records);
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('product_img',function($data){
                    if($data->product_url !=''){
                        $url=$data->product_url;
                        $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                    }else{
                        $url=asset('uploads/sku_images/'.$data->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                    }

                    $product_detail='
                        <div class="row">
                            <div class="col-md-6">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a><br>
                                
                            </div>
                        </div>
                    ';
                    return $product_detail;
                })
                ->filterColumn('product_img',function($query,$keyword){
                    $query->orWhereRaw("product_info.variation_id LIKE ?", ["%{$keyword}%"]);
                })
                ->orderColumn('product_img', function ($query, $order) {
                    $query->orderBy('product_info.variation_id', $order);
                })
                ->addColumn('product_name',function ($data){
                    if($data->is_urgent=='1'){
                        $status='<span class="badge badge-danger">Urgent</span>';
                    }else{
                        $status='';
                    }
                    if($data->product_name !=''){
                        $product_detail='
                            <div class="row">
                                <div class="col-md-12">
                                '.$data->product_name.'<br>
                                <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                <span style="color:#D35400">MO No : <strong>'.$data->pr_id.'</strong></span><br>'.$status.'<br>
                                </div>
                            </div>
                        ';
                    }else{
                        $product_detail='
                            <div class="row">
                                <div class="col-md-12">
                                '.$data->variation_id.'
                                </div>
                            </div>
                        ';
                    }
                    
                    

                    return $product_detail;
                })
                ->filterColumn('product_name',function($query,$keyword){
                    $query->orWhereRaw("product_info.product_name LIKE ?", ["%{$keyword}%"]);
                    $query->orWhereRaw("purchase_order_quantity.pr_id LIKE ?", ["%{$keyword}%"]);
                })
                ->orderColumn('product_name', function ($query, $order) {
                    $query->orderBy('product_info.variation_id', $order);
                })
                ->addColumn('approve_qtn',function ($data){
                    return '<span class="text-success">Order QTY : <strong id="order_'.$data->id.'">'.$data->remaining_qty.'</strong></span>';
                })
                ->filterColumn('approve_qtn',function($query,$keyword){
                    $query->orWhereRaw("purchase_order_quantity.order_qty LIKE ?", ["%{$keyword}%"]);
                })
                ->orderColumn('approve_qtn', function ($query, $order) {
                    $query->orderBy('purchase_order_quantity.order_qty', $order);
                })
                ->addColumn('quantity',function ($data){
                    // $count=DB::select('Select sum(receive_qty) as total_assign 
                                // from assign_quantity 
                                // where variation_id ="'.$data->variation_id.'" AND pr_id="'.$data->pr_id.'"
                                // AND supplier_id ="1" AND status="0"');
                    $count=DB::select('Select (sum(receive_qty)-sum(receiving_qty)) as total_assign
                                from assign_quantity 
                                where variation_id ="'.$data->variation_id.'"
                                AND supplier_id ="1" AND status="0"');
                    if($count[0]->total_assign !=null){
                        $qty_stock=(int)$data->Quantity - (int)$count[0]->total_assign;
                        $product_detail='<span id="qty_'.$data->id.'">'.$qty_stock.'</span><br>';
                        // <hr>
                        // <span class="text-success">'
                        // Drop in : <strong>'.$count[0]->total_assign.'</strong></span>'
                        
                        return $product_detail;
                    }
                    return '<span id="qty_'.$data->id.'">'.$data->Quantity.'</span>';
                })
                ->filterColumn('quantity',function($query,$keyword){
                    $query->orWhereRaw("product_info.Quantity LIKE ?", ["%{$keyword}%"]);
                })
                ->orderColumn('quantity', function ($query, $order) {
                    $query->orderBy('product_info.Quantity', $order);
                })
                ->addColumn('created_at',function ($data){//
                    //style="display:none" 
                    // $count=DB::select('Select sum(receive_qty) as total_assign 
                    //             from assign_quantity 
                    //             where variation_id ="'.$data->variation_id.'"
                    //             AND supplier_id ="1" AND status="0"');
                    $count=DB::select('Select (sum(receive_qty)-sum(receiving_qty)) as total_assign 
                                from assign_quantity 
                                where variation_id ="'.$data->variation_id.'"
                                AND supplier_id ="1" AND status="0"');
                    if($count[0]->total_assign !=null){
                        $qty_stock=(int)$data->Quantity - (int)$count[0]->total_assign;
                    }else{
                        $qty_stock=$data->Quantity;
                    }
                    // $qty_stock >=$data->order_qty && /
                    if($qty_stock >=20){
                        $selected="checked";
                    }else if($qty_stock <=20){
                        $selected="";
                    }else{
                        $selected="";
                    }
                    // style="display:none"
                    $created='<div class="form-check">
                                <div class="checkbox">
                                    <input type="checkbox" id="id_check_'.$data->id.'" name="id_check[]" value="'.$data->id.'"  class="form-check-input id_check" style="display:none"  '.$selected.'><br>
                                    <span>'.date('d-m-Y', strtotime($data->created_date)).'</span>
                                </div>
                            </div>
                        ';
                    return $created;
                })
                ->filterColumn('created_at',function($query,$keyword){
                    $keyword=date('Y-m-d',strtotime($keyword));
                    $query->orWhereRaw("purchase_order_quantity.created_date LIKE ?", ["%{$keyword}%"]);
                })
                ->orderColumn('created_at', function ($query, $order) {
                    $query->orderBy('purchase_order_quantity.created_date', $order);
                })
                ->addColumn('options',function ($data){
                    //  $count=DB::select('Select sum(receive_qty) as total_assign 
                    //             from assign_quantity 
                    //             where variation_id ="'.$data->variation_id.'" AND pr_id="'.$data->pr_id.'"
                    //             AND supplier_id ="1" AND status="0"');
                    // $count=DB::select('Select sum(receive_qty) as total_assign 
                    //             from assign_quantity 
                    //             where variation_id ="'.$data->variation_id.'"
                    //             AND supplier_id ="1" AND status="0"');
                    $count=DB::select('Select (sum(receive_qty)-sum(receiving_qty)) as total_assign 
                                from assign_quantity 
                                where variation_id ="'.$data->variation_id.'"
                                AND supplier_id ="1" AND status="0"');
                    if($count[0]->total_assign !=null){
                        $qty_stock=(int)$data->Quantity - (int)$count[0]->total_assign;
                    }else{
                        $qty_stock=$data->Quantity;
                    }
                    //$qty_stock >=$data->order_qty &&
                    if( $qty_stock >=20){
                        if($qty_stock >=$data->remaining_qty){
                            $value_qty='value="'.$data->remaining_qty.'"';
                        }else{
                            $value_qty='value="'.$qty_stock.'"';
                        }
                        $selected="selected";
                        $disabled="disabled";
                        $style='';
                        $readonly='readonly';
                        // $value_qty='value="'.$qty_stock.'"';
                        $sup_id=1;
                    }else if($qty_stock <=20){
                        $selected="";
                         $disabled="";
                        $style='style="display:none;"';
                        $readonly='';
                        $value_qty='';
                        $readonly='';
                        $sup_id='';
                    }else{
                        $selected="";
                        $disabled="";
                        $style='style="display:none;"';
                        $readonly='';
                        $value_qty='';
                        $readonly='';
                        $sup_id='';
                    }
                    $hidden='<input type="hidden" id="pr_id_'.$data->id.'" name="pr_id[]"  value="'.$data->pr_id.'"/>
                        <input type="hidden" name="id[]" value="'.$data->id.'"/>
                        <input type="hidden" id="variation_id_'.$data->id.'" name="variation_id[]" value="'.$data->variation_id.'"/>
                        <input type="hidden" id="quantity_'.$data->id.'" name="quantity[]" value="'.$qty_stock.'"/>
                        <input type="hidden" id="order_qty_'.$data->id.'" name="quantity[]" value="'.$data->remaining_qty.'"/>
                        <input type="text" class="form-control form-control-sm mt-1 input_order" data-id="'.$data->id.'" '.$value_qty.' '.$readonly.' id="assign_qty_'.$data->id.'" name="assign_quantity[]"  '.$style.'/>

                        ';

                    $supplier=Supplier::latest()->where('id','!=',2)->get(['supplier_name','id']);

                    $options='<select name="options[]" id="options_'.$data->id.'" class="form-control options select2 " '.$disabled.'>
                        <option value="">Please select</option>';
                    foreach ($supplier as $key => $value) {
                        if($qty_stock==0 && $value['id'] =='1'){
                            continue;
                        }
                        
                        if($sup_id ==$value['id']){
                            $selected="selected";
                        }else{
                            $selected="";
                        }
                        
                        $options.='<option value="'.$value['id'].'" '.$selected.'>'.$value['supplier_name'].'</option>';
                        
                    }
                    $options.='</select>'.$hidden.'<span id="error_'.$data->id.'" class="text-danger text-sm" style="display:none;word-break:break-all">Please Select</span>';
                    return $options;
                })
                ->rawColumns(['product_img','product_name','created_at','approve_qtn','quantity','options'])
                ->make(true);
        }
    }

    public function store(Request $request){
        // dd($request->json()->all());
        $json = $request->json()->all();
        $count=DB::table('view_products_orders')->orderBy('pr_id', 'desc')->first();
        // dd($count);
        if($count ==null){
            $pr_id=1;
        }else{
            $pr_id=($count->pr_id)+1;
        }
        
        
        foreach ($json as $key => $value) {
            $insert=[
                'variation_id' => $value['variation_id'],
                'given_qtn'=>$value['given_qnt'],
                'approve_qtn' => $value['assign_qnt'],
                'is_urgent'=>$value['urgency'],
                'created_by'=>$value['created_by'],
                'pr_id' => $pr_id,
                'created_at' => date('Y-m-d H:i:s'),
                'prod_gender' => $value['prod_gender'],
                'prod_type' => $value['prod_type'],
                'prod_color' => $value['prod_color'],
                'prod_size' => $value['prod_size'],
            ];
            

            $insert_data=DB::table('view_products_orders')->insert($insert);

            $insert_log=[
                'variation_id' => $value['variation_id'],
                'pr_id' => $pr_id,
                'given_qty' => $value['assign_qnt'],
                'supplier_id' =>0,
                'user_id' => 0,
                'type_name' => 'Purchase Order Upload',
                'created_date' => date('Y-m-d H:i:s')
            ];

            $insert_data=DB::table('item_log')->insert($insert_log);
        }

        $this->send_email();

        return response()->json(['success' => "Product added successfully"], 200);
    }
    
    public function get_sup_po_no($supplier){
        $check=DB::table('suppliers')->where('id',$supplier)->get();
        $ponumber='';
        if($check->count()>0){
            $row=$check->first();
            $today=strtotime(date("Y-m-d"));
            $update_date= strtotime($row->sup_po_no_date);
            
            $datediff = $today - $update_date;
            $difference = floor($datediff/(60*60*24));
            if($difference==0){
                $serial=$row->sup_po_no;
                $ponumber=$row->short_name.$serial;
            }else{
                $serial=(int)$row->sup_po_no+1;
                $ponumber=$row->short_name.$serial;
               
                $update_re=[
                    'sup_po_no' => $serial,
                    'sup_po_no_date' => date('Y-m-d')
                ];
                
                DB::table('suppliers')->where('id',$supplier)->update($update_re);
            }
        }
        return $ponumber;
    }

    public function assign_quantity(Request $request){
        // dd($request->all());
        $input=$request->all();
        $data=array();
        foreach($input['array'] as $key => $value){
            $where=[
                'variation_id' => $value['variation_id']
            ];
            
            $sku=DB::table('product_info')->where($where)->first();
            $supplier=$value['options'];
            
            // $sup_detail=DB::table('suppliers')->where('id',$supplier)->first();
            $po_serial=$this->get_sup_po_no($supplier);
            
            // $po_id=$value['pr_id'].'-'.$sup_detail->short_name.$sup_detail->sup_po_no;
            $po_id=$value['pr_id'].'-'.$po_serial;
            
            
            
            $insert=[
                'variation_id' => $value['variation_id'],
                'variation_design' => $value['variation_id'],
                'main_type' => $sku->group_id,
                'prod_size' => $sku->prod_size,
                'in_stock' =>  $value['quantity'],
                'supplier_id' => $value['options'],
                'assign_date' => date('Y-m-d'),
                'order_qty_given' => $value['order_qty'],
                'receive_qty' => $value['assign_qty'],
                'pr_id' => $value['pr_id'],
                'po_id' => $po_id
            ];
            $data[]=$insert;
            $response=DB::table('assign_quantity')->insert($insert);
            
            $insert_log=[
                    'variation_id' => $value['variation_id'],
                    'pr_id' => $value['pr_id'],
                    'given_qty' => $value['assign_qty'],
                    'supplier_id' =>$value['options'],
                    'user_id' => auth()->user()->id,
                    'type_name' => 'Purchase Order Approve',
                    'created_date' => date('Y-m-d H:i:s')
                ];
            $insert_data=DB::table('item_log')->insert($insert_log);
                
            $where_qty=[
                'variation_id' => $value['variation_id'],
                'pr_id' => $value['pr_id']
            ];
            
            $check_qty=DB::table('purchase_order_quantity')->where($where_qty)->first();
            
            // if($value['order_qty'] == $value['assign_qty']){
            //     $update_qty=[
            //         'remaining_qty' => 0,
            //         'updated_date' => date('Y-m-d H:i:s'),
            //         'updated_by' => auth()->user()->id,
            //         'status' =>1
            //     ];
            //     DB::table('purchase_order_quantity')->where($where_qty)->update($update_qty);
            //     DB::table('view_products_orders')
            //         ->where('variation_id', $value['variation_id'])->where('pr_id',$value['pr_id'])
            //         ->update(['status' => 1]);
            // }else{
                $qty1=(int)$check_qty->remaining_qty - (int)$value['assign_qty'];
                
                $update_qty=[
                    'remaining_qty' => $qty1,
                    'updated_date' => date('Y-m-d H:i:s'),
                    'updated_by' => auth()->user()->id,
                ];
                
                if($qty1 == 0){
                    DB::table('view_products_orders')
                    ->where('variation_id', $value['variation_id'])->where('pr_id',$value['pr_id'])
                    ->update(['status' => 1]);
                    $update_qty['status'] =1;
                }
                DB::table('purchase_order_quantity')->where($where_qty)->update($update_qty);
                
                // $sup_update=['sup_po_no' => (int)$sup_detail->sup_po_no+1];
                // DB::table('suppliers')->where('id',$supplier)->update($sup_update);
                
            // }
    
            // $insert_data=DB::table('item_log')->insert($insert_log);
            
            
            // DB::table('view_products_orders')
            //   ->where('variation_id', $value['variation_id'])->where('pr_id',$value['pr_id'])
            //   ->update(['status' => 1]);
            
        
        }
        
        return $response;
    }
    
    public function sup_po_change(){
        $suppliers=DB::table('suppliers')->where('status','1')->where('id','!=','1')->where('id','!=','2')->get();
        
        foreach($suppliers as $sup){
            $assign_data=DB::table('assign_quantity')
                        ->orderBy('id', 'desc')
                        ->where('supplier_id',$sup->id)->first();
                        
            
                        
            $po_id=$assign_data->po_id;
            $lastElement = end(explode('-', $po_id));
            $number=preg_replace('/[^0-9]/', '', $lastElement);
            
            $sup_update=['sup_po_no' => (int)$number+1];
            DB::table('suppliers')->where('id',$sup->id)->update($sup_update);
            
        }
        
        return response()->json(['code' => 200,'message' => 'Success']);
    }


    public function upload_excel(Request $request){
        // dd($request->all());
        if ($request->hasFile('file_img')) {
            $store_id=$request->store_id;
            $shipment_type=$request->shipment_type;
            $bulk_po=$request->bulk_po;
            
            $image = $request->file('file_img');
            $name = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/upload_excel');
            $image->move($destinationPath, $name);
            $original_name=$image->getClientOriginalName();
            
            $this->excel_log($name,$original_name,$store_id,$shipment_type);
            
            $extension=$image->getClientOriginalExtension();
 
            if($extension == 'csv'){
                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
            } elseif($extension == 'xlsx') {
                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
            } else {
                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
            }
            
            $pr_id=$this->po_number($store_id,$shipment_type);
            // dd($pr_id);
            
            $spreadsheet = $reader->load(public_path('/uploads/upload_excel/'.$name));
            $allDataInSheet = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
            
            //excel row validate
            $newarray=$spreadsheet->getActiveSheet()->toArray();
            unset($newarray[0]);
            $array = array_values($newarray);
            // dd($array);
            $validatedData = \Validator::make($array, [
                '*.0' => 'required',
                '*.1' => 'required|numeric|min:0|not_in:0'
            ]);
            
            if($validatedData->fails()){
                $this->data_delete($name,$pr_id);
                
                return response()->json([
                    'error' => 1,
                    'message' => 'Error ! <br> 
                            <strong>Approve Quantity is Invalid because it Accept only Numbers not alphabats or something and product name is also required</strong><br>',
                ], 200);
            }
            
            
            
            $arrayCount = count($allDataInSheet);
            $createArray = array('variation_id', 'approve_qty');
            $makeArray = array(
                'variation_id' => 'variation_id', 
                'approve_qty' => 'approve_qty',
            );
            
            $SheetDataKey = array();
            // dd($allDataInSheet);
            
            foreach ($allDataInSheet as $dataInSheet) {
                foreach ($dataInSheet as $key => $value) {
                    if (in_array(trim($value), $createArray)) {
                        $value = preg_replace('/\s+/', '_', $value);
                        $SheetDataKey[trim($value)] = $key;
                    } 
                }
            }
            
            $dataDiff = array_diff_key($makeArray, $SheetDataKey);
            // dd($dataDiff);
            $flag=0;
            if (empty($dataDiff)) {
                $flag = 1;
            }
            $fetchData=array();
            if($flag==1){
                for ($i = 2; $i <= $arrayCount; $i++) {
                    $variation_design = $SheetDataKey['variation_id'];
                    $approve_qty = $SheetDataKey['approve_qty'];
                    
                    $variation_design = filter_var(trim($allDataInSheet[$i][$variation_design]), FILTER_SANITIZE_STRING);
                    $approve_qty = filter_var(trim($allDataInSheet[$i][$approve_qty]), FILTER_SANITIZE_STRING);
                    
                    $bundle_check=preg_match( '/^4BUN/im',$variation_design);
                    
                    if($bundle_check==true){
                        //bundle function
                        
                        $list=DB::table('bundle_sets')->where('bundle_set_variation',$variation_design)->get();
                        if($list->count()>0){
                            foreach($list as $li){
                                $output = preg_replace( '/[^0-9]/', '', $approve_qty );
                                if($output){
                                    if($bulk_po =='bulk'){
                                        $this->purchase_order($li->variation_design,$approve_qty,$store_id,$shipment_type,$pr_id,$variation_design);
                                    }else{
                                        $this->purchase_order($li->variation_design,$approve_qty,$store_id,$shipment_type,$pr_id,$variation_design);
                                        
                                    }
                                }
                            }
                            
                            if($bulk_po !='bulk'){
                                $this->process_order($variation_design,$approve_qty,$store_id,$shipment_type,$pr_id);
                            }
                            
                            
                        }
                        
                    }else{
                        $output = preg_replace( '/[^0-9]/', '', $approve_qty );
                        if($output){
                            if($bulk_po =='bulk'){
                                $this->purchase_order($variation_design,$approve_qty,$store_id,$shipment_type,$pr_id);
                            }else{
                                $this->purchase_order($variation_design,$approve_qty,$store_id,$shipment_type,$pr_id);
                                $this->process_order($variation_design,$approve_qty,$store_id,$shipment_type,$pr_id);
                            }
                            
                            
                        }
                    }
                }
                $error='Successfully Order Uploaded';
                $type=0;
                
                $to=['smsufian.esire@gmail.com','ahad.esire@gmail.com'];//,'ahad.esire@gmail.com'
                $cc=['tahir.esire@gmail.com'];
                $bcc=[];//'abdulrehman.esire@gmail.com'
                $subject='New Uploaded MO ('.$pr_id.')';
                $view='emails.po_issued';
                
                $details=[
                    'name'=>auth()->user()->id,
                    'pr_id' => $pr_id,
                    'records' => DB::table('purchase_order_quantity')->join('product_info','product_info.variation_id','=','purchase_order_quantity.variation_id')->where('purchase_order_quantity.status',0)->where('purchase_order_quantity.pr_id',$pr_id)->get(),
                ];
                $this->send_email($to,$cc,$bcc,$subject,$view,$details);
            }else{
                $this->data_delete($name,$pr_id);
                
                $error= "Please import correct file, did not match excel sheet column";
                $type=1;
            }
            
            return response()->json([
                'error' => $type,
                'message' => $error
            ], 200);
        }
    }
    
    public function data_delete($file_name,$pr_id){
        unlink(public_path('uploads/upload_excel/'.$file_name));
        DB::table('view_products_orders')->where('pr_id', $pr_id)->delete();
        DB::table('upload_excel')->where('file_name', $file_name)->delete(); 
        DB::table('purchase_order_quantity')->where('pr_id', $pr_id)->delete();
        $data_del=DB::table('process_orders')->where('pr_id', $pr_id)->get();
        
        foreach($data_del as $proc_order){
            $where2=[
                'variation_id' => $proc_order->variation_id,
                'variation_design' => $proc_order->variation_design,
                'store_id' => $proc_order->store_id,
                'shipment_type' => $proc_order->shipment_type,
                'status' => 0
            ];
            
            $count1=DB::table('process_order_quantity')->where($where2)->first();
            
            $qty_process=(int)$count1->process_qty - (int)$proc_order->approve_qty;
            $qty_rec=(int)$count1->receiving_qty - (int)$proc_order->approve_qty;
            $update2=[
                'updated_date' => date('Y-m-d H:i:s'),
                'updated_by' => auth()->user()->id,
                'process_qty' => $qty_process,
                'receiving_qty' => $qty_rec
            ];
            DB::table('process_order_quantity')->where($where2)->update($update2);
        }
        
        DB::table('process_orders')->where('pr_id', $pr_id)->delete();
    }
    
    public function purchase_order($variation_design,$approve_qty,$store_id,$shipment_type,$pr_id,$bundle_set_variation=''){
        $explode=explode('-',$variation_design);
        $variation_id=$explode[0];
        
        $is_urgent=0;
        
        $split=str_split($variation_id);
        $prod_gender=$split[1];
        $prod_color=$split[count($split)-2];
        $prod_size=$split[count($split)-1];
        $prod_type=$split[2].$split[3].$split[4];
        $prod_type=str_replace('0','',$prod_type);
        
        $insert=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'given_qtn'=>$approve_qty,
            'approve_qtn' => $approve_qty,
            'is_urgent'=> 0,
            'created_by'=>auth()->user()->id,
            'pr_id' => $pr_id,
            'created_at' => date('Y-m-d H:i:s'),
            'prod_gender' => $prod_gender,
            'prod_type' => $prod_type,
            'prod_color' => $prod_color,
            'prod_size' => $prod_size,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type
        ];
        
        if($bundle_set_variation !=''){
            $insert['bundle_check']='1';
            $insert['bundle_set_variation']=$bundle_set_variation;
        }

        $insert_data=DB::table('view_products_orders')->insert($insert);
        
        $where_qty1=[
            'variation_id' => $variation_id,
            'pr_id' => $pr_id,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type
        ];
                            
        $count2=DB::table('purchase_order_quantity')->where($where_qty1)->first();
                            
        if($count2 ==null){
            $insert_qty=[
                'variation_id' => $variation_id,
                'store_id' => $store_id,
                'pr_id' => $pr_id,
                'shipment_type' => $shipment_type ,
                'created_date' => date('Y-m-d H:i:s'),
                'created_by' => auth()->user()->id,
                'order_qty' => $approve_qty,
                'remaining_qty' => $approve_qty
            ];
            
            if($is_urgent !=0 && $is_urgent ==1){
                $insert_qty['is_urgent']=1;
            }
            
            DB::table('purchase_order_quantity')->insert($insert_qty);
        }else{
            $qty2=(int)$approve_qty + (int)$count2->order_qty;
            $update_qty=[
                'updated_date' => date('Y-m-d H:i:s'),
                'updated_by' => auth()->user()->id,
                'order_qty' => $qty2,
                'remaining_qty' => $qty2
            ];
            if($is_urgent !=0 && $is_urgent ==1){
                $update_qty['is_urgent']=1;
            }
            DB::table('purchase_order_quantity')->where($where_qty1)->update($update_qty);
        }
    }
    
    public function process_order($variation_design,$approve_qty,$store_id,$shipment_type,$pr_id){
        $explode=explode('-',$variation_design);
        $variation_id=$explode[0];
        $is_urgent=0;
        $insert_process=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'approve_qty' => $approve_qty,
            'given_qty' => $approve_qty,
            'urgent_status' => $is_urgent,
            'processed_status' => 0,
            'pr_id' =>$pr_id,
            'user_id' => auth()->user()->id,
            'created_date' => date('Y-m-d H:i:s'),
            'store_id' => $store_id,
            'shipment_type' => $shipment_type
        ];
                            
        DB::table('process_orders')->insert($insert_process);
        
        $where_qty=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type,
            'status' => 0
        ];
                            
        $count1=DB::table('process_order_quantity')->where($where_qty)->first();
        
        if($count1 ==null){
            $insert_qty=[
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'store_id' => $store_id,
                'shipment_type' => $shipment_type ,
                'created_date' => date('Y-m-d H:i:s'),
                'created_by' => auth()->user()->id,
                'process_qty' => $approve_qty,
                'receiving_qty' => $approve_qty,
            ];
            
            DB::table('process_order_quantity')->insert($insert_qty);
        }else{
            $qty2=(int)$approve_qty + (int)$count1->process_qty;
            $qty3=(int)$approve_qty + (int)$count1->receiving_qty;
            $update_qty=[
                'updated_date' => date('Y-m-d H:i:s'),
                'updated_by' => auth()->user()->id,
                'process_qty' => $qty2,
                'receiving_qty' => $qty3
            ];
            DB::table('process_order_quantity')->where($where_qty)->update($update_qty);
        }
    }
    
    public function excel_log($name,$original_name,$store_id,$shipment_type){
        $insert_excel=[
            'file_name' => $name,
            'original_name' => $original_name,
            'type' => '1',
            'type_name' => 'Production Order',
            'status' => '1',
            'uploaded_by' => auth()->user()->id,
            'upload_date' => date('Y-m-d'),
            'store_id' => $store_id,
            'shipment_type' => $shipment_type
        ];
        $insert_data=DB::table('upload_excel')->insert($insert_excel);
        
        
    }
    
    public function check_warehouse_assign(Request $request){
        if($request->ajax()){
            $input=$request->all();
            
            $where=[
                'variation_id' => $input['variation_id'],
                'pr_id' => $input['pr_id'],
                'supplier_id' => 1,
                'status' => 0
            ]; 
            
            $count=DB::select('Select sum(receive_qty) as total_assign 
                                from assign_quantity 
                                where variation_id ="'.$input['variation_id'].'" AND pr_id="'.$input['pr_id'].'"
                                AND supplier_id ="1" AND status="0"');
            // $count=DB::select('Select sum(receive_qty) as total_assign 
            //                     from assign_quantity 
            //                     where variation_id ="'.$input['variation_id'].'"
            //                     AND supplier_id ="1" AND status="0"');
            
            $assign=$count[0]->total_assign;
            if($count[0]->total_assign ==null){
                $assign=0;
            }
                                
            return response()->json([
                'total_assign_qty' => $assign
            ]);
        }
    }

    


}
