<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class LogController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:item-log', ['only' => ['index']]);
        $this->middleware('permission:item-return-log', ['only' => ['return']]);
        $this->middleware('permission:barcode-change-log', ['only' => ['barcode_change']]);
    }

    public function index(Request $request){
        if($request->ajax()){
            $records=DB::table('item_log')
                        ->join('product_info','product_info.variation_id','=','item_log.variation_id')
                        ->LeftJoin('users','users.id','=','item_log.user_id')
                        ->LeftJoin('suppliers','suppliers.id','=','item_log.supplier_id')
                        ->select([
                            'item_log.*',
                            'users.name',
                            'suppliers.supplier_name',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.product_name'
                        ]);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->editColumn('name',function($data){
                        return ($data->user_id !=0)?$data->name:'API';
                    })
                    ->filterColumn('name',function($query,$keyword){
                        $api=['API','api','Api','AP','Ap','ap'];
                        if(in_array($keyword,$api)){
                            $keyword=0;
                            $query->orWhereRaw("item_log.user_id LIKE ?", ["%{$keyword}%"]);
                        }else{
                            $query->orWhereRaw("users.name LIKE ?", ["%{$keyword}%"]);
                        }
                        
                    })
                    ->editColumn('supplier_name',function($data){
                        return ($data->supplier_id !=0)?$data->supplier_name:'NIL';
                    })
                    ->filterColumn('supplier_name',function($query,$keyword){
                        $api=['NIL','nil','Nil','NI','Ni','ni'];
                        if(in_array($keyword,$api)){
                            $keyword=0;
                            $query->orWhereRaw("item_log.supplier_id LIKE ?", ["%{$keyword}%"]);
                        }else{
                            $query->orWhereRaw("suppliers.supplier_name LIKE ?", ["%{$keyword}%"]);
                        }
                        
                    })
                    ->addColumn('productDetail',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }

                        $detail='
                        <div class="row">
                            <div class="col-md-2">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                            <div class="col-md-8">
                                '.$data->product_name.'<br>
                                <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                <span style="color:#D35400">PR ID : <strong>'.$data->pr_id.'</strong></span>
                            </div>
                        </div>';

                        return $detail;
                    })
                    ->filterColumn('productDetail',function($query,$keyword){
                        $query->orWhereRaw("item_log.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("item_log.pr_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info.product_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('productDetail', function ($query, $order) {
                        $query->orderBy('item_log.variation_id', $order);
                        $query->orderBy('item_log.pr_id', $order);
                        $query->orderBy('product_info.product_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("item_log.created_date LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('item_log.created_date', $order);
                    })
                    ->rawColumns(['created_at','productDetail'])
                    ->make(true);
        }else{
            return view('log.index');
        }
    }

    public function return(Request $request){
        if($request->ajax()){
            $records=DB::table('item_return_log')
                        ->join('product_info','product_info.variation_id','=','item_return_log.variation_id')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->LeftJoin('users','users.id','=','item_return_log.user_id')
                        ->LeftJoin('suppliers','suppliers.id','=','item_return_log.supplier_id')
                        ->select([
                            'item_return_log.*',
                            'users.name',
                            'product_size.size',
                            'suppliers.supplier_name',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.product_name'
                        ]);
            return Datatables::of($records)
                    ->addIndexColumn()
                    
                    ->addColumn('productDetail',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }

                        $detail='
                        <div class="row">
                            <div class="col-md-2">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                            <div class="col-md-8">
                                '.$data->product_name.'<br>
                                <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                <span style="color:#D35400">Size : <strong>'.$data->size.'</strong></span>
                            </div>
                        </div>';

                        return $detail;
                    })
                    ->filterColumn('productDetail',function($query,$keyword){
                        $query->orWhereRaw("item_return_log.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info.product_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('productDetail', function ($query, $order) {
                        $query->orderBy('item_return_log.variation_id', $order);
                        $query->orderBy('product_info.product_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("item_return_log.created_date LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('item_return_log.created_date', $order);
                    })
                    ->rawColumns(['created_at','productDetail'])
                    ->make(true);
        }else{
            return view('log.item_return');
        }
    }
    
    public function barcode_change(Request $request){
        if($request->ajax()){
            $records=DB::table('barcodes_log')
                        ->join('product_info','product_info.variation_id','=','barcodes_log.variation_id')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->LeftJoin('users','users.id','=','barcodes_log.user_id')
                        ->LeftJoin('suppliers','suppliers.id','=','barcodes_log.supplier_id')
                        ->select([
                            'barcodes_log.*',
                            'users.name',
                            'suppliers.supplier_name',
                            'product_size.size',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.product_name'
                        ]);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('productDetail',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }

                        $detail='
                        <div class="row">
                            <div class="col-md-2">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                            <div class="col-md-10">
                                '.$data->product_name.'<br>
                                <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                <span class="text-info">Size : <strong>'.$data->size.'</strong></span><br>
                                <span style="color:#D35400">PR ID : <strong>'.$data->pr_id.'</strong></span>
                            </div>
                        </div>';

                        return $detail;
                    })
                    ->filterColumn('productDetail',function($query,$keyword){
                        $query->orWhereRaw("barcodes_log.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("barcodes_log.pr_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info.product_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('productDetail', function ($query, $order) {
                        $query->orderBy('barcodes_log.variation_id', $order);
                        $query->orderBy('barcodes_log.pr_id', $order);
                        $query->orderBy('product_info.product_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("barcodes_log.created_date LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('barcodes_log.created_date', $order);
                    })
                    ->addColumn('receiving_qty', function($data){
                        $blister_text='<span class="text-danger">Blister QTY : <strong>'.$data->blister_qty.'</strong></span><br>
                            <span class="text-info">No of label : <strong>'.$data->no_of_labels.'</strong></span>';
                       
                        return $detail='<span>'.$data->receiving_qty.'</span><br>'.$blister_text;
                     })
                    ->rawColumns(['created_at','productDetail','receiving_qty'])
                    ->make(true);
        }else{
            return view('log.barcode_change');
        }
    }
}
