<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class LogController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:item-log', ['only' => ['index']]);
    }

    public function index(Request $request){
        if($request->ajax()){
            $supplier_list=DB::table('suppliers')->get()->pluck('supplier_name','id')->toArray();
            $user_list=DB::table('users')->get()->pluck('name','id')->toArray();
            
            $variation_design=$request->variation_design;
            $records=DB::table('item_log')
                        ->join('product_info','product_info.variation_id','=','item_log.variation_id')
                        ->where('item_log.variation_id','=',$variation_design)
                        ->orderBy('id','desc')
                        ->select([
                            'item_log.*',
                            DB::raw('product_info.variation_id as v_id'),
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.product_name'
                        ]);
                        
            if($request->check_own =='1'){
                $records->where('item_log.user_id',auth()->user()->id);
            }
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('product_image',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="70" height="70">';
                        }

                        $product_detail='
                            <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                '.$img.'
                            </a><br>';
                        return $product_detail;
                    })
                    ->addColumn('log_detail',function($data) use(&$supplier_list,&$user_list){
                        $type_name=$data->type_name;
                        
                        $log_detail='';
                        $supplier_name='';
                        
                        $qty='<strong>('.$data->given_qty.')</strong>';
                        $pr_id='<strong>"'.$data->pr_id.'"</strong>';
                        
                        if(isset($supplier_list[$data->supplier_id])){
                            $supplier_name='<strong>'.$supplier_list[$data->supplier_id].'</strong>';
                        }
                        
                        if(isset($user_list[$data->user_id])){
                            $user_name='<strong>'.$user_list[$data->user_id].'</strong>';
                        }
                        
                        if($type_name =='Purchase Order Approve'){
                            $log_detail="Assign quantity $qty to $supplier_name for Manufacturing Order ID $pr_id by $user_name through Process Supplier Page."; 
                        }else if($type_name =='Order Received'){
                            $log_detail="Received quantity $qty for $supplier_name for Manufacturing Order ID $pr_id by $user_name through Drop In Page.";
                        }else if($type_name =='Switch Supplier'){
                            $log_detail="Assign quantity $qty to $supplier_name for Manufacturing Order ID $pr_id by $user_name through Switch Supplier Module." ;
                        }else if($type_name =='Assign Warehouse'){
                            $log_detail="Reserved quantity $qty for <strong>Process Order Shippment</strong> for Manufacturing Order ID $pr_id by $user_name through Drop In Page." ;
                        }else{
                            $log_detail="Assign quantity $qty to $type_name for Manufacturing Order ID $pr_id by $user_name.";
                        }
                        
                        
                        return '<div class="alert alert-warning">'.$log_detail.'</div>';
                    })
                    ->addColumn('created_date',function ($data){
                        $date=date('d-m-Y',strtotime($data->created_date));
                        $time=date('h:i A',strtotime($data->created_date));
                        $html='<span class="font-weight-bold">'.$date.'<br>'.$time.'</span>';
                        return $html;
                    })
                    ->rawColumns(['log_detail','product_image','created_date'])
                    
                    ->make(true);
        }else{
            return view('log.index');
        }
    }
}
