<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Models\Sku;
use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ItemAlterationController extends Controller
{
    function __construct(){
        $this->middleware(['auth'])->except('supplier_return');
        $this->middleware('auth:supplier')->only('supplier_return');
        $this->middleware('permission:item-alteration-add', ['only' => ['add']]);
        $this->middleware(['permission:item-alteration','permission:item-return'],['only' => ['index']]);
        $this->middleware('permission:alteration-received',['only' => ['alteration_received']]);

    }

    public function add(Request $request){
        if($request->method() == 'POST'){
            // dd($request->all());
            foreach ($request->sku as $key => $value) {
                $sku=Sku::find($value);
                $request->type[$key];

                $insert=[
                    'variation_id' => $sku->variation_id,
                    'product_info_id' => $value,
                    'quantity' => $request->quantity[$key],
                    'return_check' => $request->type[$key],
                    'supplier_id' => $request->supplier_id[$key],
                    'user_id' => auth()->user()->id,
                    'status' => 0,
                    'created_date' => date('Y-m-d H:i:s'),
                ];

                $insert_id=DB::table('item_return')->insertGetId($insert);

                if($request->type[$key]=='2'){
                    $insert_data=[
                        'variation_id' => $sku->variation_id,
                        'product_info_id' => $value,
                        'item_return_id' => $insert_id,
                        'in_stock' => $sku->Quantity,
                        'receive_qty' => $request->quantity[$key],
                        'receiving_qty' => 0,
                        'supplier_id' => $request->supplier_id[$key],
                        'status' => 0,
                        'user_id' => auth()->user()->id,
                        'created_date' => date('Y-m-d H:i:s')
                    ];

                    DB::table('alteration_item_received')->insert($insert_data);

                }

                $insert_log=[
                    'variation_id' => $sku->variation_id,
                    'quantity' => $request->quantity[$key],
                    'return_check' => ($request->type[$key]=='1')?'Return Item':'For Alteration',
                    'supplier_id' => $request->supplier_id[$key],
                    'user_id' => auth()->user()->id,
                    'created_date' => date('Y-m-d H:i:s'),
                ];

                DB::table('item_return_log')->insert($insert_log);

                $qty=(int)$sku->Quantity -(int)$request->quantity[$key];

                $sku->update([
                    'Quantity' => ($qty>0)?$qty:0
                ]);
            }
            return redirect()->route('items.alteration.add')->with('has_success','Item Alteration Insert Successfully');

        }else{
            return view('item_alter.create');
        }
        
    }

    public function supplier_list(Request $request){
        if ($request->ajax()){
            $page = $request->input('page');
            $resultCount = 10;
            $offset = ($page - 1) * $resultCount;
            $breeds = Supplier::where('supplier_name', 'LIKE',  '%' . $request->input("search"). '%')
                        ->orderBy('supplier_name')
                        ->skip($offset)
                        ->take($resultCount)
                        ->get(['id',DB::raw('supplier_name as text')]);

            $count = Supplier::where('supplier_name', 'LIKE',  '%' . $request->input("search"). '%')
            ->orderBy('supplier_name')->count();
            $endCount = $offset + $resultCount;
            $morePages = $count>$endCount;

            $results = array(
                "results" => $breeds,
                "pagination" => array(
                    "more" => $morePages
                )
            );

            return response()->json($results);
        }
        
    }

    public function sku_list(Request $request){
        if ($request->ajax() ){//&& $request->input("search") !=''
            $page = $request->input('page');
            $resultCount = 10;
            $offset = ($page - 1) * $resultCount;

            // dd(($page - 1) );

            $breeds = Sku::join('product_size','product_size.id','=','product_info.prod_size')
                        
                        ->whereRaw('LOWER(product_info.product_name) LIKE ?','%' . $request->input("search"). '%')
                        ->where('product_info.Quantity','!=',0)
                        ->orWhereRaw('LOWER(product_info.variation_id) LIKE ?',  '%' . $request->input("search"). '%')
                        ->where('product_info.Quantity','!=',0)
                        ->orderBy('product_info.product_name')
                        ->orderBy('product_info.variation_id')
                        ->skip($offset)
                        ->take($resultCount)
                        ->get([
                            'product_info.id',
                            'product_info.product_name',
                            'product_info.variation_id',
                            'product_info.group_id',
                            'product_size.size',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.Quantity as quantity'
                        ]);

            $count = Sku::whereRaw('LOWER(product_info.product_name) LIKE ?',  '%' . $request->input("search"). '%')
            ->where('product_info.Quantity','!=',0)
            ->orWhereRaw('LOWER(product_info.variation_id) LIKE ?',  '%' . $request->input("search"). '%')
            ->where('product_info.Quantity','!=',0)
            ->orderBy('product_info.product_name')
            ->orderBy('product_info.variation_id')->count();
            
            $endCount = $offset + $resultCount;
            $morePages = $count>$endCount;
            // dd($endCount > $count);
            $results = array(
                "results" => $breeds,
                "pagination" => array(
                    "more" => $morePages
                )
            );

            return response()->json($results);
        }

    }

    public function index(Request $request,$string){
        if($request->ajax()){
            $records=DB::table('item_return')
                        ->join('product_info','product_info.variation_id','=','item_return.variation_id')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->LeftJoin('users','users.id','=','item_return.user_id')
                        ->LeftJoin('suppliers','suppliers.id','=','item_return.supplier_id')
                        ->select([
                            'item_return.*',
                            'users.name',
                            'product_size.size',
                            'suppliers.supplier_name',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.product_name'
                        ]);
            if($request->type !=''){
                $records->where('return_check',$request->type);
            }
            return  Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('productDetail',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }

                        $detail='
                        <div class="row">
                            <div class="col-md-2">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                            <div class="col-md-8">
                                '.$data->product_name.'<br>
                                <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                <span style="color:#D35400">Size : <strong>'.$data->size.'</strong></span>
                            </div>
                        </div>';

                        return $detail;
                    })
                    ->filterColumn('productDetail',function($query,$keyword){
                        $query->orWhereRaw("item_return.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info.product_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('productDetail', function ($query, $order) {
                        $query->orderBy('item_return.variation_id', $order);
                        $query->orderBy('product_info.product_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("item_return.created_date LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('item_return.created_date', $order);
                    })
                    ->rawColumns(['created_at','productDetail'])
                    ->make(true);

        }else{
            if(in_array($string,['alteration','return'])){
                return view('item_alter.index',['string'=> $string]);    
            }else{
                return abort(404);
            }
            
        }
    }

    public function supplier_return(Request $request,$string){
        // echo $string; exit;
        if($request->ajax()){
            $supplier=auth('supplier')->user()->id;
            $records=DB::table('item_return')
                        ->join('product_info','product_info.variation_id','=','item_return.variation_id')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->LeftJoin('users','users.id','=','item_return.user_id')
                        ->LeftJoin('suppliers','suppliers.id','=','item_return.supplier_id')
                        ->where('supplier_id',$supplier)
                        ->where('return_check',$request->type)
                        ->select([
                            'item_return.*',
                            'users.name',
                            'product_size.size',
                            'suppliers.supplier_name',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.product_name'
                        ]);
            
            return  Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('productDetail',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }

                        $detail='
                        <div class="row">
                            <div class="col-md-2">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                            <div class="col-md-8">
                                '.$data->product_name.'<br>
                                <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                <span style="color:#D35400">Size : <strong>'.$data->size.'</strong></span>
                            </div>
                        </div>';

                        return $detail;
                    })
                    ->filterColumn('productDetail',function($query,$keyword){
                        $query->orWhereRaw("item_return.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info.product_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('productDetail', function ($query, $order) {
                        $query->orderBy('item_return.variation_id', $order);
                        $query->orderBy('product_info.product_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                        })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("item_return.created_date LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('item_return.created_date', $order);
                    })
                    ->rawColumns(['created_at','productDetail'])
                    ->make(true);


        }else{
            if(in_array($string,['return','alteration'])){
                return view('item_alter.return',['string' => $string]);
            }else{
                return abort(404);
            }
        }
    }

    public function statistics(Request $request){
        if($request->ajax()){
            $records=Supplier::leftJoin('item_return','item_return.supplier_id','=','suppliers.id')
                ->groupBy('item_return.supplier_id')
                // ->orderBy('suppliers.id','ASC')
                ->select([
                    'suppliers.supplier_name',
                    'suppliers.id',
                    DB::raw('SUM(CASE WHEN item_return.return_check=1 THEN item_return.quantity ELSE 0 END) as return_qty'),
                    DB::raw('SUM(CASE WHEN item_return.return_check=2 THEN item_return.quantity ELSE 0 END) as alter_qty'),
                    DB::raw('count(item_return.return_check) as return_check'),
                ]);
            
            if($request->start_date !=''){
                $records->where(DB::raw('DATE(item_return.created_date)'),'>=',date('Y-m-d',strtotime($request->start_date)));
            }
            if($request->end_date !=''){
                $records->where(DB::raw('DATE(item_return.created_date)'),'<=',date('Y-m-d',strtotime($request->end_date)));
            }
            return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('return_qty',function($data){
                return ($data->return_qty !='')? $data->return_qty:'0';
            })
            ->orderColumn('return_qty', function ($query, $order) {
                $query->orderBy('return_qty', $order);    
            })
            ->addColumn('alter_qty',function($data){
                return ($data->alter_qty !='')? $data->alter_qty:'0';
            })
            ->orderColumn('alter_qty', function ($query, $order) {
                $query->orderBy('alter_qty', $order);    
            })
            
            ->addColumn('supplier_name2',function($data){
                $ahref='<a href="javascript:;" class="supplier_name" data-id="'.$data->id.'" >'.$data->supplier_name.'</a>';
                return $ahref;
            })
            ->filterColumn('supplier_name2',function($query,$keyword){
                $query->orWhereRaw("LOWER(suppliers.supplier_name) LIKE ?", ["%{$keyword}%"]);     
            })
            ->orderColumn('supplier_name2', function ($query, $order) {
                $query->orderBy('suppliers.supplier_name', $order);    
            })
            ->rawColumns(['supplier_name2','return_qty','alter_qty'])
            ->make(true);

        }else{
            return view('item_alter.statistics'); 
        }
    }

    public function get_supplier_wise_data(Request $request){
        if($request->ajax()){
            $supplier_id=$request->input('supplier_id');
            $records=DB::table('item_return')
                        ->leftJoin('product_info','product_info.variation_id','=','item_return.variation_id')
                        ->join('teams','product_info.team','=','teams.team_code')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->where('item_return.supplier_id',$supplier_id)
                        ->select([
                            'item_return.created_date',
                            'teams.team_name',
                            'product_info.product_name',
                            'item_return.variation_id',
                            'item_return.return_check',
                            'item_return.quantity',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_size.size',
                        ]);
            return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('product_name',function($data){
                if($data->product_url !=''){
                    $url=$data->product_url;
                    $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                }else{
                    $url=asset('uploads/sku_images/'.$data->prod_img);
                    $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                }

                $detail='
                <div class="row">
                    <div class="col-md-4">
                        <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                            '.$img.'
                        </a>
                    </div>
                    <div class="col-md-8">
                        '.$data->product_name.'<br>
                        <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                        <span style="color:#D35400">Size : <strong>'.$data->size.'</strong></span>
                    </div>
                </div>';

                return $detail;
                
            })
            ->filterColumn('product_name',function($query,$keyword){
                $query->orWhereRaw("LOWER(product_info.product_name) LIKE ?", ["%{$keyword}%"])
                        ->orWhereRaw("LOWER(item_return.variation_id) LIKE ?", ["%{$keyword}%"])
                        ->orWhereRaw("LOWER(product_size.size) LIKE ?", ["%{$keyword}%"]);
            })
            ->orderColumn('product_name', function ($query, $order) {
                $query->orderBy('product_info.product_name', $order)
                        ->orderBy('item_return.variation_id', $order)
                        ->orderBy('product_size.size', $order);    
                    
            })
            
            ->addColumn('assign_date',function ($data){
               
                return date('d-m-Y',strtotime($data->created_date));
            })
            ->filterColumn('assign_date',function($query,$keyword){
                $keyword=date('Y-m-d',strtotime($keyword));
                $query->orWhereRaw("item_return.created_date LIKE ?", ["%{$keyword}%"]);     
            })
            ->orderColumn('assign_date', function ($query, $order) {
                $query->orderBy('item_return.created_date', $order);    
                    
            })
            
            ->rawColumns(['assign_date','product_name'])
            ->make(true);
        }
    }
    
    public function alteration_received(Request $request){
        // echo $string; exit;
        if($request->ajax()){
            $supplier=$request->supplier_id;
            $records=DB::table('item_return')
                        ->join('alteration_item_received','alteration_item_received.item_return_id','=','item_return.id')
                        ->join('product_info','product_info.variation_id','=','item_return.variation_id')
                        ->join('product_size','product_size.id','=','product_info.prod_size')
                        ->LeftJoin('users','users.id','=','item_return.user_id')
                        ->LeftJoin('suppliers','suppliers.id','=','item_return.supplier_id')
                        ->where('item_return.supplier_id',$supplier)
                        ->where('return_check',$request->type)
                        ->where('item_return.status',0)
                        ->select([
                            'item_return.*',
                            'alteration_item_received.receive_qty',
                            'alteration_item_received.receiving_qty',
                            'alteration_item_received.id as alteration_item_id',
                            'users.name',
                            'product_size.size',
                            'suppliers.supplier_name',
                            'product_info.prod_img',
                            'product_info.product_url',
                            'product_info.product_name',
                            'product_info.Quantity',
                        ]);
            
            
            return  Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('productDetail',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
                        }

                        $detail='
                        <div class="row">
                            <div class="col-md-3">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                    '.$img.'
                                </a>
                            </div>
                            <div class="col-md-9">
                                '.$data->product_name.'<br>
                                <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                <span style="color:#D35400">Size : <strong>'.$data->size.'</strong></span>
                            </div>
                        </div>';

                        return $detail;
                    })
                    ->filterColumn('productDetail',function($query,$keyword){
                        $query->orWhereRaw("item_return.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info.product_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('productDetail', function ($query, $order) {
                        $query->orderBy('item_return.variation_id', $order);
                        $query->orderBy('product_info.product_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                        })
                    ->filterColumn('created_at',function($query,$keyword){
                        $keyword=date('Y-m-d',strtotime($keyword));
                        $query->orWhereRaw("item_return.created_date LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('created_at', function ($query, $order) {
                        $query->orderBy('item_return.created_date', $order);
                    })
                    ->addColumn('receiving_input',function($data){
                        if($data->receiving_qty==$data->receive_qty){
                            $disabled='disabled';
                        }else{
                            $disabled='';
                        }
                        $hidden='
                            <input type="hidden" id="assignid_'.$data->id.'" name="id" value="'.$data->id.'" class="form-control form-control-sm has-success"/>
                            <input type="hidden" id="alterid_'.$data->id.'" name="id" value="'.$data->alteration_item_id.'" class="form-control form-control-sm has-success"/>

                            <input type="hidden" id="variation_id_'.$data->id.'" name="id" value="'.$data->variation_id.'" class="form-control form-control-sm has-success"/>
                            <input type="text" class="form-control form-control-sm has-success" id="receiving_qty_'.$data->id.'" name="receiving_qty" placeholder="0" '.$disabled.'/>
                            <span id="error_'.$data->id.'" class="text-danger text-sm" style="display:none"></span>';
                            
                        return $hidden;

                    })
                    ->addColumn('action', function($data){
                        if($data->receiving_qty==$data->receive_qty){
                            $receiving='';
                        }else{
                            $receiving='<button class="btn btn-info btn-sm received_btn" id="submit_'.$data->id.'"><i class="fab fa-get-pocket"></i> Received</button><br>';
                        }
                        
                        
                        return $receiving;

                    })
                    ->addColumn('remaining', function($data){
                        $sub=(int)$data->receive_qty-(int)$data->receiving_qty;
                        return $sub;
                    })
                    ->rawColumns(['created_at','productDetail','receiving_input','action','remaining'])
                    ->make(true);


        }else{
            $suppliers=Supplier::latest()->get();
            return view('item_alter.received',['suppliers' => $suppliers]);
            
        }
    }

    public function alter_receive(Request $request){
        // dd($request->all());
        $input = $request->all();
        $item_return=DB::table('item_return')->where('id', $input['id'])->first();
        // dd($item_return);
        $sku=Sku::where('variation_id',$input['variation_id'])->first();
        $receiving_qty=(int)$input['old_rec']+$input['receive_qty'];
        if($item_return->supplier_id =='1'){
            $qty=$sku->Quantity;
            $qty=(int)$qty-$input['receive_qty'];
            Sku::where('variation_id',$input['variation_id'])->update(['Quantity' => ($qty<0)?0:$qty]);
        }else{
            $qty=$sku->Quantity;
            $qty=(int)$qty+(int)$input['receive_qty'];
            Sku::where('variation_id',$input['variation_id'])->update(['Quantity' => ($qty<0)?0:$qty]);
        }

        $insert_log=[
            'variation_id' => $input['variation_id'],
            'quantity' => $input['receive_qty'],
            'return_check' => 'Alteration Item Receive',
            'supplier_id' => $item_return->supplier_id,
            'user_id' => auth()->user()->id,
            'created_date' => date('Y-m-d H:i:s'),
        ];

        DB::table('item_return_log')->insert($insert_log);

        $response=DB::table('alteration_item_received')
                ->where('id', $input['alter_id'])
                ->update([
                    'receiving_qty' => $receiving_qty,
                    'received_date' => date('Y-m-d H:i:s'),
                    'received_by' => auth()->user()->id
                ]);
        
        if($item_return->quantity ==$receiving_qty){
            $response=DB::table('item_return')
                ->where('id', $input['id'])
                ->update(['status' => 1]);

            $response=DB::table('alteration_item_received')
                ->where('id', $input['alter_id'])
                ->update([
                    'status' => 1,
                    'received_date' => date('Y-m-d H:i:s'),
                    'received_by' => auth()->user()->id
                ]);
        }
        echo $response;
    }
}
