<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Models\Sku;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class InventoryController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:inventory-summary', ['only' => ['index']]);
    }
    
    public function index(Request $request,$string){
        if($request->ajax()){
            // $records=Sku::groupBy('group_id')
            //                 ->join('type_images','type_images.code','=','product_info.group_id')
            //                 ->select(['product_name','prod_img','product_url','group_id','type_images.image']);
            $columns = array( 0 =>'productDetail');
            $totalData = Sku::groupBy('group_id')->where('prod_status','=','1')->where('is_deleted',0)->count();
            $totalFiltered = $totalData; 
            $limit = $request->input('length');
            $start = $request->input('start');
            // $order = $columns[$request->input('order.0.column')];
            // $dir = $request->input('order.0.dir');
            
            if(empty($request->input('search.value'))){            
                $skus = Sku::groupBy('group_id')->where('prod_status','=','1')->where('is_deleted',0);
                            // ->offset($start)
                            // ->limit($limit)
                        //  ->orderBy($order,$dir);
                        //  ->get();
            }else {
                $search = $request->input('search.value'); 

                $skus =  Sku::where('prod_status','=','1')->where('is_deleted',0)->where(function($query) use (&$search){
                                $query->where('product_name','LIKE',"%{$search}%")
                                    ->orWhere('variation_id','LIKE',"%{$search}%");
                            })
                            ->groupBy('group_id');
                            // ->offset($start)
                            // ->limit($limit)
                            // ->orderBy($order,$dir);
                            // ->get();

                $totalFiltered = Sku::where('prod_status','=','1')->where('product_name','LIKE',"%{$search}%")->orWhere('variation_id','LIKE',"%{$search}%")
                             ->groupBy('group_id')
                             ->count();
            }
            
            if($limit !='-1'){
                $skus->offset($start)->limit($limit);
            }
            
            
            
            $data = array();
            $product_size=DB::table('product_size')->where('status',1)->get();
            if(!empty($skus->get())){
                foreach ($skus->get() as $sku){
                    $nestedData=array();
                    $total=0;
                    if($sku->product_url !=''){
                        $url=$sku->product_url;
                        $img=' <img src="'.$sku->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">';
                    }else{
                        $url=asset('uploads/sku_images/'.$sku->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$sku->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">';
                    }
                    
                    $style='style="display:none"';
                    if(auth()->user()->can('item-adjust')){
                        $style='';
                    }
                    $sp=explode(",",$sku->product_name);
                    $nestedData['productDetail']='
                        <div class="row">
                            <div class="col-md-2">
                                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image" id="product_img_'.$sku->group_id.'">
                                    '.$img.'
                                </a>
                            </div>
                            
                            <div class="col-md-8">
                                '.'<strong id="product_name_'.$sku->group_id.'">'.$sp[0].'</strong>'.'<br>
                                <span class="text-success">SKU : <strong>'.$sku->group_id.'</strong></span>
                                <a href="javascript:;" id="item_adjust_'.$sku->group_id.'" data-group_id="'.$sku->group_id.'" class="float-right btn btn-info btn-sm item_adjust m-1" '.$style.'> Item Adjust</a>
                                <a href="javascript:;" id="stock_switch_'.$sku->group_id.'" data-group_id="'.$sku->group_id.'" class="float-right btn btn-primary btn-sm stock_switch m-1" '.$style.'> Stock Switch</a>
                            
                            </div>
                        </div>';
                    foreach($product_size as $ps){
                        $check=Sku::where([
                                    'group_id' => $sku->group_id,
                                    'prod_size' => $ps->id,
                                ])->first();
                        
                        if($check !==null){
                            $qty=($string=='decrum')?$check->Quantity:$check->uc_quantity;
                        }else{
                            $qty=0;
                        }
                        $total+=$qty;
                        $nestedData[$ps->size]=$qty;
                    }
                    
                    $nestedData['total']=$total;
                    $data[] = $nestedData;
    
                }
            }
            
            $json_data = array(
                "draw"            => intval($request->input('draw')),  
                "recordsTotal"    => intval($totalData),  
                "recordsFiltered" => intval($totalFiltered), 
                "data"            => $data   
                );
            echo json_encode($json_data);
        }else{
            if(in_array($string,['decrum','urban'])){
                $reasons=DB::table('damage_reason')->get();
                $stores = DB::table('store')->whereIn('id',[1,4,6])->get();
                $product_size=DB::table('product_size')->where('status',1)->get();
                return view('inventory.indexb',['product_sizes' => $product_size,'reasons' =>$reasons,'stores' => $stores,'string' => $string]); 
            }else{
                return abort(404);
            }
            
        }
    }
    
    public function export_opening_stock(Request $request){
        $file_name = 'opening_stock_'.date('d_m_Y'); 
        $skus=DB::table('type_images')
                ->leftJoin('product_info','product_info.group_id','=','type_images.code')
                ->groupBy('product_info.group_id')
                ->where('product_info.prod_status',1)->select(['type_images.code','product_info.product_name'])->get();
        
        $spreadsheet = new Spreadsheet();
        $spreadsheet->setActiveSheetIndex(0);
        $sheet = $spreadsheet->getActiveSheet();
        
        $sheet->setCellValue('A1', 'SKU');
        $sheet->setCellValue('B1', 'Product_Name');
        $sheet->setCellValue('C1', 'XS');
        $sheet->setCellValue('D1', 'S');
        $sheet->setCellValue('E1', 'M');
        $sheet->setCellValue('F1', 'L');
        $sheet->setCellValue('G1', 'XL');
        $sheet->setCellValue('H1', '2XL');
        $sheet->setCellValue('I1', '3XL');
        
        $rowCount=2;
        
        foreach($skus as $sku){
            $product_name=explode(',',$sku->product_name);
            $sheet->setCellValue('A'.$rowCount, $sku->code);
            $sheet->setCellValue('B'.$rowCount, $product_name[0]);
            $sheet->setCellValue('C'.$rowCount, 0);
            $sheet->setCellValue('D'.$rowCount, 0);
            $sheet->setCellValue('E'.$rowCount, 0);
            $sheet->setCellValue('F'.$rowCount, 0);
            $sheet->setCellValue('G'.$rowCount, 0);
            $sheet->setCellValue('H'.$rowCount, 0);
            $sheet->setCellValue('I'.$rowCount, 0);
            $rowCount++;
        }
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
    
    public function upload_opening(Request $request){
        if($request->ajax()){
            
            if ($request->hasFile('file_img')) {
                $image = $request->file('file_img');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/upload_excel');
                $image->move($destinationPath, $name);
                $original_name=$image->getClientOriginalName();
                
                
                
                $this->excel_log($name,$original_name,1,1);
                
                $extension=$image->getClientOriginalExtension();
                if($extension == 'csv'){
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
                } elseif($extension == 'xlsx') {
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                } else {
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
                }
                
                $spreadsheet = $reader->load(public_path('/uploads/upload_excel/'.$name));
                $allDataInSheet = $spreadsheet->getActiveSheet();
                $lastRow = $allDataInSheet->getHighestRow();
                
                $newarray=$spreadsheet->getActiveSheet()->toArray();
                unset($newarray[0]);
                $array = array_values($newarray);
                
                // dd($array);
                
                $validatedData = \Validator::make($array, [
                    '*.0' => 'required',
                    '*.1' => 'required',
                    '*.2' => 'required|numeric|min:0',
                ]);
                
                if($validatedData->fails()){
                    return response()->json([
                        'error' => 1,
                        'message' => 'Error ! <br> 
                                <strong>SKU And Product Name is Required and Size is Also Required Only Numbers Allowed or Minimum Zero</strong>',
                    ], 200);
                }
                
                $string=$request->store_string;
                
                if($string =='decrum'){
                    $column='Quantity';
                    $whName='OTWHBULK';
                    $store_id=5;
                }else{
                    $column='uc_quantity';
                    $whName='OTUCWHBULK';
                    $store_id=11;
                }
                
                $po_serial=$this->get_sup_po_no(1);
                $pr_id_other=date('dmy').$whName;
                $po_id=$pr_id_other.'-'.$po_serial;
                
                // dd($column);
                
                //for inventory upload
                // DB::table('product_info')->update([$column => 0]);
                
                
                for ($row = 2; $row <= $lastRow; $row++) {
                    
                    $variation_id=trim($allDataInSheet->getCell('A'.$row)->getValue());
                    $product_title=trim($allDataInSheet->getCell('B'.$row)->getValue());
                    $qty=trim($allDataInSheet->getCell('C'.$row)->getValue());
                        
                    $where=['variation_id' => $variation_id];
                    
                    
                    //for inventory upload    
                    // $product_info=DB::table('product_info')->where($where)->get();
                        
                    // if($product_info->count()>0){
                    //     $row22=$product_info->first();
                    //     DB::table('product_info')->where($where)->update([$column => ($qty <=0)?0:$qty]);
                    // }
                    
                    
                    //for assign quantity
                    $size = substr($variation_id, -1);
                    $group_id = substr($variation_id, 0, -1);
                    $insert22=[
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_id,
                        'main_type' => $group_id,
                        'prod_size' => $size,
                        'in_stock' =>  $qty,
                        'supplier_id' => 1,
                        'assign_date' => date('Y-m-d'),
                        'order_qty_given' => $qty,
                        'receive_qty' => $qty,
                        'pr_id' => $pr_id_other,
                        'po_id' => $po_id,
                    ];
                    $response=\DB::table('assign_quantity')->insert($insert22);
                }
                return response()->json(['error'=> 0,'message' => 'Excel Uploaded Successfully']);
                
            }
            
        }
    }
    
    public function upload_opening_copy(Request $request){
        if($request->ajax()){
            if ($request->hasFile('file_img')) {
                $image = $request->file('file_img');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/upload_excel');
                $image->move($destinationPath, $name);
                $original_name=$image->getClientOriginalName();
                
                $this->excel_log($name,$original_name,1,1);
                
                $extension=$image->getClientOriginalExtension();
                if($extension == 'csv'){
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
                } elseif($extension == 'xlsx') {
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                } else {
                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
                }
                
                $spreadsheet = $reader->load(public_path('/uploads/upload_excel/'.$name));
                $allDataInSheet = $spreadsheet->getActiveSheet();
                $lastRow = $allDataInSheet->getHighestRow();
                
                $newarray=$spreadsheet->getActiveSheet()->toArray();
                unset($newarray[0]);
                $array = array_values($newarray);
                // dd($array);
                $validatedData = \Validator::make($array, [
                    '*.0' => 'required',
                    '*.1' => 'required',
                    '*.2' => 'required|numeric|min:0',
                    '*.3' => 'required|numeric|min:0',
                    '*.4' => 'required|numeric|min:0',
                    '*.5' => 'required|numeric|min:0',
                    '*.6' => 'required|numeric|min:0',
                    '*.7' => 'required|numeric|min:0',
                    '*.8' => 'required|numeric|min:0',
                ]);
                
                if($validatedData->fails()){
                    return response()->json([
                        'error' => 1,
                        'message' => 'Error ! <br> 
                                <strong>SKU And Product Name is Required and Size is Also Required Only Numbers Allowed or Minimum Zero</strong>',
                    ], 200);
                }
                $sizes=DB::table('product_size')->where('status',1)->get();
                
                for ($row = 2; $row <= $lastRow; $row++) {
                    
                    $group_id=trim($allDataInSheet->getCell('A'.$row)->getValue());
                    $xs=trim($allDataInSheet->getCell('C'.$row)->getValue());
                    $s=trim($allDataInSheet->getCell('D'.$row)->getValue());
                    $m=trim($allDataInSheet->getCell('E'.$row)->getValue());
                    $l=trim($allDataInSheet->getCell('F'.$row)->getValue());
                    $xl=trim($allDataInSheet->getCell('G'.$row)->getValue());
                    $xxl=trim($allDataInSheet->getCell('H'.$row)->getValue());
                    $xxxl=trim($allDataInSheet->getCell('I'.$row)->getValue());
                    
                    foreach ($sizes as $size){
                        $variation_id=$group_id.$size->id;
                        if($size->size=='XS'){$qty=$xs;}
                        elseif($size->size=='S'){$qty=$s;}
                        elseif($size->size=='M'){$qty=$m;}
                        elseif($size->size=='L'){$qty=$l;}
                        elseif($size->size=='XL'){$qty=$xl;}
                        elseif($size->size=='XXL'){$qty=$xxl;}
                        elseif($size->size=='3XL'){$qty=$xxxl;}
                        
                        $where=['variation_id' => $variation_id];
                        
                        $product_info=DB::table('product_info')->where($where)->get();
                        
                        if($product_info->count()>0){
                            $row22=$product_info->first();
                            
                            $qty2=$row22->Quantity;
                            if($qty !=0){
                                $qty +=$qty2;
                                DB::table('product_info')->where($where)->update(['Quantity' => ($qty <=0)?0:$qty]);
                            }
                        }
                    }
                }
                
                return response()->json(['error'=> 0,'message' => 'Excel Uploaded Successfully']);
                
            }
            
        }
    }
    
    public function excel_log($name,$original_name,$store_id,$shipment_type){
        $insert_excel=[
            'file_name' => $name,
            'original_name' => $original_name,
            'type' => '1',
            'type_name' => 'Inventory Opening Upload',
            'status' => '1',
            'uploaded_by' => auth()->user()->id,
            'upload_date' => date('Y-m-d'),
            'store_id' => $store_id,
            'shipment_type' => $shipment_type
        ];
        $insert_data=DB::table('upload_excel')->insert($insert_excel);
    }
    
    
    public function sku_detail_on(Request $request){
        if($request->ajax()){
            $group_id=$request->group_id;
            $product_info=DB::table('product_info')->where('group_id',$group_id)->get();
            
            $string=$request->string;
            
            $html='';
            if($product_info->count()>0){
                $row=$product_info->first();
                if($row->product_url !=''){
                    $url=$row->product_url;
                    $img=' <img src="'.$row->product_url.'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">';
                }else{
                    $url=asset('uploads/sku_images/'.$row->prod_img);
                    $img='<img src="'.asset('uploads/sku_images/'.$row->prod_img).'" class="rounded img-thumbnail" alt="Cinque Terre" width="50" height="50">';
                }
                $sp=explode(",",$row->product_name);
                $html.='
                <div class="row">
                    <div class="col-md-2">
                        <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                            '.$img.'
                        </a>
                    </div>
                    <div class="col-md-8">
                        '.'<strong>'.$sp[0].'</strong>'.'<br>
                        <span class="text-success">SKU : <strong>'.$row->group_id.'</strong></span>
                    </div>
                </div>';
                $select_html='<option value="">Select Size</option>';
                foreach($product_info as $pf){
                    $sp=explode(",",$pf->product_name);
                    
                    if($string =='decrum'){
                        $qp=$pf->Quantity;
                    }else{
                        $qp=$pf->uc_quantity;
                    }
                    
                    $html.='<strong class="text-success">'.$sp[1].'</strong> : '.$qp.'&nbsp;&nbsp;&nbsp;';
                    
                    $select_html.='<option value="'.$pf->variation_id.'" data-Quantity="'.$qp.'">'.$sp[1].'</option>';
                }
            }
            
            return response()->json(['success' => 1,'html' => $html,'select_html' => $select_html]);
        }
    }
    
    public function get_sup_po_no($supplier){
        $check=\DB::table('suppliers')->where('id',$supplier)->get();
        $ponumber='';
        if($check->count()>0){
            $row=$check->first();
            $today=strtotime(date("Y-m-d"));
            $update_date= strtotime($row->sup_po_no_date);
            
            $datediff = $today - $update_date;
            $difference = floor($datediff/(60*60*24));
            if($difference==0){
                $serial=$row->sup_po_no;
                $ponumber=$row->short_name.$serial;
            }else{
                $serial=(int)$row->sup_po_no+1;
                $ponumber=$row->short_name.$serial;
               
                $update_re=[
                    'sup_po_no' => $serial,
                    'sup_po_no_date' => date('Y-m-d')
                ];
                
                \DB::table('suppliers')->where('id',$supplier)->update($update_re);
            }
        }
        return $ponumber;
    }
    
    public function po_number($store_id,$shipment_type,$bulk_po='NO'){
        $store_data=DB::table('store')->where('id','5')->first();
        // if($bulk_po !='NO'){
        //     $po_name=date('dmy').$store_data->short_name.'BULK';
        // }else{
        //     if($shipment_type=='1'){
        //         $cargo='AIR';
        //     }elseif($shipment_type=='2'){
        //         $cargo='SEA';
        //     }
        //     $po_name=date('dmy').$store_data->short_name.$cargo;
        // }
        
        if($store_id ==5){
            $po_name=date('dmy').'OTBULK';
        }else{
            $po_name=date('dmy').'OTUCBULK';
        }
        
        
            // $po_name.='BULK';
        // }
        
        // echo $po_name;exit;
        
        
        $where=array('prefix_pr' => $po_name);
        $get_pr=DB::table('pr_data')->where($where)->get();
        
        if(count($get_pr)>0){
            if(count($get_pr)>1){
                $count=count($get_pr)+1;
                $pr_id=$po_name.'-'.($count-1);
            }else{
                $pr_id=$po_name.'-1';
            }
    
            $in_pr_data=[
                'pr_name' => $pr_id,
                'store_id' => $store_id,
                'shipment_type' => $shipment_type,
                'created_date' => date('Y-m-d H:i:s'),
                'user_id' => auth()->user()->id,
                'prefix_pr' => $po_name
            ];
            $ac_prId=$pr_id;
    
        }else{
            $in_pr_data=[
                'pr_name' => $po_name,
                'store_id' => $store_id,
                'shipment_type' => $shipment_type,
                'created_date' => date('Y-m-d H:i:s'),
                'user_id' => auth()->user()->id,
                'prefix_pr' => $po_name
            ];
            $ac_prId=$po_name;
        }
        $ins_id=DB::table('pr_data')->insertGetId($in_pr_data);
        
        return $ac_prId;
    }
    
    public function purchase_order($variation_design,$approve_qty,$store_id,$shipment_type,$pr_id,$bundle_set_variation=''){
        $explode=explode('-',$variation_design);
        $variation_id=$explode[0];
        
        $is_urgent=0;
        
        $split=str_split($variation_id);
        $prod_gender=$split[1];
        $prod_color=$split[count($split)-2];
        $prod_size=$split[count($split)-1];
        $prod_type=$split[2].$split[3].$split[4];
        $prod_type=str_replace('0','',$prod_type);
        
        $insert=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'given_qtn'=>$approve_qty,
            'approve_qtn' => $approve_qty,
            'is_urgent'=> 0,
            'created_by'=>auth()->user()->id,
            'pr_id' => $pr_id,
            'created_at' => date('Y-m-d H:i:s'),
            'prod_gender' => $prod_gender,
            'prod_type' => $prod_type,
            'prod_color' => $prod_color,
            'prod_size' => $prod_size,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type
        ];
        
        if($bundle_set_variation !=''){
            $insert['bundle_check']='1';
            $insert['bundle_set_variation']=$bundle_set_variation;
            $insert['bundle_total_qty']=$approve_qty;
        }

        $insert_data=DB::table('view_products_orders')->insert($insert);
        
        $where_qty1=[
            'variation_id' => $variation_id,
            'pr_id' => $pr_id,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type
        ];
                            
        $count2=DB::table('purchase_order_quantity')->where($where_qty1)->first();
                            
        if($count2 ==null){
            $insert_qty=[
                'variation_id' => $variation_id,
                'store_id' => $store_id,
                'pr_id' => $pr_id,
                'shipment_type' => $shipment_type ,
                'created_date' => date('Y-m-d H:i:s'),
                'created_by' => auth()->user()->id,
                'order_qty' => $approve_qty,
                'remaining_qty' => $approve_qty
            ];
            
            if($is_urgent !=0 && $is_urgent ==1){
                $insert_qty['is_urgent']=1;
            }
            
            DB::table('purchase_order_quantity')->insert($insert_qty);
        }else{
            $qty2=(int)$approve_qty + (int)$count2->order_qty;
            $update_qty=[
                'updated_date' => date('Y-m-d H:i:s'),
                'updated_by' => auth()->user()->id,
                'order_qty' => $qty2,
                'remaining_qty' => $qty2
            ];
            if($is_urgent !=0 && $is_urgent ==1){
                $update_qty['is_urgent']=1;
            }
            DB::table('purchase_order_quantity')->where($where_qty1)->update($update_qty);
        }
    }
    
    public function process_order($variation_design,$approve_qty,$store_id,$shipment_type,$pr_id){
        $explode=explode('-',$variation_design);
        $variation_id=$explode[0];
        $is_urgent=0;
        $insert_process=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'approve_qty' => $approve_qty,
            'given_qty' => $approve_qty,
            'urgent_status' => $is_urgent,
            'processed_status' => 0,
            'pr_id' =>$pr_id,
            'user_id' => auth()->user()->id,
            'created_date' => date('Y-m-d H:i:s'),
            'store_id' => $store_id,
            'shipment_type' => $shipment_type
        ];
                            
        DB::table('process_orders')->insert($insert_process);
        
        $where_qty=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type,
            'status' => 0
        ];
                            
        $count1=DB::table('process_order_quantity')->where($where_qty)->first();
        
        if($count1 ==null){
            $insert_qty=[
                'variation_id' => $variation_id,
                'variation_design' => $variation_design,
                'store_id' => $store_id,
                'shipment_type' => $shipment_type ,
                'created_date' => date('Y-m-d H:i:s'),
                'created_by' => auth()->user()->id,
                'process_qty' => $approve_qty,
                'receiving_qty' => $approve_qty,
            ];
            
            DB::table('process_order_quantity')->insert($insert_qty);
        }else{
            $qty2=(int)$approve_qty + (int)$count1->process_qty;
            $qty3=(int)$approve_qty + (int)$count1->receiving_qty;
            $update_qty=[
                'updated_date' => date('Y-m-d H:i:s'),
                'updated_by' => auth()->user()->id,
                'process_qty' => $qty2,
                'receiving_qty' => $qty3
            ];
            DB::table('process_order_quantity')->where($where_qty)->update($update_qty);
        }
    }
    
    public function item_adjust(Request $request){
        if($request->ajax()){
            if(auth()->user()->id ==26){
                // dd($request->all());
            }
            
            
            $variation_id=$request->product_size;
            $reason_id=$request->reason_id;
            $item_adjust=$request->item_adjust;
            $stock_type=$request->stock_type;
            $commments=$request->comments;
            $received_inhouse=$request->received_inhouse;
            $issued_po=$request->issued_po;
            
            $string=$request->store_string;
            // $store_id=$request->store;
            // $shipment_type=$request->shipment_type;
            
            $product_info=DB::table('product_info')->where('variation_id',$variation_id)->first();
            
            //added by sufian 26-3-24
            if($string =='decrum'){
                $qty=$product_info->Quantity;
                $old_stock=$product_info->Quantity;
                $col='Quantity';
                $whName='OTWHBULK';
                $store_id=5;
            }else{
                $qty=$product_info->uc_quantity;
                $old_stock=$product_info->uc_quantity;
                $col='uc_quantity';
                $whName='OTUCWHBULK';
                $store_id=11;
            }
            
            if($stock_type=='Add'){
                $qty+=$item_adjust;
            }else if($stock_type=='Minus'){
                $qty-=$item_adjust;
                
                $this->assign_quantity_minus($variation_id,$item_adjust,$commments,$product_info,$string);
            }
            
            // dd($item_adjust);
            
            DB::table('product_info')->where('variation_id',$variation_id)->update([$col => ($qty<=0)?0:$qty]);
            
            $insert=[
                'variation_id' => $variation_id,
                'product_info_id' => $product_info->id,
                'reason_id' => $reason_id,
                'quantity'=>$item_adjust,
                'old_stock' => $old_stock,
                'new_stock' => $qty,
                'user_id' => auth()->user()->id,
                'created_date' => date('Y-m-d H:i:s'),
                'reason_name' => $request->reason_name,
                'comments' => $commments,
                'stock_type' => $stock_type
            ];
            
            if($received_inhouse =='YES' && $stock_type=='Add'){
                $po_serial=$this->get_sup_po_no(1);
                $pr_id_other=date('dmy').$whName;
                $po_id=$pr_id_other.'-'.$po_serial;
                $insert22=[
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_id,
                    'main_type' => $product_info->group_id,
                    'prod_size' => $product_info->prod_size,
                    'in_stock' =>  $old_stock,
                    'supplier_id' => 1,
                    'assign_date' => date('Y-m-d'),
                    'order_qty_given' => $item_adjust,
                    'receive_qty' => $item_adjust,
                    'pr_id' => $pr_id_other,
                    'po_id' => $po_id,
                ];
                
                
                $response=\DB::table('assign_quantity')->insert($insert22);
                
                $insert_log=[
                    'variation_id' => $variation_id,
                    'pr_id' => $pr_id_other,
                    'given_qty' => $item_adjust,
                    'supplier_id' =>1,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'Received InHouse WH from Item Adjust ('.$string.')',
                    'created_date' => date('Y-m-d H:i:s')
                ];
                // dd($insert_log);
                
                $insert_data=DB::table('item_log')->insert($insert_log);
            }
            
            if($issued_po =='YES' && $stock_type!='Add'){
                $pr_id=$this->po_number($store_id,1,'NO');
                $this->purchase_order($variation_id,$item_adjust,$store_id,1,$pr_id);
                // $this->process_order($variation_id,$item_adjust,$store_id,$shipment_type,$pr_id);
            }
            // dd($request->all());
            
            $html='<p style="text-align:center;font-weight:bold">'.ucfirst($string).' Inventory Adjustment Notification</p>
                    <p>
                        
                    <table style="width: 100%;border-collapse: collapse;border:1px solid black">
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Variation ID</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.$variation_id.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Adjust Qty</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.$item_adjust.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Old Stock</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.$old_stock.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>New Stock</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black"> '.$qty.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Created Date</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.date('Y-m-d H:i:s').'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Reason Name</strong></td >
                            <td style="border-collapse: collapse;border:1px solid black">'.$request->reason_name.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Stock Type</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.$stock_type.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Created By </strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.auth()->user()->name.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>comments </strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.$commments.'</td>
                        </tr>
                    </table>
                    </p>
                    <br>';
                    \Mail::html($html, function ($message){
                        if(auth()->user()->id ==26){
                            $to=['smsufian.esire@gmail.com'];
                        }else{
                            $to=['smsufian.esire@gmail.com','abdulrehman.esire@gmail.com','ahad.esire@gmail.com','danishppatel@gmail.com'];
                        }
                        
                        $message->to($to)->subject("Inventory Adjustment Notification in Miniopex");
                    });

            DB::table('item_adjustment')->insert($insert);
            return response()->json(['success' => 1,'message' => 'Item Adjust Successfully']);
        }
    }
    
    public function stock_adjust(Request $request){
        if($request->ajax()){
            if(auth()->user()->id ==26){
                // dd($request->all());
            }
            
            
            $variation_id=$request->product_size;
            $item_adjust=$request->stock_adjust;
            $stock_type='Add';
            $commments=$request->comments;
            $received_inhouse=$request->received_inhouse;
            $string=$request->store_string;
            // $store_id=$request->store;
            // $shipment_type=$request->shipment_type;
            
            $product_info=DB::table('product_info')->where('variation_id',$variation_id)->first();
            
            $decrum_qty=$product_info->Quantity;
            $uc_qty=$product_info->uc_quantity;
            
            
            //added by sufian 26-3-24
            if($string =='decrum'){
                $switch_store= 'Urban';
                $whName='OTUCWHBULK';
                
                $old_stock=$decrum_qty;
                $decrum_qty-=$item_adjust;
                $uc_qty+=$item_adjust;
            }else{
                $switch_store='Decrum';
                $whName='OTWHBULK';
                $old_stock=$uc_qty;
                $decrum_qty+=$item_adjust;
                $uc_qty-=$item_adjust;
                
            }
            
            $this->assign_quantity_minus($variation_id,$item_adjust,$commments,$product_info,$string);
            
            $update_arr=[
                'Quantity' => ($decrum_qty<=0)?0:$decrum_qty,
                'uc_quantity' => ($uc_qty<=0)?0:$uc_qty
            ];
            
            DB::table('product_info')->where('variation_id',$variation_id)->update($update_arr);
            
            $insert=[
                'variation_id' => $variation_id,
                'product_info_id' => $product_info->id,
                'reason_id' => 9,
                'quantity'=>$item_adjust,
                'old_stock' => $old_stock,
                'new_stock' => ($string =='decrum')?$decrum_qty:$uc_qty,
                'user_id' => auth()->user()->id,
                'created_date' => date('Y-m-d H:i:s'),
                'reason_name' => 'Stock Switch',
                'comments' => $commments,
                'stock_type' => $stock_type
            ];
            
            if($received_inhouse =='YES' && $stock_type=='Add'){
                $po_serial=$this->get_sup_po_no(1);
                $pr_id_other=date('dmy').$whName;
                $po_id=$pr_id_other.'-'.$po_serial;
                $insert22=[
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_id,
                    'main_type' => $product_info->group_id,
                    'prod_size' => $product_info->prod_size,
                    'in_stock' =>  $old_stock,
                    'supplier_id' => 1,
                    'assign_date' => date('Y-m-d'),
                    'order_qty_given' => $item_adjust,
                    'receive_qty' => $item_adjust,
                    'pr_id' => $pr_id_other,
                    'po_id' => $po_id,
                ];
                
                
                $response=\DB::table('assign_quantity')->insert($insert22);
                
                $insert_log=[
                    'variation_id' => $variation_id,
                    'pr_id' => $pr_id_other,
                    'given_qty' => $item_adjust,
                    'supplier_id' =>1,
                    'user_id' => auth()->user()->id,
                    'type_name' => 'Received  in '.$switch_store.' InHouse WH from '.$string.' Stock',
                    'created_date' => date('Y-m-d H:i:s')
                ];
                // dd($insert_log);
                
                $insert_data=DB::table('item_log')->insert($insert_log);
            }
            
            $html='<p style="text-align:center;font-weight:bold">Stock Switch Notification</p>
                    <p>
                        
                    <table style="width: 100%;border-collapse: collapse;border:1px solid black">
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Variation ID</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.$variation_id.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Given Qty</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.$item_adjust.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Old Stock</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.$old_stock.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>New Stock</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black"> '.(($string =='decrum')?$decrum_qty:$uc_qty).'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Created Date</strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.date('Y-m-d H:i:s').'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Reason Name</strong></td >
                            <td style="border-collapse: collapse;border:1px solid black">Stock Switch from '.$string.' to '.$switch_store.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>Created By </strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.auth()->user()->name.'</td>
                        </tr>
                        <tr>
                            <td style="border-collapse: collapse;border:1px solid black"><strong>comments </strong></td>
                            <td style="border-collapse: collapse;border:1px solid black">'.$commments.'</td>
                        </tr>
                    </table>
                    </p>
                    <br>';
                    \Mail::html($html, function ($message){
                        if(auth()->user()->id ==26){
                            $to=['smsufian.esire@gmail.com'];
                        }else{
                            $to=['smsufian.esire@gmail.com','abdulrehman.esire@gmail.com','ahad.esire@gmail.com','danishppatel@gmail.com'];
                        }
                        
                        $message->to($to)->subject("Stock Switch Notification in Miniopex");
                    });

            DB::table('item_adjustment')->insert($insert);
            return response()->json(['success' => 1,'message' => 'Stock Switch Successfully']);
        }
    }
    
    public function assign_quantity_minus_copy($variation_id,$qty){
        $list=DB::table('assign_quantity')
                    ->where('variation_id',$variation_id)
                    ->where('status',0)
                    ->where('supplier_id',1)
                    ->select(['receive_qty','receiving_qty','id'])->get();
        // dd($list);
        $actual_qty=$qty;
        $aaqty=0;
        
        $count=1;
        
        if($list->count()>0){
            foreach ($list as $record){
                $receive_qty=$record->receive_qty;
                $receiving_qty=$record->receiving_qty;
                
                $remaining=(int)$receive_qty-(int)$receiving_qty;
                // if($count==2){
                //     dd($q);
                // }
                // dd($remaining);
                
                if($qty<=$remaining){
                    $up_qty=$qty;
                    $qty=0;
                }else{
                    $up_qty=$remaining;
                    $qty=(int)$qty - (int)$remaining;
                }
                
                // if($count==2){
                //     dd($qty);
                // }
                
                // dd($qty);
                
                $actual_rec=(int)$receiving_qty + (int)$up_qty;
                $update_rec=['receiving_qty' =>  $actual_rec,'received_by' => auth()->user()->id, 'received_at'=>date('Y-m-d H:i:s')];
                
                $up=DB::table('assign_quantity')->where('id',$record->id);
                
                $up->update($update_rec);
                
                if($receive_qty==$actual_rec){
                    $up->update(['status' => 1]);
                }
                
                if($qty==0){
                    break;
                }
                $count++;
            }
        }
    }
    
    public function update_aq_minus($variation_id,$update_arr,$string){
        if($string=='decrum'){
            DB::table('assign_quantity')
                    ->where('variation_id',$variation_id)
                    ->where('status',0)
                    ->where('supplier_id',1)
                    ->where('pr_id','NOT LIKE','%UC%')
                    ->update($update_arr);
        }else{
            DB::table('assign_quantity')
                    ->where('variation_id',$variation_id)
                    ->where('status',0)
                    ->where('supplier_id',1)
                    ->where('pr_id','LIKE','%UC%')
                    ->update($update_arr);
        }
        
    }
    
    public function assign_quantity_minus($variation_id,$qty,$comments,$product_info,$string){
        if($string=='decrum'){
            $list=DB::table('assign_quantity')
                    ->where('variation_id',$variation_id)
                    ->where('status',0)
                    ->where('supplier_id',1)
                    ->where('pr_id','NOT LIKE','%UC%')
                    ->select([
                        DB::raw('sum(receive_qty) as receive_qty'),
                        DB::raw('sum(receiving_qty) as receiving_qty')])->get();
            $whName='OTREWHBULK';
            $in_stock=$product_info->Quantity;
        }else{
            $list=DB::table('assign_quantity')
                    ->where('variation_id',$variation_id)
                    ->where('status',0)
                    ->where('supplier_id',1)
                    ->where('pr_id','LIKE','%UC%')
                    ->select([
                        DB::raw('sum(receive_qty) as receive_qty'),
                        DB::raw('sum(receiving_qty) as receiving_qty')])->get();
            $whName='OTUCREWHBULK';
            $in_stock=$product_info->uc_quantity;
        }
        
        
        // dd($list[0]->receive_qty);
                        
        
        if($list->count()>0 && $list[0]->receive_qty !=NULL){
            $li=$list->first();
            $receive_qty=$li->receive_qty;
            $receiving_qty=$li->receiving_qty;
                
            $remaining=(int)$receive_qty-(int)$receiving_qty;
            if($remaining !=$qty){
                $up_qty=(int)$remaining - (int)$qty;
                $update_arr=[
                    'status' => 1,
                    'comments' => $comments,
                    'is_cancelled' => 1,
                    'is_cancelled_by' => auth()->user()->id,
                    'is_cancelled_date' => date('Y-m-d')
                ];
                
                $this->update_aq_minus($variation_id,$update_arr,$string);
                
                if($up_qty >0){
                    $po_serial=$this->get_sup_po_no(1);
                    $pr_id_other=date('dmy').$whName;
                    $po_id=$pr_id_other.'-'.$po_serial;
                    $insert22=[
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_id,
                        'main_type' => $product_info->group_id,
                        'prod_size' => $product_info->prod_size,
                        'in_stock' =>  $in_stock,
                        'supplier_id' => 1,
                        'assign_date' => date('Y-m-d'),
                        'order_qty_given' => $up_qty,
                        'receive_qty' => $up_qty,
                        'pr_id' => $pr_id_other,
                        'po_id' => $po_id,
                    ];
                    $response=\DB::table('assign_quantity')->insert($insert22); 
                }
                
                
                
                
            }else if($remaining ==$qty){
                $update_arr=[
                    'status' => 1,
                    'comments' => $comments,
                    'is_cancelled' => 1,
                    'is_cancelled_by' => auth()->user()->id,
                    'is_cancelled_date' => date('Y-m-d')
                ];
                
                $this->update_aq_minus($variation_id,$update_arr,$string);
            }
            
        }
        
        
        
    }
    
    public function variation_process_order(Request $request){
        if($request->ajax()){
            $variation_id=$request->variation_id;
            
            $where=[
                'variation_id' => $variation_id,
                'status' => 0
            ];
            
            $list=DB::table('process_order_quantity')->where($where)->get();
            
            $checked=0;
            if($list->count()>0){
                $checked=1;
            }
            
            $where=[
                'bundle_sets.variation_id' => $variation_id,
                'bundle_list_pr_wise.status' => 0
            ];
            $list=DB::table('bundle_list_pr_wise')
                ->join('bundle_sets','bundle_sets.bundle_set_variation','=','bundle_list_pr_wise.bundle_set_variation')
                ->where('bundle_sets.is_deleted',0)
                ->where($where)
                ->get();
                
            if($list->count()>0){
                $checked=1;
            }
            
            return response()->json(['code'=> 200,'checked' => $checked]);
        }
    }
    
    public function ExportNewInventory($string){
        if(!in_array($string,['decrum','urban'])){
            abort('404');
        }
        
        $title ='Inventory_'.$string;
        $file_name='inventory_'.$string.'_'.date('Y_m_d_h_i_s');
        
        $records= DB::table('product_info')->select('variation_id','product_name','Quantity','uc_quantity')
        ->where('prod_status',1)
        ->where('is_deleted',0)
        ->get();
        
        $objPHPExcel= new Spreadsheet();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
        $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
        $objPHPExcel->getActiveSheet()->getStyle("A2:G2")->getFont()->setBold(true);
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Variation Id');
        $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Product Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Quantity');
        
        
        if($records->count()>0){
            $counter=3;
            $sno=1;
            $total_qty=0;
            foreach($records as $row){
                
                if($string =='decrum'){
                    $quantity=$row->Quantity;
                }else{
                    $quantity=$row->uc_quantity;
                }
                
                $total_qty+=$quantity;

                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $row->variation_id);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->product_name);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $quantity);
                
                $counter++;
                $sno++;
            }
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, 'Total');
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $total_qty);
        }
        
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
}
