<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class HistoryController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        
    }
    
    public function  process_order2($pr_id){
        // $value='BULK';
        
        $total_qty=DB::table('process_orders')
                        ->where('pr_id',$pr_id)
                        ->select([
                            DB::raw('sum(approve_qty) as approve_qty'),
                            DB::raw('sum(given_qty) as given_qty'),
                            DB::raw('count(variation_design) as total_sku')
                        ])->first();
        $total_bundle_qty=DB::table('bundle_list_pr_wise')
                        ->where('pr_id',$pr_id)
                        ->select([
                            DB::raw('sum(approve_qty) as approve_qty'),
                            DB::raw('sum(given_qty) as given_qty'),
                            DB::raw('count(bundle_set_variation) as total_sku')
                        ])->first();
        
        $approve_qty=(int)$total_qty->approve_qty;
        $remaining_qty=(int)$total_qty->given_qty;
        $ready_to_ship=(int)$approve_qty - (int)$remaining_qty;
        $total_sku=(int)$total_qty->total_sku;
        
        $bundle_approve_qty=($total_bundle_qty->approve_qty !=NULL)?(int)$total_bundle_qty->approve_qty*3:0;
        $bundle_remaining_qty=($total_bundle_qty->given_qty !=NULL)?(int)$total_bundle_qty->given_qty*3:0;
        $bundle_ready_to_ship=(int)$bundle_approve_qty - (int)$remaining_qty;
        $total_bundle_sku=(int)($total_bundle_qty->total_sku !=NULL)?(int)$total_bundle_qty->total_sku*3:0;
        
        $approve_qty+=$bundle_approve_qty;
        $remaining_qty+=$bundle_remaining_qty;
        $ready_to_ship+=$bundle_ready_to_ship;
        $total_sku+=$total_bundle_sku;
        
        
        
        return [
                'approve_qty' => $approve_qty,
                'remaining_qty' => $remaining_qty, 
                'ready_to_ship' => ($ready_to_ship<0)?0:$ready_to_ship,
                'total_sku' => $total_sku
            ];
    }
    
    public function  process_order($pr_id){
        $value='BULK';
        // if(preg_match("/{$value}/i", strtolower($pr_id))) {
            $total_qty=DB::table('view_products_orders')
                        ->where('pr_id',$pr_id)
                        // ->where('bundle_check',0)
                        ->select([
                            DB::raw('sum(approve_qtn) as approve_qtn'),
                            DB::raw('sum(given_qtn) as given_qtn'),
                            DB::raw('count(variation_design) as total_sku')
                        ])->first();
            // $total_bundle_qty=DB::table('view_products_orders')
            //             ->groupBy('bundle_set_variation')
            //             ->where('pr_id',$pr_id)
            //             ->where('bundle_check',1)
            //             ->select([
            //               'approve_qtn','given_qtn','bundle_set_variation'
            //             ])->get();
            
            $approve_qty=(int)$total_qty->approve_qtn;
            $remaining_qty=(int)$total_qty->approve_qtn;
            
            $total_sku=(int)$total_qty->total_sku;
            
            // if($total_bundle_qty->count()>0){
            //     $count=0;
            //     foreach ($total_bundle_qty as $tbq){
            //         $approve_qty+=$tbq->approve_qtn;
            //         $remaining_qty+=$tbq->approve_qtn;
            //         $count++;
            //     }
                
            //     $total_sku+=$count;
            // }
            
            // $total_bundle_qty=DB::table('view_products_orders')
            //             ->groupBy('bundle_set_variation')
            //             ->where('pr_id',$pr_id)
            //             ->where('bundle_check',1)
            //             ->select([
            //                 DB::raw('(sum(approve_qtn)*3) as approve_qtn'),
            //                 DB::raw('sum(given_qtn) as given_qtn'),
            //                 DB::raw('count(bundle_set_variation) as total_sku')
            //             ])->get();
            
            // $approve_qty=(int)$total_qty->approve_qtn;
            // $remaining_qty=(int)$total_qty->approve_qtn;
            
            // $total_sku=(int)$total_qty->total_sku;
            
            // if($total_bundle_qty->count()>0){
            //     $tbq=$total_bundle_qty->first();
                
            //     $approve_qty+=(int)$tbq->approve_qtn;
            //     $remaining_qty+=(int)$tbq->approve_qtn;
            //     $total_sku+=(int)$tbq->total_sku;
            // }
            $ready_to_ship=(int)$approve_qty - (int)$remaining_qty;
            
            // // $total_bundle_sku=(int)(isset($total_bundle_qty->total_sku))?$total_bundle_qty->total_sku:0;
            // // $bundle_approve_qty=(isset($total_bundle_qty->approve_qtn))?$total_bundle_qty->approve_qtn/$total_bundle_sku:0;
            // // $bundle_remaining_qty=(isset($total_bundle_qty->approve_qtn))?$total_bundle_qty->approve_qtn/$total_bundle_sku:0;
            // // $bundle_ready_to_ship=(int)$bundle_approve_qty - (int)$bundle_remaining_qty;
            
            
            // $approve_qty+=$bundle_approve_qty;
            // $remaining_qty+=$bundle_remaining_qty;
            // $ready_to_ship+=$bundle_ready_to_ship;
            // $total_sku+=$total_bundle_sku;
            
        // }else{
        //     $total_qty=DB::table('process_orders')
        //                 ->where('pr_id',$pr_id)
        //                 ->select([
        //                     DB::raw('sum(approve_qty) as approve_qty'),
        //                     DB::raw('sum(given_qty) as given_qty'),
        //                     DB::raw('count(variation_design) as total_sku')
        //                 ])->first();
        //     $total_bundle_qty=DB::table('bundle_list_pr_wise')
        //                 ->where('pr_id',$pr_id)
        //                 ->select([
        //                     DB::raw('sum(approve_qty) as approve_qty'),
        //                     DB::raw('sum(given_qty) as given_qty'),
        //                     DB::raw('count(bundle_set_variation) as total_sku')
        //                 ])->first();
        
        //     $approve_qty=(int)$total_qty->approve_qty;
        //     $remaining_qty=(int)$total_qty->given_qty;
        //     $ready_to_ship=(int)$approve_qty - (int)$remaining_qty;
        //     $total_sku=(int)$total_qty->total_sku;
            
        //     $bundle_approve_qty=$total_bundle_qty->approve_qty;
        //     $bundle_remaining_qty=$total_bundle_qty->given_qty;
        //     $bundle_ready_to_ship=(int)$bundle_approve_qty - (int)$remaining_qty;
        //     $total_bundle_sku=(int)$total_qty->total_sku;
            
        //     $approve_qty+=$bundle_approve_qty;
        //     $remaining_qty+=$bundle_remaining_qty;
        //     $ready_to_ship+=$bundle_ready_to_ship;
        //     $total_sku+=$total_bundle_sku;
        // } 
        
        
        return [
                'approve_qty' => $approve_qty,
                'remaining_qty' => $remaining_qty, 
                'ready_to_ship' => ($ready_to_ship<0)?0:$ready_to_ship,
                'total_sku' => $total_sku
            ];
    }
    
    public function initial_supplier($pr_id){
        
        $sup_list=DB::table('suppliers')->where('id','!=',1)->where('id','!=',2)->get();
        
        $order=[];
        $receive=[];
        $pending=[];
        $total_order_qty=0;
        $total_received_qty=0;
        $total_pending_qty=0;
        
        foreach($sup_list as $sup){
            $assign=DB::table('assign_quantity')
                ->where('supplier_id',$sup->id)->where('pr_id',$pr_id)->where('supplier_id','!=',1)->where('supplier_id','!=',2)->where('switch_status','0')
                ->select([DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty')])->first();
                
            $total_order=($assign->receive_qty !="")?$assign->receive_qty:0;
            $total_receive_qty=($assign->receiving_qty!="")?$assign->receiving_qty:0;
            $remaining=(int)$total_order-(int)$total_receive_qty;
            
            $exp=explode(' ',$sup->supplier_name);
            $order[]='<strong>'.$exp[0].'</strong>  : '.$total_order;
            $receive[]='<strong>'.$exp[0].'</strong>  : '.$total_receive_qty;
            $pending[]='<strong>'.$exp[0].'</strong>  : '.$remaining;
            
            $total_order_qty+=$total_order;
            $total_received_qty+=$total_receive_qty;
            $total_pending_qty+=$remaining;
            
        }
        
        $order[]='<hr><strong>Total</strong> : '.$total_order_qty;
        $receive[]='<hr><strong>Total</strong> : '.$total_received_qty;
        $pending[]='<hr><strong>Total</strong> : '.$total_pending_qty;
        
        return [
            'order' => $order,
            'receive' => $receive,
            'pending' => $pending,
            'total_order_qty' =>$total_order_qty,
            'total_received_qty' => $total_received_qty,
            'total_pending_qty' => $total_pending_qty
        ];
    }
    
    public function initial_wh($pr_id){
        $assign=DB::table('assign_quantity')
                ->where('supplier_id',1)->where('last_receiving_id',0)->where('pr_id',$pr_id)
                ->select([DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty')])->first();
                
        $total_receive=($assign->receive_qty !='')?$assign->receive_qty:'0';
        $total_receiving_qty=($assign->receiving_qty !='')?$assign->receiving_qty:'0';
        
        $in_order='<strong>Initial WH</strong> : '. $total_receive;
        $in_wh=$total_receive;
        $in_out='<strong>Out from Initial WH</strong> : '.$total_receiving_qty;
        $in_remaining='<strong>Remaining From Initial WH</strong> : '.(int)$assign->receive_qty-(int)$assign->receiving_qty;
        
        $assign=DB::table('assign_quantity')
                ->where('supplier_id',1)->where('last_receiving_id','!=',0)->where('pr_id',$pr_id)
                ->select([DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty')])->first();
        $total_receive=($assign->receive_qty !='')?$assign->receive_qty:'0';
        $total_receiving_qty=($assign->receiving_qty !='')?$assign->receiving_qty:'0';
        
        $order='<strong>Received WH</strong> : '. $total_receive;
        $received_wh=$total_receive;
        $out='<strong>Out from Received WH</strong> : '.$total_receiving_qty;
        $remaining='<strong>Remaining From Received WH</strong> : '.(int)$assign->receive_qty-(int)$assign->receiving_qty;
        
        return [
                'in_order' => $in_order,
                'in_out' => $in_out,
                'in_remaining' => $in_remaining,
                'order' => $order,
                'out' => $out,
                'remaining' => $remaining,
                'in_wh' => $in_wh,
                'received_wh' =>$received_wh 
            ];
        
        
    }
    
    public function processed_order_shipped($pr_id){
        $process_order=DB::table('processed_orders')
                        ->where('pr_id',$pr_id)
                        ->where('shipment_ready_status',1)
                        ->where('filled_qty',0)
                        ->select([
                            DB::raw('sum(approve_qty) as approve_qty')
                        ])->first();
        
        $shipped_qty=isset($process_order->approve_qty)?(int)$process_order->approve_qty:0;
        $process_order_rem=DB::table('processed_orders')
                        ->where('pr_id',$pr_id)
                        ->where('shipment_ready_status',0)
                        ->whereRaw('approve_qty <> filled_qty')
                        ->select([
                            DB::raw('(sum(approve_qty)- sum(filled_qty)) as approve_qty')
                        ])->first();
        $shipped_qty_rem=isset($process_order_rem->approve_qty)?(int)$process_order_rem->approve_qty:0;
        $shipped_qty+=$shipped_qty_rem;
        
        return $shipped_qty;
        
    }
    
    public function ready_to_ship_single_qty($pr_id){
        $query = DB::table('processed_orders')
                    ->select([DB::raw('sum(filled_qty) as approve_qty')])
                    ->where('shipment_ready_status',0)
                    ->whereRaw('variation_design NOT like "%4BUN%"')
                    ->where('pr_id',$pr_id)->first();
        $total_pending_qty=0;
        if($query !=NULL){
            $total_pending_qty=(int)$query->approve_qty;  
        }
        
        return $total_pending_qty;
    }
    
    public function ready_to_ship_bundle_qty($pr_id){
        $query = DB::table('processed_orders')
                    ->select([DB::raw('sum(filled_qty) as approve_qty')])
                    ->where('shipment_ready_status',0)
                    ->whereRaw('variation_design like "%4BUN%"')
                    ->where('pr_id',$pr_id)->first();
        $total_pending_qty=0;
        if($query !=NULL){
            $total_pending_qty=(int)($query->approve_qty)*3;  
        }
        
        return $total_pending_qty;
    }

    public function index(Request $request){
        if($request->ajax()){
            $records=$pr_data=DB::table('pr_data')->orderBy('id','desc');
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('supplier_assign',function($data){
                        $row=$this->initial_new_supplier($data->pr_name);
                        return implode('<br>',$row['order']);
                    })
                    ->addColumn('supplier_receive',function($data){
                        $row=$this->initial_new_supplier($data->pr_name);
                        return implode('<br>',$row['receive']);
                    })
                    ->addColumn('supplier_pending',function($data){
                        $row=$this->initial_new_supplier($data->pr_name);
                        return implode('<br>',$row['pending']);
                    })
                    ->addColumn('warehouse',function($data){
                        $row=$this->initial_wh($data->pr_name);
                        $html=$row['in_order'].'<br>'.$row['order'];
                        return $html;
                    })
                    ->addColumn('warehouse_out',function($data){
                        $row=$this->initial_wh($data->pr_name);
                        $html=$row['in_out'].'<br>'.$row['out'];
                        return $html;
                    })
                    ->addColumn('warehouse_remaining',function($data){
                        $row=$this->initial_wh($data->pr_name);
                        $html=$row['in_remaining'].'<br>'.$row['remaining'];
                        return $html;
                    })
                    ->addColumn('approve_qty',function($data){
                        $row=$this->process_order($data->pr_name);
                        return $row['approve_qty'];
                    })
                    ->addColumn('remaining_qty',function($data){
                        $bulk='BULK';
                        if(preg_match("/{$bulk}/i", strtolower($data->pr_name))) {
                            // $row=$this->process_order($data->pr_name);
                            return 0;
                        }else{
                            $row=$this->process_order2($data->pr_name);
                            return $row['remaining_qty'];
                        }
                        
                    })
                    ->addColumn('ready_to_ship',function($data){
                         $bulk='BULK';
                        if(preg_match("/{$bulk}/i", strtolower($data->pr_name))) {
                            return 0;
                        }else{
                            $single=$this->ready_to_ship_single_qty($data->pr_name);
                            $bundle=$this->ready_to_ship_bundle_qty($data->pr_name);
                            
                            return ((int)$single+(int)$bundle);
                        }
                        
                    })
                    ->filterColumn('approve_qty',function($query,$keyword){
                        $query->orWhereRaw("pr_data.pr_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('approve_qty', function ($query, $order) {
                        $query->orderBy('pr_data.pr_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                    ->rawColumns(['created_at','approve_qty','remaining_qty','ready_to_ship','supplier_assign','supplier_receive','supplier_pending','warehouse','warehouse_out','warehouse_remaining'])
                    ->make(true);
        }else{
            return view('history.index');
        }
    }
    
    public function initial_new_supplier($pr_id){
        
        $sup_list=DB::table('suppliers')->where('id','!=',1)->where('id','!=',2)->get();
        
        $order=[];
        $receive=[];
        $pending=[];
        $total_order_qty=0;
        $total_received_qty=0;
        $total_pending_qty=0;
        $total_cancelled=0;
        
        $html='<table class="table table-bordered">
                <thead >
                  <tr class="thead-light">
                    <th>Supplier</th>
                    <th>Assign</th>
                    <th>Receive</th>
                    <th>Cancelled</th>
                    <th>Remaining</th>
                  </tr>
                </thead>
                <tbody>';
        
        foreach($sup_list as $sup){
            $assign=DB::table('assign_quantity')
                ->where('supplier_id',$sup->id)
                ->where('pr_id',$pr_id)
                ->where('supplier_id','!=',1)
                ->where('supplier_id','!=',2)
                ->where('switch_status','0')
                ->select([
                    DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                    'switch_status',
                ])->first();
                
            $assign2=DB::table('assign_quantity')
                ->where('supplier_id',$sup->id)
                ->where('pr_id',$pr_id)
                ->where('supplier_id','!=',1)
                ->where('supplier_id','!=',2)
                ->where('switch_status','1')
                ->where('receiving_qty','!=','0')
                ->select([
                    DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                    'switch_status',
                ])->first();
            
            $cancelled=DB::table('assign_quantity')
                ->where('supplier_id',$sup->id)
                ->where('supplier_id','!=',1)
                ->where('supplier_id','!=',2)
                ->where('is_cancelled','1')
                ->where('pr_id',$pr_id)
                ->select([
                    DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                    'switch_status',
                ])->first();
                
            $total_order2=(int)($assign->order_qty_given !="")?$assign->order_qty_given:0;
            $total_order=(int)($assign->receive_qty !="")?$assign->receive_qty:0;
            $total_receive_qty=($assign->receiving_qty!="")?$assign->receiving_qty:0;
            
            $switch_order_qty=(int)($assign2->order_qty_given !="")?$assign2->order_qty_given:0;
            $switch_order=(int)($assign2->receive_qty !="")?$assign2->receive_qty:0;
            $switch_receive_qty=($assign2->receiving_qty!="")?$assign2->receiving_qty:0;
            
            $cancelled_assigned_order_qty=(int)($cancelled->receive_qty !="") ? $cancelled->receive_qty : 0 ;
            $cancelled_received_order_qty=(int)($cancelled->receiving_qty!="") ? $cancelled->receiving_qty: 0 ;
            $cancelled_qty=$cancelled_assigned_order_qty - $cancelled_received_order_qty;
            
            $t_order2='';
            
                
            
            $remaining=(int)$total_order-(int)$total_receive_qty;
            $remaining-=$cancelled_qty;
            
            $total_order+=$switch_receive_qty;
            $total_receive_qty+=$switch_receive_qty;
            
            
            $t_order=$total_order;
            
            
            
            
            
            $exp=explode(' ',$sup->supplier_name);
            $order[]='<strong>'.$exp[0].'</strong>  : '.$total_order;
            $receive[]='<strong>'.$exp[0].'</strong>  : '.$total_receive_qty;
            $pending[]='<strong>'.$exp[0].'</strong>  : '.$remaining;
            
            $html.='<tr>
                    <td class="font-weight-bold">'.$exp[0].'</td>
                    <td class="table-primary">'.$t_order2.$t_order.'</td>
                    <td class="table-success">'.$total_receive_qty.'</td> 
                    <td class="table-danger">'.$cancelled_qty.'</td> 
                    <td class="table-info">'.$remaining.'</td>
                </tr>';
            
            $total_order_qty+=$t_order;
            $total_received_qty+=$total_receive_qty;
            $total_pending_qty+=$remaining;
            $total_cancelled+=$cancelled_qty;
            
        }
        $html.='</tbody>
                <tfoot>
                <tr class="thead-light">
                    <th class="font-weight-bold"> Total</th>
                    <th class="font-weight-bold">'.$total_order_qty.'</th>
                    <th class="font-weight-bold">'.$total_received_qty.'</th> 
                    <th class="font-weight-bold">'.$total_cancelled.'</th>
                    <th class="font-weight-bold">'.$total_pending_qty.'</th>
                </tr>
                </tfoot>
                </table>';
        
        $order[]='<hr><strong>Total</strong> : '.$total_order_qty;
        $receive[]='<hr><strong>Total</strong> : '.$total_received_qty;
        $pending[]='<hr><strong>Total</strong> : '.$total_pending_qty;
        
        return [
            'order' => $order,
            'receive' => $receive,
            'pending' => $pending,
            'total_order_qty' =>$total_order_qty,
            'total_received_qty' => $total_received_qty,
            'total_pending_qty' => $total_pending_qty,
            'html' => $html
        ];
    }
    
    public function mo_new_list(Request $request){
        if($request->ajax()){
            $records=$pr_data=DB::table('pr_data')
                                ->join('users','users.id','=','pr_data.user_id')
                                ->orderBy('pr_data.id','desc')
                                ->select([
                                    'pr_data.pr_name',
                                    'pr_data.created_date',
                                    'users.name'
                                ]);
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('approve_qty',function($data){
                        $row=$this->process_order($data->pr_name);
                        return $row['approve_qty'];
                    })
                    ->addColumn('total_sku',function($data){
                        $row=$this->process_order($data->pr_name);
                        return $row['total_sku'];
                    })
                    ->filterColumn('approve_qty',function($query,$keyword){
                        $query->orWhereRaw("pr_data.pr_name LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('approve_qty', function ($query, $order) {
                        $query->orderBy('pr_data.pr_name', $order);
                    })
                    ->addColumn('created_at', function($data){
                        return date('d-m-Y',strtotime($data->created_date));
                     })
                     
                    ->addColumn('action', function($data){
                        return '<button type="button" class="btn btn-info sup_check" id="sup_check_'.$data->pr_name.'" data-pr_id="'.$data->pr_name.'" >Supplier Check</button>';
                     })
                    ->rawColumns(['created_at','approve_qty','total_sku','action'])
                    ->make(true);
        }else{
            return view('history.mo_list');
        }
    }
    
    //added by sufian 26-12-22 Supplier Pr list
    public function supplier_po_issued_detail(Request $request){
        if($request->ajax()){
            $pr_id=$request->pr_id;
            $row=$this->initial_wh($pr_id);
            $html2=$row['in_order'];
            $in_wh=$row['in_wh'];
            
            $row=$this->process_order($pr_id);
            $approve_qty=$row['approve_qty'];
            $shipped=$this->processed_order_shipped($pr_id);
            
            $row=$this->initial_new_supplier($pr_id);
            $row2=$this->total_supplier_assign_sku($pr_id);
            $supplier_assign=$row['total_order_qty'];
            
            $html='<div class="alert alert-warning">';
            $html.='<strong>MO# : '.$pr_id.'</strong>
                    <div class="float-right">
                    <span class="badge badge-primary" style="font-size:19px">Sup Order QTY : '.$approve_qty.'</span>
                    <span class="badge badge-info" style="font-size:19px">Supplier Assign : '.$supplier_assign.'</span>
                    <span class="badge badge-warning" style="font-size:19px">Warehouse Assign : '.$in_wh.'</span>
                    <span class="badge badge-success" style="font-size:19px">Shipped : '.$shipped.'</span>
                    </div>
            <hr />';
            
            $html.=$row2;
            $html.=$row['html'];
            
            $html.='</div>';
            
            return response()->json(['code' => 200, 'html' => $html]);
        }
        
    }
    //added by sufian 23-12-22 Pr list
    public function mo_list(Request $request){
        if($request->ajax()){
            $pr_id=$request->pr_id;
            $value='BULK';
            if(preg_match("/{$value}/i", strtolower($pr_id))) {
                $bundle=DB::table('view_products_orders')
                        ->join('bundle','bundle.bundle_set_variation','=','view_products_orders.bundle_set_variation')
                        ->orderBy('bundle.bundle_set_variation','ASC')
                        ->groupBy(['bundle.bundle_set_variation'])
                        ->where('view_products_orders.pr_id',$pr_id)
                        ->where('view_products_orders.bundle_check',1)
                        ->select([
                            'view_products_orders.bundle_set_variation as variation_id',
                            'view_products_orders.id',
                            'view_products_orders.bundle_set_variation as variation_design',
                            'view_products_orders.approve_qtn as approve_qty',
                            'bundle.bundle_set_name as product_name',
                            'bundle.image_url as prod_img',
                            'bundle.image_url as product_url'
                        ]);
                $records=DB::table('view_products_orders')
                        ->join('product_info_design','product_info_design.variation_design','=','view_products_orders.variation_design')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.variation_design','ASC')
                        ->where('view_products_orders.pr_id',$pr_id)
                        ->where('view_products_orders.bundle_check',0)
                        ->union($bundle)
                        ->select([
                            'view_products_orders.variation_id',
                            'view_products_orders.id',
                            'view_products_orders.variation_design',
                            'view_products_orders.approve_qtn as approve_qty',
                            'product_info_design.product_name',
                            'product_info_design.prod_img',
                            'product_info_design.product_url'
                        ]);
            }else{
                $bundle=DB::table('bundle_list_pr_wise')
                            ->join('bundle','bundle.bundle_set_variation','=','bundle_list_pr_wise.bundle_set_variation')
                            ->where('bundle_list_pr_wise.pr_id',$pr_id)
                            ->select([
                                'bundle_list_pr_wise.bundle_set_variation as variation_id',
                                'bundle_list_pr_wise.id',
                                'bundle_list_pr_wise.bundle_set_variation as variation_design',
                                'bundle_list_pr_wise.approve_qty',
                                'bundle.bundle_set_name as product_name',
                                'bundle.image_url as prod_img',
                                'bundle.image_url as product_url'
                            ]);
                $records=DB::table('process_orders')
                        ->join('product_info_design','product_info_design.variation_design','=','process_orders.variation_design')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.variation_design','ASC')
                        ->where('process_orders.pr_id',$pr_id)
                        ->union($bundle)
                        ->select([
                            'process_orders.variation_id',
                            'process_orders.id',
                            'process_orders.variation_design',
                            'process_orders.approve_qty',
                            'product_info_design.product_name',
                            'product_info_design.prod_img',
                            'product_info_design.product_url'
                        ]);
                        
            }
            
            
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('product_img',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        } 
                        
                        $product_detail='
                            <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                '.$img.'
                            </a><br>
                        ';
                        return $product_detail;
                    })
                    ->addColumn('product_name',function ($data){
                        if($data->product_name !=''){
                            
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-12">
                                    '.$data->product_name.'<br>
                                    <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                    <span style="color:#D35400">SKU with Design : <strong>'.$data->variation_design.'</strong></span><br>
                                    </div>
                                </div>
                            ';
                        }else{
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-6">
                                    '.$data->variation_id.'
                                    </div>
                                </div>
                            ';
                        }
                        return $product_detail;
                    })
                    ->addColumn('product_size',function ($data){
                        if($data->product_name !=''){
                            $prod_name=$data->product_name;
                            $exp=explode(',',$prod_name);
                            
                            $product_detail=$exp[1];
                        }else{
                            $product_detail='';
                        }
                        return $product_detail;
                    })
                    ->filterColumn('product_name',function($query,$keyword){
                        $query->orWhereRaw("product_info_design.product_name LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info_design.variation_id LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info_design.variation_design LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('product_name', function ($query, $order) {
                        $query->orderBy('product_info_design.product_name', $order);
                    })
                    ->rawColumns(['product_img','product_name','product_size'])
                    ->make(true);
        }else{
            $pr_list=$pr_data=DB::table('pr_data')->orderBy('id','desc')->get();
            return view('history.pr_list',['pr_list' => $pr_list]);
        }
    }
    
    //added by sufian 04-01-22 Product Wise Detail 
    public function in_stock_product($variation_id){
        $check=DB::table('product_info')->where('variation_id',$variation_id)->where('is_deleted',0)->get();
        $qty=0;
        if($check->count()>0){
            $row=$check->first();
            $qty=$row->Quantity;
        }
        
        return $qty;
    }
    
    public function total_supplier_assign_sku($pr_id){
        $total_qty=DB::table('view_products_orders')
                    ->where('pr_id',$pr_id)
                    ->where('bundle_check',0)
                    ->select([
                        DB::raw('sum(approve_qtn) as approve_qtn'),
                        DB::raw('sum(given_qtn) as given_qtn'),
                        DB::raw('count(variation_design) as total_sku')
                    ])->first();
        $total_bundle_qty=DB::table('view_products_orders')
                    ->groupBy('bundle_set_variation')
                    ->where('pr_id',$pr_id)
                    ->where('bundle_check',1)
                    ->select([
                      'approve_qtn','given_qtn','bundle_set_variation'
                    ])->get();
        
        // $total_bundle_qty=DB::table('view_products_orders')
        //             ->groupBy('bundle_set_variation')
        //             ->where('pr_id',$pr_id)
        //             ->where('bundle_check',1)
        //             ->select([
        //               DB::raw('sum(bundle_total_qty) approve_qtn'),
        //               DB::raw('count(bundle_set_variation) total_sku'),
        //             ])->first();
            
        $approve_qty=(int)$total_qty->approve_qtn;
        $remaining_qty=(int)$total_qty->approve_qtn;
            
        $total_sku=(int)$total_qty->total_sku;
        $count=0;
        $bapprove_qty=0; 
        if($total_bundle_qty->count()>0){
            
            foreach ($total_bundle_qty as $tbq){
                $approve_qty+=$tbq->approve_qtn;
                $remaining_qty+=$tbq->approve_qtn;
                $bapprove_qty+=$tbq->approve_qtn;
                $count++;
            }
            
            $total_sku+=(int)($count*3);
        }
        
        // if($total_bundle_qty !=NULL){
        //     $approve_qty+=$total_bundle_qty->approve_qtn;
        //     $remaining_qty+=$total_bundle_qty->approve_qtn;
        //     $bapprove_qty+=$total_bundle_qty->approve_qtn;
            
        //     $total_sku+=(int)($total_bundle_qty->total_sku);
        //     $count=$total_bundle_qty->total_sku/3;
        //     $bapprove_qty=$bapprove_qty/3;
        // }
        
        $html='<div>
                <span class="badge badge-primary" style="font-size:15px">MO Approve QTY : '.$approve_qty.'</span>
                <span class="badge badge-info" style="font-size:15px">Total Single SKU : <strong>'.(int)$total_qty->total_sku.'</span>
                <span class="badge badge-info" style="font-size:15px">EST. Supplier Qty : <strong>'.(int)$total_qty->approve_qtn.'</span>
                <span class="badge badge-warning" style="font-size:15px">Total Bundle SKU : <strong>'.$count.' (SIN : '.($count*3).')'.'</strong></span>
                <span class="badge badge-warning" style="font-size:15px">Total Bundle Qty : <strong>'.$bapprove_qty.'</strong></span>
                <span class="badge badge-warning" style="font-size:15px">EST. Supplier Qty(QTY*3) : <strong>'.((int)$bapprove_qty*3).'</strong></span>
                <span class="badge badge-success" style="font-size:15px">Total SKU : <strong>'.$total_sku.'</strong></span>
                <span class="badge badge-success" style="font-size:15px">EST. Supplier Order : <strong>'.((int)$total_qty->approve_qtn + ((int)$bapprove_qty*3)).'</strong></span>
                
            </div><hr/>';
        return $html;
    }
    
    public function supplier_intial_product($variation_id){
        $assign=DB::table('assign_quantity')
                ->where('supplier_id','!=',1)
                ->where('supplier_id','!=',2)
                ->where('switch_status','0')
                ->where('variation_id',$variation_id)
                ->select([
                    DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty')
                ])->first();
                
        $assign2=DB::table('assign_quantity')
            ->where('supplier_id','!=',1)
            ->where('supplier_id','!=',2)
            ->where('switch_status','1')
            ->where('receiving_qty','!=','0')
            ->where('variation_id',$variation_id)
            ->select([
                DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
            ])->first();
                
        $total_order2=(int)($assign->order_qty_given !="")?$assign->order_qty_given:0;
        $total_order=(int)($assign->receive_qty !="")?$assign->receive_qty:0;
        $total_receive_qty=($assign->receiving_qty!="")?$assign->receiving_qty:0;
            
        $switch_order_qty=(int)($assign2->order_qty_given !="")?$assign2->order_qty_given:0;
        $switch_order=(int)($assign2->receive_qty !="")?$assign2->receive_qty:0;
        $switch_receive_qty=($assign2->receiving_qty!="")?$assign2->receiving_qty:0;
            
                
            
        $remaining=(int)$total_order-(int)$total_receive_qty;
        $total_order+=$switch_receive_qty;
        $total_receive_qty+=$switch_receive_qty;
        
        return [
            'total_order_qty' =>$total_order,
            'total_received_qty' => $total_receive_qty,
            'total_pending_qty' => $remaining,
        ];
    }
    
    public function initial_wh_product($variation_id){
        $assign=DB::table('assign_quantity')
                ->where('supplier_id',1)
                ->where('last_receiving_id',0)
                ->where('variation_id',$variation_id)
                ->select([
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty')])
                ->first();
                
        $total_receive_in=($assign->receive_qty !='')?$assign->receive_qty:'0';
        $total_receiving_qty_in=($assign->receiving_qty !='')?$assign->receiving_qty:'0';
        $in_remaining=(int)$assign->receive_qty-(int)$assign->receiving_qty;
        
        $assign=DB::table('assign_quantity')
                ->where('supplier_id',1)
                ->where('last_receiving_id','!=',0)
                ->where('variation_id',$variation_id)
                ->select([
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty')
                ])->first();
        $total_receive_rec=($assign->receive_qty !='')?$assign->receive_qty:'0';
        $total_receiving_qty_rec=($assign->receiving_qty !='')?$assign->receiving_qty:'0';
        
        $remaining_rec=(int)$assign->receive_qty-(int)$assign->receiving_qty;
        
        return [
            'in_order' => $total_receive_in,
            'in_out' => $total_receiving_qty_in,
            'in_remaining' => $in_remaining,
            'receive_rec' => $total_receive_rec,
            'out_rec' => $total_receiving_qty_rec,
            'remaining_rec' => $remaining_rec
        ];
        
        
    }
    
    public function  process_order_product($variation_design,$store_id='',$shipment_type=''){
        if($store_id !='' && $shipment_type!=''){
            $total_qty=DB::table('process_orders')
                ->where('variation_design',$variation_design)
                ->where('processed_status',0)
                ->where('store_id',$store_id)
                ->where('shipment_type',$shipment_type)
                ->select([
                    DB::raw('sum(approve_qty) as approve_qty'),
                    DB::raw('sum(given_qty) as given_qty')
                ])->first();
        }else{
            $total_qty=DB::table('process_orders')
                ->where('variation_design',$variation_design)
                ->where('processed_status',0)
                ->select([
                    DB::raw('sum(approve_qty) as approve_qty'),
                    DB::raw('sum(given_qty) as given_qty')
                ])->first();
        }
        
        
        $approve_qty=($total_qty->approve_qty !='')?$total_qty->approve_qty:0;
        $remaining_qty=($total_qty->given_qty !='')?$total_qty->approve_qty:0;
        $ready_to_ship=(int)$approve_qty - (int)$remaining_qty;
        
        return [
            'approve_qty' => $approve_qty,
            'remaining_qty' => $remaining_qty, 
            'ready_to_ship' => ($ready_to_ship !='')?$ready_to_ship:0
        ];
    }
    
    public function  processed_order_product($variation_design,$store_id='',$shipment_type=''){
        if($store_id !='' && $shipment_type !=''){
           $total=DB::table('shipment_info')
                ->join('shipment','shipment.shipment_id','=','shipment_info.shipment_id')
                ->where('cargo_select',$shipment_type)
                ->where('store_id',$store_id)
                ->where('opex_sku',$variation_design)
                ->where('remaining_qty','!=','0')
                ->first([
                    DB::raw('count(shipment_info.id) as total_remaining_sku'),
                    DB::raw('sum(shipment_info.remaining_qty) as total_remaining_qty')
                ]);
                
            $total_actual=DB::table('shipment_info')
                ->join('shipment','shipment.shipment_id','=','shipment_info.shipment_id')
                ->where('cargo_select',$shipment_type)
                ->where('store_id',$store_id)
                ->where('opex_sku',$variation_design)
                ->first([
                    DB::raw('count(shipment_info.id) as 	total_sku'),
                    DB::raw('sum(shipment_info.expected_qnt) as total_shipment_qty')
                ]); 
        }else{
           $total=DB::table('shipment_info')
                ->where('opex_sku',$variation_design)
                ->where('remaining_qty','!=','0')
                ->first([
                    DB::raw('count(id) as total_remaining_sku'),
                    DB::raw('sum(remaining_qty) as total_remaining_qty')
                ]);
                
            $total_actual=DB::table('shipment_info')
                ->where('opex_sku',$variation_design)
                ->first([
                    DB::raw('count(id) as 	total_sku'),
                    DB::raw('sum(expected_qnt) as total_shipment_qty')
                ]); 
        }
        
        
        $rem=(int)$total_actual->total_shipment_qty - (int)$total->total_remaining_qty;
            
        return $rem;
    }
    
    
    public function sku_list(Request $request){
        if($request->ajax()){
           $records=DB::table('product_info_design')
                ->where('product_info_design.is_deleted',0)
                ->select([
                    'product_info_design.product_name',
                    'product_info_design.prod_img',
                    'product_info_design.product_url',
                    'product_info_design.variation_design',
                    'product_info_design.variation_id'
                ]);
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('product_img',function($data){
                    if($data->product_url !=''){
                        $url=$data->product_url;
                        // $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        $img='view image';
                    }else{
                        $url=asset('uploads/sku_images/'.$data->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        $img='view image';
                        
                    }
                    
                    

                    $product_detail='
                        <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                            '.$img.'
                        </a><br>
                    ';
                    return $product_detail;
                })
                ->addColumn('product_name',function ($data){
                        
                        if($data->product_name !=''){
                            
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-12">
                                    '.$data->product_name.'<br>
                                    <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                    <span style="color:#D35400">SKU with Design : <strong>'.$data->variation_design.'</strong></span><br>
                                    </div>
                                </div>
                            ';
                        }else{
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-6">
                                    '.$data->variation_id.'
                                    </div>
                                </div>
                            ';
                        }
                        return $product_detail;
                    })
                ->addColumn('product_size',function ($data){
                        if($data->product_name !=''){
                            $prod_name=$data->product_name;
                            $exp=explode(',',$prod_name);
                            
                            $product_detail=$exp[1];
                        }else{
                            $product_detail='';
                        }
                        return $product_detail;
                    })
                ->filterColumn('product_name',function($query,$keyword){
                    $query->orWhereRaw("product_info_design.product_name LIKE ?", ["%{$keyword}%"]);
                    $query->orWhereRaw("product_info_design.variation_id LIKE ?", ["%{$keyword}%"]);
                    $query->orWhereRaw("product_info_design.variation_design LIKE ?", ["%{$keyword}%"]);
                })
                ->orderColumn('product_name', function ($query, $order) {
                    $query->orderBy('product_info_design.product_name', $order);
                })
                ->addColumn('instock',function ($data){
                    return $this->in_stock_product($data->variation_id);
                })
                // ->addColumn('initial_wh',function ($data){
                //     $intial=$this->initial_wh_product($data->variation_id);
                //     return $intial['in_order'];
                // })
                ->addColumn('supplier_order',function ($data){
                    $intial=$this->supplier_intial_product($data->variation_id);
                    return $intial['total_order_qty'];
                })
                ->addColumn('supplier_receiving',function ($data){
                    $intial=$this->supplier_intial_product($data->variation_id);
                    return $intial['total_received_qty'];
                })
                ->addColumn('supplier_pending',function ($data){
                    $intial=$this->supplier_intial_product($data->variation_id);
                    return $intial['total_pending_qty'];
                })
                
                ->addColumn('ready_to_ship',function ($data){
                    $intial=$this->process_order_product($data->variation_id);
                    return $intial['ready_to_ship'];
                })
                ->addColumn('shipped',function ($data){
                    $intial=$this->processed_order_product($data->variation_design);
                    return $intial;
                })
                ->addColumn('process_order',function ($data){
                    $intial=$this->process_order_product($data->variation_design);
                    return $intial['remaining_qty'];
                })
                
                ->rawColumns([
                    'product_img',
                    'product_name',
                    'product_size',
                    'instock',
                    'supplier_order',
                    'supplier_receiving',
                    'supplier_pending',
                    'ready_to_ship',
                    'shipped',
                    'process_order'
                ])
                ->make(true);
        }else{
            return view('history.sku_list');
        }
    }
    
    
    
    public function sku_list_storewise(Request $request){
        if($request->ajax()){
            $store_id=$request->store;
            $shipment_type=$request->shipment_type;
            
            if($store_id !='' && $shipment_type !=''){
                $records=DB::table('product_info_design')
                ->where('product_info_design.is_deleted',0)
                ->select([
                    'product_info_design.product_name',
                    'product_info_design.prod_img',
                    'product_info_design.product_url',
                    'product_info_design.variation_design',
                    'product_info_design.variation_id'
                ]);
            
           
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('product_img',function($data){
                    if($data->product_url !=''){
                        $url=$data->product_url;
                        // $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        $img='view image';
                    }else{
                        $url=asset('uploads/sku_images/'.$data->prod_img);
                        $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        $img='view image';
                        
                    }
                    
                    

                    $product_detail='
                        <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                            '.$img.'
                        </a><br>
                    ';
                    return $product_detail;
                })
                ->addColumn('product_name',function ($data){
                        
                        if($data->product_name !=''){
                            
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-12">
                                    '.$data->product_name.'<br>
                                    <span class="text-success">SKU : <strong>'.$data->variation_id.'</strong></span><br>
                                    <span style="color:#D35400">SKU with Design : <strong>'.$data->variation_design.'</strong></span><br>
                                    </div>
                                </div>
                            ';
                        }else{
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-6">
                                    '.$data->variation_id.'
                                    </div>
                                </div>
                            ';
                        }
                        return $product_detail;
                    })
                ->addColumn('product_size',function ($data){
                        if($data->product_name !=''){
                            $prod_name=$data->product_name;
                            $exp=explode(',',$prod_name);
                            
                            $product_detail=$exp[1];
                        }else{
                            $product_detail='';
                        }
                        return $product_detail;
                    })
                ->filterColumn('product_name',function($query,$keyword){
                    $query->orWhereRaw("product_info_design.product_name LIKE ?", ["%{$keyword}%"]);
                    $query->orWhereRaw("product_info_design.variation_id LIKE ?", ["%{$keyword}%"]);
                    $query->orWhereRaw("product_info_design.variation_design LIKE ?", ["%{$keyword}%"]);
                })
                ->orderColumn('product_name', function ($query, $order) {
                    $query->orderBy('product_info_design.product_name', $order);
                })
                ->addColumn('instock',function ($data){
                    return $this->in_stock_product($data->variation_id);
                })
                // ->addColumn('initial_wh',function ($data){
                //     $intial=$this->initial_wh_product($data->variation_id);
                //     return $intial['in_order'];
                // })
                ->addColumn('supplier_order',function ($data){
                    $intial=$this->supplier_intial_product($data->variation_id);
                    return $intial['total_order_qty'];
                })
                ->addColumn('supplier_receiving',function ($data){
                    $intial=$this->supplier_intial_product($data->variation_id);
                    return $intial['total_received_qty'];
                })
                ->addColumn('supplier_pending',function ($data){
                    $intial=$this->supplier_intial_product($data->variation_id);
                    return $intial['total_pending_qty'];
                })
                
                ->addColumn('ready_to_ship',function ($data) use(&$store_id,&$shipment_type){
                    $intial=$this->process_order_product($data->variation_id,$store_id,$shipment_type);
                    return $intial['ready_to_ship'];
                })
                ->addColumn('shipped',function ($data) use(&$store_id,&$shipment_type){
                    $intial=$this->processed_order_product($data->variation_design,$store_id,$shipment_type);
                    return $intial;
                })
                ->addColumn('process_order',function ($data) use(&$store_id,&$shipment_type){
                    $intial=$this->process_order_product($data->variation_design,$store_id,$shipment_type);
                    return $intial['remaining_qty'];
                })
                
                ->rawColumns([
                    'product_img',
                    'product_name',
                    'product_size',
                    'instock',
                    'supplier_order',
                    'supplier_receiving',
                    'supplier_pending',
                    'ready_to_ship',
                    'shipped',
                    'process_order'
                ])
                ->make(true);
            }else{
                return Datatables::of(array())->make(true);
            }
            
        }else{
            $stores=DB::table('store')->whereIn('id',[1,4,6])->get();
            return view('history.sku_list_storewise',['stores' => $stores]);
        }
    }
    
    ///added by sufian 14-12-23
    public function shipped_order(Request $request){
        if($request->ajax()){
            
            $start_date=date('Y-m-d',strtotime($request->start_date));
            $end_date=date('Y-m-d',strtotime($request->end_date));
            $variation_design=$request->variation_design;
            $records=DB::table('processed_orders')
                        ->groupBy('processed_orders.variation_design','processed_orders.store_id','processed_orders.shipment_type')
                        ->leftjoin('product_info_design','product_info_design.variation_design','=','processed_orders.variation_design')
                        ->leftjoin('bundle','bundle.bundle_set_variation','=','processed_orders.variation_design')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.prod_size','ASC')
                        ->orderBy('product_info_design.prod_design','ASC')
                        ->where('processed_orders.is_cancelled','0')
                        ->whereRaw('processed_orders.variation_design Like "%'.$variation_design.'%"')
                        ->where(DB::raw('DATE(processed_orders.created_date)'),'>=',$start_date)
                        ->where(DB::raw('DATE(processed_orders.created_date)'),'<=',$end_date)
                        ->select([
                            'processed_orders.variation_id',
                            'processed_orders.variation_design',
                            DB::raw('sum(processed_orders.filled_qty) as filled_qty'),
                            DB::raw('sum(processed_orders.approve_qty) as approve_qty'),
                            DB::raw('(IF(processed_orders.variation_design like "%4BUN%",bundle.bundle_set_name,product_info_design.product_name)) as product_name'),
                            // 'product_info.Quantity',
                            DB::raw('(IF(processed_orders.variation_design like "%4BUN%",bundle.image_url,product_info_design.prod_img)) as prod_img'),
                            DB::raw('(IF(processed_orders.variation_design like "%4BUN%",bundle.image_url,product_info_design.product_url)) as product_url'),
                            DB::raw("GROUP_CONCAT(processed_orders.pr_id SEPARATOR '<br>') as mo_list")
                            
                        ]);
                        
            // dd($records);
            
            
            
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('product_img',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                            $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                            $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
                        }
    
                        $product_detail='
                            
                                    <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a><br>
                                    
                                
                        ';
                        return $product_detail;
                    })
                    ->addColumn('product_name',function ($data){
                        
                        if($data->product_name !=''){
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-12">
                                    '.$data->product_name.'
                                    </div>
                                </div>
                            ';
                        }else{
                            $product_detail='
                                <div class="row">
                                    <div class="col-md-6">
                                    '.$data->variation_id.'
                                    </div>
                                </div>
                            ';
                        }
                        return $product_detail;
                    })
                    ->filterColumn('product_name',function($query,$keyword){
                        $query->orWhereRaw("product_info_design.product_name LIKE ?", ["%{$keyword}%"]);
                        $query->orWhereRaw("product_info_design.variation_id LIKE ?", ["%{$keyword}%"]);
                        // $query->orWhereRaw("product_info_design.variation_design LIKE ?", ["%{$keyword}%"]);
                    })
                    ->orderColumn('product_name', function ($query, $order) {
                        $query->orderBy('product_info_design.product_name', $order);
                    })
                    ->addColumn('mo_list',function ($data){
                        
                        $date=$data->mo_list;
                        return $date;
                    })
                    ->addColumn('shipped_stock',function ($data){
                        $instock=(int)$data->approve_qty - (int)$data->filled_qty;
                        
                        
                        return $instock;
                    })
                    ->rawColumns(['product_img','product_name','shipped_stock','mo_list'])
                    ->make(true);
        }else{
            return view('history.sku_view');
        }
    }
}
