<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use PDF;
use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class GatePassController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:gatepass-list', ['only' => ['index','getall']]);
        $this->middleware('permission:supplier-statistics',['only' => ['statistics']]);


    }

    public function index(){
        $suppliers=Supplier::latest()->where('id','!=','1')->where('id','!=','2')->get();
        $po_list=DB::table('product_receiving')->groupBy('po_id')->select(['po_id'])->get();
        $gatepass_serial=DB::table('product_receiving')->groupBy('gatepass_serial')->select(['gatepass_serial'])->get();
        // dd($gatepass_serial);
        return view('gatepass.index',['suppliers' => $suppliers,'po_list' => $po_list,'gatepass_serial' => $gatepass_serial]);
    }

    public function getall(Request $request){
        // dd($request->all());
        $input=$request->all();
        $supplier_id=$input['supplier_id'];
        $start_date=date('Y-m-d',strtotime($input['start_date']));
        $end_date=date('Y-m-d',strtotime($input['end_date']));
        $po_id=$input['po_id'];
        $serial_id=$input['serial_id'];


        $records=DB::table('product_receiving')->where('product_receiving.supplier_id',$supplier_id)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->join('product_info','product_info.variation_id','=','product_receiving.variation_id')
            ->select([
                'product_receiving.last_receiving as receive_qtn',
                'product_receiving.*',
                'product_info.prod_img',
                'product_info.product_url',
                'product_info.product_name',
                'product_info.prod_type',
            ]);
            
        if($po_id !=''){
            $records->where('product_receiving.po_id',$po_id);
        }
        
        if($serial_id !=''){
            $records->where('product_receiving.gatepass_serial',$serial_id);
        }

        // $records=DB::table('product_barcodes')->where('product_barcodes.supplier_id',$supplier_id)
        //         ->where('created_date','>=',$start_date)
        //         ->where('created_date','<=',$end_date)
        //         ->join('product_info','product_info.variation_id','=','product_barcodes.variation_id')
        //         ->groupBy('product_barcodes.variation_id')
        //         ->groupBy('product_barcodes.hash')
        //         ->select([DB::raw('count(product_barcodes.id) as receive_qtn'),
        //         'product_barcodes.*',
        //         'product_info.prod_img',
        //         'product_info.product_url',
        //         'product_info.product_name',
        //         ]);
        return Datatables::of($records)
        ->addIndexColumn()
        ->addColumn('product_img',function($data){
            if($data->product_url !=''){
                $url=$data->product_url;
                $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="100" height="100">';
            }else{
                $url=asset('uploads/sku_images/'.$data->prod_img);
                $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="100" height="100">';
            }

            $product_detail='
                <div class="row">
                    <div class="col-md-6">
                        <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                            '.$img.'
                        </a><br>
                        SKU : <strong>'.$data->variation_id.'</strong><br>
                    </div>
                </div>
            ';
            
            
            return $product_detail;
        })
        ->filterColumn('product_img',function($query,$keyword){
            $query->orWhereRaw("product_receiving.variation_id LIKE ?", ["%{$keyword}%"]);
            $query->orWhereRaw("product_receiving.po_id LIKE ?", ["%{$keyword}%"]);
        })
        ->orderColumn('product_img', function ($query, $order) {
            $query->orderBy('product_receiving.variation_id', $order);    
        })
        ->addColumn('created_at',function ($data){
            $created='<span>'.date('d-m-Y', strtotime($data->created_date)).'</span>';
            if(auth()->user()->can('reverse-gatepass')){
              $created.='<br><button class="btn btn-info btn-sm float-right reverse_gatepass" id="reverse_gatepass_'.$data->id.'" data-last_receiving_id="'.$data->id.'">Reverse</button>';  
            }
            return $created;
        })
        ->addColumn('txs',function ($data){
            $txs=$data->prod_type;
            
            if($txs<1000){
                if($txs<100){
                    if($txs<10){
                        $txs='000'.$txs;
                    }else{
                        $txs='00'.$txs; 
                    }    
                }else{
                    $txs='0'.$txs;
                }
            }
            return '4'.$txs;
        })
        ->filterColumn('created_at',function($query,$keyword){
            $keyword=date('Y-m-d',strtotime($keyword));
            $query->orWhereRaw("product_receiving.created_date LIKE ?", ["%{$keyword}%"]);
        })
        ->orderColumn('created_at', function ($query, $order) {
            $query->orderBy('product_receiving.created_date', $order);
        })
        
        ->rawColumns(['product_img','created_at','txs'])
        ->make(true);
    }

    public function statistics(Request $request){
        if($request->ajax()){
            
            
            $records=Supplier::query()
                ->select([
                    'suppliers.supplier_name',
                    'suppliers.id'
                ])->whereNotIn('suppliers.id',[1,2])
                ->where('status','=',1);
            return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('receive_qty',function($data){
                $row=$this->initial_new_supplier($data->id);
                return $row['total_order_qty'];
            })
            ->addColumn('receiving_qty',function($data){
                $row=$this->initial_new_supplier($data->id);
                return $row['total_received_qty'];
            })
            ->addColumn('supplier_name2',function($data){
                $ahref='<a href="javascript:;" class="supplier_name" data-id="'.$data->id.'" >'.$data->supplier_name.'</a>';
                return $ahref;
            })
            ->filterColumn('supplier_name2',function($query,$keyword){
                $query->orWhereRaw("LOWER(suppliers.supplier_name) LIKE ?", ["%{$keyword}%"]);     
            })
            ->orderColumn('supplier_name2', function ($query, $order) {
                $query->orderBy('suppliers.supplier_name', $order);    
            })
            ->addColumn('remaining',function ($data){
                $row=$this->initial_new_supplier($data->id);
                return $row['total_pending_qty'];
            })
            ->addColumn('cancelled',function ($data){
                $row=$this->initial_new_supplier($data->id);
                // dd($row);
                return $row['total_cancelled'];
            })
            ->addColumn('pr_id', function ($data) {
                $row=$this->initial_new_supplier($data->id);
                return $row['total_pr_id'];    
            })
            ->rawColumns(['supplier_name2','pr_id','receive_qty','receiving_qty','remaining','cancelled'])
            ->make(true);

        }else{
            return view('gatepass.statistics'); 
        }
    }

    public function get_pr_data(Request $request){
        if($request->ajax()){
            $supplier_id=$request->input('supplier_id');
            $records=DB::table('assign_quantity')
                        ->leftJoin('product_info','product_info.variation_id','=','assign_quantity.variation_id')
                        ->join('teams','product_info.team','=','teams.team_code')
                        ->where('assign_quantity.supplier_id',$supplier_id)
                        // ->where('assign_quantity.status',0)
                        ->where('assign_quantity.switch_status',0)
                        // ->orderBy('assign_quantity.pr_id','DESC')
                        ->select([
                            'assign_quantity.assign_date',
                            'assign_quantity.po_id',
                            'teams.team_name',
                            'product_info.product_name',
                            'assign_quantity.variation_id',
                            'assign_quantity.receive_qty',
                            'assign_quantity.receiving_qty',
                        ]);
            return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('product_name',function($data){
                $title='<label class="text-success">'.$data->product_name.'</label><br>
                        <label class="text-info"> Sku : '.$data->variation_id.'</label>
                ';
                return $title;
            })
            ->filterColumn('product_name',function($query,$keyword){
                $query->orWhereRaw("LOWER(product_info.product_name) LIKE ?", ["%{$keyword}%"])
                        ->orWhereRaw("LOWER(assign_quantity.variation_id) LIKE ?", ["%{$keyword}%"]);     
            })
            ->orderColumn('product_name', function ($query, $order) {
                $query->orderBy('product_info.product_name', $order)
                        ->orderBy('assign_quantity.variation_id', $order);    
                    
            })
            ->addColumn('remaining',function ($data){
                $remaining=(int)$data->receive_qty-(int)$data->receiving_qty;
                return $remaining;
            })
            ->addColumn('assign_date',function ($data){
               
                return date('d-m-Y',strtotime($data->assign_date));
            })
            ->filterColumn('assign_date',function($query,$keyword){
                $keyword=date('Y-m-d',strtotime($keyword));
                $query->orWhereRaw("assign_quantity.assign_date LIKE ?", ["%{$keyword}%"]);     
            })
            ->orderColumn('assign_date', function ($query, $order) {
                $query->orderBy('assign_quantity.assign_date', $order);    
                    
            })
            
            ->rawColumns(['assign_date','product_name','remaining'])
            ->make(true);
        }
    }
    
    public function make_gate_pass_pdf(Request $request){
        $input=$request->all();
        $supplier_id=$input['supplier_id'];
        $start_date=date('Y-m-d',strtotime($input['start_date']));
        $end_date=date('Y-m-d',strtotime($input['end_date']));
        
        $po_id2=$input['po_id2'];
        
        $rec_id2=$input['rec_id2'];
        
        $is_print=$request->is_print;
        // $gate_pass_serial=$input['gate_pass_serial'];

        if($supplier_id !=''){
            $supplier_data=Supplier::where('id' , $supplier_id)->first('supplier_name');
            $supplier_name=$supplier_data->supplier_name;
        }
        
        
        // if(){
          $rec=DB::table('product_receiving')->where('product_receiving.supplier_id',$supplier_id)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)  
            ->select([ DB::raw("CONCAT('REC',product_receiving.gatepass_serial) AS gatepass_serial")])
            ->groupBy('product_receiving.gatepass_serial')
            ->pluck('product_receiving.gatepass_serial');
        // }
        
        if($po_id2 !=''){
            $rec->where('product_receiving.po_id',$po_id2);
        }
        
        if($rec_id2 !=''){
            $rec->where('product_receiving.gatepass_serial',$rec_id2);
        }
        
        $rec_id=implode(',',$rec->toArray());
        
        
        
        $records=DB::table('product_receiving')->where('product_receiving.supplier_id',$supplier_id)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->join('product_info','product_info.variation_id','=','product_receiving.variation_id')
            ->join('product_size','product_info.prod_size','=','product_size.id')
            ->select([
                'product_receiving.last_receiving as receive_qtn',
                'product_receiving.*',
                'product_size.size',
                'product_info.prod_img',
                'product_info.product_url',
                'product_info.product_name',
            ])->orderBy('product_receiving.gatepass_serial','desc');
            
        if($po_id2 !=''){
            $records->where('product_receiving.po_id',$po_id2);
        }
        
        if($rec_id2 !=''){
            $records->where('product_receiving.gatepass_serial',$rec_id2);
        }
            
        if($is_print !=''){
            $html=view('pdf.gate_pass',[
                'records' => $records->get(),
                'supplier_name' => $supplier_name,
                'start_date' => $start_date,
                'end_date' => $end_date,
                // 'gate_pass_serial' => $gate_pass_serial,
                'rec_id' => $rec_id,
            ])->render();
            
            return response()->json(['success' => 1,'html' => $html]);
            
        }else{
           $pdf = PDF::loadView('pdf.gate_pass', [
                'records' => $records->get(),
                'supplier_name' => $supplier_name,
                'start_date' => $start_date,
                'end_date' => $end_date,
                // 'gate_pass_serial' => $gate_pass_serial,
                'rec_id' => $rec_id,
            ])->setPaper('A4', 'Protrait');
    
            return $pdf->download('gate_pass_'.date('d_m_Y').'.pdf'); 
        }
            
        
    }
    
    public function gate_pass_serial(Request $request){
        $input=$request->all();
        $supplier_id=$input['supplier_id'];
        
        if($supplier_id !=''){
            $count=DB::table('gatepass_serial')->where('supplier_id',$supplier_id)->orderBy('gate_pass_serial', 'desc')->first();
            
            if($count ==null){
                $gate_pass_serial=1;
                
            }else{
                $gate_pass_serial=($count->gate_pass_serial)+1;
            }
            $insert=[
                'gate_pass_serial' => $gate_pass_serial,
                'supplier_id'=> $supplier_id,
                'created_date' => date('Y-m-d')
            ];
            
            DB::table('gatepass_serial')->insert($insert);
            
            return response()->json([
                'gate_pass_serial' => $gate_pass_serial
            ]);
        }
    }
    
    public function gate_pass_po_list(Request $request){
        $supplier_id=$request->supplier_id;
        $start_date=$request->start_date;
        $end_date=$request->end_date;
        $records_po=DB::table('product_receiving')
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->join('suppliers','suppliers.id','=','product_receiving.supplier_id')
            ->join('users','users.id','=','product_receiving.user_id')
            ->groupBy('po_id')
            ->select([
                'product_receiving.po_id',
                'product_receiving.created_date',
                'suppliers.supplier_name',
                'users.name'
            ]);
        $records_serial=DB::table('product_receiving')
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->join('suppliers','suppliers.id','=','product_receiving.supplier_id')
            ->join('users','users.id','=','product_receiving.user_id')
            ->groupBy('gatepass_serial')
            ->select([
                'product_receiving.gatepass_serial',
                'product_receiving.created_date',
                'suppliers.supplier_name',
                'users.name'
            ]);
        if($supplier_id != ""){
            $records_po->where('product_receiving.supplier_id',$supplier_id);
            $records_serial->where('product_receiving.supplier_id',$supplier_id);
        }
        
        $html='<option value="">Please Select</option>';
        foreach ($records_po->get()  as $record){
            $html.='<option value="'.$record->po_id.'">PO #'.$record->po_id.'&nbsp;&nbsp;|&nbsp;&nbsp; Supplier #: '.$record->supplier_name.'&nbsp;&nbsp;|&nbsp;&nbsp; DropIN Date : '.date('d-m-Y',strtotime($record->created_date)).'&nbsp;&nbsp;|&nbsp;&nbsp; DropIn by : '.$record->name.'</option>';
        }
        
        $html2='<option value="">Please Select</option>';
        foreach ($records_serial->get()  as $record){
            $html2.='<option value="'.$record->gatepass_serial.'">REC #: REC'.$record->gatepass_serial.'&nbsp;&nbsp;|&nbsp;&nbsp; Supplier #: '.$record->supplier_name.'&nbsp;&nbsp;|&nbsp;&nbsp; DropIN Date : '.date('d-m-Y',strtotime($record->created_date)).'&nbsp;&nbsp;|&nbsp;&nbsp; DropIn by : '.$record->name.'</option>';
        }
        
        return response()->json(['success' => 1,'pohtml' =>$html,'serialhtml' => $html2]);
    }
    
    public function po_list_gatepass_serial(Request $request){
        $supplier_id=$request->supplier_id;
        $start_date=$request->start_date;
        $end_date=$request->end_date;
        $po_id=$request->po_id;
        $records=DB::table('product_receiving')
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->join('suppliers','suppliers.id','=','product_receiving.supplier_id')
            ->join('users','users.id','=','product_receiving.user_id')
            ->groupBy('gatepass_serial')
            ->select([
                'product_receiving.gatepass_serial',
                'product_receiving.created_date',
                'suppliers.supplier_name',
                'users.name'
            ]);
        if($supplier_id != ""){
            $records->where('product_receiving.supplier_id',$supplier_id);
        }
        
        if($po_id != ""){
            $records->where('product_receiving.po_id',$po_id);
        }
        
        $html='<option value="">Please Select</option>';
        foreach ($records->get()  as $record){
            $html.='<option value="'.$record->gatepass_serial.'">REC #: REC'.$record->gatepass_serial.'&nbsp;&nbsp;|&nbsp;&nbsp; Supplier #: '.$record->supplier_name.'&nbsp;&nbsp;|&nbsp;&nbsp; DropIN Date : '.date('d-m-Y',strtotime($record->created_date)).'&nbsp;&nbsp;|&nbsp;&nbsp; DropIn by : '.$record->name.'</option>';
        }
        
        return response()->json(['success' => 1,'html' =>$html]);
    }
    
    public function reverse_gatepass(Request $request){
        if($request->ajax()){
            $last_receiving_id=$request->last_receiving_id;
            $product_receiving=DB::table('product_receiving')->where('id',$request->last_receiving_id)->first();
            
            $assign_id=$product_receiving->assign_id;
            $variation_id=$product_receiving->variation_id;
            $last_receiving=$product_receiving->last_receiving;
            
            $assign_quantity=DB::table('assign_quantity')->where('id',$assign_id)->first();
            $receiving_qty=(int)$assign_quantity->receiving_qty;
            $status=$assign_quantity->status;
            
            
            $receiving_qty-=(int)$last_receiving;
            
            if($status=='1'){
                $status='0';
            }
            
            $update_assign=[
                'receiving_qty' => $receiving_qty,
                'status' => $status
            ];
            
            DB::table('assign_quantity')->where('id',$assign_id)->update($update_assign);
            
            $product_info=DB::table('product_info')->where('variation_id',$variation_id)->first();
            
            $qty=(int)$product_info->Quantity;
            
            $qty-=(int)$last_receiving;
            
            $update_info=[
                'Quantity' => ($qty<0)?'0':$qty
            ];
            
            DB::table('product_info')->where('variation_id',$variation_id)->update($update_info);
            
            $insert_reverse=[
                'variation_id' => $variation_id,
                'quantity' => $last_receiving,
                'reason' => $request->reason,
                'po_id' => $product_receiving->po_id,
                'pr_id' => $product_receiving->pr_id,
                'rec_id' => $product_receiving->rec_id,
                'supplier_id' => $product_receiving->supplier_id,
                'user_id' => auth()->user()->id,
                'created_date' => date('Y-m-d H:i:s')
            ];
            
            $insert_data=\DB::table('gatepass_reverse_history')->insert($insert_reverse);
            DB::table('product_receiving')->where('id',$request->last_receiving_id)->delete();
            DB::table('assign_quantity')->where('last_receiving_id',$request->last_receiving_id)->delete();
            
            ///added by sufian 08-05-23
            if($product_receiving->bulk_receiving_id !=0){
                DB::table('product_bulk_receiving')->where('id',$product_receiving->bulk_receiving_id)->delete();
            }
            
            return response()->json(['success' => 1,'message' => 'GatePass Reverse Successfully']);
            
        }
    }
    
    ///added by sufian 
    public function initial_new_supplier($sup_id){
        $order=[];
        $receive=[];
        $pending=[];
        $total_order_qty=0;
        $total_received_qty=0;
        $total_pending_qty=0;
        $total_cancelled_qty=0;
        
        $assign=DB::table('assign_quantity')
            ->where('supplier_id',$sup_id)
            ->where('supplier_id','!=',1)
            ->where('supplier_id','!=',2)
            ->where('switch_status','0')
            ->select([
                DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),
                DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                DB::raw('count(assign_quantity.variation_id) as pr_id'),
                'switch_status',
            ])->first();
                
        $assign2=DB::table('assign_quantity')
            ->where('supplier_id',$sup_id)
            ->where('supplier_id','!=',1)
            ->where('supplier_id','!=',2)
            ->where('switch_status','1')
            ->where('receiving_qty','!=','0')
            ->select([
                DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                DB::raw('count(assign_quantity.variation_id) as pr_id'),
                'switch_status',
            ])->first();
            
        $cancelled=DB::table('assign_quantity')
                ->where('supplier_id',$sup_id)
                ->where('supplier_id','!=',1)
                ->where('supplier_id','!=',2)
                ->where('is_cancelled','1')
                ->select([
                    DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                    DB::raw('count(assign_quantity.variation_id) as pr_id'),
                    'switch_status',
                ])->first();
        
        // $sku_qty=DB::table('assign_quantity')
        //         ->where('supplier_id',$sup_id)
        //         ->where('supplier_id','!=',1)
        //         ->where('supplier_id','!=',2)
        //         ->select([
        //             DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
        //             DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
        //             DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
        //             DB::raw('count(assign_quantity.variation_id) as pr_id'),
        //             'switch_status',
        //         ])->first();
                
        $total_order2=(int)($assign->order_qty_given !="")?$assign->order_qty_given:0;
        $total_order=(int)($assign->receive_qty !="")?$assign->receive_qty:0;
        $total_receive_qty=($assign->receiving_qty!="")?$assign->receiving_qty:0;
        $total_receive_qty=($assign->receiving_qty!="")?$assign->receiving_qty:0;
        $total_pr_id=($assign->pr_id!="")?$assign->pr_id:0;
            
        $switch_order_qty=(int)($assign2->order_qty_given !="")?$assign2->order_qty_given:0;
        $switch_order=(int)($assign2->receive_qty !="")?$assign2->receive_qty:0;
        $switch_receive_qty=($assign2->receiving_qty!="")?$assign2->receiving_qty:0;
        $switch_pr_id=($assign2->pr_id!="")?$assign2->pr_id:0;
        
        $cancelled_assigned_order_qty=(int)($cancelled->receive_qty !="") ? $cancelled->receive_qty : 0 ;
        $cancelled_sku_qty=(int)($cancelled->pr_id !="") ? $cancelled->pr_id : 0 ;
        $cancelled_received_order_qty=(int)($cancelled->receiving_qty!="") ? $cancelled->receiving_qty: 0 ;
        $cancelled_qty=$cancelled_assigned_order_qty - $cancelled_received_order_qty;
        
        // dd($cancelled_qty);
            
                
            
        $remaining=(int)$total_order-(int)$total_receive_qty;
        $remaining-=$cancelled_qty;
        
        $total_order+=$switch_receive_qty;
        $total_receive_qty+=$switch_receive_qty;
        $total_pr_id-=$switch_pr_id;
        
        // $total_pr_id-=$cancelled_sku_qty;
            
        $t_order=$total_order;

        $total_order_qty+=$t_order;
        $total_received_qty+=$total_receive_qty;
        $total_pending_qty+=$remaining;
        $total_cancelled_qty+=$cancelled_qty;
        
        return [
            'total_order_qty' =>$total_order_qty,
            'total_received_qty' => $total_received_qty,
            'total_pending_qty' => $total_pending_qty,
            'total_pr_id' => $total_pr_id ,//(int)$total_pr_id+(int)$cancelled_sku_qty
            'total_cancelled' => $total_cancelled_qty
        ];
    }
    
    ////added by sufian 05-05-23
    public function store_wise_pending($supplier_id,$pr_id){
        $record=DB::table('assign_quantity')
                    ->where('status',0)
                    ->where('is_cancelled',0)
                    ->where('supplier_id',$supplier_id)
                    ->where('pr_id', 'like', '%' . $pr_id . '%')
                    ->select([DB::raw('(sum(receive_qty) - sum(receiving_qty)) as total_pending')])
                    ->get();
                    
        // dd($record);
        
        if($record->count()==0){
            $pending=0;
        }else{
            $first=$record->first();
            $pending=($first->total_pending !=NULL)? (int)$first->total_pending:0;
        }
        return $pending;
    }
    
    public function storewise_statistics(Request $request){
        if($request->ajax()){
            $draw = $request->post('draw');
            $start = $request->post("start");
            $rowperpage = $request->post("length"); // total number of rows per page

            $columnIndex_arr = $request->post('order');
            $columnName_arr = $request->post('columns');
            $order_arr = $request->post('order');
            $search_arr = $request->post('search');
            
            $totalRecords = Supplier::query()->where('suppliers.id','!=',1)->where('suppliers.id','!=',2)->count();
            
            // dd($totalRecords);
            
            
            
            $searchValue = $search_arr['value']; // Search value
            
            if($searchValue !=''){
                $records=Supplier::query()
                ->select([
                    'suppliers.supplier_name',
                    'suppliers.id'
                ])->where('suppliers.id','!=',1)->where('suppliers.id','!=',2)->whereRaw('suppliers.supplier_name Like "%'.$searchValue.'%"');
                $totalRecordswithFilter =$records->count();
            }else{
                $totalRecordswithFilter =$totalRecords;
                $records=Supplier::query()
                ->select([
                    'suppliers.supplier_name',
                    'suppliers.id'
                ])->where('suppliers.id','!=',1)->where('suppliers.id','!=',2);
            }
            
            
            
            if($rowperpage !='-1'){
                $records->offset($start)->take($rowperpage);
            }
            
            if(isset($columnIndex_arr[0]['column'])){
                $columnIndex = $columnIndex_arr[0]['column']; // Column index
                $columnName = $columnName_arr[$columnIndex]['data']; // Column name
                $columnSortOrder = $order_arr[0]['dir']; // asc or desc
                $records->orderBy($columnName, $columnSortOrder);
            }else{
                $records->orderBy('id','ASC');
            }
            
            $data = array();
            
            $stores=DB::table('store')->whereIn('id',[1,4,6,5,10])->select(['id','short_name','strong_name'])->get();
            
            if(!empty($records->get())){
                foreach($records->get() as $sup){
                    $nestedData=array();
                    $total=0;
                    $nestedData['supplier_name']=$sup->supplier_name;
                    foreach ($stores as $store){
                        $pr_id_air=$store->short_name.'AIR';
                        $pr_id_sea=$store->short_name.'SEA';
                        $pr_id_bulk=$store->short_name.'BULK';
                        
                        // dd($pr_id_air);
                        
                        $air=$this->store_wise_pending($sup->id,$pr_id_air);
                        $sea=$this->store_wise_pending($sup->id,$pr_id_sea);
                        $bulk=$this->store_wise_pending($sup->id,$pr_id_bulk);
                        
                        
                        $total+=$air;
                        $total+=$sea;
                        $total+=$bulk;
                        
                        $nestedData[str_replace(' ','_',$store->strong_name).'_air']=$air;
                        $nestedData[str_replace(' ','_',$store->strong_name).'_sea']=$sea;
                        $nestedData[str_replace(' ','_',$store->strong_name).'_bulk']=$bulk;
                    }
                    
                    $nestedData['total']=$total;
                    $data[] = $nestedData;
                }
            }
            
            
            
            $response = array(
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordswithFilter,
                "aaData" => $data,
            );
            // dd($response);
            
            echo json_encode($response);
            
        }else{
            $stores = DB::table('store')->whereIn('id',[1,4,6,5,10])->get();
            return view('gatepass.storewise_statisitics',['stores' => $stores]); 
        }
    }
}
