<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use PDF;
use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

use Helper;

class GatePassController extends Controller
{
    public $active_store =[1,6,11];
    
    function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:gatepass-list', ['only' => ['index','getall']]);
        $this->middleware('permission:supplier-statistics',['only' => ['statistics']]);


    }

    public function index(){
        $suppliers=Supplier::latest()->whereNotIn('id',[1,2])->where('status','=',1)->get();
        return view('gatepass.index',['suppliers' => $suppliers]);
    }

    public function getall(Request $request){
        // dd($request->all());
        $input=$request->all();
        $supplier_id=$input['supplier_id'];
        $start_date=date('Y-m-d',strtotime($input['start_date']));
        $end_date=date('Y-m-d',strtotime($input['end_date']));
        $po_id=$input['po_id'];
        $serial_id=$input['serial_id'];


        $records=DB::table('product_receiving')->where('product_receiving.supplier_id',$supplier_id)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->join('product_info','product_info.variation_id','=','product_receiving.variation_id')
            ->select([
                'product_receiving.last_receiving as receive_qtn',
                'product_receiving.*',
                'product_info.prod_img',
                'product_info.product_url',
                'product_info.product_name',
                'product_info.prod_type',
            ]);
            
        if($po_id !=''){
            $records->where('product_receiving.po_id',$po_id);
        }
        
        if($serial_id !=''){
            $records->where('product_receiving.gatepass_serial',$serial_id);
        }

        // $records=DB::table('product_barcodes')->where('product_barcodes.supplier_id',$supplier_id)
        //         ->where('created_date','>=',$start_date)
        //         ->where('created_date','<=',$end_date)
        //         ->join('product_info','product_info.variation_id','=','product_barcodes.variation_id')
        //         ->groupBy('product_barcodes.variation_id')
        //         ->groupBy('product_barcodes.hash')
        //         ->select([DB::raw('count(product_barcodes.id) as receive_qtn'),
        //         'product_barcodes.*',
        //         'product_info.prod_img',
        //         'product_info.product_url',
        //         'product_info.product_name',
        //         ]);
        return Datatables::of($records)
        ->addIndexColumn()
        ->addColumn('product_img',function($data){
            if($data->product_url !=''){
                $url=$data->product_url;
                $img=' <img src="'.$data->product_url.'" class="rounded" alt="Cinque Terre" width="50" height="50">';
            }else{
                $url=asset('uploads/sku_images/'.$data->prod_img);
                $img='<img src="'.asset('uploads/sku_images/'.$data->prod_img).'" class="rounded" alt="Cinque Terre" width="50" height="50">';
            }

            $product_detail='
                <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                    '.$img.'
                </a>
            ';
            
            
            return $product_detail;
        })
        ->filterColumn('product_img',function($query,$keyword){
            $query->orWhereRaw("product_receiving.variation_id LIKE ?", ["%{$keyword}%"]);
            $query->orWhereRaw("product_receiving.po_id LIKE ?", ["%{$keyword}%"]);
        })
        ->orderColumn('product_img', function ($query, $order) {
            $query->orderBy('product_receiving.variation_id', $order);    
        })
        ->addColumn('created_at',function ($data){
            $created='<span>'.date('d-m-Y', strtotime($data->created_date)).'</span>';
            return $created;
        })
        ->addColumn('txs',function ($data){
            $txs=$data->prod_type;
            
            if($txs<1000){
                if($txs<100){
                    if($txs<10){
                        $txs='000'.$txs;
                    }else{
                        $txs='00'.$txs; 
                    }    
                }else{
                    $txs='0'.$txs;
                }
            }
            return '4'.$txs;
        })
        
        ->addColumn('action',function ($data){
            $created='';
            if(auth()->user()->can('reverse-gatepass')){
              $created.='<button class="btn btn-dark btn-sm reverse_gatepass" id="reverse_gatepass_'.$data->id.'" data-last_receiving_id="'.$data->id.'">Reverse</button>';  
            }
            return $created;
            
        })
        
        ->rawColumns(['product_img','created_at','txs','action'])
        ->make(true);
    }

    public function statistics(Request $request){
        if($request->ajax()){
            $records=Supplier::query()
                ->select([
                    'supplier_name',
                    'id'
                ])->whereNotIn('suppliers.id',[1,2])
                ->where('status','=',1);
                
                
                
            if(!empty($request->input('search.value'))){
                $search = trim($request->input('search.value'));
                $records->where(function($query) use(&$search){
                    $query->where('supplier_name','LIKE',"%{$search}%")
                        ->orWhere('id','LIKE',"%{$search}%");
                }); 
            }
            
            $sup=Helper::get_supplier_pending();
            // dd($sup);
            return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('supplier_name2',function($data){
                $ahref='<a href="javascript:;" class="supplier_name" data-id="'.$data->id.'" >'.$data->supplier_name.'</a>';
                return $ahref;
            })
            
            ->addColumn('total_sku',function ($data) use(&$sup){
                $total_sku=0;
                if(isset($sup[$data->id])){
                    $total_sku=$sup[$data->id]->total_sku;
                }
                return $total_sku;
            })
            ->addColumn('total_pending',function ($data) use(&$sup){
                $total_pending=0;
                if(isset($sup[$data->id])){
                    $total_pending=$sup[$data->id]->total_pending;
                }
                return $total_pending;
            })
            ->rawColumns(['supplier_name2','total_sku','total_pending'])
            ->make(true);

        }else{
            return view('gatepass.statistics'); 
        }
    }

    public function get_pr_data(Request $request){
        if($request->ajax()){
            $supplier_id=$request->input('supplier_id');
            $records=DB::table('assign_quantity')
                        ->leftJoin('product_info','product_info.variation_id','=','assign_quantity.variation_id')
                        ->where('assign_quantity.supplier_id',$supplier_id)
                        ->where('assign_quantity.status',0)
                        ->select([
                            'assign_quantity.assign_date',
                            'assign_quantity.po_id',
                            'product_info.product_name',
                            'assign_quantity.variation_id',
                            DB::raw('(assign_quantity.receive_qty - assign_quantity.receiving_qty) as pending')
                        ]);
            if(!empty($request->input('search.value'))){
                $search = trim($request->input('search.value'));
                $records->where(function($query) use(&$search){
                    $query->where('product_info.product_name','LIKE',"%{$search}%")
                        ->orWhere('assign_quantity.variation_id','LIKE',"%{$search}%");
                }); 
            }
            
            return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('product_name',function($data){
                return $data->product_name;
            })
            ->addColumn('remaining',function ($data){
                $remaining=(int)$data->pending;
                return $remaining;
            })
            ->addColumn('assign_date',function ($data){
               
                return date('d-m-Y',strtotime($data->assign_date));
            })
            ->rawColumns(['assign_date','product_name','remaining'])
            ->make(true);
        }
    }
    
    public function make_gate_pass_pdf(Request $request){
        $input=$request->all();
        $supplier_id=$input['supplier_id'];
        $start_date=date('Y-m-d',strtotime($input['start_date']));
        $end_date=date('Y-m-d',strtotime($input['end_date']));
        
        $po_id2=$input['po_id2'];
        
        $rec_id2=$input['rec_id2'];
        
        $is_print=$request->is_print;
        // $gate_pass_serial=$input['gate_pass_serial'];

        if($supplier_id !=''){
            $supplier_data=Supplier::where('id' , $supplier_id)->first('supplier_name');
            $supplier_name=$supplier_data->supplier_name;
        }
        
        
        // if(){
          $rec=DB::table('product_receiving')->where('product_receiving.supplier_id',$supplier_id)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)  
            ->select([ DB::raw("CONCAT('REC',product_receiving.gatepass_serial) AS gatepass_serial")])
            ->groupBy('product_receiving.gatepass_serial')
            ->pluck('product_receiving.gatepass_serial');
        // }
        
        if($po_id2 !=''){
            $rec->where('product_receiving.po_id',$po_id2);
        }
        
        if($rec_id2 !=''){
            $rec->where('product_receiving.gatepass_serial',$rec_id2);
        }
        
        $rec_id=implode(',',$rec->toArray());
        
        
        
        $records=DB::table('product_receiving')->where('product_receiving.supplier_id',$supplier_id)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->join('product_info','product_info.variation_id','=','product_receiving.variation_id')
            ->select([
                'product_receiving.last_receiving as receive_qtn',
                'product_receiving.*',
                'product_info.prod_img',
                'product_info.product_url',
                'product_info.product_name',
            ])->orderBy('product_receiving.gatepass_serial','desc');
            
        if($po_id2 !=''){
            $records->where('product_receiving.po_id',$po_id2);
        }
        
        if($rec_id2 !=''){
            $records->where('product_receiving.gatepass_serial',$rec_id2);
        }
            
        if($is_print !=''){
            $html=view('pdf.gate_pass',[
                'records' => $records->get(),
                'supplier_name' => $supplier_name,
                'start_date' => $start_date,
                'end_date' => $end_date,
                // 'gate_pass_serial' => $gate_pass_serial,
                'rec_id' => $rec_id,
            ])->render();
            
            return response()->json(['success' => 1,'html' => $html]);
            
        }else{
           $pdf = PDF::loadView('pdf.gate_pass', [
                'records' => $records->get(),
                'supplier_name' => $supplier_name,
                'start_date' => $start_date,
                'end_date' => $end_date,
                // 'gate_pass_serial' => $gate_pass_serial,
                'rec_id' => $rec_id,
            ])->setPaper('A4', 'Protrait');
    
            return $pdf->download('gate_pass_'.date('d_m_Y').'.pdf'); 
        }
            
        
    }
    
    public function gate_pass_serial(Request $request){
        $input=$request->all();
        $supplier_id=$input['supplier_id'];
        
        if($supplier_id !=''){
            $count=DB::table('gatepass_serial')->where('supplier_id',$supplier_id)->orderBy('gate_pass_serial', 'desc')->first();
            
            if($count ==null){
                $gate_pass_serial=1;
                
            }else{
                $gate_pass_serial=($count->gate_pass_serial)+1;
            }
            $insert=[
                'gate_pass_serial' => $gate_pass_serial,
                'supplier_id'=> $supplier_id,
                'created_date' => date('Y-m-d')
            ];
            
            DB::table('gatepass_serial')->insert($insert);
            
            return response()->json([
                'gate_pass_serial' => $gate_pass_serial
            ]);
        }
    }
    
    public function gate_pass_po_list(Request $request){
        $supplier_id=$request->supplier_id;
        $start_date=$request->start_date;
        $end_date=$request->end_date;
        
        $suppliersList=Supplier::latest()->whereNotIn('id',[1,2])->where('status','=',1)->get()->pluck('supplier_name','id')->toArray();
        $userList=DB::table('users')->selectRaw('name,id')->get()->pluck('name','id')->toArray();
        
        $records_po=DB::table('product_receiving')
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->groupBy('po_id')
            ->select([
                'product_receiving.po_id',
                'product_receiving.created_date',
                'product_receiving.supplier_id',
                'product_receiving.user_id',
            ]);
        $records_serial=DB::table('product_receiving')
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->groupBy('gatepass_serial')
            ->select([
                'product_receiving.gatepass_serial',
                'product_receiving.created_date',
                'product_receiving.supplier_id',
                'product_receiving.user_id',
            ]);
        if($supplier_id != ""){
            $records_po->where('product_receiving.supplier_id',$supplier_id);
            $records_serial->where('product_receiving.supplier_id',$supplier_id);
        }
        
        $html='<option value="">Please Select</option>';
        foreach ($records_po->get()  as $record){
            $supp_h=isset($suppliersList[$record->supplier_id])? '&nbsp;&nbsp;|&nbsp;&nbsp; Supplier #: '.$suppliersList[$record->supplier_id]:'';
            $user_h=isset($userList[$record->user_id])?'&nbsp;&nbsp;|&nbsp;&nbsp; DropIn by : '.$userList[$record->user_id]:'';
            
            $html.='<option value="'.$record->po_id.'">PO #'.$record->po_id.$supp_h.'&nbsp;&nbsp;|&nbsp;&nbsp; DropIN Date : '.date('d-m-Y',strtotime($record->created_date)).$user_h.'</option>';
        }
        
        $html2='<option value="">Please Select</option>';
        foreach ($records_serial->get()  as $record){
            $supp_h=isset($suppliersList[$record->supplier_id])? '&nbsp;&nbsp;|&nbsp;&nbsp; Supplier #: '.$suppliersList[$record->supplier_id]:'';
            $user_h=isset($userList[$record->user_id])?'&nbsp;&nbsp;|&nbsp;&nbsp; DropIn by : '.$userList[$record->user_id]:'';
            $html2.='<option value="'.$record->gatepass_serial.'">REC #: REC'.$record->gatepass_serial.$supp_h.'&nbsp;&nbsp;|&nbsp;&nbsp; DropIN Date : '.date('d-m-Y',strtotime($record->created_date)).$user_h.'</option>';
        }
        
        return response()->json(['success' => 1,'pohtml' =>$html,'serialhtml' => $html2]);
    }
    
    public function po_list_gatepass_serial(Request $request){
        $supplier_id=$request->supplier_id;
        $start_date=$request->start_date;
        $end_date=$request->end_date;
        $po_id=$request->po_id;
        
        $suppliersList=Supplier::latest()->whereNotIn('id',[1,2])->where('status','=',1)->get()->pluck('supplier_name','id')->toArray();
        $userList=DB::table('users')->selectRaw('name,id')->get()->pluck('name','id')->toArray();
        
        $records=DB::table('product_receiving')
            ->where(DB::raw('DATE(product_receiving.created_date)'),'>=',$start_date)
            ->where(DB::raw('DATE(product_receiving.created_date)'),'<=',$end_date)
            ->join('suppliers','suppliers.id','=','product_receiving.supplier_id')
            ->join('users','users.id','=','product_receiving.user_id')
            ->groupBy('gatepass_serial')
            ->select([
                'product_receiving.gatepass_serial',
                'product_receiving.created_date',
                'product_receiving.supplier_id',
                'product_receiving.user_id',
            ]);
        if($supplier_id != ""){
            $records->where('product_receiving.supplier_id',$supplier_id);
        }
        
        if($po_id != ""){
            $records->where('product_receiving.po_id',$po_id);
        }
        
        $html='<option value="">Please Select</option>';
        foreach ($records->get()  as $record){
            $supp_h=isset($suppliersList[$record->supplier_id])? '&nbsp;&nbsp;|&nbsp;&nbsp; Supplier #: '.$suppliersList[$record->supplier_id]:'';
            $user_h=isset($userList[$record->user_id])?'&nbsp;&nbsp;|&nbsp;&nbsp; DropIn by : '.$userList[$record->user_id]:'';
            $html.='<option value="'.$record->gatepass_serial.'">REC #: REC'.$record->gatepass_serial.$supp_h.'&nbsp;&nbsp;|&nbsp;&nbsp; DropIN Date : '.date('d-m-Y',strtotime($record->created_date)).$user_h.'</option>';
            
        }
        
        return response()->json(['success' => 1,'html' =>$html]);
    }
    
    public function reverse_gatepass(Request $request){
        if($request->ajax()){
            $last_receiving_id=$request->last_receiving_id;
            $product_receiving=DB::table('product_receiving')->where('id',$request->last_receiving_id)->first();
            
            $assign_id=$product_receiving->assign_id;
            $variation_id=$product_receiving->variation_id;
            $last_receiving=$product_receiving->last_receiving;
            
            $assign_quantity=DB::table('assign_quantity')->where('id',$assign_id)->first();
            $receiving_qty=(int)$assign_quantity->receiving_qty;
            $status=$assign_quantity->status;
            
            
            $receiving_qty-=(int)$last_receiving;
            
            if($status=='1'){
                $status='0';
            }
            
            $update_assign=[
                'receiving_qty' => $receiving_qty,
                'status' => $status
            ];
            
            DB::table('assign_quantity')->where('id',$assign_id)->update($update_assign);
            
            $product_info=DB::table('product_info')->where('variation_id',$variation_id)->first();
            
            $pr_id=$assign_quantity->pr_id;
        
            $store=\DB::table('pr_data')->where('pr_name',$pr_id)->first();
            
            $qty=$product_info->Quantity;
            $cquantity='Quantity';
            if($store->store_id=='11'){
                $qty=$product_info->uc_quantity;
                $cquantity='uc_quantity';
            }else if($store->store_id=='12'){///added by sufian 07-01-24
                $qty=$product_info->ss_quantity;
                $cquantity='ss_quantity';
            }
            
            
            $qty-=(int)$last_receiving;
            
            $update_info=[
                $cquantity => ($qty<0)?'0':$qty
            ];
            
            DB::table('product_info')->where('variation_id',$variation_id)->update($update_info);
            
            $insert_reverse=[
                'variation_id' => $variation_id,
                'quantity' => $last_receiving,
                'reason' => $request->reason,
                'po_id' => $product_receiving->po_id,
                'pr_id' => $product_receiving->pr_id,
                'rec_id' => $product_receiving->rec_id,
                'supplier_id' => $product_receiving->supplier_id,
                'user_id' => auth()->user()->id,
                'created_date' => date('Y-m-d H:i:s')
            ];
            
            $insert_data=\DB::table('gatepass_reverse_history')->insert($insert_reverse);
            DB::table('product_receiving')->where('id',$request->last_receiving_id)->delete();
            DB::table('assign_quantity')->where('last_receiving_id',$request->last_receiving_id)->delete();
            
            ///added by sufian 08-05-23
            if($product_receiving->bulk_receiving_id !=0){
                DB::table('product_bulk_receiving')->where('id',$product_receiving->bulk_receiving_id)->delete();
            }
            
            return response()->json(['success' => 1,'message' => 'GatePass Reverse Successfully']);
            
        }
    }
    
    
    
    
    public function storewise_statistics(Request $request){
        if($request->ajax()){
            $draw = $request->post('draw');
            $start = $request->post("start");
            $rowperpage = $request->post("length"); // total number of rows per page

            $columnIndex_arr = $request->post('order');
            $columnName_arr = $request->post('columns');
            $order_arr = $request->post('order');
            $search_arr = $request->post('search');
            
            $totalRecords = Supplier::query()->whereNotIn('suppliers.id',[1,2])->where('status','=',1)->count();
            
            // dd($totalRecords);
            
            
            
            $searchValue = $search_arr['value']; // Search value
            
            if($searchValue !=''){
                $records=Supplier::query()
                ->select([
                    'suppliers.supplier_name',
                    'suppliers.id'
                ])->whereNotIn('suppliers.id',[1,2])->where('status','=',1)->whereRaw('suppliers.supplier_name Like "%'.$searchValue.'%"');
                $totalRecordswithFilter =$records->count();
            }else{
                $totalRecordswithFilter =$totalRecords;
                $records=Supplier::query()
                ->select([
                    'suppliers.supplier_name',
                    'suppliers.id'
                ])->whereNotIn('suppliers.id',[1,2])->where('status','=',1);
            }
            
            
            
            if($rowperpage !='-1'){
                $records->offset($start)->take($rowperpage);
            }
            
            if(isset($columnIndex_arr[0]['column'])){
                $columnIndex = $columnIndex_arr[0]['column']; // Column index
                $columnName = $columnName_arr[$columnIndex]['data']; // Column name
                $columnSortOrder = $order_arr[0]['dir']; // asc or desc
                $records->orderBy($columnName, $columnSortOrder);
            }else{
                $records->orderBy('id','ASC');
            }
            
            $data = array();
            
            $stores=DB::table('store')->whereIn('id',$this->active_store)->select(['id','short_name','strong_name'])->get();
            
            if(!empty($records->get())){
                foreach($records->get() as $sup){
                    $nestedData=array();
                    $total=0;
                    $nestedData['supplier_name']=$sup->supplier_name;
                    foreach ($stores as $store){
                        $pr_id_air=$store->short_name.'AIR';
                        $pr_id_sea=$store->short_name.'SEA';
                        $pr_id_bulk=$store->short_name.'BULK';
                        
                        // dd($pr_id_air);
                        
                        $air=Helper::store_wise_pending($sup->id,$pr_id_air);
                        $sea=Helper::store_wise_pending($sup->id,$pr_id_sea);
                        $bulk=Helper::store_wise_pending($sup->id,$pr_id_bulk);
                        
                        
                        $total+=$air;
                        $total+=$sea;
                        $total+=$bulk;
                        
                        $nestedData[str_replace(' ','_',$store->strong_name).'_air']=$air;
                        $nestedData[str_replace(' ','_',$store->strong_name).'_sea']=$sea;
                        $nestedData[str_replace(' ','_',$store->strong_name).'_bulk']=$bulk;
                    }
                    
                    $nestedData['total']=$total;
                    $data[] = $nestedData;
                }
            }
            
            
            
            $response = array(
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordswithFilter,
                "aaData" => $data,
            );
            // dd($response);
            
            echo json_encode($response);
            
        }else{
            $stores = DB::table('store')->whereIn('id',$this->active_store)->get();
            return view('gatepass.storewise_statisitics',['stores' => $stores]); 
        }
    }
}
