<?php

namespace App\Http\Controllers\Admin;
use DataTables;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Helper;


class AWDController extends Controller
{
    function __construct(){
        $this->middleware(['auth']);
    }
    
    public function printLabel(Request $request){
        if($request->ajax()){
            
            $columns = [
                0 =>'apl.id' 
            ];
            
            $store_id=$request->store_id;
            
            if($store_id ==''){
                return Datatables::of([])->make(true);
            }
            
            // $records=DB::table('awd_print_label as apl')
            //         ->leftJoin('process_order_quantity as pod','pod.variation_design','=','apl.opex_sku')
            //         ->leftJoin('bundle_list_pr_wise as blrw','blrw.bundle_set_variation','=','apl.opex_sku')
            //         ->leftJoin('bundle as b','b.bundle_set_variation','=','apl.opex_sku')
            //         ->leftJoin('product_info_design as c','c.variation_design','=','apl.opex_sku')
            //         ->where('apl.store_id',$store_id)
            //         ->where('pod.status','=',0)
            //         ->where('pod.shipment_type','=',3)
            //         ->where('blrw.status','=',0)
            //         ->where('blrw.shipment_type','=',3)
            //         ->select([
            //             DB::raw('IF (apl.opex_sku LIKE  "%BUN%",b.bundle_set_name,c.product_name) as product_name'),
            //             'apl.id',
            //             'apl.opex_sku',
            //             'apl.variation_id',
            //             'apl.asin',
            //             'apl.fnsku',
            //             'apl.amazon_sku',
            //             'c.prod_img',
            //             'c.product_url',
            //             'b.image_url',
            //             DB::raw('sum(pod.receiving_qty) as approve_qty'),
            //             DB::raw('sum(blrw.given_qty) as given_qty')
            //         ]);
            
            $limit = $request->input('length');
            $start = $request->input('start');
            // $order = $columns[$request->input('order.0.column')];
            // $dir = $request->input('order.0.dir');
            $order = $columns[0];
            $dir = 'ASC';
            
            
            $records = DB::table('awd_print_label as apl')
                ->leftJoin(DB::raw('(
                    SELECT variation_design, SUM(receiving_qty) as receiving_qty
                    FROM process_order_quantity
                    WHERE status = 0 AND shipment_type = 3 AND store_id = '.$store_id.'
                    GROUP BY variation_design
                ) as pod'), 'pod.variation_design', '=', 'apl.opex_sku')
                ->leftJoin(DB::raw('(
                    SELECT bundle_set_variation, SUM(given_qty) as given_qty
                    FROM bundle_list_pr_wise
                    WHERE status = 0 AND shipment_type = 3 AND store_id = '.$store_id.'
                    GROUP BY bundle_set_variation
                ) as blrw'), 'blrw.bundle_set_variation', '=', 'apl.opex_sku')
                ->leftJoin('bundle as b', 'b.bundle_set_variation', '=', 'apl.opex_sku')
                ->leftJoin('product_info_design as c', 'c.variation_design', '=', 'apl.opex_sku')
                ->select(
                    DB::raw('IF(apl.opex_sku LIKE "%BUN%", b.bundle_set_name, c.product_name) as product_name'),
                    'apl.id',
                    'apl.opex_sku',
                    'apl.variation_id',
                    'apl.asin',
                    'apl.fnsku',
                    'apl.amazon_sku',
                    'c.prod_img',
                    'c.product_url',
                    'b.image_url',
                    DB::raw('COALESCE(SUM(pod.receiving_qty), 0) as approve_qty'),
                    DB::raw('COALESCE(SUM(blrw.given_qty), 0) as given_qty')
                )
                ->where('apl.store_id', $store_id)
                ->groupBy(
                    'apl.id',
                    'apl.opex_sku',
                    'apl.variation_id',
                    'apl.asin',
                    'apl.fnsku',
                    'apl.amazon_sku',
                    'c.prod_img',
                    'c.product_url',
                    'b.image_url'
                )
                ->havingRaw('approve_qty > 0 OR given_qty > 0')
                ;
            
            
            
            
            
            
            
            
            $totalData = $records->count();
            $totalFiltered = $totalData;
            
            if(!empty($request->input('search.value'))){
                $search = trim($request->input('search.value'));
                $records->whereRaw('apl.opex_sku LIKE "%'.$search.'%" OR b.bundle_set_name LIKE "%'.$search.'%" OR c.product_name LIKE "%'.$search.'%" OR apl.fnsku LIKE "%'.$search.'%"');
                
                $totalData = $records->get()->count();
                $totalFiltered = $totalData;
            }
            
            if($limit !='-1'){
                $skus=$records->offset($start)->limit($limit)->get();
            }else{
                 $skus=$records->get();
            }
            
            $arr=Helper::get_quantity($store_id);
            
            $data = [];
            
            if($skus->count()>0){
                foreach($skus as $sku){
                    
                    $bundle_check=preg_match( '/^4BUN/im',$sku->opex_sku);
                    if($bundle_check){
                        $url=$sku->image_url;
                        
                        $qty_stock=0;
                        $dq=0;
                        
                        $approve_qty=7; //21 T shirt means 7 Sets
                        $set_approve_qty=21;
                        
                        $req_qty=$sku->given_qty;
                        
                        $where=['bundle_set_variation' => $sku->opex_sku];
                        $lists=DB::table('bundle_sets')->where($where)->get();
                        
                        ///added by sufian 08-07-23
                        $same_list=DB::table('bundle_sets')
                                ->where($where)
                                ->groupBy('variation_id')
                                ->selectRaw("concat(variation_id,'-',bundle_set_variation) same_variation,count(variation_id) as same_sku_count")
                                ->havingRaw('count(variation_id)>1')
                                ->get();
                                
                        $same_arr=[];
                        $same_st=[];
                        if($same_list->count()>0){
                            foreach($same_list as $sl){
                                $same_arr[$sl->same_variation] =$sl->same_sku_count;
                                $same_st[$sl->same_variation] =0;
                            }
                        }
                        
                        $html='';
                        $instock_arr=[];
                        foreach($lists as $list){
                            $same_variation=$list->variation_id.'-'.$sku->opex_sku;
                            
                            if(isset($same_arr[$same_variation]) && isset($arr[$list->variation_id])){
                                $ac_qty=$arr[$list->variation_id]/$same_arr[$same_variation];
                                $ac_qty=(int)$ac_qty;
                                
                                if($same_st[$same_variation] ==0){
                                    $same_st[$same_variation]=$ac_qty;
                                }
                                
                                $qty_stock=$same_st[$same_variation];
                                $arr[$list->variation_id]=$arr[$list->variation_id] - $same_st[$same_variation];
                            }else{
                                if(isset($arr[$list->variation_id])){
                                    $qty_stock=$arr[$list->variation_id];
                                    $arr[$list->variation_id]=0;
                                }else{
                                    $qty_stock=0;
                                }
                            }
                            
                            $instock_arr[]=$qty_stock;
                            
                            
                            
                            
                            $html.='<span class="text-info">'.$list->variation_id.' : <strong>'.$qty_stock.'</strong></span><br>';
                        }
                        
                        $tStock=min($instock_arr);
                        $arrSum=array_sum($instock_arr);
                        
                        $html.='<hr><span class="text-primary" id="bun_'.$sku->opex_sku.'">Total InStock : <strong>'.$arrSum.'</strong></span>';
                        $detail='<span class="text-success">Available Bundle : <strong>'.min($instock_arr).'</strong></span><hr>'.$html;
                        
                        
                        $BoxMake=($tStock >0)? (int)($tStock/$approve_qty): 0;
                        $reqBox=($req_qty >0)? (int)($req_qty/$approve_qty): 0;
                        
                        $original_stock=$detail;
                    }else{
                        if($sku->product_url !=''){
                            $url=$sku->product_url;    
                        }else{
                            $url=asset('uploads/sku_images/'.$sku->prod_img);
                        }
                        
                        $product_name = strtolower($sku->product_name);
                        if (preg_match("/\b(varsity|jacket)\b/", $product_name)) {
                            $approve_qty = 10;
                        } else {
                            $approve_qty = 20;
                        }
                        
                        
                        $variation_id=$sku->variation_id;
                        
                        if(isset($arr[$variation_id])){
                            $qty_stock=$arr[$variation_id];
                            $arr[$variation_id]=0;
                        }else{
                            $qty_stock=0;
                        }
                        
                        
                        
                        $req_qty=$sku->approve_qty;
                        
                        $BoxMake=($qty_stock >0)? (int)($qty_stock/$approve_qty): 0;
                        $reqBox=($req_qty >0)? (int)($req_qty/$approve_qty): 0;
                        
                        $original_stock=$qty_stock;
                    }
                    
                    $d_none='';
                    // if($qty_stock < $approve_qty){
                    //     $d_none='d-none';
                    // }
                    
                    // $d_none='';
                    
                    
                            
                    
                    
                    
                    
                    $product_detail='
                            <input 
                                type="checkbox" 
                                id="id_check_'.$sku->id.'" 
                                name="id_check[]" 
                                value="'.$sku->id.'" 
                                class="form-check-input id_check ml-2 d-none"
                            >
                            
                            <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                <img src="'.$url.'" class="rounded" alt="Cinque Terre" width="70" height="70">
                            </a>';
                    
                    $action='
                    <div class="input-group '.$d_none.'">
                        <input 
                            type="text" 
                            class="form-control form-control-sm has-success input_filled" 
                            data-id="'.$sku->id.'" 
                            data-box="'.$BoxMake.'"
                            data-y="'.$reqBox.'"
                            data-approve_qty="'.$approve_qty.'" 
                            data-fnsku="'.$sku->fnsku.'"
                            data-variation_design="'.$sku->opex_sku.'"
                            data-variation_id="'.$sku->variation_id.'"
                            id="filled_qty_'.$sku->id.'" 
                            name="filled_qty[]" 
                            placeholder="0" 
                        />
                    
                        <a href="javascript:;" id="print_label_'.$sku->id.'" data-id="'.$sku->id.'" data-approve_qty="'.$approve_qty.'" class="btn btn-sm btn-dark print_label" title="Print Label">
                            <i class="fas fa-barcode"></i>
                        </a>
                    </div>
                    <span id="error_'.$sku->id.'" class="text-danger text-sm" style="display:none"></span><br>';
                        
                    $new=[];
                    
                    $new['product_img']=$product_detail;
                    $new['opex_sku']=$sku->opex_sku;
                    $new['product_name']=$sku->product_name;
                    $new['instock']=$original_stock;
                    $new['boxMake']=$BoxMake;
                    $new['req_qty']=$req_qty;
                    $new['reqBox']=$reqBox;
                    $new['asin']=$sku->asin;
                    $new['fnsku']=$sku->fnsku;
                    $new['amazon_sku']=$sku->amazon_sku;
                    $new['action']=$action;
                    $data[] = $new;
                }
            }
            
            $json_data = [
                "draw"            => intval($request->input('draw')),  
                "recordsTotal"    => intval($totalData),  
                "recordsFiltered" => intval($totalFiltered), 
                "data"            => $data,
            ];
            
            return response()->json($json_data);
        }else{
            $stores=DB::table('store')->where('status','=',1)->get();
            return view('awd.printLabel',['stores' => $stores]);
        }
    }
    
    
    
    public function upload_fnsku(Request $request){
        if($request->ajax()){
            // dd($request->all());
            
            if($request->hasFile('file_img')){
                $input = $request->all();
                
                $image = $request->file('file_img');
                $name = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/upload_excel');
                $image->move($destinationPath, $name);
                
                $insert_excel=[
                    'file_name' => $name,
                    'original_name' => $image->getClientOriginalName(),
                    'type' => '7',
                    'type_name' => 'AWD FNSKU Upload',
                    'status' => '1',
                    'uploaded_by' => auth()->user()->id,
                    'upload_date' => date('Y-m-d')
                ];
                
    
                $insert_data=DB::table('upload_excel')->insert($insert_excel);
                $this->import_fnsku($name,$image->getClientOriginalExtension(),$input['store_id']);
                
                return response()->json([
                    'code' => 200,
                    'message' => 'AWD FNSKU Uploaded Successfully'
                ]);
            }else{
                return response()->json([
                    'code' => 400,
                    'message' => 'File Not Found'
                ]);
            }
        }
        
    }
    
    public function import_fnsku($file_name,$extension,$store_id){
        if($extension == 'csv'){
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
        } elseif($extension == 'xlsx') {
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        } else {
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
        }

        $spreadsheet = $reader->load(public_path('/uploads/upload_excel/'.$file_name));
        $allDataInSheet = $spreadsheet->getActiveSheet();
        $lastRow = $allDataInSheet->getHighestRow();
        
        $in_arr=[];
        for ($row = 2; $row <= $lastRow; $row++) {
            $opex_sku= trim($allDataInSheet->getCell('A'.$row)->getValue());
            $variation_design=explode('-',$opex_sku);
            $variation_id=$variation_design[0];
            
            
            $data = [
                'opex_sku'=>trim($allDataInSheet->getCell('A'.$row)->getValue()),
                'variation_id' => $variation_id,
                'product_name'=>trim($allDataInSheet->getCell('B'.$row)->getValue()),
                'fnsku'=>trim($allDataInSheet->getCell('C'.$row)->getValue()),
                'asin'=>trim($allDataInSheet->getCell('D'.$row)->getValue()),
                'amazon_sku'=>trim($allDataInSheet->getCell('E'.$row)->getValue()),
                'store_id' => $store_id,
                'created_by'=>auth()->user()->id,
                'created_date' => date('Y-m-d H:i:s'),
            ];
            $in_arr[]=$data;
        }
        
        if(count($in_arr)>0){
            DB::table('awd_print_label')->where('store_id','=',$store_id)->delete();
            DB::table('awd_print_label')->insert($in_arr);
        }
    }
    
    public function show_print_label(Request $request){
        if($request->ajax()){
            $id=$request->id;
            $approve_qty=$request->approve_qty;
            
            $record=DB::table('awd_print_label as apl')
                    ->leftJoin('bundle as b','b.bundle_set_variation','=','apl.opex_sku')
                    ->leftJoin('product_info_design as c','c.variation_design','=','apl.opex_sku')
                    ->where('apl.id',$id)
                    ->select([
                        DB::raw('IF (apl.opex_sku LIKE  "%BUN%",b.bundle_set_name,c.product_name) as product_name'),
                        'apl.id',
                        'apl.opex_sku',
                        'apl.asin',
                        'apl.fnsku'
                    ])->first();
            
            
            $html='';
            $generator = new \Picqer\Barcode\BarcodeGeneratorPNG();
            for($i=1;$i<=$approve_qty;$i++){
                $p_name=$record->product_name;
                $html .= '
                    <div style="text-align:center;border:solid 0px;font-family:Calibri;font-weight:600;margin-top:10px;">
                        <div class="text-left product-name" style="background-color: yellow;float:left;padding-left:10px;padding-right:10px;padding-bottom:10px;width:315px !important;">
			                <div style="margin-top:5px;font-weight:bold;margin:5px;">
                    
                                 <img  src="data:image/png;base64,' . base64_encode($generator->getBarcode($record->fnsku, $generator::TYPE_CODE_128, 2,50)) . '" style="width:90%;" />
                           
                                 <br />
                                <span  style="font-size:20px !important;">'.$record->fnsku.'</span>
                                <br />
                                <center>
                                <div  style="font-size: 19px;font-weight:600px;">'.$p_name.'</div>
                              
                                </div>
                			      </center>
                         </div>
                         
                         </div>
                ';
            }
            
            return response()->json([
                'success'=>true,
                'html' => $html
            ]);
        }
    }
    
    
    public function send_to_case_pack_ready(Request $request){
        if($request->ajax()){
            
            // dd($request->all());
            $store_id=$request->store_id;
            $storeDetail=DB::table('store')->where('id','=',$store_id)->first();
        
            $store_name='';
            if($storeDetail){
                $store_name=$storeDetail->strong_name;
            }
            
            foreach($request->array as $key => $input){
                $where_processed=[
                    'variation_id' => $input['variation_id'],
                    'variation_design' => $input['variation_design'],
                    'store_id' => $store_id,
                    'status' => 0
                ];
                
                $check=DB::table('awd_ready_case_pack_quantity')->where($where_processed)->get();
                
                $minus_qty= $input['filled_qty'] *  $input['approve_qty'];
                
                if($check->count()>0){
                    $row=$check->first();
                    $update=[
                        'process_qty' => (int)$row->process_qty + (int)$input['filled_qty'],
                        'receiving_qty' => (int)$row->receiving_qty + (int)$input['filled_qty'],
                        'process_inv_qty' => (int)$row->process_inv_qty + (int)$minus_qty,
                        'receive_inv_qty' => (int)$row->process_inv_qty + (int)$minus_qty,
                        'updated_date' => date('Y-m-d H:i:s'),
                        'updated_by' => auth()->user()->id,
                    ];
                    DB::table('awd_ready_case_pack_quantity')->where($where_processed)->update($update);
                }else{
                    $insert=[
                        'variation_id' => $input['variation_id'],
                        'variation_design' => $input['variation_design'],
                        'fnsku' => $input['fnsku'],
                        'process_qty' => $input['filled_qty'],
                        'receiving_qty' => $input['filled_qty'],
                        'process_inv_qty' => $minus_qty,
                        'receive_inv_qty' => $minus_qty,
                        'status' => 0,
                        'created_by' => auth()->user()->id,
                        'created_date' => date('Y-m-d H:i:s'),
                        'store_id' => $store_id,
                    ];
                    
                    // dd($insert);
                    $insert_data=DB::table('awd_ready_case_pack_quantity')->insert($insert);
                }
                
                $lastOrderId=DB::table('awd_ready_case_pack')->max('id');
            
                $prefix = '0000';
		        $pid=$lastOrderId+1;
		        $pd = sprintf( '%04d', ($prefix + $pid) );
		        
		        $box_scan_id=$input['variation_design'].'-CP'.$pd.'-'.$input['filled_qty']; //SKU-CP001-totalBoxQty
                
                $insert=[
                    'variation_id' => $input['variation_id'],
                    'variation_design' => $input['variation_design'],
                    'box_scan_id' => $box_scan_id,
                    'fnsku' => $input['fnsku'],
                    'approve_qty' => $input['filled_qty'],
                    'filled_qty' => $input['filled_qty'],
                    'approve_inv_qty' => $minus_qty,
                    'filled_inv_qty' => $minus_qty,
                    'casepack_ready_status' => 0,
                    'user_id' => auth()->user()->id,
                    'created_date' => date('Y-m-d H:i:s'),
                    'store_id' => $store_id
                ];
                
                $insert_data=DB::table('awd_ready_case_pack')->insert($insert);
                
                
                $log_detail= 'Case Pack Ready For <strong>"'.$store_name.'" </strong> for this SKU <strong>('.$input['variation_design'].')</strong> <br>Total Box :'.$input['filled_qty'].'<br> Total Quantity Minus :'.$minus_qty;
                $insert_log=[
                    'variation_id' => $input['variation_id'],
                    'pr_id' => $box_scan_id,
                    'given_qty' => $minus_qty,
                    'supplier_id' =>0,
                    'user_id' => auth()->user()->id,
                    'type_name' => $log_detail,
                    'created_date' => date('Y-m-d H:i:s')
                ];
                
                // dd($insert_log);

                $insert_data=DB::table('item_log')->insert($insert_log);
               
                
                ///process order
                $bundle_check=preg_match( '/^4BUN/im',$input['variation_design']);
                if($bundle_check){
                    $where=['bundle_set_variation' => $input['variation_design']];
                    $variation_list=DB::table('bundle_sets')->where($where)->get();
                    
                    if($variation_list->count()>0){
                        foreach($variation_list as $li){
                            Helper::inStock_minus($li->variation_id,$input['approve_qty'],$store_id);
                        }
                    }
                    Helper::bundle_order_minus($input['variation_id'],$input['variation_design'],$store_id,3,$minus_qty);
                }else{
                    Helper::process_order_quantity_minus($input['variation_id'],$input['variation_design'],$store_id,3,$minus_qty);
                    Helper::process_order_minus($input['variation_id'],$input['variation_design'],$store_id,3,$minus_qty);
                    Helper::inStock_minus($input['variation_id'],$minus_qty,$store_id);
                }
            }
            
            return response()->json([
                'code' => 200,
                'message' => 'Assign Quantity Successfully'
            ], 200);
            
        }
    }
    
    public function get_readyCase_count(Request $request){
        if($request->ajax()){
            $store_id=$request->store_id;
            
            $query = DB::table('awd_ready_case_pack_quantity')
                    ->select(
                        [DB::raw('SUM(receiving_qty) total_pending_qty')])
                    ->groupBy('store_id')
                    ->where('status',0)
                    ->whereRaw('variation_design NOT like "%4BUN%"')
                    ->where('store_id',$store_id)
                    ->first();
                
            $single_pending=0;
            if($query !=NULL){
                $single_pending=(int)$query->total_pending_qty;  
            }
            
            $query = DB::table('awd_ready_case_pack_quantity')
                    ->select(
                        [DB::raw('SUM(receiving_qty) total_pending_qty')])
                    ->groupBy('store_id')
                    ->where('status',0)
                    ->whereRaw('variation_design like "%4BUN%"')
                    ->where('store_id',$store_id)
                    ->first();
            
            $bundle_pending=0;
            if($query !=NULL){
                $bundle_pending=(int)($query->total_pending_qty);  
            }
            
            $data=[
                'single_pending' => $single_pending,
                'bundle_pending' => $bundle_pending
            ];
            
            return response()->json($data);
        }
    }
    
    public function casePack_ready(Request $request){
        if($request->ajax()){
            $records=DB::table('awd_ready_case_pack_quantity as arcpq')
                        ->groupBy('arcpq.variation_design','arcpq.store_id')
                        ->leftjoin('product_info_design as pid','pid.variation_design','=','arcpq.variation_design')
                        ->leftjoin('bundle as b','b.bundle_set_variation','=','arcpq.variation_design')
                        ->orderBy('pid.variation_id','ASC')
                        ->orderBy('pid.prod_size','ASC')
                        ->orderBy('pid.prod_design','ASC')
                        ->where('arcpq.status','0')
                        ->select([
                            'arcpq.variation_id',
                            'arcpq.id',
                            'arcpq.variation_design',
                            DB::raw('sum(arcpq.receiving_qty) as filled_qty'),
                            DB::raw('sum(arcpq.process_qty) as approve_qty'),
                            DB::raw('sum(arcpq.receive_inv_qty) as receive_inv_qty'),
                            DB::raw('sum(arcpq.process_inv_qty) as process_inv_qty'),
                            'arcpq.created_date',
                            DB::raw('(IF(arcpq.variation_design like "%4BUN%",b.bundle_set_name,pid.product_name)) as product_name'),
                            DB::raw('(IF(arcpq.variation_design like "%4BUN%",b.image_url,pid.prod_img)) as prod_img'),
                            DB::raw('(IF(arcpq.variation_design like "%4BUN%",b.image_url,pid.product_url)) as product_url'),
                        ]);
            
            $records->where('store_id',$request->store);
            
            if(!empty($request->input('search.value'))){
                $search = trim($request->input('search.value'));
                $records->whereRaw('(arcpq.variation_design LIKE "%'.$search.'%" OR b.bundle_set_name LIKE "%'.$search.'%" OR pid.product_name LIKE "%'.$search.'%" OR arcpq.fnsku LIKE "%'.$search.'%")');
            }
            
            return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('product_img',function($data){
                        if($data->product_url !=''){
                            $url=$data->product_url;
                        }else{
                            $url=asset('uploads/sku_images/'.$data->prod_img);
                        }
    
                        $product_detail='
                            <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                <img src="'.$url.'" class="rounded" alt="Cinque Terre" width="70" height="70">
                            </a>
                        ';
                        return $product_detail;
                    })
                    ->addColumn('product_name',function ($data){
                        return $data->product_name;
                    })
                    ->filterColumn('product_name',function($query,$keyword){
                        $query->whereRaw('pid.product_name LIKE "%'.$keyword.'%" OR  arcpq.variation_design LIKE "%'.$keyword.'%" OR b.bundle_set_name  LIKE "%'.$keyword.'%"');
                    })
                    ->addColumn('size',function($data){
                        $name=explode(',',$data->product_name);
                        return $name[1];
                    })
                    ->rawColumns(['product_img','product_name','size'])
                    ->make(true);
        }else{
            $stores=DB::table('store')->where('status','=',1)->orderBy('id','ASC')->get();
            return view('awd.readyCasePack',['stores'=> $stores]);
        }
    }
    
    public function excel_case_pack_ready(Request $request){
        $store_id=$request->store_id2;
        
        $store_name=DB::table('store')->where('id',$store_id)->first('strong_name')->strong_name;
        
        $file_name='ready_case_pack_'.$store_name.'_'.date('Y_m_d_h_i_s');
        
        $records=DB::table('awd_ready_case_pack_quantity')
                        ->groupBy('awd_ready_case_pack_quantity.variation_design','awd_ready_case_pack_quantity.store_id')
                        ->leftjoin('product_info_design','product_info_design.variation_design','=','awd_ready_case_pack_quantity.variation_design')
                        ->leftjoin('bundle','bundle.bundle_set_variation','=','awd_ready_case_pack_quantity.variation_design')
                        ->leftjoin('awd_print_label','awd_print_label.opex_sku','=','awd_ready_case_pack_quantity.variation_design')
                        ->orderBy('product_info_design.variation_id','ASC')
                        ->orderBy('product_info_design.prod_size','ASC')
                        ->orderBy('product_info_design.prod_design','ASC')
                        ->where('awd_ready_case_pack_quantity.status','0')
                        ->where('awd_ready_case_pack_quantity.store_id',$store_id)
                        ->select([
                            'awd_print_label.amazon_sku',
                            'awd_print_label.fnsku',
                            'awd_ready_case_pack_quantity.variation_id',
                            'awd_ready_case_pack_quantity.id',
                            'awd_ready_case_pack_quantity.variation_design',
                            DB::raw('sum(awd_ready_case_pack_quantity.receiving_qty) as filled_qty'),
                            DB::raw('sum(awd_ready_case_pack_quantity.process_qty) as approve_qty'),
                            DB::raw('sum(awd_ready_case_pack_quantity.receive_inv_qty) as receive_inv_qty'),
                            DB::raw('sum(awd_ready_case_pack_quantity.process_inv_qty) as process_inv_qty'),
                            'awd_ready_case_pack_quantity.created_date',
                            DB::raw('(IF(LOCATE("4BUN", awd_ready_case_pack_quantity.variation_design),bundle.bundle_set_name,product_info_design.product_name)) as product_name'),
                            // 'processed_orders.pr_id',
                        ])->get();
                        
        
                        
        $objPHPExcel= new Spreadsheet();
        $objPHPExcel->setActiveSheetIndex(0);
        // $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
        // $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
        // $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
        // $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
        $objPHPExcel->getActiveSheet()->getStyle("A1:K1")->getFont()->setBold(true);
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'S No');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Amazon SKU');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Amazon FNSKU');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Variation Design');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Quantity');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Unit Per Box');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Number of Boxes');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Box Length (in)');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Box Width (in)');
        $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Box Height (in)');
        $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Box Weight (lbs)');
        
        $boxD=DB::table('box_dimensions')->get();
        $boxD=collect($boxD)->pluck(null,'box_type')->toArray();
        
        
        if($records->count()>0){
            $counter=2;
            $sno=1;
            $total_available=0;
            $total_order=0;
            foreach($records as $row){
                
                $exp=explode(',',$row->product_name);
                $product_name=$exp[0];
                $size=$exp[1];
                
                $total_order+=$row->filled_qty;
                $total_available+=$row->receive_inv_qty;
                
                $bundle_check=preg_match( '/^4BUN/im',$row->variation_design);
                if($bundle_check){
                    $approve_qty=7;
                    $box_type='bundle';
                }else{
                    
                    $product_nameN = strtolower($row->product_name);
                    if (preg_match("/\b(varsity|jacket)\b/", $product_nameN)) {
                        $approve_qty = 10;
                        $box_type='varsity';
                    } else {
                        $approve_qty = 20;
                        $box_type='tshirt';
                    }
                }
                
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $sno);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->amazon_sku);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->fnsku);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $row->variation_design);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$counter, $row->receive_inv_qty);
                $objPHPExcel->getActiveSheet()->SetCellValue('F'.$counter, $approve_qty);
                $objPHPExcel->getActiveSheet()->SetCellValue('G'.$counter, $row->filled_qty);
                $objPHPExcel->getActiveSheet()->SetCellValue('H'.$counter, $boxD[$box_type]->length);
                $objPHPExcel->getActiveSheet()->SetCellValue('I'.$counter, $boxD[$box_type]->width);
                $objPHPExcel->getActiveSheet()->SetCellValue('J'.$counter, $boxD[$box_type]->height);
                $objPHPExcel->getActiveSheet()->SetCellValue('K'.$counter, $boxD[$box_type]->weight);
                
                
                $counter++;
                $sno++;
            }
        }
        
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
    
    public function pending_CasePack_count(Request $request){
        if($request->ajax()){
            $store_id=$request->store_id;
            
            $total_bundle=$total_varsity=$total_tshirt=0;
            
            $bundle=DB::table('bundle_list_pr_wise as blpw')
                ->where('blpw.status','=',0)
                ->where('blpw.shipment_type','=',3)
                ->where('blpw.store_id','=',$store_id)
                ->selectRaw('SUM(blpw.given_qty) as given_qty')
                ->first();
                
            if($bundle){
                $given_qty=$bundle->given_qty;
                // dd($given_qty);
                $total_bundle=($given_qty >0)? (int)($given_qty/7): 0;
            }
            
            $varsity=DB::table('process_order_quantity as pod')
                        ->leftJOIN('product_info_design as pid','pid.variation_design','=','pod.variation_design')
                        
                        ->where('pod.status','=',0)
                        ->where('pod.shipment_type','=',3)
                        ->where('pod.store_id','=',$store_id)
                        // ->whereRaw(' (LOWER(pid.product_name) LIKE "%varsity%" OR LOWER(pid.product_name) LIKE "%jacket%") ')
                        ->whereIn('pid.segment_id',[9,14,19])
                        ->selectRaw('SUM(pod.receiving_qty) as receiving_qty')
                        ->first();
                        
            if($varsity){
                $given_qty=$varsity->receiving_qty;
                $total_varsity=($given_qty >0)? (int)($given_qty/10): 0;
            }
            
            $tshirt=DB::table('process_order_quantity as pod')
                        ->leftjoin('product_info_design as pid','pid.variation_design','=','pod.variation_design')
                        ->where('pod.status','=',0)
                        ->where('pod.shipment_type','=',3)
                        ->where('pod.store_id','=',$store_id)
                        // ->whereRaw(' (LOWER(pid.product_name) NOT LIKE "%varsity%" OR LOWER(pid.product_name) NOT LIKE "%jacket%") ')
                        ->whereNotIn('pid.segment_id',[9,14,19])
                        ->selectRaw('SUM(pod.receiving_qty) as receiving_qty')
                        ->first();
                        
            if($tshirt){
                $given_qty=$tshirt->receiving_qty;
                $total_tshirt=($given_qty >0)? (int)($given_qty/20): 0;
            }
            
            $data=[
                'total_bundle' => $total_bundle,
                'total_tshirt' => $total_tshirt,
                'total_varsity' => $total_varsity
            ];
            
            return response()->json($data);
        }
    }
}
