<?php
namespace App\Helpers;

use Illuminate\Support\Facades\DB;
use Auth;


class ReportHelper{
    
    
    public static function SayHello(){
        return "SayHello";
    }
    
    
    public static function field_template($get_single='y',$table,$fields='*',$where=[],$orderBy='',$sort_by=''){
        $result=DB::table($table)
                    ->select($fields);
                    
        if(!empty($where)){
            $result->where($where);
        }
        
        if($orderBy !=''){
            if($sort_by ==''){
                $sort_by='ASC';
            }
            
            $result->orderBy($orderBy,$sort_by);
        }
        
        
        $get=$result->get();
            
        if($get->count()>0){
            if($get_single=='y'){
                $first=$get->first();
                return $first;
            }else{
                return $get;
            } 
                
        }else{
            return NULL;
        }
        
    }
    
    
    
    public static function AmazonOrders($table, $startDate, $endDate, $countryCount, $child = 1, $teamId) {

        $filters = [
            "order_status != 'Cancelled'",
            "item_status != 'Cancelled'",
            "sales_channel != 'Non-Amazon'",
            "fulfillment_channel = 'Amazon'",
            "sales_channel != 'SI CA Prod Marketplace'",
        ];

        // Team filter with conditional addition
        $teamIdFilter = $teamId != '' ? "product_name LIKE '%[$teamId%'" : "product_name LIKE '%[4%'";
        $filters[] = $teamIdFilter;

        $countrySql = "";
        $countryPlaceholders = [];
        if (!empty($countryCount)) {
            $countryMap = [
                "US" => ["Amazon.com", "Amazon.com.mx"],
                "CA" => ["Amazon.ca"],
                "UK" => ["amazon.co.uk"],
                "AU" => ["amazon.com.au"],
                "EU" => ["Amazon.de"],
            ];
            
            $checkOr=0;    
            foreach ($countryCount as $country) {
              if (isset($countryMap[$country])) {
                $checkOrAnd=($checkOr==1)?'OR':'';
                $countrySql .= ' '.$checkOrAnd.' sales_channel IN ("'.implode('","', $countryMap[$country]).'")';
                $checkOr=1;
              }
            }
        }
        
        if($child =='1'){
            $column='variation_design as sku';
            $group_by='variation_design';
        }else{
            $column="IF(LOCATE('-', variation_design) > 0, CONCAT(group_id,'-', SUBSTRING_INDEX(variation_design, '-', -1)), group_id) as sku";
            $group_by='sku';
        }

        $sql = DB::table($table)
            ->selectRaw($column.',count(amazon_order_id) as total_sale')
            ->whereRaw(implode(' AND ', $filters));
        
        if ($countrySql) {
            // dd ($countrySql);
            $sql->whereRaw('('.$countrySql.')');
        }
        
        $sql->whereRaw(" DATE_FORMAT(purchase_date, '%Y-%m-%d') BETWEEN '$startDate' AND '$endDate'")
            ->groupBy($group_by);

        $results = $sql->get();
        
        if($child =='1'){
            $formattedResult=collect($results)->pluck(null,'sku')->toArray();
            return $formattedResult;
        }else{
            $arr=[];
            foreach ($results as $r){
                $sku=$r->sku;
                if(isset($arr[$sku])){
                    $arr[$sku]['total_sale'] = ($arr[$sku]['total_sale'] ?? 0) + $r->total_sale;
                }else{
                    $arr[$sku]=[
                        'sku' => $r->sku,
                        'total_sale' => $r->total_sale
                    ];
                }
                
                // $sku_instock=$r->sku.'_instock';
                // $sku_inbound=$r->sku.'_inbound';
                // $arr[$sku_instock] = ($arr[$sku_instock] ?? 0) + $r->instock;
                // $arr[$sku_inbound] = ($arr[$sku_inbound] ?? 0) + $r->inbound;
            }
            
            return $arr;
        }
    }
    
    public static function AmazonOrders_C($table, $startDate, $endDate, $countryCount, $child = 1, $teamId) {
        $sql = DB::table($table)->select('product_name');
    
        $filters = [
            "order_status != 'Cancelled'",
            "item_status != 'Cancelled'",
            "sales_channel != 'Non-Amazon'",
            "fulfillment_channel = 'Amazon'",
            "sales_channel != 'SI CA Prod Marketplace'",
            ($teamId != '' ? "product_name LIKE '%[$teamId%'" : "product_name LIKE '%[4%'"),
            "DATE_FORMAT(purchase_date, '%Y-%m-%d') BETWEEN '$startDate' AND '$endDate'"
        ];
    
        if (!empty($countryCount)) {
            $countries = [];
            foreach ($countryCount as $country) {
                $countries[] = self::getSalesChannelCondition($country);
            }
            $filters[] = '(' . implode(' OR ', $countries) . ')';
        }
    
        $sql->whereRaw(implode(' AND ', $filters))->groupBy('amazon_order_id');
    
        $query = $sql->get();
        $skuArray = [];
    
        foreach ($query as $row) {
            $sku = self::extractSKU($row->product_name);
            $parentSku = ($child == 1) ? $sku : substr($sku, 0, -1);
            $skuArray[$parentSku] = ($skuArray[$parentSku] ?? 0) + 1;
        }
    
        return $skuArray;
    }

    public static function getSalesChannelCondition($country) {
        switch ($country) {
            case "US":
                return "sales_channel IN ('Amazon.com', 'Amazon.com.mx')";
            case "CA":
                return "sales_channel = 'Amazon.ca'";
            case "UK":
                return "sales_channel = 'amazon.co.uk'";
            case "AU":
                return "sales_channel = 'amazon.com.au'";
            case "EU":
                return "sales_channel = 'Amazon.de'";
            default:
                return "";
        }
    }
    
    public static function extractSKU($productName) {
        preg_match('#\[(.*?)\]#', trim($productName), $matches);
        return trim($matches[1] ?? '');
    }
    
    public static function getAmazonInventory($tableName,$child_sku=1){
        
        if($child_sku =='1'){
            $column='variation_design as sku';
            $group_by='variation_design';
        }else{
            $column="IF(LOCATE('-', variation_design) > 0, CONCAT(group_id,'-', SUBSTRING_INDEX(variation_design, '-', -1)), group_id) as sku";
            $group_by='sku';
        }
        
        
        $results = DB::table($tableName)
        ->selectRaw($column.',SUM(afn_fulfillable_quantity) as instock,(SUM(afn_inbound_working_quantity) + SUM(afn_inbound_shipped_quantity)) as inbound,SUM(afn_reserved_quantity) as reserved')
        ->groupBy($group_by)
        ->get();
        
        // dd($results);
        
        
        if($child_sku =='1'){
            $formattedResult=collect($results)->pluck(null,'sku')->toArray();
            // dd($formattedResult['40009014']);
            return $formattedResult;
        }else{
            $arr=[];
            foreach ($results as $r){
                $sku=$r->sku;
                if(isset($arr[$sku])){
                    $arr[$sku]['instock'] = ($arr[$sku]['instock'] ?? 0) + $r->instock;
                    $arr[$sku]['inbound'] = ($arr[$sku]['inbound'] ?? 0) + $r->inbound;
                    $arr[$sku]['reserved'] = ($arr[$sku]['reserved'] ?? 0) + $r->reserved;
                    
                }else{
                    $arr[$sku]=[
                        'sku' => $r->sku,
                        'instock' => $r->instock,
                        'inbound' => $r->inbound,
                        'reserved' => $r->reserved
                    ];
                }
                
                // $sku_instock=$r->sku.'_instock';
                // $sku_inbound=$r->sku.'_inbound';
                // $arr[$sku_instock] = ($arr[$sku_instock] ?? 0) + $r->instock;
                // $arr[$sku_inbound] = ($arr[$sku_inbound] ?? 0) + $r->inbound;
            }
            
            
            
            return $arr;
        }
    }
    
    public static function getAWDInventory($tableName,$child_sku=1){
        
        if($child_sku =='1'){
            $column='variation_design as sku';
            $group_by='variation_design';
        }else{
            $column="IF(LOCATE('-', variation_design) > 0, CONCAT(group_id,'-', SUBSTRING_INDEX(variation_design, '-', -1)), group_id) as sku";
            $group_by='sku';
        }
        
        
        $results = DB::table($tableName)
        ->selectRaw($column.',SUM(available_awd_units) as instock,SUM(inbound_awd_units) as inbound,SUM(reserved_in_awd_units) as reserved')
        ->groupBy($group_by)
        ->get();
        
        
        if($child_sku =='1'){
            $formattedResult=collect($results)->pluck(null,'sku')->toArray();
            return $formattedResult;
        }else{
            $arr=[];
            foreach ($results as $r){
                $sku=$r->sku;
                if(isset($arr[$sku])){
                    $arr[$sku]['instock'] = ($arr[$sku]['instock'] ?? 0) + $r->instock;
                    $arr[$sku]['inbound'] = ($arr[$sku]['inbound'] ?? 0) + $r->inbound;
                    $arr[$sku]['reserved'] = ($arr[$sku]['reserved'] ?? 0) + $r->reserved;
                    
                }else{
                    $arr[$sku]=[
                        'sku' => $r->sku,
                        'instock' => $r->instock,
                        'inbound' => $r->inbound,
                        'reserved' => $r->reserved
                    ];
                }
                
                // $sku_instock=$r->sku.'_instock';
                // $sku_inbound=$r->sku.'_inbound';
                // $arr[$sku_instock] = ($arr[$sku_instock] ?? 0) + $r->instock;
                // $arr[$sku_inbound] = ($arr[$sku_inbound] ?? 0) + $r->inbound;
            }
            
            return $arr;
        }
    }
    
    public static function AmazonSingleOrders($table, $startDate, $endDate, $countryCount,$sku,$check_group=1) {

        $filters = [
            "order_status != 'Cancelled'",
            "item_status != 'Cancelled'",
            "sales_channel != 'Non-Amazon'",
            "fulfillment_channel = 'Amazon'",
            "sales_channel != 'SI CA Prod Marketplace'",
        ];
        
        
        if($check_group){
            $search_minus_e='-';
            if(preg_match("/{$search_minus_e}/i", strtolower($sku))){
                $exp=explode('-',$sku);
                $group_id=$exp[0];
                $dalpha=$exp[1];
                
                $filters[] = 'group_id = "'.$group_id.'"';
                $filters[] = 'variation_design LIKE "%'.$dalpha.'%"';
            }else{
                $filters[] = 'group_id = "'.$sku.'"';
            }
        }else{
           $filters[] = 'variation_design = "'.$sku.'"'; 
        }

        // Team filter with conditional addition
        $teamIdFilter = "product_name LIKE '%[4%'";
        $filters[] = $teamIdFilter;

        $countrySql = "";
        $countryPlaceholders = [];
        if (!empty($countryCount)) {
            $countryMap = [
                "US" => ["Amazon.com", "Amazon.com.mx"],
                "CA" => ["Amazon.ca"],
                "UK" => ["amazon.co.uk"],
                "AU" => ["amazon.com.au"],
                "EU" => ["Amazon.de"],
            ];
            
            $checkOr=0;    
            foreach ($countryCount as $country) {
              if (isset($countryMap[$country])) {
                $checkOrAnd=($checkOr==1)?'OR':'';
                $countrySql .= ' '.$checkOrAnd.' sales_channel IN ("'.implode('","', $countryMap[$country]).'")';
                $checkOr=1;
              }
            }
        }
        
        
        $sql = DB::table($table)
            ->selectRaw('variation_design as sku,count(amazon_order_id) as total_sale')
            ->whereRaw(implode(' AND ', $filters));
        
        if ($countrySql) {
            // dd ($countrySql);
            $sql->whereRaw('('.$countrySql.')');
        }
        
        $sql->whereRaw(" DATE_FORMAT(purchase_date, '%Y-%m-%d') BETWEEN '$startDate' AND '$endDate'")
            ->groupBy('variation_design');

        $results = $sql->get();
        $formattedResult=collect($results)->pluck(null,'sku')->toArray();
        return $formattedResult;
    }
    
    public static function getAmazonSingleInventory($tableName,$sku,$check_group=1){
        
        $results = DB::table($tableName)
        ->selectRaw('variation_design as sku,SUM(afn_fulfillable_quantity) as instock,(SUM(afn_inbound_working_quantity) + SUM(afn_inbound_shipped_quantity)) as inbound,SUM(afn_reserved_quantity) as reserved')
        ->groupBy('sku');
        
        if($check_group){
            $search_minus_e='-';
            if(preg_match("/{$search_minus_e}/i", strtolower($sku))){
                $exp=explode('-',$sku);
                $group_id=$exp[0];
                $dalpha=$exp[1];
                
                $results->whereRaw('group_id = "'.$group_id.'" AND variation_design LIKE "%'.$dalpha.'%"');
            }else{
                $results->whereRaw('group_id = "'.$sku.'"');
            }
        }else{
           $results->whereRaw('variation_design = "'.$sku.'"');
        }
        
        $formattedResult=collect($results->get())->pluck(null,'sku')->toArray();
        return $formattedResult;
        
    }
    
    public static function AmazonReturns($table, $startDate, $endDate, $child = 1, $teamId) {
        // Team filter with conditional addition
        
        $filters=[];
        $teamIdFilter = $teamId != '' ? "product_name LIKE '%[$teamId%'" : "product_name LIKE '%[4%'";
        
        $filters[] = $teamIdFilter;

        
        
        if($child =='1'){
            $column='variation_design as sku';
            $group_by='variation_design';
        }else{
            $column="IF(LOCATE('-', variation_design) > 0, CONCAT(group_id,'-', SUBSTRING_INDEX(variation_design, '-', -1)), group_id) as sku";
            $group_by='sku';
        }

        $sql = DB::table($table)
            ->selectRaw($column.',count(order_id) as total_returns')
            ->whereRaw(implode(' AND ', $filters));
        
        
        
        $sql->whereRaw(" DATE_FORMAT(return_date, '%Y-%m-%d') BETWEEN '$startDate' AND '$endDate'")
            ->groupBy($group_by);

        $results = $sql->get();
        
        if($child =='1'){
            $formattedResult=collect($results)->pluck(null,'sku')->toArray();
            return $formattedResult;
        }else{
            $arr=[];
            foreach ($results as $r){
                $sku=$r->sku;
                if(isset($arr[$sku])){
                    $arr[$sku]['total_returns'] = ($arr[$sku]['total_returns'] ?? 0) + $r->total_returns;
                }else{
                    $arr[$sku]=[
                        'sku' => $r->sku,
                        'total_returns' => $r->total_returns
                    ];
                }
                
                // $sku_instock=$r->sku.'_instock';
                // $sku_inbound=$r->sku.'_inbound';
                // $arr[$sku_instock] = ($arr[$sku_instock] ?? 0) + $r->instock;
                // $arr[$sku_inbound] = ($arr[$sku_inbound] ?? 0) + $r->inbound;
            }
            
            return $arr;
        }
    }
    
    public static function singleAmazonReturns($table, $startDate, $endDate,$child = 1, $group_id) {
        // Team filter with conditional addition
        
        $filters=[];
        if($child =='1'){
            $sku=$group_id;
            
            $filters=[
                'variation_design = "'.$group_id.'"'
            ];
        }else{
            $design=explode('-',$group_id);
            
            $sku=$design[0];
            $design=isset($design[1])?'-'.$design[1]:'';
            
            $filters=[
                'group_id = "'.$sku.'"'
            ];
            
            if($design){
                $filters[]='variation_design LIKE "%'.$design.'%"';
            }
            
        }
        
        $sql = DB::table($table)
            ->whereRaw(implode(' AND ', $filters))
            ->whereRaw(" DATE_FORMAT(return_date, '%Y-%m-%d') BETWEEN '$startDate' AND '$endDate'");

        $results = $sql->get();
        
        return $results;
    }
    
    public static function AmazonTotalReturns($table, $startDate, $endDate, $teamId) {
        // Team filter with conditional addition
        
        $filters=[];
        $teamIdFilter = $teamId != '' ? "product_name LIKE '%[$teamId%'" : "product_name LIKE '%[4%'";
        
        $filters[] = $teamIdFilter;

        $sql = DB::table($table)->selectRaw('count(order_id) as total_returns')->whereRaw(implode(' AND ', $filters));
        $sql->whereRaw(" DATE_FORMAT(return_date, '%Y-%m-%d') BETWEEN '$startDate' AND '$endDate'");
        $results = $sql->first();
        
        $total_returns=0;
        if($results){
            $total_returns=$results->total_returns;
        }
        
        return $total_returns;
    }
    
    public static function AmazonTotalOrders($table, $startDate, $endDate, $countryCount, $teamId) {

        $filters = [
            "order_status != 'Cancelled'",
            "item_status != 'Cancelled'",
            "sales_channel != 'Non-Amazon'",
            "fulfillment_channel = 'Amazon'",
            "sales_channel != 'SI CA Prod Marketplace'",
        ];

        // Team filter with conditional addition
        $teamIdFilter = $teamId != '' ? "product_name LIKE '%[$teamId%'" : "product_name LIKE '%[4%'";
        $filters[] = $teamIdFilter;

        $countrySql = "";
        $countryPlaceholders = [];
        if (!empty($countryCount)) {
            $countryMap = [
                "US" => ["Amazon.com", "Amazon.com.mx"],
                "CA" => ["Amazon.ca"],
                "UK" => ["amazon.co.uk"],
                "AU" => ["amazon.com.au"],
                "EU" => ["Amazon.de"],
            ];
            
            $checkOr=0;    
            foreach ($countryCount as $country) {
              if (isset($countryMap[$country])) {
                $checkOrAnd=($checkOr==1)?'OR':'';
                $countrySql .= ' '.$checkOrAnd.' sales_channel IN ("'.implode('","', $countryMap[$country]).'")';
                $checkOr=1;
              }
            }
        }
        
        $sql = DB::table($table)
            ->selectRaw('count(amazon_order_id) as total_sale')
            ->whereRaw(implode(' AND ', $filters));
        
        if ($countrySql) {
            // dd ($countrySql);
            $sql->whereRaw('('.$countrySql.')');
        }
        
        $sql->whereRaw(" DATE_FORMAT(purchase_date, '%Y-%m-%d') BETWEEN '$startDate' AND '$endDate'");

        $results = $sql->first();
        
        $total_sale=0;
        if($results){
            $total_sale=$results->total_sale;
        }
        
        return $total_sale;
    }
    
    public static function totalSale($sku,$dataArrayStock,$child,$country_list = 'US'){
        $totalSale=0;
        
        $sale='sale_parent';
        
        if($child ==1){
            $sale ='sale_child';
        }
        
        if($country_list == 'US'){
            $country='us';
        }else if($country_list == 'CA'){
            $country='ca';
        }
        
        $sale = $sale.'_'.$country;
        
        // dd($dataArrayStock['decrum_sale']);
        
        if(isset($dataArrayStock[$sale][$sku])){
            $totalSale+=$dataArrayStock[$sale][$sku]['total_sale'];
        }
        
        return $totalSale;
    }
    
    public static function stockCheck($sku,$dataStock,$child,$country_list='US',$stock_type){
        $total_stock=0;
        
        $inventory='inventory_parent';
        $awd='awd_parent';
        
        if($child ==1){
            $inventory ='inventory_child';
            $awd='awd_child';
        }
        
        if($country_list == 'US'){
            $country='us';
        }else if($country_list == 'CA'){
            $country='ca';
        }
        
        $inventory = $inventory.'_'.$country;
        $awd = $awd.'_'.$country;
        
        $inventoryStock=[
            'instock' => 0,
            'inbound' => 0,
            'reserved' => 0
        ];
        
        $awdStock = $inventoryStock;
        
        if(isset($dataStock[$inventory][$sku])){
            $inventoryStock=$dataStock[$inventory][$sku];        
        }
        
        if(isset($dataStock[$awd][$sku])){
            $awdStock=$dataStock[$awd][$sku];        
        }
        
        if($stock_type =='instock'){
            $total_stock += $inventoryStock['instock'];
        }else if($stock_type =='inbound'){
            $total_stock += $inventoryStock['inbound'];
        }else if($stock_type =='reserved'){
            $total_stock += $inventoryStock['reserved'];
        }else if($stock_type =='awd_instock'){
            $total_stock += $awdStock['instock'];
        }else if($stock_type =='awd_inbound'){
            $total_stock += $awdStock['inbound'];
        }else if($stock_type =='awd_reserved'){
            $total_stock += $awdStock['reserved'];
        }
        
        return $total_stock;
    }
}