<?php
namespace App\Helpers;

use Illuminate\Support\Facades\DB;
use Auth;


class Helper{
    public static $urban_store=[11,13];
    
    public static function field_template($get_single='y',$table,$fields='*',$where=[],$orderBy='',$sort_by=''){
        $result=DB::table($table)
                    ->select($fields);
                    
        if(!empty($where)){
            $result->where($where);
        }
        
        if($orderBy !=''){
            if($sort_by ==''){
                $sort_by='ASC';
            }
            
            $result->orderBy($orderBy,$sort_by);
        }
        
        
        $get=$result->get();
            
        if($get->count()>0){
            if($get_single=='y'){
                $first=$get_single->first();
                return $first;
            }else{
                return $get;
            } 
                
        }else{
            return NULL;
        }
        
    }
    
    public static function get_supplier_pending(){
        $assign=DB::table('assign_quantity')
            ->where('supplier_id','!=',1)
            ->where('status','=','0')
            ->selectRaw('supplier_id,count(assign_quantity.variation_id) as total_sku,(sum(receive_qty) - sum(receiving_qty)) as total_pending')
            ->groupBy('supplier_id')
            ->get();
            
        $formattedResult=collect($assign)->pluck(null,'supplier_id')->toArray();
        return $formattedResult;
    }
    
    ////added by sufian 05-05-23
    public static function store_wise_pending($supplier_id,$pr_id){
        $record=DB::table('assign_quantity')
                    ->where('status',0)
                    ->where('is_cancelled',0)
                    ->where('supplier_id',$supplier_id)
                    ->where('pr_id', 'like', '%' . $pr_id . '%')
                    ->select([DB::raw('(sum(receive_qty) - sum(receiving_qty)) as total_pending')])
                    ->get();
                    
        // dd($record);
        
        if($record->count()==0){
            $pending=0;
        }else{
            $first=$record->first();
            $pending=($first->total_pending !=NULL)? (int)$first->total_pending:0;
        }
        return $pending;
    }
    
    public static function initial_new_supplier($sup_id){
        $order=[];
        $receive=[];
        $pending=[];
        $total_order_qty=0;
        $total_received_qty=0;
        $total_pending_qty=0;
        $total_cancelled_qty=0;
        
        $assign=DB::table('assign_quantity')
            ->where('supplier_id',$sup_id)
            ->where('supplier_id','!=',1)
            ->where('supplier_id','!=',2)
            ->where('switch_status','0')
            ->select([
                DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),
                DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                DB::raw('count(assign_quantity.variation_id) as pr_id'),
                'switch_status',
            ])->first();
                
        $assign2=DB::table('assign_quantity')
            ->where('supplier_id',$sup_id)
            ->where('supplier_id','!=',1)
            ->where('supplier_id','!=',2)
            ->where('switch_status','1')
            ->where('receiving_qty','!=','0')
            ->select([
                DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                DB::raw('count(assign_quantity.variation_id) as pr_id'),
                'switch_status',
            ])->first();
            
        $cancelled=DB::table('assign_quantity')
                ->where('supplier_id',$sup_id)
                ->where('supplier_id','!=',1)
                ->where('supplier_id','!=',2)
                ->where('is_cancelled','1')
                ->select([
                    DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                    DB::raw('count(assign_quantity.variation_id) as pr_id'),
                    'switch_status',
                ])->first();
                
        $total_order2=(int)($assign->order_qty_given !="")?$assign->order_qty_given:0;
        $total_order=(int)($assign->receive_qty !="")?$assign->receive_qty:0;
        $total_receive_qty=($assign->receiving_qty!="")?$assign->receiving_qty:0;
        $total_receive_qty=($assign->receiving_qty!="")?$assign->receiving_qty:0;
        $total_pr_id=($assign->pr_id!="")?$assign->pr_id:0;
            
        $switch_order_qty=(int)($assign2->order_qty_given !="")?$assign2->order_qty_given:0;
        $switch_order=(int)($assign2->receive_qty !="")?$assign2->receive_qty:0;
        $switch_receive_qty=($assign2->receiving_qty!="")?$assign2->receiving_qty:0;
        $switch_pr_id=($assign2->pr_id!="")?$assign2->pr_id:0;
        
        $cancelled_assigned_order_qty=(int)($cancelled->receive_qty !="") ? $cancelled->receive_qty : 0 ;
        $cancelled_sku_qty=(int)($cancelled->pr_id !="") ? $cancelled->pr_id : 0 ;
        $cancelled_received_order_qty=(int)($cancelled->receiving_qty!="") ? $cancelled->receiving_qty: 0 ;
        $cancelled_qty=$cancelled_assigned_order_qty - $cancelled_received_order_qty;
        
        // dd($cancelled_qty);
            
                
            
        $remaining=(int)$total_order-(int)$total_receive_qty;
        $remaining-=$cancelled_qty;
        
        $total_order+=$switch_receive_qty;
        $total_receive_qty+=$switch_receive_qty;
        $total_pr_id-=$switch_pr_id;
        
        // $total_pr_id-=$cancelled_sku_qty;
            
        $t_order=$total_order;

        $total_order_qty+=$t_order;
        $total_received_qty+=$total_receive_qty;
        $total_pending_qty+=$remaining;
        $total_cancelled_qty+=$cancelled_qty;
        
        return [
            'total_order_qty' =>$total_order_qty,
            'total_received_qty' => $total_received_qty,
            'total_pending_qty' => $total_pending_qty,
            'total_pr_id' => $total_pr_id ,//(int)$total_pr_id+(int)$cancelled_sku_qty
            'total_cancelled' => $total_cancelled_qty
        ];
    }
    
    public static function assign_wh_list($store_id){
        $where = [
            'assign_quantity.status' => 0,
            'assign_quantity.supplier_id' => 1
        ];

        $short_name = 'UC';
        // $likeCondition = $store_id == 11 ? 'LIKE' : 'NOT LIKE';
        $likeCondition = in_array($store_id,self::$urban_store) ? 'LIKE' : 'NOT LIKE';

        $list = DB::table('assign_quantity')
            ->where($where)
            ->where('pr_id', $likeCondition, '%' . $short_name . '%')
            ->groupBy('assign_quantity.variation_id')
            ->select([
                'assign_quantity.variation_id',
                DB::raw('(SUM(assign_quantity.receive_qty) - SUM(assign_quantity.receiving_qty)) AS total_assign')
            ])
            ->get();

        $formattedArr = $list->pluck('total_assign', 'variation_id')->toArray();
        return $formattedArr;
    }
    
    public static function get_quantity($store_id){
        // $column = $store_id == 11 ? 'uc_quantity' : 'Quantity';
        $column = in_array($store_id,self::$urban_store) ? 'uc_quantity' : 'Quantity';
        
        $where=[
            'prod_status' => 1,
            'is_deleted' => 0,
            
        ];
        
        
        
        $get_inv=DB::table('product_info')
            ->where($where)
            ->where($column,'!=',0)
            ->selectRaw('variation_id,'.$column.' as quantity')
            ->get();
            
        $formattedArr = $get_inv->pluck('quantity', 'variation_id')->toArray();
        return $formattedArr;
    } 
    
    public static function inStock_minus($variation_id,$minus_qty,$store_id){
        // $column = $store_id == 11 ? 'uc_quantity' : 'Quantity';
        $column = in_array($store_id,self::$urban_store) ? 'uc_quantity' : 'Quantity';
        $store_name = in_array($store_id,self::$urban_store) ? 'Urban' : 'Decrum';
        
        $where=['variation_id' => $variation_id];
        $product_info=DB::table('product_info')->where($where)->first();
        
        if($product_info){
            $qty=$product_info->{$column};
            $qty=$qty-$minus_qty;
            DB::table('product_info')->where($where)->update([$column => ($qty<0)?0:$qty]);
            self::assign_quantity_minus($variation_id,$minus_qty,$store_id);
            
            $log_detail= 'Inventory Update <strong> old stock : "'.$product_info->{$column}.'" => New Stock:"'.$qty.'" in '.$store_name.' Warehouse</strong>'; 
            
            $insert_log=[
                'variation_id' => $product_info->variation_id,
                'pr_id' => 'InventoryUpdate',
                'given_qty' => $qty,
                'supplier_id' =>0,
                'user_id' => auth()->user()->id,
                'type_name' => $log_detail,
                'created_date' => date('Y-m-d H:i:s')
            ];

                $insert_data=DB::table('item_log')->insert($insert_log);
         }
    }
    
    public static function assign_quantity_minus($variation_id,$qty,$store_id){
        $short_name = 'UC';
        // $likeCondition = $store_id == 11 ? 'LIKE' : 'NOT LIKE';
        $likeCondition = in_array($store_id,self::$urban_store) ? 'LIKE' : 'NOT LIKE';
        
        $list = DB::table('assign_quantity')
                ->where('variation_id',$variation_id)
                ->where('status',0)
                ->where('supplier_id',1)
                ->where('pr_id', $likeCondition, '%' . $short_name . '%')
                ->select(['receive_qty','receiving_qty','id'])
                ->get();
        
        
        $actual_qty=$qty;
        
        if($list->count()>0){
            foreach ($list as $record){
                $receive_qty=$record->receive_qty;
                $receiving_qty=$record->receiving_qty;
                
                $remaining=(int)$receive_qty-(int)$receiving_qty;
                
                if($qty<=$remaining){
                    $up_qty=$qty;
                    $qty=0;
                }else{
                    $up_qty=$remaining;
                    $qty=(int)$qty - (int)$remaining;
                }
                
                $actual_rec=(int)$receiving_qty + (int)$up_qty;
                
                $update_rec=[
                    'receiving_qty' =>  $actual_rec,
                    'received_by' => isset(auth()->user()->id)?auth()->user()->id:28, 
                    'received_at'=>date('Y-m-d H:i:s')
                ];
                
                $up=DB::table('assign_quantity')->where('id',$record->id);
                
                $up->update($update_rec);
                
                if($receive_qty==$actual_rec){
                    $up->update(['status' => 1]);
                }
                
                if($qty==0){
                    break;
                }
            }
        }
    }
    
    public static function get_sup_po_no($supplier){
        $check=DB::table('suppliers')->where('id',$supplier)->get();
        $ponumber='';
        if($check->count()>0){
            $row=$check->first();
            $today=strtotime(date("Y-m-d"));
            $update_date= strtotime($row->sup_po_no_date);
            
            $datediff = $today - $update_date;
            $difference = floor($datediff/(60*60*24));
            if($difference==0){
                $serial=$row->sup_po_no;
                $ponumber=$row->short_name.$serial;
            }else{
                $serial=(int)$row->sup_po_no+1;
                $ponumber=$row->short_name.$serial;
               
                $update_re=[
                    'sup_po_no' => $serial,
                    'sup_po_no_date' => date('Y-m-d')
                ];
                
                DB::table('suppliers')->where('id',$supplier)->update($update_re);
            }
        }
        return $ponumber;
    }
    
    public static function check_process_order($variation_id,$store_id){
        $where=[
            'variation_id' => $variation_id,
            'status' => 0
        ];
        
        if($store_id =='11'){
            $whereSingleRaw='store_id =11';
            $whereBundleRaw='bundle_list_pr_wise.store_id =11';
        }else{
            $whereSingleRaw='store_id != 11';
            $whereBundleRaw='bundle_list_pr_wise.store_id !=11';
        }
        
        
        $check=DB::table('process_order_quantity')
                ->where($where)
                ->whereRaw($whereSingleRaw)
                ->get();
        
        $count=1;
        if($check->count()>0){
            // dd($check);
            $count=2;
        }
        
        $where=[
                'bundle_sets.variation_id' =>$variation_id,
                'bundle_list_pr_wise.status' =>0,
                'bundle_sets.is_deleted' => 0
            ];
        
        $check=\DB::table('bundle_sets')
            ->leftjoin('bundle_list_pr_wise','bundle_list_pr_wise.bundle_set_variation','=','bundle_sets.bundle_set_variation')
            ->where($where)
            ->whereRaw($whereBundleRaw)
            ->get();
        if($check->count()>0){
            $count=2;
        }
        
        return $count;
    }
    
    public static function assign_wh($variation_id,$qty,$pr_id,$store_id){
        $check_assign=self::check_process_order($variation_id,$store_id);
        $po_serial=self::get_sup_po_no(1);
        $pr_id_other=$pr_id;
        $po_id=$pr_id_other.'-'.$po_serial;
        
        $group_id=substr($variation_id, 0, -1);
        $size=substr($variation_id, -1);
        
        if($check_assign==2){
            $insert22=[
                    'variation_id' => $variation_id,
                    'variation_design' => $variation_id,
                    'main_type' => $group_id,
                    'prod_size' => $size,
                    'in_stock' =>  $qty,
                    'supplier_id' => 1,
                    'assign_date' => date('Y-m-d'),
                    'order_qty_given' => $qty,
                    'receive_qty' => $qty,
                    'pr_id' => $pr_id_other,
                    'po_id' => $po_id,
                ];
                
                
            $response=\DB::table('assign_quantity')->insert($insert22);
            
            $insert_log=[
                'variation_id' => $variation_id,
                'pr_id' => $pr_id_other,
                'given_qty' => $qty,
                'supplier_id' => 1,
                'user_id' => isset(auth()->user()->id)?auth()->user()->id:28,
                'type_name' => 'Assign Warehouse',
                'created_date' => date('Y-m-d H:i:s')
            ];
            $insert_data=\DB::table('item_log')->insert($insert_log);
        }
    }
    
    public static function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i <$length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
    public static function process_order_quantity_minus($variation_id,$variation_design,$store_id,$shipment_type,$qty){
        $where_qty=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type,
            'status' => 0
        ];
                
        $count1=DB::table('process_order_quantity')->where($where_qty)->first();
        $qty2=(int)$count1->receiving_qty - (int)$qty;
        $update_qty=[
            'updated_date' => date('Y-m-d H:i:s'),
            'updated_by' => auth()->user()->id,
            'receiving_qty' => ($qty2<0)?0:$qty2,
        ];
                
        if($qty2 <=0){
            $update_qty['status']=1;
        }
                
        DB::table('process_order_quantity')->where($where_qty)->update($update_qty);
    }
    
    public static function process_order_minus($variation_id,$variation_design,$store_id,$shipment_type,$qty){
        $actual_approve=$qty;
        $where=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type,
            'processed_status' => 0,
        ];
        
        $list=DB::table('process_orders')->where($where)->get();
        if($list->count()>0){
            foreach($list as $record){
                $given_qty=$record->given_qty;
                $approve_qty=$record->approve_qty;
                
                if($qty<=$given_qty){
                    $up_qty=$qty;
                    $given_qty=$given_qty-$qty;
                    $qty=0;
                }else{
                    $up_qty=$given_qty;
                    $qty=(int)$qty - (int)$given_qty;
                    $given_qty=0;
                    
                }
                
                $update_rec=['given_qty' => $given_qty];
                
                $up=DB::table('process_orders')->where('id',$record->id);
                
                $up->update($update_rec);
                
                if($given_qty <=0){
                    $up->update(['processed_status' => 1]);
                }
                
                if($qty==0){
                    break;
                }
            }
        }
    }
    
    public static function bundle_order_minus($variation_id,$variation_design,$store_id,$shipment_type,$qty){
        $actual_approve=$qty;
        $where=[
            'bundle_set_variation' => $variation_id,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type,
            'status' => 0,
        ];
        
        
        
        $list=DB::table('bundle_list_pr_wise')->where($where)->get();
        if($list->count()>0){
            foreach($list as $record){
                $given_qty=$record->given_qty;
                $approve_qty=$record->approve_qty;
                
                if($qty<=$given_qty){
                    $up_qty=$qty;
                    $given_qty=$given_qty-$qty;
                    $qty=0;
                }else{
                    $up_qty=$given_qty;
                    $qty=(int)$qty - (int)$given_qty;
                    $given_qty=0;
                    
                }
                
                $update_rec=['given_qty' => $given_qty];
                
                $up=DB::table('bundle_list_pr_wise')->where('id',$record->id);
                
                $up->update($update_rec);
                
                if($given_qty <=0){
                    $up->update(['status' => 1]);
                }
                
                if($qty==0){
                    break;
                }
            }
        }
    }
    
    public static function findPendingOrder($store_id,$shipment_type){
        $query = DB::table('process_order_quantity')
                ->select([DB::raw('SUM(receiving_qty) total_pending_qty')])
                ->where('status',0)
                ->where('shipment_type',$shipment_type)
                ->where('store_id',$store_id)
                ->get();
        
        $total_pending=0;
        
        if($query->count() > 0){
           $row = $query->first();
           $total_pending = !empty($row->total_pending_qty) ? $row->total_pending_qty : 0;
        }
        
        $query = DB::table('bundle_list_pr_wise')
                    ->select([DB::raw('SUM((given_qty)) total_pending_qty')])
                    ->where('status',0)
                    ->where('shipment_type',$shipment_type)
                    ->where('store_id',$store_id)
                    ->get();

        if($query->count() > 0){
           $row = $query->first();
           $total_pending += !empty($row->total_pending_qty) ? $row->total_pending_qty : 0;
        }
        return $total_pending;
    }
}